;DUU-01.ASM - Disk Utility Universal.
;
;Based upon DU.ASM  V7.5 Revised 1/23/81
;	which in turn was based upon the versions of
;	DU on CP/MUG volumes 40 and 46.
;
;Modified for CP/M UG 7/31 and 09/27/81 Ward Christensen
;
;DISK UTILITY - By Ward Christensen
;	
;PROCESSOR: ASM OR MAC
;
;DEPENDENCIES: None known - see comments below.
;
;REVISIONS (LAST FIRST):
;
;10/23/81 <WLC>	Deleted "U" command.  No longer used by
;	"F" (its only purpose).  I forgot to delete it
;	when "F" was rewritten.
;
;->	Made sure + and - check the "NOTPOS" flag; that
;	was a "loophole" that could "mislead" you.
;
;->	Added ability to put Hex into default decimal
;	fields.  Needed this to transfer files, where
;	their hex length is known, i.e. a file 29h
;	sectors long in contiguous extents may be
;	read into memory via: <<;+;/29h
;
;->	Added "E" (erase screen) command.  Store the
;	char sequence, 0ffH terminated, at 104h.
;	Useful as in "e;+;d;z20;/" to dump, sit, loop.
;	The screen clear "e" causes the display to "sit".
;
;->	Set "@" when using "F" command, so for example
;	to erase a file: "ffoo.zot;ch@,e5";w
;	Also change "not found" of "F" command so it
;	aborts, thus preventing, in the above ex., the
;	actual change-and-write.
;
;10/21/81 <WLC> "Z" command: make it wait a
;	decimal # of tenths of a second not hex.
;
;->	Add "<<" command, to save a sector, bumping
;	the sector address saved at.  The ">>" command
;	will get back the oldest saved sector.
;	Any time "<" is executed, all saved sectors
;	are "tossed".  Use this for "buffer reset".
;
;	For example, to transfer a single-density track 0
;	to the buffer, then to another disk:
;
;	t0;s1;<		position, restore buffer
;	<<;+;/26	save, step in 26 times
;	lb;t0;s1	log in drive b, position
;	>>;w;+;/26	restore, write, step, repeat 26
;		----
;->	The "M" command needs space to read the directory......
;	into.  It uses the space FOLLOWING the highest active
;	read sector.  If you get "out of memory" on the "M"
;	command, you will have to issue "<" to reset the
;	buffer.
;
;->	Added symbol "@" to mean "the address at which
;	the last "=" (search) matched.  Thus to scan for
;	an "LIX" somewhere on the disk, and change it
;	to an LXI:
;	=LIX;CA@,LXI	
;	(Change ascii "@ where it matched" to LXI)
;
;	Note that + and - may be used with "@", i.e.
;	=LXI<9>H,9;CA@+6,5
;	would change the "9" to a "5".
;
;	May also be used with the CHfrom-thru,value,
;	but DUU would take the "-" as arithmetic on the
;	"@", and not as "thru".  Thus a "hack" need be
;	used: ch@+0-@+1f,e5		The "@+0" allows
;	the "-" to be taken in the context 	of "thru".
;	ch@-@+1f,e5		would be interpreted as
;	"@ minus (@+1f)", which isn't what you want.
;
;10/10/81 <WLC> "F" command showed (S)ector 1 too
;	high because it called NEXTSEC before
;	displaying it
;
;================ TO CP/MUG AS OF HERE ================
;
;10/01/81 Corrected minor bug in "M" command so that
;	it now properly positions in input buffer if it
;	is ^C interrupted.  Thus "m;ffoo.asm" or some
;	such will work if the "M"-map is interrupted. (WLC)
;
;09/30/81 Moved the stack back to being in the program,
;	insted of "below BDOS".  Changing the stack from
;	beingd in the program, to being below BDOS,
;	introduced the (rare but potential) bug of the
;	directory read overlaying the stack.  I don't
;	understand the reason why it was changed in the 1st
;	place. (WLC)
;
;09/27/81 Changed "F" command to work with 2.2 to find
;	a file in the directory.  "F" with no operands
;	finds the next occurrence of the file.  I think
;	this obsoletes the "U" command, because the only
;	reason I could see for the "U" command was the
;	directory search of the old "U" command. (WLC)
;
;07/31/81 I compared this version (DU-V75) against my
;	current version, using a character-by-character
;	split-screen video compare.  The "significant"
;	changes turned out to be buried in "insignificant"
;	changes, i.e. case changes of comments, etc. I guess
;	I "over-reacted" to the significant stylistic
;	changes in DU, and "changed the program back" to "my
;	style" - i.e. deleted "type any char to continue",
;	colons after labels, less meaningful short labels,
;	etc.  Noise lines, i.e. ";" lines before continu-
;	ation labels, etc. made "+", "-", "/" all be back to
;	decimal numbers. (single density "+26" goes in a
;	track, not "+1a"). Also deleted historical comments
;	which are no longer relevant such as specific
;	controller mods which are now replaced by Ron
;	Fowler's excellent "universal" disk handling.  (WLC)
;
;	One warning: This program assumes track 0 to be
;	the same format as the rest of the disk.  This is
;	valid for hard disks, but for most floppy systems,
;	(take that to mean "all I have seen") track 0 is
;	single density.  On my tarbell, doing "t0;s1", which
;	should be the sector occupied by the BOOT, DUU
;	"hangs".  I found I have to do "t0;s2" to get the
;	first sector.  Also, attempts to go beyond the 26
;	sectors track 0 have on it, will hang the system.
;	09/27/81 Ward C.
;
;See DU.DOC for description and detailed instructions.
;	Also, some details are near the end of this
;	file in the form of the help text.
;
;This version of DU is compatible with CP/M 1.4 and 2.x
;and does not require alteration for various hardware
;configurations.  It adjusts itself automatically to
;the correct number of sectors, tracks, directory size,
;etc.  It has been tested on 5-1/4" and 8" floppy, and
;10 megabyte hard disk systems.
;
;Because of the automatic adaption feature, no conditional
;assembly options are included.  The only alteration that
;needs to be done is to use DDT to set the byte at 103h
;to zero for systems using a 2 mHz clock or non-zero for
;4 mHz clock.  This only affects the time delay used in
;the 'sleep' command.
;
;*************************************************
;* 						 *
;*   This program has been heavily modified	 *
;* to allow it to work without modification	 *
;* on most versions of CP/M 1.4 and, hopefully,	 *
;* all versions of CP/M 2.x.			 *
;*   If you have difficulty getting this program *
;* to run, AND if you are using CP/M 2.x, AND	 *
;* if you know your BIOS to be bug-free, leave	 *
;* a message on Technical CBBS of Dearborn,	 *
;* Michigan (313)-846-6127 with a description	 *
;* of the problem and a summary of your hard-	 *
;* ware configuration.				 *
;*   One known possible problem involves the	 *
;* system tracks on some systems, and results	 *
;* from the system sectors being skewed. There	 *
;* is NO way for a program executing under CP/M	 *
;* to know about this.  This program assumes the *
;* standard convention of no skew being used on	 *
;* the system tracks. This usually isn't a prob- *
;* lem because the SYSGEN program can be used to *
;* get the system from the disk so that	it can	 *
;* be modified.					 *
;*   This program should work under standard	 *
;* versions of CP/M 1.4.  The only requirement	 *
;* is that the BIOS "SETSEC" routine not modify	 *
;* the sector number passed to it in the B 	 *
;* register.  Again, system tracks with skewed	 *
;* sectors will be a problem.			 *
;*   If you add any features or make any useful	 *
;* changes to this program, please modem a copy	 *
;* to the above CBBS, so the currency of the	 *
;* program can be maintained.			 *
;*						 *
;* 		Ron Fowler			 *
;*						 *
;*************************************************
;
;01/23/81 Changed SETSEC to ignore high-order result of
;	  SECTRN if SPT<256.  This fixes some translation
;	  problems where the BIOS leaves garbage in H. (BRR)
;
;01/13/81 Updated help messages for '#' and 'N' commands.
;	  Modified sign-on message.  (RGF)
;
;01/12/81 Fixed problem with sector translation under
;	  CP/M 1.4.  (RGF)
;
;01/11/81 Fixed problem with CP/M 1.4.  Added 'N' command.
;	  Hard-code 'FASTCLOCK' as a boolean at 103h.  Add
;	  fix for sector number being 0 in system tracks,
;	  as suggested by Keith Petersen, W8SDZ. Added '#'
;	  command and memory-full check. Changed login to
;	  position to directory track at every log.  This
;	  is necessary to set up the 'FIRST0' flag.  (RGF)
;
;01/08/81 Corrected error in MAP routine that caused map
;	  to fail when >255 groups allocated.  Changed
;	  'REPEAT' to allow up to 65535 repeats.  (RGF)
;	09/27/81 changed REPEAT back from HEX to decimal. <WLC>
;
;01/06/81 Modified to allow use with ALL systems, without
;	  conditional assembly, thru use of disk parameter
;	  block.  By Ron Fowler, Westland, Mich.
;
;01/05/81 Modified '+' and '-' commands as follows:
;		1) + at end of disk now wraps to start
;		2) - at start wraps back to end
;		3) argument for + & - now good to 65535
;				(RGF)
;	07/31/81 UN-DID THIS. (WLC)
;
;01/03/81 Modified logic in console status test to allow
;	  any non-zero value to indicate char waiting.
;			(RGF)
;
;	09/27/81 WLC question about the above mod - "Why was
;	it done?"  The CP/M alteration guide says "CONST
;	...return[s] a 0FFH in register A if a character is
;	ready to read, an 00H in register A if no console
;	characters are ready..."  Why allow "any non-zero value"????
;
;
;01/02/81 Made compatible with MACRO80 assembler
;	(labels made unique within 6 chars, and separated
;	multi-statement lines).  (RGF)
;	07/31/81 UN-DONE.  THIS IS AN "ASM" PROGRAM. I
;	"SLEEP", NOT "SLEP", AND "PROMPT" NOT "PRMPT". 
;	Since all CP/M systems come with ASM, I see nothing
;	wrong with taking advantage of all meaningful
;	characters a label may have, even if it excludes
;	assembly by the occasionl M-80 user, (who must have
;	ASM anyway).
;
;11/04/80 Forced write type 1 (pre-read and immediate
;	write) so deblocking BIOS's don't mess up.  Ignore
;	bit 7 in = command unless <nn> form was used. 
;	Display unprintables as <nn> in V command.  Show
;	user no. in M command (will always be 00 for 1.4)
;	and only print parentheses if E5 present.  (BRR)
;
;10/30/80 Fixed bug in backspace/control-X.  Corrected more
;	  bit-7 stuff.	Added 'U' command to change user no.
;	  under CP/M 2.x.  Added pauses in help file. (BRR)
;
;09/16/80 Fix backspace in line enter routine, add MAXDIR
;	  equate, general cleanup of ASM file. (KBP)
;
;06/22/80 Put in 'Q' command.  Fix so 'P' (printer)
;	  mode outputs L/F's.  (WLC)
;
;05/21/80 Make sector, track, be decimal, not hex.
;	  Also dis-allow a read until positioned.
;	  (DU otherwise not in sync with CP/M)  (WLC)
;
;02/24/80 Mod login command to not really do log, just
;	  drive select.  (WLC)
;
;01/08/80 Reposition after 'M' command.  (WLC)
;
;01/07/79 Add VIEW command.  (WLC)
;
;01/06/80 Rewrite 'F' command.  (WLC)
;
;10/10/79 Save regs in BIOS calls, translate input to upper case
;	  add commands: < save sector
;			> restore sect
;			/ repeat
;	  allow change from-thru.  (WLC)
;
;02/25/79 Put sector read into 'S' command.  (WLC)
;
;11/26/78 Add disk # to login command.  (WLC)
;
;11/12/78 Add login command.  (WLC)
;
;08/06/78 Originally written to reconstruct blown
;	  disks on CBBS via remote access.  (WLC)
;
;
;		----------------
;Sorry for the lack of comments in the code 
;portion of this program - it was just hacked
;together to satisfy my needs, but lots of
;other people found it useful.	Its external
;documentation is good, but its sadly lacking
;comments on the instructions.  (WLC)
;		----------------
;
;System equates
;
BASE	EQU	0	;SET TO 4200H FOR HEATH OR TRS-80 ALTCPM
;
FCB	EQU	BASE+5CH
BDOS	EQU	BASE+5
PRINT	EQU	9
GVERS	EQU	12
RESETDK EQU	13
SELDK	EQU	14
SRCHF	EQU	17	;SEARCH FIRST
SUSER	EQU	32
GETDSK	EQU	25
GETDPB	EQU	31
;
TRNOFF	EQU	15	;CP/M 1.4 OFFSET FROM BASE
			;OF BDOS TO SECTRAN ROUTINE
SKWOFF	EQU	1AH	;CP/M 1.4 OFFSET TO SKEW TABLE
S2OFF	EQU	14	;OFFSET INTO FCB FOR S2 BYTE
DPBOFF	EQU	3AH	;CP/M 1.4 OFFSET TO DPB WITHIN BDOS
S2MASK	EQU	0FH	;MASK FOR EXTENDED RC BITS OF S2
DPBLEN	EQU	15	;SIZE OF CP/M 2.x DISK PARM BLOCK
;
;
;Define ASCII characters
;
CR	EQU	0DH	;CARRIAGE RETURN
LF	EQU	0AH	;LINE FEED
TAB	EQU	09H	;TAB
BS	EQU	08H	;BACKSPACE
;
	ORG	BASE+100H
;
	JMP	PASTCK	;JUMP OVER CLOCK BYTE AND I.D.
;
CLOCK	DB	1	;<---PUT NON-ZERO HERE FOR 4 MHZ CLOCK
;
;====> Store your erase-screen chars here, 0ffH terminated <===
;
CLEAR	DB	1AH,0FFH,0,0,0,0,0	;CRT ERASE SEQUENCE
;
PASTCK	LXI	SP,STACK
	MVI	C,GVERS	;GET CP/M VERSION NR
	CALL	BDOS
	MOV	A,H	;COMBINE THE TWO BYTE...
	ORA	L	;...VERSION NR FOR A FLAG
	STA	VER2FL	;SAVE IT
;
;Set up local jumps to BIOS
	LHLD	BASE+1	;WARM BOOT POINTER
	LXI	D,3	;READY FOR ADD
	DAD	D	
	SHLD	VCONST+1
	DAD	D
	SHLD	VCONIN+1
	DAD	D
	SHLD	VCONOUT+1
	DAD	D
	SHLD	VLIST+1
	DAD	D	;PUNCH
	DAD	D	;RDR
	DAD	D
	SHLD	VHOME+1
	DAD	D
	SHLD	VSELDK+1
	DAD	D
	SHLD	VSETTRK+1
	DAD	D
	SHLD	VSETSEC+1
	DAD	D
	SHLD	SETDMA+1
	DAD	D
	SHLD	VREAD+1
	DAD	D
	SHLD	VWRITE+1
	LDA	VER2FL
	ORA	A
	JZ	DOCPM1
	DAD	D	;LISTST
	DAD	D
	SHLD	VSCTRN+1
	JMP	HELLO
;
DOCPM1	LHLD	BDOS+1
	MVI	L,0	 ;BDOS ON PAGE BOUNDARY
	PUSH	H
	LXI	D,TRNOFF ;CP/M 1.4 SECTRAN ROUTINE OFFSET
	DAD	D
	SHLD	VSCTRN+1
	POP	H
	LXI	D,SKWOFF ;CP/M 1.4 SKEW TABLE OFFSET
	DAD	D
	SHLD	SECTBL	 ;SET UP SKEW TABLE POINTER
;
HELLO	CALL	ILPRT
	DB	CR,LF,'DISK UTILITY ver 7.5+mods 10/23/81'
	DB	CR,LF
	DB	'Universal Version (DUU)',CR,LF
	DB	CR,LF
	DB	'Type ? for help',CR,LF
	DB	'Type X to exit'
	DB	CR,LF,0
	CALL	GETSTP		;SET UP PARAMETERS
	CALL	NOCONT		;SHOW "F" NOT ALLOWED
	LXI	H,BASE+80H ;TO INPUT BUFF
	MOV	A,M
	ORA	A
	JZ	PROMPTR	;NO COMMAND
;GOT INITIAL COMMAND, SET IT UP
	MOV	B,A	;SAVE LENGTH
	DCR	B
	JZ	PROMPTR
	LXI	D,INBUF
	INX	H	;SKIP LEN
	INX	H	;SKIP ' '
	CALL	MOVE
	MVI	A,CR
	STAX	D
	LXI	H,INBUF
	JMP	PROMPTI
;
PROMPTC	CALL	CRLF
	JMP	PROMPT
;
PROMPRC	CALL	CRLF
PROMPTR	XRA	A
	STA	QFLAG
	CALL	RDBUF
PROMPTI	MVI	A,255
	STA	TOGO	;LOOP COUNT FOR "/"
	STA	TOGO+1
PROMPT	EQU	$
SETSTK	LXI	SP,STACK
	XRA	A	;ZERO 2-UP PRINT
	STA	TWOUP	;..SWITCH
	MVI	A,1
	STA	FTSW	;TELL SEARCH NOT TO INCR
	PUSH	H
	LXI	H,BASE+100H
	SHLD	BUFAD	;FOR RDBYTE
	POP	H
	CALL	CTLCS	;ABORT?
	JZ	PROMPRC	;..YES, READ BUFFER
	MOV	A,M
	CPI	CR
	JZ	PROMPTR
	CPI	';'	;LOGICAL CR?
	INX	H
	JZ	PROMPT
	CALL	UPCASE
	STA	DUMTYPE	;TYPE OF DUMP (A,D,H)
	CPI	'+' ! JZ PLUS
	CPI	'-' ! JZ MINUS
	CPI	'=' ! JZ SEARCH
	CPI	'<' ! JZ SAVE
	CPI	'>' ! JZ RESTORE
	CPI	'#' ! JZ STATS
	CPI	'?' ! JZ HELP
	CPI	'A' ! JZ DUMP
	CPI	'C' ! JZ CHG
	CPI	'D' ! JZ DUMP
	CPI	'E' ! JZ ERASE
	CPI	'F' ! JZ POSFIL
	CPI	'G' ! JZ POS
	CPI	'H' ! JZ DUMP
	CPI	'L' ! JZ LOGIN
	CPI	'M' ! JZ MAP
	CPI	'N' ! JZ NEWDSK
	CPI	'P' ! JZ PRINTFF
	CPI	'Q' ! JZ QUIET
	CPI	'R' ! JZ DOREAD
	CPI	'S' ! JZ POS
	CPI	'T' ! JZ POS
	CPI	'V' ! JZ VIEW
	CPI	'W' ! JZ DOWRITE
	CPI	'X' ! JZ BASE
	CPI	'Z' ! JZ SLEEP
	CPI	'/' ! JZ REPEAT
;
WHAT	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'?',CR,LF,0
	JMP	PROMPTR
;
;Memory full error
;
MEMFULL	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'+++ Out of memory +++',CR,LF
	DB	' (may be due to many "<<" stacked sectors)'
	DB	CR,LF,0
	JMP	PROMPTR
;
;Print disk statistics
;
STATS	PUSH	H
	CALL	ILPRT
	DB	'Disk Information:',CR,LF
	DB	'Tracks:',9,9,0
	LHLD	MAXTRK
	INX	H
	CALL	DEC
	CALL	ILPRT
	DB	CR,LF,'Sec/trk:',9,0
	LHLD	SPT
	CALL	DEC
	CALL	ILPRT
	DB	CR,LF,'Grpsize:',9,0
	LDA	BLM
	INR	A
	MOV	L,A
	MVI	H,0
	CALL	DEC
	CALL	ILPRT
	DB	' (sectors per group)',CR,LF
	DB	'Tot grps:',9,0
	LHLD	DSM
	CALL	DEC
	CALL	ILPRT
	DB	CR,LF,'Dir entries:',9,0
	LHLD	DRM
	INX	H
	CALL	DEC
	CALL	ILPRT
	DB	CR,LF,'Sys tracks:',9,0
	LHLD	SYSTRK
	CALL	DEC
	CALL	ILPRT
	DB	CR,LF,CR,LF,'Sectors in "<<" buffer: ',0
	LHLD	NUMSAVD
	MVI	H,0
	CALL	DEC
	CALL	ILPRT
	DB	CR,LF,'Number gotten via ">>": ',0
	LHLD	NUMREST
	MVI	H,0
	CALL	DEC
	CALL	CRLF
	POP	H
	JMP	PROMPT
;
;The following command resets the disk
;system thru CP/M, and may be usable for
;changing the disk density or format.
;This can only be done if your BIOS resets
;the auto-density select parameters at
;every track-zero access.
;
NEWDSK	PUSH	H
	CALL	NOCONT
	MVI	C,RESETDK
	CALL	BDOS
	LDA	DRIVE
	MOV	C,A
	POP	H
	CALL	SELECT
	JMP	PROMPT
;
;QUIET MODE
;
QUIET	STA	QFLAG	;NOW QUIET
	JMP	PROMPT
;
;REPEAT BUFFER CONTENTS
;
REPEAT	CALL	DECIN	;NN SPECIFIED?
	MOV	A,D
	ORA	E
	JZ	NNN	;NO.
	LHLD	TOGO
	INX	H	;TEST FOR FIRST TIME
	MOV	A,H
	ORA	L	;WAS IT 0FFFFH?
	JNZ	NNN	;NO	COUNTING
	XCHG		;GET COUNT
	SHLD	TOGO	;SET COUNT
NNN	LHLD	TOGO
	XCHG
	LXI	H,INBUF	;READY TO REPEAT
	INX	D	;TEST FOR 0FFFFH
	MOV	A,D
	ORA	E
	JZ	PROMPT	;CONTINOUS
	DCX	D	;COUNT DOWN
	DCX	D	;MAKE UP FOR PREV INX D
	XCHG
	SHLD	TOGO
	MOV	A,H	;ALL DONE?
	ORA	L
	XCHG		;GET BACK INBUF PTR
	JNZ	PROMPT	;NO, KEEP GOING
	JMP	PROMPTR	;ALL DONE
;
;TOGGLE PRINT FLAG
;
PRINTFF	LDA	PFLAG
	XRI	1
	STA	PFLAG
	JMP	PROMPT
;
;SLEEP ROUTINE, IN TENTHS OF A SEC
;
SLEEP	CALL	DECIN	;GET COUNT IF ANY
	MOV	A,E	;ANY?
	ORA	A
	JNZ	SLEEPLP
	MVI	E,10
SLEEPLP	LXI	B,8000	;APPROX .1 SEC @ 2MHz
	LDA	CLOCK
	ORA	A
	JZ	SLEEP2
	LXI	B,16000	;APPROX .1 SEC @ 4 MHz
SLEEP2	DCX	B
	MOV	A,B
	ORA	C
	JNZ	SLEEP2
	PUSH	D
	CALL	CTLCS
	POP	D
	JZ	PROMPRC
	DCR	E
	JNZ	SLEEPLP
	JMP	PROMPT
;
;CHECK FOR CONTROL-C OR S
;
CTLCS	CALL	CONST
	ORA	A
	JNZ	GETC
	ORI	1	;NO CHAR, RETN NZ
	RET
GETC	CALL	CONIN
	ANI	1FH	;ALLOW ASCII
	CPI	'S'-40H
	CZ	CONIN
	CPI	'C'-40H
	RET		;0 SET IF CTL-C
;
;Find our way at initialization
;
GETSTP	MVI	C,GETDSK
	CALL	BDOS	;GET CURNT DSK
	MOV	C,A	;  WE HAVE TO SELECT
	JMP	SELECT	;  TO GET THE DPH
;
LOGIN	CALL	NOCONT
	CALL	DOLOG
	JMP	PROMPT
;
DOLOG	MOV	A,M	;DISK REQ?
	LXI	D,0
	CPI	CR
	JZ	LGNODK
	CPI	';'
	JZ	LGNODK
	CALL	UPCASE
	INX	H
	SUI	'A'
	MOV	C,A
SELECT	PUSH	H
	MOV	A,C
	STA	DRIVE	;REMEMBER LATER WHERE WE ARE
VSELDK	CALL	$-$	;ADDR FILLED IN BY 'INIT'
	LDA	VER2FL
	ORA	A	;IF NOT CP/M 2.x ...
	JZ	SELSKP	;..THEN SKIP THIS JUNK
	MOV	A,H
	ORA	L
	JZ	WHAT	;SELECT ERROR
	MOV	E,M	;GET THE SECTOR TABLE PNTR
	INX	H
	MOV	D,M
	INX	H
	XCHG
	SHLD	SECTBL
	LXI	H,8	;OFFSET TO DPBPTR
	DAD	D
	MOV	A,M	;PICK UP DPB POINTER
	INX	H	;  TO USE
	MOV	H,M	;  AS PARAMETER
	MOV	L,A	;  TO LOGIT
SELSKP	CALL	LOGIT
	LHLD	SYSTRK	;RESET TRACK AND SECTOR
	XCHG		;  TO DIRECTORY
	CALL	SETTRK	;  ON EVERY
	LXI	D,1	;  LOGIN
	CALL	SETSEC	;  CHANGE
	LHLD	PHYSEC	;THIS LOGIC WILL TELL
	MOV	A,H	;  IF FIRST SEC
	ORA	L	;  IS PHYSICAL 0
	STA	FIRST0
	CALL	CALCSUB
	POP	H
;
LGNODK	CALL	NOWRITE
	RET
;
;READ IN THE DISK DIRECTORY
;
READDIR	PUSH	H
	CALL	NOWRITE	;POSITIONING LOST
	LHLD	SYSTRK
	SHLD	CURTRK
	LXI	H,1
	SHLD	CURSEC
	LHLD	DRM	;GET DIR SIZE FROM DPB
	INX	H	;MAKE 1-RELATIVE
	CALL	ROTRHL
	CALL	ROTRHL	;DIVIDE BY 4 (4 NAMES/SECTOR)
	MOV	B,H
	MOV	C,L
	LHLD	NXTSAVE	;POSITION AFTER SAVE BUFFER
	XCHG		;MOVE TO DE
RDIRLP	PUSH	B
	PUSH	D
	MOV	B,D
	MOV	C,E
	LDA	BDOS+2	;CHECK MEM AVAIL
	DCR	A
	CMP	D
	JC	MEMFULL
	CALL	SETDMA
	LHLD	CURTRK
	XCHG
	CALL	SETTRK
	LHLD	CURSEC
	XCHG
	CALL	SETSEC
	CALL	READ
	CALL	NEXTSEC
	POP	D
	POP	B
	LXI	H,80H
	DAD	D
	XCHG
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	RDIRLP
	LXI	B,BASE+80H
	CALL	SETDMA
	POP	H
	RET
;
;MA THE DIRECTORY
;
MAP	CALL	NOCONT	;CAN'T CONTINUE "F" COMMAND
	CALL	READDIR	;READ IN DIRECTORY
	MVI	C,0	;INIT START GRP #
	LDA	AL0	;READ DIR GRP BITS
	CALL	COLECT	;COLLECT COUNT OF DIR GRPS..
	LDA	AL1	;..IN REGISTER C
	CALL	COLECT
	MVI	B,0	;BC NOW HAS A DEFAULT START GRP #
	CALL	HEXIN
	PUSH	H	;SAVE INBUF PTR
	MOV	A,E	;GET START
	ORA	D	;NOTHING?
	JZ	MAPDF	;..YES, DFLT
	MOV	B,D
	MOV	C,E
;
MAPDF	CALL	HEXB
	MVI	A,'-'
	CALL	TYPE
	CALL	GETGRP	;GET GRP(C) TO HL
MAPCONT	INX	B	;NEXT GRP #
	PUSH	H
	LHLD	DSM	;GET HIGHEST GRP #
	INX	H	;PLUS 1 FOR COMPARISON
	MOV	A,L	;WHEN BC REACHES DSM+1..
	CMP	C	;..THEN WE HAVE EXCEEDED..
	JNZ	MAPC1	;..THE DISK CAPACITY..
	MOV	A,H
	CMP	B
MAPC1	POP	H
	JZ	MAPEND	;..AND WE ARE DONE
	PUSH	H
	CALL	GETGRP	;GET ANOTHER
	POP	D	;SEE IF SAME
	CALL	CTLCS
	JZ	MAPEND2
	MOV	A,D
	CMP	H
	JNZ	MAPDIFF
	MOV	A,E
	CMP	L
	JZ	MAPCONT	;SAME, CONTINUE
;
;DIFFERENT FILE ENCOUNTERED
;
MAPDIFF	DCX	B
	CALL	HEXB
	INX	B
	XCHG
	CALL	MAPNAME
	JMP	MAPDF
;
;END OF MAP
;
MAPEND	DCX	B	;GET LAST
	CALL	HEXB
	CALL	MAPNAME
;
;END OF MAP - REPOSITION TO PREVIOUS GROUP
;
MAPEND2	CALL	CRLF
	LHLD	GROUP
	XCHG
	JMP	POSGRP2	;..WHICH POPS INBUF AND CONTINUES
;
;PRINT FILE NAME POINTED TO BY HL
;
MAPNAME	CALL	SPACE
	MOV	A,H
	ORA	L	;NONE?
	JZ	NONAME
	MOV	A,M	;SEE IF ALLOC
	CPI	0E5H	;FREE?
	MVI	A,' '
	JNZ	MAPNSP1
	MVI	A,'('
MAPNSP1	CALL	TYPE
	PUSH	H	;SAVE POINTER
	MOV	A,M
	CALL	HEX	;SHOW USER NUMBER
	CALL	SPACE
	INX	H	;SKIP USER BYTE
	PUSH	B
	MVI	B,8
	CALL	MAPN2
	MVI	A,'.'
	CALL	TYPE
	MVI	B,3
	CALL	MAPN2
	POP	B
	CALL	SPACE
	MOV	A,M	;GET EXT
	CALL	HEX
	POP	H
	MOV	A,M
	CPI	0E5H
	MVI	A,' '
	JNZ	MAPNSP2
	MVI	A,')'
MAPNSP2	CALL	TYPE	;")" IF ERASED FILE
	JMP	FLIP
;
NONAME	CALL	ILPRT
	DB	'    ++FREE++        ',0
FLIP	LDA	TWOUP
	XRI	1
	STA	TWOUP
	JZ	CRLF
DELIM	MVI	A,':'
	CALL	TYPE
	JMP	SPACE
;
;PRINT NAME, LENGTH IN B
;
MAPN2	MOV	A,M
	ANI	7FH	;STRIP POSSIBLE 2.x ATTRIBUTE BIT
	INX	H
	CPI	' '	;PRINTABLE?
	JC	MAPN2H	;..NO, IN HEX
	CPI	7EH	;7E IS LEADIN ON SOME CRTS
	JC	MAPN2A
MAPN2H	CALL	BHEX
	JMP	MAPN2Z
;
MAPN2A	CALL	TYPE
MAPN2Z	DCR	B
	JNZ	MAPN2
	RET
;
;FIND WHICH FILE GROUP (BC) BELONGS TO
;
GETGRP	LHLD	DRM	;MAX DIR ENTRY #
	INX	H	;MAKE 1-RELATIVE
	SHLD	FILECT
	LHLD	NXTSAVE	;DIR. READ IN AFTER SAVE BUFFER
GETGLP	PUSH	H	;SAVE POINTER TO NAME
	MOV	A,M	;PICK UP DN BYTE
	LXI	D,14	;NOW GET RECORD COUNT
	DAD	D	;  S2 PORTION ..
	MOV	A,M	;  IS 0 IN CP/M 1.4
	CPI	0E5H
	JZ	GETGNF
	ANI	0FH
	MOV	E,A
	INX	H
	MOV	A,M
	ORA	E
	JZ	GETGNF
	MVI	E,16	;FIRST SET FOR 8-BIT GRPS
	LDA	DSM+1
	ORA	A
	JZ	SMALGRP
	MVI	E,8	;NOPE, BIG GROUPS
SMALGRP	MOV	D,A	;SAVE GRP SIZE INDICATOR
GETGL2	INX	H	;POINTING INTO DM FIELD
	CALL	GRPCMP	;COMPARE BC GRP # AGAINST 1 DM FLD
	JZ	GETGOT	;JUMP IF FOUND ONE
	DCR	E	;ELSE COUNT DOWN
	JNZ	GETGL2	;GO TEST SOME MORE
GETGNF	POP	H	;NOT THIS ONE!
	LXI	D,32	;SO GO TO NEXT
	DAD	D
	XCHG
	LHLD	FILECT	;THERE IS LIMIT TO EVERYTHING
	DCX	H
	SHLD	FILECT
	MOV	A,H
	ORA	L
	XCHG		;RE-ALIGN
	JNZ	GETGLP
;
;Group is not allocated to any file
	LXI	H,0	;SAY SO
	RET
;
;GOT THE FILE
;
GETGOT	POP	H
	RET
;
;SAVE THE CURRENT SECTOR.  IF "<" SAVE ONLY ONE, AND
;	RESET THE SAVED STACK.  IF "<<" SAVE, POINT
;	TO NEXT BUFFER ADDR.
;
SAVE	LDA	WRFLG
	ORA	A
	JZ	BADW	;NONE TO SAVE
	MVI	A,'<'	;TEST NEXT CHAR
	CALL	NEXTEST	;	FOR '<'
	PUSH	H
	LHLD	NXTSAVE
	XCHG
	JNZ	SAVECUR	;SAVE, SECT ADDR IN DE
	LXI	H,80H
	DAD	D	;HL = NEXT SECT
	SHLD	NXTSAVE	;SAVE NEXT SECT ADDR
	LDA	NUMSAVD
	INR	A
	STA	NUMSAVD
	JNZ	SAVENS
	DCR	A
	STA	NUMSAVD
	XCHG
	SHLD	NXTSAVE
	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'++ Can''t save more than 255 sectors'
	DB	CR,LF,0
	JMP	PROMPTR
;
SAVECUR	CALL	RESETBF	;RESET BUFF POINTERS
;
SAVENS	LDA	BDOS+2
	DCR	A
	CMP	D
	JZ	MEMFULL
	LXI	H,BASE+80H
	MVI	B,128
	CALL	MOVE
	MVI	A,1	;..SHOW
	STA	SAVEFLG	;..SAVED EXISTS
	POP	H
	JMP	PROMPT
;
;RESTORE THE CURRENT SECTOR
;
RESTORE	LDA	SAVEFLG
	ORA	A
	JZ	NOSAVE	;NONE TO SAVE
	MVI	A,'>'
	CALL	NEXTEST	;SEE IF WANT NEXT
	PUSH	H
	LHLD	NXTREST
	JNZ	RESTN	;OLD SECTOR
;
;REQUEST TO RESTORE "NEXT" SECTOR
;
	XCHG		;SAVE POINTER IN HL
	LDA	NUMSAVD		;COMPARE # SAVED
	LXI	H,NUMREST	;	TO
	INR	M		;	# RESTORED
	CMP	M
	JC	NOSAVE		;EXIT IF ERROR
	LXI	H,80H
	DAD	D	;GO TO NEXT BUFFER
	SHLD	NXTREST
	XCHG		;OLD (UN-INCREMENTED) TO HL
;
RESTN	LXI	D,BASE+80H
	MVI	B,128
	CALL	MOVE	;FROM (HL) TO (DE) LEN. IN (B)
	POP	H
	JMP	PROMPT
;
NOSAVE	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'++NO "<" SAVE COMMAND ISSUED',CR,LF
	DB	'  OR RESTORING MORE THAN SAVED'
	DB	CR,LF,0
	CALL	RESETBF	;RESET BUFF POINTERS
	JMP	PROMPTR
;
;RESET "<<" AND ">>" BUFFER POINTERS
;
RESETBF	XRA	A
	STA	NUMSAVD
	STA	NUMREST
	LXI	H,SAVEBUF
	SHLD	NXTSAVE
	SHLD	NXTREST
	RET
;
;MOVE (HL) TO (DE) LENGTH IN B
;
MOVE	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MOVE
	RET
;
;TEST IF CURR CHAR IN BUFFER IS = (A).
;	BUMP HL IF SO
;
NEXTEST	CMP	M	;MATCH?
	RNZ		;	NO, RET
	INX	H	;	YES SKIP IT
	RET		;	THEN RETURN
;
NOWRITE	XRA	A	;GET 0
	STA	WRFLG	;CAN'T WRITE NOW
	RET
;
;NO MATCH IN SEARCH, TRY NEXT CHAR
;
SRNOMAT	POP	H
	CALL	CTLCS	;ABORT?
	JNZ	SEARCH	;	NO
	LXI	H,INBUF	;YES
	MVI	M,CR
	JMP	CALCGRP	;SHOW WHERE STOPPED
;
;SEARCH FOR CHARACTER STRING
;
SEARCH	CALL	NOCONT
	PUSH	H	;SAVE STRING POINTER
	XRA	A	;STORE 0
	STA	SECDISP	;	INTO SECT DISPL.
SRCHL	CALL	RDBYTE	;GET A BYTE
	MOV	B,A	;SAVE IT
	MOV	A,M	;CHECK NEXT MATCH CHAR.
	CPI	'<'	;WILL IT BE HEX?
	MOV	A,B	;RESTORE DISK CHAR
	JZ	SRCHL1
	ANI	7FH	;NEXT CHAR IS ASCII...STRIP BIT 7
SRCHL1	PUSH	PSW
	CALL	GETVAL	;GET SEARCH VALUE
	MOV	B,A
	POP	PSW
	CMP	B	;MATCH?
	JNZ	SRNOMAT	;NO MATCH
	INX	H
	MOV	A,M	;DONE?
	CPI	CR
	JZ	SREQU
	CPI	';'
	JNZ	SRCHL
;GOT MATCH
SREQU	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'= AT ',0
	LDA	BUFAD
	ANI	7FH
	CALL	HEX
	CALL	CRLF
	JMP	CALCGRP
;
;GET VALUE FROM INPUT BUFFER
;
GETVAL	MOV	A,M
	CPI	'<'	;HEX ESCAPE?
	RNZ		;NO, RETURN
;"<<" MEANS ONE "<"
	INX	H
	MOV	A,M
	CPI	'<'
	RZ
;GOT HEX
	PUSH	D
	CALL	HEXIN	;GET VALUE
	CPI	'>'	;PROPER DELIM?
	MOV	A,E	;GET VALUE
	POP	D
	JNZ	WHAT	;ERROR
	RET
;
;READ A BYTE AT A TIME
;
RDBYTE	PUSH	H
	LDA	FTSW	;FIRST READ?
	ORA	A
	JNZ	READ1
	LHLD	BUFAD
	MOV	A,L
	ORA	A	;IN BUFFER?
	JM	NORD	;YES, SKIP READ
;
;HAVE TO READ
;
	CALL	NEXTSEC
READ1	XRA	A
	STA	FTSW	;NOT FIRST READ
	LHLD	CURSEC
	XCHG
	CALL	SETSEC
	LHLD	CURTRK
	XCHG
	CALL	SETTRK
	CALL	READ
	CALL	CALCSUB
	LXI	H,BASE+80H
;
;CHECK IF THE BYTE "SECDISP" IS 0.  IF SO, WE ARE
;READING FIRST BYTE OF "=" COMMAND SEARCH.
;SO SAVE THE ADDRESS, SO THE "@" SYMBOL MAY
;BE USED IN A CH OR CA COMMAND TO REFERENCE
;"WHEREVER" THE MATCH WAS FOUND.
;
NORD	LDA	SECDISP
	ORA	A
	JNZ	NORD2
	MOV	A,L	;GET DISP
	STA	SECDISP
NORD2	MOV	A,M
	INX	H
	SHLD	BUFAD
	POP	H
	RET
;
;VIEW THE FILE IN ASCII STARTING AT
;CURRENT SECTOR, STEPPING THRU THE DISK
;
VIEW	CALL	NOCONT
	LDA	WRFLG
	ORA	A
	JZ	BADDMP
	CALL	DECIN	;GET SECTOR COUNT
	PUSH	H
	MOV	A,E
	ORA	A
	JNZ	VIEWLP
	INR	E	;DFLT=1
VIEWLP	LXI	H,BASE+80H ;TO DATA
VIEWCHR	CALL	CTLCS
	JZ	VIEWEND
	MOV	A,M
	CPI	1AH
	JZ	VIEWEOF
	ANI	7FH
	CPI	7EH
	JNC	VIEWHX	;SHOW RUBOUT AND TILDE AS HEX
	CPI	' '
	JNC	VIEWPR
	CPI	CR
	JZ	VIEWPR
	CPI	LF
	JZ	VIEWPR
	CPI	TAB
	JZ	VIEWPR
VIEWHX	MOV	A,M	;NOT ASCII...PRINT AS <NN>
	CALL	BHEX
	JMP	VIEWNP
;
VIEWPR	CALL	TYPE
VIEWNP	INR	L
	JNZ	VIEWCHR
	DCR	E
	JZ	VIEWEND
	PUSH	D	;SAVE COUNT
	CALL	NEXTSEC
	LHLD	CURSEC
	XCHG
	CALL	SETSEC	
	LHLD	CURTRK
	XCHG
	CALL	SETTRK
	CALL	READ
	POP	D	;RESTORE COUNT
	JMP	VIEWLP
;
VIEWEOF	CALL	ILPRT
	DB	CR,LF,TAB,'++EOF++',CR,LF,0
VIEWEND	POP	H
	CALL	CRLF
	JMP	CALCGRP
;
;DUMP IN HEX OR ASCII
;
DUMP	LDA	WRFLG
	ORA	A
	JNZ	DUMPOK
BADDMP	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'++Can''t dump, no sector read.',CR,LF,0
EXPL	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'Use G command following F,',CR,LF
	DB	'or R or S following T',CR,LF,0
	JMP	PROMPTR
;
DUMPOK	MOV	A,M
	CPI	';'
	JZ	DUMPDF	;DFLT
	CPI	CR
	JNZ	DUMPNDF
;
;USE DEFAULT
DUMPDF	LXI	B,BASE+80H
	LXI	D,0FFH
	JMP	DUMP1
;
DUMPNDF	CALL	DISP
	MOV	B,D
	MOV	C,E
	CPI	CR
	JZ	DUMP1
	CPI	';'
	JZ	DUMP1
	INX	H	;SKIP ','
	CALL	DISP
;
;BC = start, DE = end
;
DUMP1	PUSH	H	;SAVE COMMAND POINTER
	MOV	H,B
	MOV	L,C
DUMPLP	MOV	A,L
	ANI	7FH
	CALL	HEX
	CALL	SPACE
	CALL	SPACE
	LDA	DUMTYPE
	CPI	'A'
	JZ	DUMPAS
	PUSH	H	;SAVE START
DHEX	MOV	A,M
	CALL	HEX
	MOV	A,L
	ANI	3
	CPI	3
	CZ	SPACE
	MOV	A,L
	ANI	7
	CPI	7
	CZ	SPACE
	MOV	A,E
	CMP	L
	JZ	DPOP
	INX	H
	MOV	A,L
	ANI	0FH
	JNZ	DHEX
DPOP	CALL	CTLCS
	JZ	PROMPRC
	LDA	DUMTYPE
	CPI	'H'
	JZ	DNOAS	;HEX ONLY
	POP	H	;GET START ADDR
DUMPAS	CALL	ASTER
DCHR	MOV	A,M
	ANI	7FH
	CPI	' '
	JC	DPER
	CPI	7EH
	JC	DOK
DPER	MVI	A,'.'
DOK	CALL	TYPE
	MOV	A,E
	CMP	L
	JZ	DEND
	INX	H
	MOV	A,L
	ANI	0FH
	JNZ	DCHR
DEND	CALL	ASTER
	CALL	CRLF
	PUSH	D
	CALL	CTLCS
	POP	D
	JZ	PROMPTR
	MOV	A,E
	CMP	L
	JNZ	DUMPLP
	POP	H
	JMP	PROMPT
;
DNOAS	POP	B
	CALL	CRLF
	MOV	A,E
	CMP	L
	JNZ	DUMPLP
	POP	H
	JMP	PROMPT
;
;POSITION
;
POS	CALL	NOCONT
	PUSH	PSW
	MOV	A,M
	CPI	';'
	JZ	POSINQ
	CPI	CR
	JNZ	POSOK
POSINQ	POP	PSW
	JMP	INQ
;
POSOK	POP	PSW
	CPI	'T'
	JZ	POSTRKD
	CPI	'S'
	JZ	POSSECD
	CPI	'G'
	JZ	POSGRPH
	JMP	WHAT
;
POSTRKD	CALL	DECIN
POSTRK	PUSH	H
	LHLD	MAXTRK
	CALL	SUBDE
	POP	H
	JC	OUTLIM
	CALL	SETTRK
	CALL	NOWRITE	;TRACK DOESN'T READ
	MVI	A,1
	STA	NOTPOS	;SHOW NOT POSITIONED
	JMP	CALCGRP
;
POSSECD	CALL	DECIN
	MOV	A,D
	ORA	E
	JZ	WHAT	;DON'T ALLOW SECTOR 0
POSSEC	PUSH	H
	LHLD	SPT
	CALL	SUBDE
	POP	H
	JC	WHAT
	CALL	SETSEC
	CALL	READ
	XRA	A
	STA	NOTPOS	;POSITIONED OK
;
CALCGRP	CALL	CALCSUB
	JMP	INQ
;
;CALCULATE GROUP FROM TRACK AND SECTOR
;
CALCSUB	PUSH	H
	LHLD	SYSTRK
	XCHG
	LHLD	CURTRK
	CALL	SUBDE
	XCHG
	LHLD	SPT
	CALL	MULT
	XCHG
	LHLD	CURSEC
	DCX	H
	DAD	D
	LDA	BLM
	MOV	B,A
	MOV	A,L
	ANA	B
	STA	GRPDISP
	LDA	BSH
	MOV	B,A
CALCLOP	CALL	ROTRHL
	DCR	B
	JNZ	CALCLOP
	SHLD	GROUP
	POP	H
	RET
;
POSGRPH	CALL	HEXIN
POSGRP	PUSH	H
	LHLD	DSM
	CALL	SUBDE
	POP	H
	JC	OUTLIM
	XCHG
	SHLD	GROUP
	XCHG
	XRA	A
	STA	GRPDISP
	PUSH	H
POSGRP2	CALL	GTKSEC
	CALL	SETTRK
	XCHG
	CALL	SETSEC
	CALL	READ
	XRA	A
	STA	NOTPOS	;NOW POSITIONED
	POP	H
	JMP	INQ
;
GTKSEC	MOV	H,D
	MOV	L,E
	LDA	BSH
GLOOP	DAD	H
	DCR	A
	JNZ	GLOOP
	LDA	GRPDISP
	ADD	L	;CAN'T CARRY
	MOV	L,A
;
;Divide by nr of sectors, quotient=track, remainder=sector
;
	XCHG
	LHLD	SPT
	CALL	NEG
	XCHG
	LXI	B,0
;
DIVLP	INX	B
	DAD	D
	JC	DIVLP
	DCX	B
	XCHG
	LHLD	SPT
	DAD	D
	PUSH	H
	LHLD	SYSTRK
	DAD	B
	XCHG
	POP	H
	INX	H
	RET
;
;ZAP ABILITY TO DO "F" (FIND NEXT) BECAUSE ANOTHER
;DISK COMMAND LOST POSITIONING.
;
NOCONT	PUSH	H
	LXI	H,0
	SHLD	FCONT
	POP	H
	RET
;
;POSITION TO FILENAME BY "MANUALLY" READING
;THE DIRECTORY.  THIS OVERCOMES THE 2.2 PROBLEM
;OF BEING UNABLE TO DETECT WHAT SECTOR WAS
;FOUND AFTER "SEARCH FIRST" BDOS FUNCTION
;
POSFIL	MOV	A,M	;GET CHAR AFTER 'F'
	CPI	CR
	JZ	PFCONT	;NO NAME
	CPI	';'	;NEXT COMMAND?
	JZ	PFCONT
	LXI	D,FCB
	XRA	A	;LOGGED IN DISK
	STAX	D
	INX	D
	MVI	B,8
	CALL	MVNAME
	MVI	B,3
	CALL	MVNAME
	PUSH	H
	LHLD	SYSTRK	;TO
	SHLD	CURTRK	;	DIR
	LXI	H,0	;INIT TO 0, CALLS
	SHLD	CURSEC	;	NEXTSEC B4 USING
	LHLD	DRM	;# OF DIR ENTRIES-1
	INX	H	;	EXACT #
	SHLD	NUMENT	;# OF DIR ENTRIES
	LXI	B,80H+BASE
	CALL	SETDMA
PFRD	CALL	NEXTSEC
	LHLD	CURTRK
	XCHG
	CALL	SETTRK
	LHLD	CURSEC
	XCHG
	CALL	SETSEC
	CALL	READ
	LXI	H,80H+BASE
PFNRD	LXI	D,FCB+1	;TO NAME
	INX	H	;SKIP DISK BYTE
;
;SEE IF THIS NAME MATCHES
;
	MVI	B,11	;NAME LENGTH
PFMATLP	LDAX	D	;GET NAME CHAR
	CPI	'?'
	JZ	PFMAT	;MATCH ANY
	CMP	M	;MATCH EXACTLY?
	JZ	PFMAT
	ORI	80H	;TRY MATCH WITH HI BIT
	CMP	M
	JNZ	PFNMAT	;	NO
PFMAT	INX	H
	INX	D
	DCR	B
	JNZ	PFMATLP
;
;GOT NAME
;
	CALL	CALCSUB	;COMPUTE GROUP
	CALL	INQSUB	;SHOW WHICH ONE
	MOV	A,L	;GET DISPLACEMENT
	ANI	060H	;TO START OF NAME
	STA	SECDISP
	ORI	80H	;PUT IT BACK 80-FF
	MOV	L,A
	SHLD	FCONT	;SAVE FOR "F"IND NEXT
	LXI	D,32	;DUMP LENGTH
	XCHG
	DAD	D	;SET UP FOR DUMP
	XCHG
	XRA	A
	STA	NOTPOS	;SHOW NOW POSITIONED
	MVI	A,'D'
	STA	DUMTYPE
	STA	WRFLG	;ALLOW REWRITE
	JMP	DUMPLP	;DUMPLP POPS H (CMD BUF ADDR)
;
;NOT FOUND
;
PFNOTF	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'++FILE NOT FOUND',CR,LF,0
	POP	H	;GET CMD BUFF PTR
	CALL	NOWRITE
	CALL	NOCONT
	MVI	A,1
	STA	NOTPOS
	JMP	PROMPTR
;
;CONTINUING FIND
;
PFCONT	PUSH	H
	LHLD	FCONT
	MOV	A,H
	ORA	L
	JNZ	PFNMAT
	POP	H
	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'++Can''t continue F command',CR,LF,0
	JMP	PROMPTR
;
;NO MATCH, GET NEXT CHAR
;
PFNMAT	XCHG		;SAVE BUFF POINTER
	LHLD	NUMENT	;GET # DIR ENTRIES
	DCX	H
	SHLD	NUMENT
	MOV	A,H
	ORA	L
	JZ	PFNOTF	;NOT FOUND
	XCHG		;BUFF BACK TO HL
	MOV	A,L	;GET DISPLACEMENT
	ANI	0E0H	;BACK TO START OF ENTRY
	ADI	32	;ONE ENTRY
	MOV	L,A
	JNC	PFNRD	;NO READ, STILL IN SECTOR
	JMP	PFRD	;TO NEXT SECTOR
;
MVNAME	MOV	A,M
	INX	H	;IN CASE HAVE TO SKIP
	CPI	'.'	;	'.'
	JZ	PADSP
	CPI	'*'	;	OR '*'
	JZ	PADQ	;FILL W/"?"
	DCX	H	;
	CPI	CR
	JZ	PADSP
	CPI	';'
	JZ	PADSP
	CALL	UPCASE
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MVNAME
	MOV	A,M
	CPI	CR
	RZ
	CPI	';'
	RZ
	INX	H
	CPI	'.'
	RZ
	JMP	WHAT
;
PADSP	MVI	A,' '
	JMP	PAD
;
PADQ	MVI	A,'?'
;
PAD	STAX	D
	INX	D
	DCR	B
	JNZ	PAD
	MOV	A,M	;SKIP '.'
	CPI	'.'	;	AFTER '*'
	RNZ		;	IN "*.*"
	INX	H
	RET
;
PLUS	LDA	NOTPOS
	ORA	A
	JNZ	CANTRD
	CALL	NOCONT
	LXI	D,1	;DFLT TO 1 SECT
	MOV	A,M	;GET NEXT CHAR
	CPI	CR	;CR?
	JZ	PLUSGO	;..YES, DFLT TO 1
	CPI	';'
	JZ	PLUSGO
	CALL	DECIN	;GET DECIMAL #
	MOV	A,D
	ORA	E
	JZ	WHAT
PLUSGO	CALL	NEXTSEC
	DCX	D	;MORE TO GO?
	MOV	A,D
	ORA	E
	JNZ	PLUSGO	;..YES
;
;OK, INCREMENTED TO SECTOR.  SETUP AND READ
;
PLUSMI	PUSH	H
	LHLD	CURSEC
	XCHG
	CALL	SETSEC
	LHLD	CURTRK
	XCHG
	CALL	SETTRK
	POP	H
	CALL	READ
	JMP	CALCGRP
;
MINUS	LDA	NOTPOS
	ORA	A
	JNZ	CANTRD
	CALL	NOCONT
	LXI	D,1	;SET DFLT
	MOV	A,M	;GET CHAR
	CPI	CR	;CR?
	JZ	MINGO	;..YES, DFLT=1
	CPI	';'
	JZ	MINGO
	CALL	DECIN	;..NO, GET ##
	MOV	A,D
	ORA	E
	JZ	WHAT
MINGO	PUSH	H
	LHLD	CURSEC
	DCX	H
	MOV	A,H
	ORA	L
	JNZ	MINOK
	LHLD	CURTRK
	MOV	A,H
	ORA	L
	JNZ	SEASH
	LHLD	CURSEC
	INX	H
	SHLD	CURSEC
BOUNDS	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'Out of bounds',CR,LF,0
	JMP	PROMPTR
;
SEASH	DCX	H
	SHLD	CURTRK
	LHLD	SPT
MINOK	SHLD	CURSEC
	POP	H
	DCX	D
	MOV	A,D
	ORA	E
	JNZ	MINGO
	JMP	PLUSMI
;
;Go to next sector
;
NEXTSEC	PUSH	H
	PUSH	D
	LHLD	CURSEC
	INX	H
	XCHG
	LHLD	SPT
	CALL	SUBDE
	XCHG
	JNC	NEXTOK
	LHLD	CURTRK
	INX	H
	XCHG
	LHLD	MAXTRK
	CALL	SUBDE
;
;07/31/81 Delete wrap to start (hangs on my system,
;	hangs on Micromation).  ...but mostly because
;	the "front" of the disk has n-o-t-h-i-n-g to
;	do with the "back" of the disk, so why wrap?
;
;	A less "emotional" and more "practical reason,
;	is that commands such as "q+;/" (used to check
;	if a disk is readable) or "=xxx" (which scans
;	forward for a match) by "definition" shouldn't
;	"wrap and run forever". <WLC>
;
	JC	BOUNDS
;
	XCHG
	SHLD	CURTRK
	LXI	H,1
;
NEXTOK	SHLD	CURSEC
	POP	D
	POP	H
	RET
;
;TELL WHAT GROUP, DISPLACEMENT, TRACK, SECTOR, PHYSICAL SECTOR
;
INQ	CALL	INQSUB
	JMP	PROMPT
;
;POSITION INQUIRY SUBROUTINE
;EXECUTED VIA: G S OR T (WITH NO OPERANDS)
;
INQSUB	PUSH	H
	LHLD	SYSTRK
	XCHG
	LHLD	CURTRK
	CALL	SUBDE
	JC	NOGRP
	CALL	ILPRT
	DB	'G=',0
	LHLD	GROUP
	MOV	B,H
	MOV	C,L
	CALL	HEXB
	MVI	A,':'
	CALL	TYPE
	LDA	GRPDISP
	CALL	HEX
	MVI	A,','
	CALL	TYPE
NOGRP	CALL	ILPRT
	DB	' T=',0
	LHLD	CURTRK
	CALL	DEC
	CALL	ILPRT
	DB	', S=',0
	LHLD	CURSEC
	CALL	DEC
	CALL	ILPRT
	DB	', PS=',0
	LHLD	PHYSEC
	CALL	DEC
	CALL	CRLF
	POP	H
	RET
;
CHG	MOV	A,M	;GET TYPE (HEX, ASCII)
	CALL	UPCASE
	PUSH	PSW	;SAVE "H" OR "A"
	INX	H
	CALL	DISP	;GET, VALIDATE DISP TO DE
	INX	H
	LXI	B,0	;SHOW NO 'THRU' ADDR
	CPI	'-'	;TEST DELIM FR. DISP
	JNZ	CHGNTH	;NO THRU
	PUSH	D	;SAVE FROM
	CALL	DISP	;GET THRU
	INX	H	;SKIP END DELIM
	MOV	B,D
	MOV	C,E	;BC = THRU
	POP	D	;GET FROM
	JMP	CHGAH
;
CHGNTH	CPI	','
	JNZ	WHAT
;
CHGAH	POP	PSW
	CPI	'H'
	JZ	CHGHEX
	CPI	'A'
	JNZ	WHAT
;CHANGE ASCII
CHGALP	MOV	A,M
	CPI	CR
	JZ	PROMPTC
	CPI	';'
	JZ	PROMPTC
	LDAX	D
	CPI	' '
	JC	CHGAHX
	CPI	7EH
	JNC	CHGAHX
	JMP	CHGA2
;
CHGAHX	CALL	BHEX
	JMP	CHGA3
;
CHGA2	CALL	TYPE
CHGA3	SHLD	BACK	;IN CASE "THRU"
	CALL	GETVAL	;ASCII OR <HEX>
	STAX	D	;UPDATE CHAR
	INX	H	;TO NEXT INPUT CHAR
;See if 'THRU' requested
	MOV	A,C
	ORA	A
	JZ	CHGANTH
	CMP	E	;DONE?..
	JZ	PROMPTC	;..YES
	LHLD	BACK
CHGANTH	INR	E
	JNZ	CHGALP
	MOV	A,M
	CPI	CR
	JZ	PROMPTC
	CPI	';'
	JZ	PROMPTC
	JMP	WHAT
;
;CHANGE HEX
;
CHGHCOM	INX	H
;
CHGHEX	MOV	A,M
	CPI	CR
	JZ	PROMPTC
	CPI	';'
	JZ	PROMPTC
	CPI	','	;DELIM?
	JZ	CHGHCOM
	PUSH	D
	SHLD	HEXAD	;IN CASE 'THRU'
	CALL	HEXIN	;POSITIONS TO DELIM
	MOV	A,E	;GET VALUE
	POP	D	;..ADDR
	PUSH	PSW	;SAVE VALUE
	LDAX	D	;GET OLD
	CALL	HEX	;ECHO IN HEX
	POP	PSW	;GET NEW
	STAX	D	;SAVE NEW
	MOV	A,C	;SEE IF 'THRU'
	ORA	A
	JZ	CHGHNTH	;..NO.
	CMP	E	;..YES, DONE?
	JZ	PROMPTC
	LHLD	HEXAD	;..NO: MORE
CHGHNTH	INR	E
	JNZ	CHGHEX
	MOV	A,M
	CPI	CR
	JZ	PROMPTC
	CPI	';'
	JZ	PROMPTC
	JMP	WHAT
;
DOREAD	CALL	READ
	JMP	PROMPT
;
CANTRD	XRA	A
	STA	QFLAG	;NOT QUIET
	CALL	ILPRT
	DB	'++Can''t read or go +/-: not positioned',CR,LF
	DB	'Position by:',CR,LF
	DB	9,'Track then Sector, or',CR,LF
	DB	9,'Group or to file name via F',CR,LF,0
	JMP	PROMPT
;
DOWRITE	CALL	WRITE
	JMP	PROMPT
;
BHEX	PUSH	PSW
	MVI	A,'<'
	CALL	TYPE
	POP	PSW
	CALL	HEX
	MVI	A,'>'
	CALL	TYPE
	RET
;
HEXB	LDA	DSM+1
	ORA	A
	JZ	HEXX
	MOV	A,B
	CALL	HEX
HEXX	MOV	A,C
HEX	PUSH	PSW
	RAR
	RAR
	RAR
	RAR
	CALL	NIBBL
	POP	PSW
NIBBL	ANI	0FH
	CPI	10
	JC	HEXNU
	ADI	7
HEXNU	ADI	'0'
	JMP	TYPE
;
;Decimal output routine
;
DEC	PUSH	B
	PUSH	D
	PUSH	H
	LXI	B,-10
	LXI	D,-1
DECOU2	DAD	B
	INX	D
	JC	DECOU2
	LXI	B,10
	DAD	B
	XCHG
	MOV	A,H
	ORA	L
	CNZ	DEC
	MOV	A,E
	ADI	'0'
	CALL	TYPE
	POP	H
	POP	D
	POP	B
	RET
;
SPACE	MVI	A,' '
	JMP	TYPE
;
ASTER	MVI	A,'*'
	JMP	TYPE
;
;Inline print routine
;
ILPRT	XTHL
ILPLP	CALL	CTLCS	;ABORT?
	JZ	PROMPRC
	MOV	A,M
	CPI	1	;PAUSE?
	JNZ	ILPOK
	CALL	CONIN
	CPI	3	;ABORT?
	JZ	PROMPTR
	JMP	ILPNX
;
ILPOK	CALL	TYPE
ILPNX	INX	H
	MOV	A,M
	ORA	A
	JNZ	ILPLP
	INX	H
	XTHL
	RET
;
;DISP CALLS HEXIN, AND VALIDATES A SECTOR
;DISPLACEMENT, THEN CONVERTS IT TO AN ADDRESS
;
DISP	CALL	HEXIN
	PUSH	PSW	;SAVE DELIMITER
	MOV	A,D
	ORA	A
	JNZ	BADISP
	MOV	A,E
	ORA	A
	JM	BADISP
	ADI	80H	;TO POINT TO BUFFER AT BASE+80H
	MOV	E,A
	MVI	D,BASE/256
	POP	PSW	;GET DELIM
	RET
;
BADISP	XRA	A
	STA	QFLAG	;NOT QUIET
	CALL	ILPRT
	DB	'++BAD DISPLACEMENT (NOT 0-7F)'
	DB	CR,LF,0
	JMP	PROMPTR
;
HEXIN	LXI	D,0
	MOV	A,M
	CPI	'#'	;DECIMAL?
	JZ	HDIN	;MAKE DECIMAL
	CPI	'@'
	JZ	GETDISP
HINLP	MOV	A,M
	CALL	UPCASE
	CPI	CR
	RZ
	CPI	';'
	RZ
	CPI	','
	RZ
	CPI	'-'	;'THRU'?
	RZ
	CPI	'>'
	RZ
	INX	H
	CPI	'H'	;TERMINATOR?
	JZ	HINLP	;YES, SKIP IT
	CPI	'0'
	JC	WHAT
	CPI	'9'+1
	JC	HINNUM
	CPI	'A'
	JC	WHAT
	CPI	'F'+1
	JNC	WHAT
	SUI	7
HINNUM	SUI	'0'
	XCHG
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	ADD	L
	MOV	L,A
	XCHG
	JMP	HINLP
;
HDIN	INX	H	;SKIP '#'
DECIN	CALL	SCANH	;SEE IF xxxH
	JZ	HEXIN
	LXI	D,0
DINLP	MOV	A,M
	CALL	UPCASE
	CPI	CR
	RZ
	CPI	';'
	RZ
	CPI	','
	RZ
	CPI	'-'	;'THRU'?
	RZ
	INX	H
	CPI	'0'
	JC	WHAT
	CPI	'9'+1
	JNC	WHAT
	SUI	'0'
	PUSH	H
	MOV	H,D
	MOV	L,E
	DAD	H	;X2
	DAD	H	;X4
	DAD	D	;X5
	DAD	H	;X10
	ADD	L
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A
	XCHG
	POP	H
	JMP	DINLP
;
;SCAN TO SEE IF xxxH WAS SPECIFIED
;
SCANH	MOV	D,H
	MOV	E,L	;XFER HL TO DE
SCANHL	LDAX	D
	CALL	UPCASE
	CPI	'H'
	RZ
	INX	D	;TO NEXT
	CPI	'0'
	RC
	CPI	'9'+1
	JC	SCANHL
	CPI	'A'
	RC
	CPI	'F'+1
	JC	SCANHL
	ORA	A	;SET NON ZERO
	RET
;
;REQUEST TO GET DISPLACEMENT IN SECTOR
;AT WHICH LAST "=" COMMAND MATCHED.
;
GETDISP	INX	H	;SKIP "@"
	MOV	A,M
	CPI	'-'
	JZ	DISPPM
	CPI	'+'
	JZ	DISPPM
	LDA	SECDISP	;GET DISPLACEMENT
	ANI	7FH	;MAKE IT RELATIVE TO 0
	MOV	E,A	;SAVE IT
	MVI	D,0	;SET DE = TO IT
	MOV	A,M	;GET ENDING DELIM
	RET
;
;GOT + OR - DISPLACEMENT
;
DISPPM	PUSH	PSW	;SAVE +/-
	INX	H	;TO NEXT
	CALL	HEXIN	;GET VALUE TO DE
	POP	PSW	;GET +/-
	CPI	'-'	;IF -,
	CZ	COMDE	;	COMPLEMENT DE
	LDA	SECDISP
	ADD	E
	ANI	7FH	;PRESERVE SECT DISPL
	MOV	E,A
	MVI	D,0	;DE = 0-7F
	MOV	A,M	;GET DELIMITER FOR 
	RET		;	FURTHER TESTS
;
;COMPLEMENT DE
;
COMDE	MOV	A,D
	CMA
	MOV	D,A
	MOV	A,E
	CMA
	MOV	E,A
	INX	D	;1'S COMP ==> 2'S COMP
	RET
;
;READ IN A CONSOLE BUFFER FULL
;
RDBUF	MVI	A,':'
	CALL	TYPE
;
RDBF1	LXI	H,INBUF
	MVI	B,0
RDBLP	CALL	CONIN
	MOV	C,A	;SAVE FOR BS TEST
;
;Evaluate control characters
;
	CPI	'U'-40H	! JZ RDCTLU
	CPI	CR	! JZ RDCR
	CPI	'H'-40H	! JZ RDBS
	CPI	7FH	! JZ RDBS
	CPI	'R'-40H	! JZ RDCTLR
	CPI	'X'-40H ! JZ RDCTLX
	CPI	' '	! JC RDBCCC	;CHECK ^C
	MOV	M,A
	INX	H
	INR	B
	JM	FULL
	CALL	TYPE
	JMP	RDBLP
;
FULL	DCR	B
	DCX	H
	MVI	A,'*'	;SIGNAL WE'RE FULL
	CALL	TYPE
	JMP	RDBLP
;
;GOT CR
;
RDCR	MOV	M,A	;SAVE IT
	CALL	TYPE	;ECHO IT
	MVI	A,LF	;ECHO..
	CALL	TYPE	;..LF
	LXI	H,INBUF
	RET
;
;GOT DELETE OR BS, ECHO IF BS
;
RDBS	XRA	A	;AT FRONT..
	ORA	B	;..OF LINE?
	JZ	RDCTLU	;..YES, ECHO ^U
	DCX	H
	DCR	B
	MOV	A,C
	CPI	'H'-40H	;BS?
	JZ	BACKUP	;ECHO THE BS
	MOV	A,M	;ECHO..
	CALL	TYPE	;..DELETED CHAR
	JMP	RDBLP
;
BACKUP	CALL	WIPER
	JMP	RDBLP
;
RDCTLX	INR	B
RDCX1	DCR	B
	JZ	RDBF1
	CALL	WIPER
	JMP	RDCX1
;
WIPER	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,BSMSG	;BACKSPACE, SPACE, BACKSPACE
	MVI	C,PRINT
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	RET
;
BSMSG	DB	BS,' ',BS,'$'
;
;CHECK FOR ^C TYPED - MAY HAVE FORGOTTEN "X" EXITS
;
RDBCCC	CPI	'C'-40H
	JNZ	RDBLP
	CALL	ILPRT
	DB	'^C Ignored - Use X command to '
	DB	'exit to CP/M',0
;
;GOT CTL-R, RETYPE
;
RDCTLR	MVI	M,CR
	CALL	CRLF
	LXI	H,INBUF
	MVI	B,0
RDCRL	MOV	A,M
	CPI	CR
	JZ	RDBLP
	CALL	TYPE
	INR	B
	INX	H
	JMP	RDCRL
;
;GOT CTL-U OR BACKUP TO BEGINNING OF LINE.
;
RDCTLU	MVI	A,'^'
	CALL	TYPE
	MVI	A,'U'
	CALL	TYPE
	CALL	CRLF
	JMP	RDBUF
;
CRLF	MVI	A,CR
	CALL	TYPE
	MVI	A,LF
	JMP	TYPE
;
UPCASE	CPI	60H
	RC
	ANI	5FH	;MAKE UPPER CASE
	RET
;
;SCREEN CLEAR ROUTINE
;
ERASE	LXI	D,CLEAR
ERLP	LDAX	D	;GET CHAR
	CPI	0FFH
	JZ	PROMPT	;DONE
	MOV	C,A
	PUSH	D
	PUSH	H
	CALL	VCONOUT
	POP	H
	POP	D
	INX	D
	JMP	ERLP
;
CONST	PUSH	B
	PUSH	D
	PUSH	H
VCONST	CALL	$-$	;ADDR FILLED IN BY 'INIT'
	POP	H
	POP	D
	POP	B
	RET
;
CONIN	PUSH	B
	PUSH	D
	PUSH	H
VCONIN	CALL	$-$	;ADDR FILLED IN BY 'INIT'
	POP	H
	POP	D
	POP	B
	RET
;
;CONSOLE OUT WITH TAB EXPANSION
;
TYPE	PUSH	B
	PUSH	D
	PUSH	H
	MOV	C,A	;FOR OUTPUT ROUTINE
	CPI	TAB
	JNZ	TYPE2
TYPETAB	MVI	A,' '
	CALL	TYPE
	LDA	TABCOL
	ANI	7
	JNZ	TYPETAB
	JMP	TYPERET
;
;FILTER OUT CONTROL CHARACTERS TO
;PREVENT GARBAGE DURING VIEW OF FILE
;
TYPE2	CPI	' '
	JNC	TYPEQ
	CPI	CR
	JZ	TYPEQ
	CPI	LF
	JNZ	TYPENCR
TYPEQ	LDA	QFLAG
	ORA	A
	CZ	VCONOUT
;UPDATE COLUMN USED IN TAB EXPANSION
	MOV	A,C	;GET CHAR
	CPI	CR
	JNZ	TYPENCR
	MVI	A,0
	STA	TABCOL
	JMP	TYPELST
;
VCONOUT	JMP	$-$	;ADDR FILLED IN BY 'INIT'
;
TYPENCR	CPI	' '	;CTL CHAR?
	JC	TYPELST	;..NO CHANGE IN COL
	LDA	TABCOL
	INR	A
	STA	TABCOL
TYPELST	LDA	PFLAG
	ANI	1
	CNZ	LIST	;FROM C REG.
TYPERET	POP	H
	POP	D
	POP	B
	RET
;
LIST	PUSH	B	;SAVED REGS
	PUSH	D
	PUSH	H
VLIST	CALL	$-$	;ADDR FILLED IN BY 'INIT'
	POP	H
	POP	D
	POP	B
	RET
;
HOME	PUSH	H
VHOME	CALL	$-$	;ADDR FILLED IN BY 'INIT'
	POP	H
	RET
;
;Set track # in DE
;
SETTRK	PUSH	H
	LHLD	MAXTRK
	CALL	SUBDE
	POP	H
	JC	OUTLIM
	XCHG
	SHLD	CURTRK
	XCHG
	MOV	B,D
	MOV	C,E
	PUSH	H
VSETTRK	CALL	$-$	;ADDR FILLED IN BY 'INIT'
	POP	H
	RET
;
SETSEC	PUSH	H
	PUSH	D
	LHLD	SYSTRK
	XCHG
	SHLD	CURSEC
	LHLD	CURTRK
	CALL	SUBDE
	POP	B
	MOV	H,B
	MOV	L,C
	JNC	NOTSYS
	LDA	FIRST0	;SEE IF FIRST SEC 0
	ORA	A
	JNZ	GSETSEC	;NO, JUMP AWAY
	DCX	H	;YES, SO DECREMENT
	JMP	GSETSEC	;  REQUESTED, THEN GO
;
NOTSYS	LHLD	SECTBL
	XCHG
	DCX	B
VSCTRN	CALL	$-$	;ADDR FILLED IN BY 'INIT'
	LDA	SPT+1	;IF SPT<256 (HI-ORD = 0)
	ORA	A	; THEN FORCE 8-BIT TRANSLATION
	JNZ	VSCTR1	; ELSE KEEP ALL 16 BITS
	MOV	H,A
VSCTR1	LDA	VER2FL	;SEE IF VERSION 2.x
	ORA	A	;SET FLAGS
	JNZ	GSETSEC	;JUMP IF CP/M 2.x
	MVI	H,0	;CP/M 1.4 GOOD TO ONLY 8 BITS
	MOV	L,C	;MOST BIOS'S RETURN THE
			;  PHYSICAL SEC # IN REG C
GSETSEC	SHLD	PHYSEC	;THIS MAY BE REDUNDANT IN
			; MOST 1.4 VERSIONS, BUT
			; SHOULD CAUSE NO PROBLEMS
	MOV	B,H
	MOV	C,L
VSETSEC	CALL	$-$	;ADDR FILLED IN BY 'INIT'
	POP	H
	RET
;
OUTLIM	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'++not within tracks 0-',0
	PUSH	H
	LHLD	MAXTRK
	CALL	DEC
	POP	H
	CALL	ILPRT
	DB	'++'
	DB	CR,LF,0
	CALL	NOWRITE
	JMP	PROMPTR
;
SETDMA	JMP	$-$	;ADDR FILLED IN BY 'INIT'
;
READ	MVI	A,1
	STA	WRFLG
	PUSH	H
VREAD	CALL	$-$	;ADDR FILLED IN BY 'INIT'
	ORA	A
	JZ	READOK
	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'++READ failed, sector may be invalid++'
	DB	CR,LF,0
READOK	POP	H
	RET
;
WRITE	LDA	WRFLG
	ORA	A
	JNZ	PWRITE
BADW	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'++CANNOT WRITE UNLESS READ ISSUED'
	DB	CR,LF,0
	JMP	EXPL
;
PWRITE	PUSH	H
	MVI	C,1	;FORCE WRITE TYPE 1 IN CASE 2.x DEBLOCK USED
VWRITE	CALL	$-$	;ADDR FILLED IN BY 'INIT'
	ORA	A
	JZ	WRITEOK
	XRA	A
	STA	QFLAG
	CALL	ILPRT
	DB	'++WRITE failed++',CR,LF,0
WRITEOK	POP	H
	RET
;
;HELP
;	10/21/81 Put BACK tabs instead of all
;		the spaces.  Sure wish I knew
;		what motivated people to do such
;		SENSLESS changes!
;	09/27/81 DELETED "type any char to continue".
;		(I find ^S an adequate means.  First
;		time I asked for "H" with DU-77, and
;		DID use ^S it took it as the "any char"
;		and instead of stopping IT WENT.  <WLC> )
;
HELP	CALL	ILPRT
	DB	'USE ^S to hold printing, ^C to abort it'
 DB CR,LF,CR,LF
	DB	'Operands in brackets [...] are optional;'
 DB CR,LF
	DB	'"xx" means hex; "nn" means decimal.  Where hex'
 DB CR,LF
	DB	'is the default, enter #nn for decimal.'
 DB CR,LF
	DB	'Change decimal input to hex via xxH (or Hxx).'
 DB CR,LF,CR,LF
	DB	'+[nn]	step in [nn] sectors;'
 DB CR,LF
	DB	'-[nn]	step out [nn] sectors'
 DB CR,LF
	DB	'#	print disk parameters for curr drive.'
 DB CR,LF
	DB	'	& # of saved (via "<<") sectors'
 DB CR,LF
	DB	'=sss	search for ASCII sss from curr sector.'
 DB CR,LF
	DB	'	Caution: upper/lower case matters.'
 DB CR,LF
	DB	'	Use <xx> for hex: <3b> for ";";'
 DB CR,LF
	DB	'	To find "IN 0" use: =<db><0>     or'
 DB CR,LF
	DB	'	for "(tab)H,0(CR)(LF)" use: =<9>H,0<D><A>'
 DB CR,LF
	DB	'	NOTE: After using "=", you may use "@" to'
 DB CR,LF
	DB	'	refer to the displacement of the match:'
 DB CR,LF
	DB	'	=LIX;ca@,LXI;w	would change LIX to LXI'
 DB CR,LF
	DB	'	@+xx and @-xx are allowed, too.'
 DB CR,LF
	DB	'<	save current sector into mem. buff.'
 DB CR,LF
	DB	'	(Resets memory pointer used by "<<").'
 DB CR,LF
	DB	'<<	save current sector, bump mem addr.'
 DB CR,LF
	DB	'	NOTE: this buffer is at 2000H, so you'
 DB CR,LF
	DB	'	can exit DUU and get at the sectors.'
 DB CR,LF
	DB	'	ALSO NOTE: # reports # of saved sects.'
 DB CR,LF
	DB	'>	restore saved sector'
 DB CR,LF
	DB	'>>	restore oldest saved sector, setup for next'
 DB CR,LF
	DB	'?	give help'
 DB CR,LF
	DB	'A[ff,tt] ASCII dump (hex ff, tt, 7F max)'
 DB CR,LF
	DB	'C	Change:'
 DB CR,LF
	DB	'	CHaddr,byte,byte... (hex)'
 DB CR,LF
	DB	'  or	CAaddr,data...  (Ascii)'
 DB CR,LF
	DB	'	<xx> Allowed for imbedded hex.'
 DB CR,LF
	DB	'  or	CHfrom-thru,byte  e.g. ch0-7f,e5'
 DB CR,LF
	DB	'  or	CAfrom-thru,byte'
 DB CR,LF
	DB	'D[ff,tt] Dump (hex+ASCII)'
 DB CR,LF
	DB	'E	Send erase-screen (string at 104H, FF ends)'
 DB CR,LF
	DB	'Fn.t	Find file'
 DB CR,LF
	DB	'F	Find next extent of file'
 DB CR,LF
	DB	'Gxx	CP/M Allocation Group xx'
 DB CR,LF
	DB	'H[ff,tt] hex dump'
 DB CR,LF
	DB	'L	Log in drive'
 DB CR,LF
	DB	'Lx	Log in drive x'
 DB CR,LF
	DB	'M[xx]	Map [from group xx]'
 DB CR,LF
	DB	'N	New disk'
 DB CR,LF
	DB	'P	Toggle printer switch'
 DB CR,LF
	DB	'Q	Quiet mode (no msgs)'
 DB CR,LF
	DB	'R	Read current sector'
 DB CR,LF
	DB	'Snn	Sector nn'
 DB CR,LF
	DB	'Tnn	Track nn'
 DB CR,LF
	DB	'V[nn]	View [nn] ASCII sectors'
 DB CR,LF
	DB	'W	Write current sector'
 DB CR,LF
	DB	'X	Exit program'
 DB CR,LF
	DB	'Z[nn]	Sleep [nn tenths]'
 DB CR,LF
	DB	'/[nn]	Repeat [nn times]'
 DB CR,LF,CR,LF
	DB	'Cancel a function with C or Ctl-C.'
 DB CR,LF
	DB	'Suspend output with S or Ctl-S.'
 DB CR,LF
	DB	'Separate commands with ";".'
 DB CR,LF
	DB	'	Example: g0'
 DB CR,LF
	DB	'	+;d;z20;/'
 DB CR,LF
	DB	'	would step in, dump, sleep 2 sec, '
 DB CR,LF
	DB	'	and repeat until control-c typed.'
 DB CR,LF,CR,LF
	DB	'See DU.DOC for complete examples.'
 DB CR,LF,CR,LF,0
	JMP	PROMPT
;
;	Subroutines
;
GRPCMP	MOV	A,C
	INR	D
	DCR	D
	JZ	CMP8
	CMP	M
	INX	H
	RNZ
	MOV	A,B
CMP8	CMP	M
	RET
;
;2's complement HL ==> HL
;
NEG	MOV	A,L
	CMA
	MOV	L,A
	MOV	A,H
	CMA
	MOV	H,A
	INX	H
	RET
;
;HL/2 ==> HL
;
ROTRHL	ORA	A
	MOV	A,H
	RAR
	MOV	H,A
	MOV	A,L
	RAR
	MOV	L,A
	RET
;
;Collect the number of '1' bits
;in A as a count in C
;
COLECT	MVI	B,8
;
COLOP	RAL
	JNC	COSKIP
	INR	C
;
COSKIP	DCR	B
	JNZ	COLOP
	RET
;
;HL-DE ==> HL
;
SUBDE	MOV	A,L
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A
	RET
;
;Quick Kludge multiply
;HL=DE ==> HL
;
MULT	PUSH	B
	PUSH	D
	XCHG
	MOV	B,D
	MOV	C,E
	MOV	A,B
	ORA	C
	JNZ	MULCON
	LXI	H,0	;FILTER SPECIAL CASE
	JMP	MLDONE	;	OF MULTIPLY BY 0
;
MULCON	DCX	B
	MOV	D,H
	MOV	E,L
;
MULTLP	MOV	A,B
	ORA	C
	JZ	MLDONE
	DAD	D
	DCX	B
	JMP	MULTLP
;
MLDONE	POP	D
	POP	B
	RET
;
;Routine to fill in disk params
;with every drive change
;
LOGIT	LDA	VER2FL
	ORA	A	;IF NOT CP/M 2.x THEN
	JZ	LOG14	;	DO IT AS 1.4
	LXI	D,DPB	;  THEN MOVE TO LOCAL
	MVI	B,DPBLEN ;  WORKSPACE
	CALL	MOVE
	JMP	LOGCAL
;
LOG14	LHLD	BDOS+1	;FIRST FIND 1.4 BDOS
	MVI	L,0
	LXI	D,DPBOFF ;THEN OFFSET TO 1.4'S DPB
	DAD	D
	MVI	D,0	;SO 8 BIT PARMS WILL BE 16
	MOV	E,M	;NOW MOVE PARMS
	INX	H
	XCHG
	SHLD	SPT
	XCHG
	MOV	E,M
	INX	H
	XCHG
	SHLD	DRM
	XCHG
	MOV	A,M
	INX	H
	STA	BSH
	MOV	A,M
	INX	H
	STA	BLM
	MOV	E,M
	INX	H
	XCHG
	SHLD	DSM
	XCHG
	MOV	E,M
	INX	H
	XCHG
	SHLD	AL0
	XCHG
	MOV	E,M
	XCHG
	SHLD	SYSTRK
;
LOGCAL	LXI	H,GRPDISP
	MOV	A,M
	PUSH	PSW
	LDA	BLM
	MOV	M,A
	PUSH	H
	LHLD	DSM
	XCHG
	CALL	GTKSEC
	SHLD	MAXSEC
	XCHG
	SHLD	MAXTRK
	POP	H
	POP	PSW
	MOV	M,A
	RET
;
;Temporary storage area
;
BUFAD	DW	BASE+100H ;FORCES INITIAL READ
HEXAD	DW	0	;TO RE-FETCH A VALUE
TOGO	DW	0FFFFH	;REPEAT COUNT (FFFF=CONT)
TWOUP	DB	0
PFLAG	DB	0	;1=PRINT
GROUP	DW	0
GRPDISP	DB	0
SAVEFLG	DB	0
CURTRK	DW	0
CURSEC	DW	1
PHYSEC	DW	1
TABCOL	DB	0
FILECT	DW	0
DIRPOS	DB	0
FINDFLG	DB	0	;1=MUST POSITION AFTER FIND
FTSW	DB	1	;SEARCH W/O INCREMENT
NOTPOS	DB	1	;INITIALLY NOT POSITIONED
WRFLG	DB	0	;MAY NOT WRITE UNTIL '+', '-',
;			 OR 'G' COMMAND
QFLAG	DB	0	;QUIET? (0=NO)
FIRST0	DB	0	;SETS TO 0 IF FIRST SEC # IS 0
DRIVE	DB	0
MAXTRK	DW	0
MAXSEC	DW	0
VER2FL	DB	0
SECTBL	DW	0	;POINTER TO SECTOR SKEW TABLE
NXTSAVE	DW	SAVEBUF	;NEXT SECT BUFFER TO STORE INTO
;			 (READDIR READS DIR IN HERE, TOO)
NXTREST	DW	SAVEBUF	;NEXT SECT BUFFER TO READ FROM
NUMSAVD	DB	0	;# IN BUFFER
NUMREST	DB	0	;# WRITTEN SO FAR
SECDISP	DB	0	;DISP IN SECTOR AT WHICH MATCH
;			;OCCURRED
;
	DS	120	;STACK SPACE
STACK:
BACK	DS	2	;TO BACK UP IN "CA0-7F,X"
NUMENT	DS	2	;# OF DIR ENTRIES FOR "F" TO SCAN
FCONT	DS	2	;FIND - CONTINUE SEARCH POINTER
DUMTYPE	DS	1
;
;	-	-	-	-	-	-	-
;The disk parameter block
;is moved here from CP/M
;
DPB	EQU	$	;DISK PARAMETER BLOCK (COPY)
SPT	DS	2
BSH	DS	1
BLM	DS	1
EXM	DS	1
DSM	DS	2
DRM	DS	2
AL0	DS	1
AL1	DS	1
CKS	DS	2
SYSTRK	DS	2
;
;End of disk parameter block
;
INBUF	DS	128
;
;ORG TO 2000, SO SID/DDT MAY BE LOADED TO WORK
;WITH DATA SAVED BY MULTIPLE "<<" COMMANDS.
;(SHOULD DUU GROW, THIS WILL AUTOMATICALLY
;BE ORGed TO 3000H WHEN NECESSARY)
;
	ORG	($+0FFFH) AND 0F000H
;
SAVEBUF	EQU	$	;X000 ALIGNED SECT BUFF
;
;NOTE DIRECTORY READ IN HERE "SOMEWHERE" DEPENDING
;UPON WHERE NXTSAVE POINTS
;
	END
