
/*
 *
 *			     C-HELPER
 *
 *		HELP Facility for C-HELPER
 *
 * 
 *		for MS-DOS and Computer Innovations C86 
 * 
 *		Copyright (c) 1983,84 Solution Systems
 *
 *			  May 1984 
 * 
 */

#include "stdio.h" 
#include "chelper.h"

#define  HELPFILE 	"CHELPER.HLP"   	/* name of help file */ 
#define  DELIMITER	'?'			/* help file */ 
#define  LINEMAX	512
#define  PAGE		24

FILE *fopen();


/* chelper: help module */
main()
{

    help();       /* give user help */ 
}

/* display copyright */ 
banner() 
{ 

    fprintf(errmsg,
	"\tCHELPER %s Copyright (C) 1983,84 Solution Systems\n",version);

} 

/* give the user some help */
help()
{
FILE *input;

	if(!(input=fopen(HELPFILE,"r"))) {	
		fprintf(stderr,"Help file not found: %s\n", 
			HELPFILE); 
		exit(1); 
	}		 
	while(helpuser(input))  
		fseek(input,0L,0);	/* rewind to beginning */
	fclose(input); 
	return; 
}

/* helpuser: return 1 if continue, 0 else */ 
helpuser(input)                        
FILE *input; 
{ 
char ch; 

top: 
   menu(); 
   fprintf(errmsg,
	"\n\n\tPlease select one option from the above.");
   fprintf(errmsg,
	"\n\tThen press ENTER: ");
get: 
   ch=getchar(); 
   if(ch!='\n') 
	while(getchar()!='\n') 
		; 

   switch(ch) { 
	default:   goto get; 
	case '\n': goto top; 
	case 'Q': 
	case 'q':  return 0; 
	case '1':  return dohelp(input,"CHELPER"); 
	case '2':  return dohelp(input,"CBC"); 
	case '3':  return dohelp(input,"CCREF"); 
	case '4':  return dohelp(input,"DIFF"); 
	case '5':  return dohelp(input,"GREP"); 
	case '6':  return dohelp(input,"FCHART"); 
	case '7':  return dohelp(input,"PP"); 
	case '8':  return dohelp(input,"CUTIL"); 
   } 

}	/* end helpuser */


/* display menu on the screen */ 
menu() 
{ 

	fprintf(errmsg,"\n\n\n"); 
	banner(); 
	 
	fprintf(errmsg, 
	"\n\tSample Program Runs and Help are Available On:\n\n"); 

	pm('1',"CHELPER",	"Summary Of C-HELPER Programs"); 
	pm('2',"CBC",		"Curly Brace Checker"); 
	pm('3',"CCREF",		"C Program Cross Reference"); 
	pm('4',"DIFF",		"Differential Text File Comparator"); 
	pm('5',"GREP",		"Pattern Searching/Matching Program"); 
	pm('6',"FCHART",	"C Program Flowcharting Aid"); 
	pm('7',"PP",		"C Program Formatted Print (Pretty Print)"); 
	pm('8',"CUTIL",		"Multi-Purpose File Filter"); 

	fprintf(errmsg,"\n"); 
	pm('Q',"Quit",		"Exit to the Operating System"); 
        fprintf(errmsg,"\n\n\n"); 

}       /* end menu */


/* print menu entry */ 
pm(select,prog,description) 
char select, *prog, *description; 
{                 

	fprintf(errmsg,"\t%c - %-8s %s\n",select,prog,description); 

}       /* end pm */


/* give help on the subject */ 
dohelp(input,topic) 
FILE *input; 
char *topic; 
{ 
char buffer[LINEMAX]; 
int cnt; 

   fprintf(errmsg, 
	"\n\tHelp With %s\n",topic);   

   cnt=0; 
   while(fgets(buffer,LINEMAX,input)) { 
	if((*buffer==DELIMITER) &&  
           (!strncmp(buffer+1,topic,strlen(topic)))) { 
		while(fgets(buffer,LINEMAX,input)) { 
		   if(*buffer==DELIMITER) 
			goto good; 
		   if(++cnt>=PAGE) { 
			fprintf(stderr, 
			   "\t\t\t\t\tPress ENTER to continue...."); 
			while(getchar()!='\n')  ; 
			cnt=0; 
		   }			 
		   fputs(buffer,errmsg);
		} 
		goto good; 
	} 
   } 
   fprintf(errmsg,"\n\tHelp not found on %s\n",topic); 
   return 0;    	/* didn't find any help */ 

good: 
  fprintf(stderr,"\t\t\t\t\tPress  ENTER to continue...."); 
  while(getchar()!='\n') ; 
  return 1; 
}       	/* end dohelp */

 