/*
 *			PP C program formatter
 *
 *		USAGE: pp file_in [>file_out or prn:]
 *
 *	        FOR CP/M-86 AND COMPUTER INNOVATIONS C
 *
 *		    BY BOB GREEN FOR SOLUTION SYSTEMS
 *
 *		       Copyrite (c) December 1983
 */

#include "local.h"

int slevel[10];
int clevel;
int spflg[20][10];
int sind[20][10];
int siflev[10];
int sifflg[10];
int iflev;
int ifflg;
int level;
int ind[10];
int eflg;
int paren;
int pflg[10];
int aflg;
int ct;
int stabs[20][10];
int qflg;
int j;
int sflg;
int bflg;
int peek;
int tabs;
char lchar;
char pchar;
char *wif[2];
char *welse[2];
char *wfor[2];
char *wds[3];
char string[200];
char cc;
char lastchar;
char c;

main(argc,argv)
int argc;
char *argv[];
{
	FILE *fp, *fopen();

	if (argc < 2 || argc > 3) {
		fprintf(stderr,
		"\nPP C Program Formatter, Copyrite (c) Dec. 1983 by Solution Systems");
		fprintf(stderr,"\nUsage: pp input_file [>output_file]\n\n");
		exit();
	}

	if ((fp = fopen(*++argv,"r")) == 0) {
		fprintf(stderr,
		"\nPP C Program Formatter, Copyrite (c) Dec. 1983 by Solution Systems\n");
		fprintf(stderr,"File: %s not found\n\n",*argv);
		exit();
	}
	else {
		fprintf(stderr,
		    "\nPP C Program Formatter, Copyrite (c) Dec. 1983 by Solution Systems");
		fprintf(stderr, "\nprocessing file: %s\n\n",*argv);
		p_print(fp);
		exit();
	}
}

p_print(fp)
FILE *fp;
{

	/*  Initialize everything here.  */
	int i,k;
	clevel = iflev = level = eflg = paren = 0;
	aflg = qflg = j = bflg = tabs = 0;
	ifflg = peek = -1;
	sflg = 1;
	initw(ind,"0,0,0,0,0,0,0,0,0,0");
	initw(pflg,"0,0,0,0,0,0,0,0,0,0");
	wif[0] = "if";
	welse[0] = "else";
	wfor[0] = "for";
	wds[0] = "case";
	wds[1] = "default";
	wif[1] = welse[1] = wfor[1] = wds[2] = 0;
	/*  End of initialization.  */

	while ((c = getchr(fp)) != EOF) {
		switch(c) {
		default:
			string[j++] = c;
			if (c != ',') lchar = c;
			break;
		case ' ':
		case '\t':
			if (lookup(welse) == 1) {
				gotelse();
				if (sflg == 0 || j > 0) string[j++] = c;
				putx();
				sflg = 0;
				break;
			}
			if (sflg == 0 || j > 0) string[j++] = c;
			break;
		case '\n':
			if (eflg = lookup(welse) == 1) gotelse();
			putx();
			printf("\n");
			sflg = 1;
			if (eflg == 1) {
				pflg[level]++;
				tabs++;
			}
			else
				if (pchar == lchar)
					aflg = 1;
			break;
		case '{':
			if (lookup(welse) == 1) gotelse();
			siflev[clevel] = iflev;
			sifflg[clevel] = ifflg;
			iflev = ifflg = 0;
			clevel++;
			if (sflg == 1 && pflg[level] != 0) {
				pflg[level]--;
				tabs--;
			}
			string[j++] = c;
			putx();
			getnl(fp);
			putx();
			printf("\n");
			tabs++;
			sflg = 1;
			if (pflg[level] > 0) {
				ind[level] = 1;
				level++;
				slevel[level] = clevel;
			}
			break;
		case '}':
			clevel--;
			if ((iflev = siflev[clevel]-1) < 0) iflev = 0;
			ifflg = sifflg[clevel];
			putx();
			tabs--;
			ptabs();
			if ((peek = getchr(fp)) == ';') {
				printf("%c;",c);
				peek = -1;
			}
			else printf("%c",c);
			getnl(fp);
			putx();
			printf("\n");
			sflg = 1;
			if (clevel < slevel[level]) if (level > 0) level--;
			if (ind[level] != 0) {
				tabs -= pflg[level];
				pflg[level] = 0;
				ind[level] = 0;
			}
			break;
		case '"':
		case '\'':
			string[j++] = c;
			while ((cc = getchr(fp)) != c) {
				string[j++] = cc;
				if (cc == '\\') {
					string[j++] = getchr(fp);
				}
				if (cc == '\n') {
					putx();
					sflg = 1;
				}
			}
			string[j++] = cc;
			if (getnl(fp) == 1) {
				lchar = cc;
				peek = '\n';
			}
			break;
		case ';':
			string[j++] = c;
			putx();
			if (pflg[level] > 0 && ind[level] == 0) {
				tabs -= pflg[level];
				pflg[level] = 0;
			}
			getnl(fp);
			putx();
			printf("\n");
			sflg = 1;
			if (iflev > 0)
				if (ifflg == 1) {
					iflev--;
					ifflg = 0;
				}
				else iflev = 0;
			break;
		case '\\':
			string[j++] = c;
			string[j++] = getchr(fp);
			break;
		case '?':
			qflg = 1;
			string[j++] = c;
			break;
		case ':':
			string[j++] = c;
			if (qflg == 1) {
				qflg = 0;
				break;
			}
			if (lookup(wds) == 0) {
				sflg = 0;
				putx();
			}
			else {
				tabs--;
				putx();
				tabs++;
			}
			if ((peek = getchr(fp)) == ';') {
				printf(";");
				peek = -1;
			}
			getnl(fp);
			putx();
			printf("\n");
			sflg = 1;
			break;
		case '/':
			string[j++] = c;
			if ((peek = getchr(fp)) != '*') break;
			string[j++] = peek;
			peek = -1;
			comment(fp);
			break;
		case ')':
			paren--;
			string[j++] = c;
			putx();
			if (getnl(fp) == 1) {
				peek = '\n';
				if (paren != 0) aflg = 1;
				else if (tabs > 0) {
					pflg[level]++;
					tabs++;
					ind[level] = 0;
				}
			}
			break;
		case '#':
			string[j++] = c;
			while ((cc = getchr(fp)) != '\n') string[j++] = cc;
			string[j++] = cc;
			sflg = 0;
			putx();
			sflg = 1;
			break;
		case '(':
			string[j++] = c;
			paren++;
			if (lookup(wfor) == 1) {
				while ((c = getx(fp)) != ';');
				ct=0;
cont:
				while ((c = getx(fp)) != ')') {
					if (c == '(') ct++;
				}
				if (ct != 0) {
					ct--;
					goto cont;
				}
				paren--;
				putx();
				if (getnl(fp) == 1) {
					peek = '\n';
					pflg[level]++;
					tabs++;
					ind[level] = 0;
				}
				break;
			}
			if (lookup(wif) == 1) {
				putx();
				stabs[clevel][iflev] = tabs;
				spflg[clevel][iflev] = pflg[level];
				sind[clevel][iflev] = ind[level];
				iflev++;
				ifflg = 1;
			}
		}
	}
}

ptabs() {
	int i;
	for(i=0; i < tabs; i++) printf("        ");	     /* 8 spcs */
}

lookup(tab)
char *tab[];
{
	char r;
	int l,kk,k,i;
	if (j < 1) return(0);
	kk=0;
	while (string[kk] == ' ') kk++;
	for(i=0; tab[i] != 0; i++) {
		l=0;
		for(k=kk;(r = tab[i][l++]) == string[k] && r != '\0';k++);
		if (r == '\0' && (string[k] < 'a' || string[k] > 'z')) return(1);
	}
	return(0);
}

gotelse() {
	tabs = stabs[clevel][iflev];
	pflg[level] = spflg[clevel][iflev];
	ind[level] = sind[clevel][iflev];
	ifflg = 1;
}

getnl(fp)
FILE *fp;
{
	while ((peek = getchr(fp)) == '\t' || peek == ' ') {
		string[j++] = peek;
		peek = -1;
	}
	if ((peek = getchr(fp)) == '/') {
		peek = -1;
		if ((peek = getchr(fp)) == '*') {
			string[j++] = '/';
			string[j++] = '*';
			peek = -1;
			comment(fp);
		}
		else string[j++] = '/';
	}
	if ((peek = getchr(fp)) == '\n') {
		peek = -1;
		return(1);
	}
	return(0);
}

comment(fp)
FILE *fp;
{
rep:
	while ((c = string[j++] = getchr(fp)) != '*')
		if (c == '\n') {
			putx();
			sflg = 1;
		}
gotstar:
	if ((c = string[j++] = getchr(fp)) != '/') {
		if (c == '*') goto gotstar;
		goto rep;
	}
}

getchr(fp)
FILE *fp;
{

	if (peek < 0 && lastchar != ' ' && lastchar != '\t') pchar = lastchar;
	lastchar = (peek<0) ? getc(fp):peek;
	peek = -1;
	return(lastchar == '\r' ? getc(fp):lastchar);
}

getx(fp)
FILE *fp;
{
	char ch;
beg:
	if ((ch = string[j++] = getchr(fp)) == '\\') {
		string[j++] = getchr(fp);
		goto beg;
	}
	if (ch == '\'' || ch == '"') {
		while ((cc = string[j++] = getchr(fp)) != ch) if (cc == '\\') string[j++] = getchr(fp);
		goto beg;
	}
	if (ch == '\n') {
		putx();
		aflg = 1;
		goto beg;
	}
	else return(ch);
}

putx() {
	if (j > 0) {
		if (sflg != 0) {
			ptabs();
			sflg = 0;
			if (aflg == 1) {
				aflg = 0;
				if (tabs > 0) printf("    ");   /* 4 spcs */
			}
		}
		string[j] = '\0';
		printf("%s",string);
		j = 0;
	}
	else {
		if (sflg != 0) {
			sflg = 0;
			aflg = 0;
		}
	}
}

initw(argu, lst)
int *argu;
char *lst;
{
int i;
char *xx[2];

	xx[0] = "0";
	xx[1] = '\0';
	for(i=0; i <= 9; i++) ind[i] = xx;
}

