(*$L+*)		(* this compiler switch turns listing on; take the space from
		  in front of the "$" to turn listing ON.  For how to make
		  listings, see the Pascal M manual.  The $L switch turns on
		  listings, but only if in the commandinvocation you tell it
		  where to send the listing.  Example: PRUN Pascal ARCHIVE
		  L=Archive.lst will put Archive.lst on the currently logged
		  disk. *)
(*$R+*)		{ Turns ON range checking. (array bounds) This is normally on.}

program archive;

(*$F ntoolinc.pas*)  (* -- new tools variables include file *)
(*$F lwercase.pas*)  (* lowercase routines *)
(*$F nfchario.pas*)  (* non-file character I/O *)
(*$F getargs.pas*)   (* gets arguments from the command line *)
(*$F equal.pas*)     (* tests if two strings are equal *)
(*$F toolclse.pas*)  (* closes files *)
(*$F mfileio.pas*)   (* most of the file I/O for the Tools package *)
(*$F initio.pas*)    (* initialize I/O *)
(*$F open.pas*)      (* opens files *)
(*$F create.pas*)    (* creates files *)
(*$F isdigit.pas*)   (* is this character a digit? (0 ... 9) *)
(*$F ctoi.pas*)      (* string to integer routine *)
(*$F itoc.pas*)      (* integer to string routine *)
(*$F getword.pas*)   (* move a word into a string *)

(*  fchario.pas  -- the files that used to be in this file have been
   spread over these six files:
     equal.pas
     mfileio.pas
     open.pas
     create.pas
     ctoi.pas
     itoc.pas

    The procedure equal, which used to appear in both fchario.pas and
   archproc.pas has been moved to equal.pas. *)


{ PRINTPLUS -- print + to show progress.}
procedure printplus;

	begin
		write('+');
	end;

{ archive -- file maintainer }

procedure archive;
const
    MAXFILES = 5; { or whatever }
var
    aname : string;	{ archive name }
    cmd : argstring;	{ command type }
    fname : packed array [1 .. MAXFILES] of string;   { filename args }
    fstat : packed array [1 .. MAXFILES] of boolean;   { true=in archive }
    nfiles : integer;	{ number of filename arguments }
    errcount : integer;	{ number of errors }
    archtemp : string;  { temp file name 'artemp' }
    archhdr : string;   { header string '-h-' }

(*$F initarch.pas*)	(* initialize archive *)
(*$F getfns.pas*)	(* the routine getfns, from K and P *)
(*$F archproc.pas*)	(* archive's procedures *)
(*$F update.pas*)	(* update procedure, taken out of archproc.pas *)

(*$P+*)			(* puts a pagebreak in the listing file *)
(* There are several differences between this version and the one in the book;
  notably is the check against improper length; the other is an extra set of
  parentheses around "or"'s.  That last is due to an improper expression
  evaluation routine in MT+; note that they do not change the sense of the
  if statements, and in fact may make them easier to read. *)

begin (* archive procedure *)
    initarch;
	printplus;
    if (not getarg(1, cmd, MAXSTR)) then
    begin
	message('no command');
	help
    end
    else if (not getarg(2, aname, MAXSTR)) then
    begin
	message('no filenames');
	help
    end;
    l_case_string(cmd);
    getfns;
    if (length(cmd) <> 2) then  (* takes care of wrong length commands *)
	help
    else if (cmd[1] <> '-') then
	help
    else if ((cmd[2] = 'c') or (cmd[2] = 'u')) then
	update(aname, ord(cmd[2]))
    else if (cmd[2] = 't') then
	table(aname)
    else if ((cmd[2] = 'x') or (cmd[2] = 'p')) then
	extract(aname, ord(cmd[2]))
    else if (cmd[2] = 'd') then
	tool_delete(aname)
    else begin
	putstr(cmd, STDERR);
	message(': No such command');
	help;
    end (* if chain *);
end (* archive procedure *);


begin (* main program *)
	printplus;
  grabtail(source);
	printplus;
  initio;
	printplus;
  archive;
 	writeln;
end   (* archive prog *).

