
{ isalphanum -- true if c is a letter or digit (IS ALPHANUMeric) }
function isalphanum (c : character) : boolean;
begin
  isalphanum := c in
    [ord('a')..ord('z'),
     ord('A')..ord('Z'),
     ord('0')..ord('9')];
end(* isalphanum *);
{ the alternative to using sets would be:
  isalphanum := (c>=ord('a') and c<=ord('z')) or 
                (c>=ord('A') and c<=ord('Z')) or
                (c>=ord('0') and c<=ord('9'));
  although the 'savings' in runtime here are iffy at best.  Perhaps the best
  way all around would be to globally declare the set 
  VAR
    ALPHANUM : set of char;

  and make it a 'constant set' in your main program:

  begin
    ALPHANUM := [ord('a')..ord('z'), ord('A')..ord('Z'), ord('0')..ord('9')];

  this way you could make isalphanum merely:
  
  isalphanum := c in ALPHANUM;

  with no intervening "ord"'s.  Why, you might ask, not merely declare:
  
  CONST 
    ALPHANUM = [ord('a')..ord('z'), ord('A')..ord('Z'), ord('0')..ord('9')];

  Well, that would be fine, except that it isn't allowed under any PASCAL I 
  know of.  I would like that construct very much, but no CONSTant sets are
  allowed.  }
it isn'