-h- MTCIO.PAS 73
Use the file MTCIO1.SRC; it contains everything that was contained here.
-h- MTCIO1.SRC 2439
lock : integer;
procedure openfile;  (*strictly for MTPLUS*)
var
  okay : boolean;
  filename : string[14];  (* CP/M maximum filename length *)
  error : integer;

{ all right, you ask, what is lock for?  Since close in P/MT+ takes two 
  arguments, one of which is an IORESULT return, we 'conform' the programs
  by creating a global variable 'lock'.  Then the value is returned to lock,
  MT+ is happy, and the close for the program is the same for either M or MT+.}

(* NOTE WELL THAT LOCK : INTEGER must be up above the procedure; that is 
what makes it a global variable.  If you do not have it there -- if it
is instead inside the procedure -- you will get the most mysterious error
messages, sufficient to drive you utterly mad, because it will tell you
that you have error #104 in line 125 or thereabouts.  The error reporting
of PASCAL MT+ is not optimal to begin with, and mystery errors like that
only make things worse.  The lesson is, if you are using global variables
even as dummies, they must be declared global. IN PASCAL YOU MUST DECLARE
ALL VARIABLES.  That's not a bug, it's a feature. *)

{ The $I- option, which is used in /M and UCSD to 'turn off' I/O checking, is 
  not supported in MT+.  Other methods I haven't had time to figure out are
  used instead.  Later, perhaps.}

{ On MT+ include files:  Their syntax is:

(*$Ifilename any comment you feel like*)  Note this text is not compiled

  Which is much less restrictive than P/M.  Other
  compiler directives can be followed by more text:

(*$R+*) this will indeed be compiled (and cause errors)

  Which is at least consistent.  In any case, it's probably a bad practice;
  put your directives on a separate line so they stand out in the program.}

(* ******************************************************************* *)

BEGIN (*procedure*)
   REPEAT
	okay := true;
      write('What file you wish to read from ? ');
      readln(filename);
      assign(infile,filename);  (* MT+ standard *)
	RESET(INFILE);
	IF IORESULT = 255 THEN
		BEGIN 
			OKAY := FALSE;
			WRITELN('Cannot open file. Try again.');
		END;
	UNTIL OKAY;

	writeln('Note that in MTPLUS we can over write an existing');
	writeln('file without checking.  Be careful, there will be');
	writeln('            *** NO WARNING ***! ');

	writeln;
	writeln('What file do you want to write to? ');
	readln(filename);
	ASSIGN(outfile,filename);
	REWRITE(outfile);
   
end (* end of procedure *);


-h- MTCIO2.PAS 373
MODULE mtcio1; (*demonstration of modular compilation*)
	(* semicolon above is NOT optional. *)
VAR
infile  : external file of char;
outfile : external text;
	(* note the external declarations.  These say that you
	will find these variables in the stuff below, but the
	variables themselves are declared in another routine.*)

(* place the file MTCIO1.SRC here *)

MODEND.
-h- MTCOPY.SRC 4837
PROGRAM countchars (input, output, infile, outfile);

	(* THIS PROGRAM WILL NOT WORK ON PASCAL MT+ ALTHOUGH THE
	IDENTICAL PROGRAM WILL WORK ON PASCAL M.  THE REASON IS
	INSTRUCTIVE.  SEE BELOW. *)

	(* Accepts character input from a file whose name you are asked
	for and counts the number of characters input and puts them out
	again.*)

	(* Does what the Grogono program on page 17 asks for. *)

	(* THIS program will compile in PASCAL MT +, and it will link and
	run.  It just doesn't do what you wanted it to.  The reason is
	inherent in the definitions of "standard file" and the different
	ways that PASCAL M and PASCAL MT+ treat the LINE FEED character.
		ASCII has no NEWLINE character.  Instead there are the old
	teletype characters, carriage return, and line feed, which move the
	printing head in the ways suggested: cr moves the carriage to the left
	margin, and lf which moves it down a line but does not make horisontal
	motion.
		Which one, then, is the NEWLINE?  In PASCAL there is a test
	for the CONDITION of eoln, meaning end of line.  But what should be
	recognized as the end of a line?  When PASCAL M encounters a cr,
	it automagically tests the following character to see if that is
	a line feed; if it is, it IGNORES IT ENTIRELY, and does not even
	read it.  This can be useful, although frustrating as hell if you
	are trying to make exact copies of a file.
		PASCAL MT+ assumes that a TEXT file is STANDARD, and the
	standard is that each line is terminated with a CR LF pair.  Thus
	this program will compile and run, but the copy it makes will have
	the first character after the cr missing if it is aimed at a file
	made by an editor that marks line ends with cr without lf.  In the
	micro world there are a number of editors that do that!  ELECTRIC
	PENCIL, WRITE, and WORDSTAR are among them.  (Wordstar marks line
	ends with "soft" carriage returns, which are a CR with the first
	bit set high.  If that doesn't mean much to you, don't worry about
	it.  The point is that this program won't treat those files properly.
		However, see MTCOPY1.SRC which WILL run properly, and read
	the notes in it. *)

	(* ***************************************  *)

   CONST
	cr = 13;
	lf = 10;
	blank = ' ';
	comma = ',';
        period = '.';
    VAR
        charcount, blankcount, commacount, periodcount : integer;
        linecount, lfcount    : integer;
        character : char;
        infile : text;  (* for MTCOPY1 this is file of char, which
			makes a real difference. *)

        outfile : text;
{$IMTCIO.SRC}
		(* above line calls for file MTCIO.SRC which must be
		present on your disk or you can't compile this. *)
	

    BEGIN
      openfile;             (* this makes a call to a procedure;
			    what a procedure is and how it works is
			    discussed later in Grogono.  For the 
			    immediate moment, trust us.*)

       charcount := 0;
       blankcount := 0;
       commacount := 0;
       periodcount := 0;
	linecount := 0;  (*initializing variables. Don't omit it. *)
	lfcount :=0;  (* variable used in MTCOPY1 but NOT in this one. *)



	writeln;  (* writeln does nothing but print a blank line
		   on your screen.  Purpose should be obvious.*)

	writeln('Files open, processing text. Be patient.');
	writeln;

       WHILE NOT eof(infile) DO
          BEGIN
             read(infile,character);     (* note that infile is the
					    name of a file which is 
					    opened in procedure openfile.*)

	   IF eoln(infile)
		THEN
		   BEGIN
			write(outfile,character,chr(cr),chr(lf));
			   (* note we write character as well as cr and
			      lf.  This is because eoln is a condition,
			      not a character, and the char in the buffer
			      when we have eoln will be lost if we don't 
			      write it. *)

			   (* once again, KNOW that this DOES NOT WORK
			   under PASCAL MT+ but does under PASCAL/M *)

			write('+');  (* progress report *)
			linecount := linecount + 1;
		   END (* end of if *)
	        ELSE write(outfile,character);
             charcount := charcount + 1;
             IF character = blank
                THEN blankcount := blankcount + 1
             ELSE IF character = comma
                THEN commacount := commacount + 1
             ELSE IF character = period
                THEN periodcount := periodcount + 1;  (* optional ; *)
          END; { while }
       writeln;
       writeln(charcount, ' characters');
       writeln(blankcount, ' blanks');
       writeln(commacount, ' commas');
       writeln(periodcount, ' periods');
	writeln(linecount, ' lines');

        close(infile,lock); 
				 (* this closes and saves the input file so
				it can be used again.  Don't worry about 
				how this works yet either.*)
        close(outfile,lock);
				 (* without this, the contents of the file are
				lost (!)*)

    END. { countchars }
-h- MTCOPY1.SRC 7078
PROGRAM countchars (input, output, infile, outfile);
	(* Accepts character input from a file whose name you are asked
	 for and counts the number of characters input and puts them out
	 again.*)

	(* FOR PASCAL MT+ implementaton. *)

	(* MTCOPY1 works properly.  MTCOPY does not. Reasons are
	instructive.*)

	{This is just to illustrate that we can use this kind of mark
	for a comment as well as the (*  *).  Incidentally, the compiler
	does sort of scan inside these, looking for the termination, and
	can get confused if unbalanced; which is why we did (* *) and not
	just a star parenthesis for the illustration.  This comment has
	to be terminated with a close curly brace since that is what
	opened it. }

	(* THIS PROGRAM Does what the Grogono program on page 17
	asks for, plus some other stuff.*)

	(* TO MAKE THIS WORK we have to do things differently from the way
	we did in PASCAL/M.  MT+ believes that a "standard file" which is
	declared as type text  (See Grogono on TYPES) terminates each line 
	with a carriage return - line feed pair; that is, that the ASCII
	NEWLINE character is TWO CHARACTERS, cr & lf.  Unfortunately, most
	modern editors on CP/M do not use this convention.  WordStar, WRITE,
	Electric Pencil, and many others uses a CARRIAGE RETURN ONLY as the
	end of "line" mark.  Of course to those editors the "line" is a full
	paragraph of text, with "lines" being a variable length depending on
	what you wanted it to be.  Thus PASCAL isn't ideally suited to take
	care of this.
		The result is that this program differs from the one
	shown on page 17 of Grogono, but there isn't much we can do about
	it. *)
    CONST
	cr = 13;
	lf = 10;
	blank = ' ';
	comma = ',';
        period = '.';
	endfile = 26; (* decimal ASCII for control-Z*)
		(* one of the sad things is that if we are going to use 
		what Digital Research and MT+ think are horrid nonstandard
		files, which is to say files created by about 80% of the
		text editors in the micro field, we cannot even use the
		standard PASCAL EOF (end of file) test as we can in
		PASCAL/M.  Instead, we must explicitly test for the 
		presence of a control-z in the file.  Of course this also
		lets us get at files with control-z in them, as some
		files are (they have been jiggered up to make them unreadable
		under CP/M). This means we need this definition. *)


    VAR
        charcount, blankcount, commacount, periodcount : integer;
        linecount, lfcount    : integer;
        character : char;
        infile : file of char;  (* NOTE DIFFERENT FROM PASCAL/M *)
			(* NOTE also in MTCOPY we declared this as text.
			But to MT+ text means cr lf pairs, not just
			cr.  One of the test files on this disk is
			made with WRITE and lines end with cr only.
			You cannot deal with that without all this
			jiggery pokery.  Sorry. *)
        outfile : text;

{$IMTCIO1.SRC}
		(* above line calls for file MTCIO1.SRC which must be
		present on your disk or you can't compile this. *)
		(* MTCIO1 knows how to open and close CP/M files.  It also
		asks you for the file names. *)
		

    BEGIN   (* after all the gubbage, the program begins here. *)

      openfile;             (* this makes a call to a procedure;
			    what a procedure is and how it works is
			    discussed later in Grogono.  For the 
			    immediate moment, trust us.*)

       charcount := 0;
       blankcount := 0;
       commacount := 0;
       periodcount := 0;
	linecount := 0;  (*initializing variables. Don't omit it. *)
	lfcount :=0;
		(* note also that we use := rather than just = because
		in PASCAL = and := are two different operations.  Think
		of = as a test, while := is a command to set the left
		side equal to the right side. *)


	writeln;
	writeln('Files open, processing text. Be patient.');

       WHILE (character <> chr(endfile)) AND NOT eof DO
          BEGIN
             read(infile,character);     (* note that infile is the
					    name of a file which is 
					    opened in procedure openfile.*)

	   IF character = chr(lf) 
		THEN lfcount := lfcount + 1 (*You must NOT have a ; HERE!*)
			 (* the syntax of IF THEN ELSE IF statements can be
			very confusing.  Try putting a ; at the end of the
			line above.  You will see a mysterious error message
			from the compiler.  The only way to get a feel for
			the kinds of things the compiler doesn't like is to
			give it some where you know what the bug is and then
			see what it tells you.  Unfortunately, this message
			is not all that informative about what the real 
			problem is. *)

	   ELSE IF character = chr(cr)  (*test to see if a cr, = eoln *)
				(* can't have a ; up there, either. *)
		THEN
		   BEGIN
			write(outfile,chr(cr),chr(lf));
			    (* write both cr and lf here. Ignore the
				cr that you got out of the file. *)

			write('+');  (* progress report *)
			linecount := linecount + 1;
		   END (* end of the else if character = chr(cr) *)
			(* note NO ; here, and CANNOT be one here.*)

	        ELSE
		   BEGIN
		      write(outfile,character);
			charcount := charcount +1;
				  (* putting this statement here means that
				   we count characters only if not cr or lf. *)


		   END;  (* on the other hand, there MUST be a ; here,
			or the program cannot compile. 
		        This END statement terminates only
			the ELSE above, but the ; here ends the huge IF
			test for cr and lf and like that.  To 
			make your life more difficult, the compiler won't 
			really tell you what is wrong.  Take out the ; here
			and compile and see what we mean. *)


{            charcount := charcount + 1;
			(* if we took out the comment braces here, this 
			statement would always execute, even if the 
			character were a cr or lf.  By moving this
			statement around you can get different results,
			depending on what you believe a character is. *) }


             IF character = blank
                THEN blankcount := blankcount + 1
             ELSE IF character = comma
                THEN commacount := commacount + 1
             ELSE IF character = period
                THEN periodcount := periodcount + 1;  (* optional ; *)
			(* In BASIC we would have jumped around these
			tests from the test for cr and lf on the reasonable
			ground that if a char is a cr or lf it cannot be
			anything else.  It can be done here, and note that
			the ELSE IF construction above guarantees that no 
			condition will be tested after a TRUE has been
			found.  PASCAL and most structured languages use
			nested IF  (IF - ELSE IF - ELSE IF ) to do what BASIC
			usually does with GOTO. *)

          END; { while }
       writeln;
       writeln(charcount, ' characters');
       writeln(blankcount, ' blanks');
       writeln(commacount, ' commas');
       writeln(periodcount, ' periods');
	writeln(linecount, ' lines');

        close(infile,lock); 
				 (* this closes and saves the input file so
				it can be used again.  Don't worry about 
				how this works yet either.*)
        close(outfile,lock);
				 (* without this, the contents of the file are
				lost (!)*)

    END. { countchars }
-h- MTCOPY2.SRC 5647
PROGRAM countchars (input, output, infile, outfile);
	(* Accepts character input from a file whose name you are asked
	 for and counts the number of characters input and puts them out
	 again.*)

	(* FOR PASCAL MT+ implementaton. *)

	(* MTCOPY1 works properly.  MTCOPY does not. Reasons are
	instructive.*)

	(*THIS IS MTCOPY2 used to illustrate modular compilation.
	The file MTCIO2.SRC was separately compiled (successfully).  It
	is also included in this file through an INCLUDE directive.
		This is different from MTCOPY1.SRC in that MTCOPY1
	includes MTCIO1.SRC, and that file, although functionally identical
	to MTCIO2.SRC, will not compile separately, and thus cannot be tested
	separately.
		It is often a good idea to make your inclusions modular,
	so that you can be CERTAIN that it isn't an included module that
	is causing your program to blow up.  In MTPLUS the error messages
	do not always make it clear that your problems are in an included
	module rather than the main program.*)

	(* THIS PROGRAM Does what the Grogono program on page 17
	asks for, plus some other stuff.*)

	(* TO MAKE THIS WORK we have to do things differently from the way
	we did in PASCAL/M.  Please see the other copy progs about this. *)
    CONST
	cr = 13;
	lf = 10;
	blank = ' ';
	comma = ',';
        period = '.';
	endfile = 26; (* decimal ASCII for control-Z*)
		(* See previous files about this *)

    VAR
        charcount, blankcount, commacount, periodcount : integer;
        linecount, lfcount    : integer;
        character : char;
        infile : file of char;  (* NOTE DIFFERENT FROM PASCAL/M *)
			(* see previous files about this *)
        outfile : text;

	lock : external integer; (* this is declared in MTCIO2.SRC *)

	EXTERNAL PROCEDURE openfile;

(*     { $IMTCIO2.SRC}
	In MTCOPY1.SRC the above line is used to bring in an include
	file.   Here the line is commented out (note curly brace) and
	will NOT BE SEEN by the compiler.  Instead, when we want to put
	the external procedure "openfile" which is defined in MTCIO2.SRC,
	we do that at LINK time.
		Thus to make MTCOPY2 work we must first go:
	    MTPLUS MTCIO2
		That will compile, and put MTCIO2.ERL on the disk.
	  You then go:
	    MTPLUS MTCOPY2
		and when that compiles go:
	    LINKMT MTCOPY2,MTCIO2,PASLIB/S

	This will produce a program functionally identical to MTCOPY1.
	MTCIO2 must be linked in, because it knows how to open and
	close CP/M files.  *)
		

    BEGIN   (* after all the gubbage, the program begins here. *)

      openfile;             (* this makes a call to a procedure;
			    what a procedure is and how it works is
			    discussed later in Grogono.  For the 
			    immediate moment, trust us.*)

       charcount := 0;
       blankcount := 0;
       commacount := 0;
       periodcount := 0;
	linecount := 0;  (*initializing variables. Don't omit it. *)
	lfcount :=0;
		(* note also that we use := rather than just = because
		in PASCAL = and := are two different operations.  Think
		of = as a test, while := is a command to set the left
		side equal to the right side. *)


	writeln;
	writeln('Files open, processing text. Be patient.');

       WHILE (character <> chr(endfile)) AND NOT eof DO
          BEGIN
             read(infile,character);     (* note that infile is the
					    name of a file which is 
					    opened in procedure openfile.*)

	   IF character = chr(lf) 
		THEN lfcount := lfcount + 1 (*You must NOT have a ; HERE!*)
		(* See previous files about the syntax of if statements *)

	   ELSE IF character = chr(cr)  (*test to see if a cr, = eoln *)
				(* can't have a ; up there, either. *)
		THEN
		   BEGIN
			write(outfile,chr(cr),chr(lf));
			    (* write both cr and lf here. Ignore the
				cr that you got out of the file. *)

			write('+');  (* progress report *)
			linecount := linecount + 1;
		   END (* end of the else if character = chr(cr) *)
			(* note NO ; here, and CANNOT be one here.*)

	        ELSE
		   BEGIN
		      write(outfile,character);
			charcount := charcount +1;
				  (* putting this statement here means that
				   we count characters only if not cr or lf. *)


		   END;  (* on the other hand, there MUST be a ; here,
			or the program cannot compile. 
		        This END statement terminates only
			the ELSE above, but the ; here ends the huge IF
			test for cr and lf and like that.  To 
			make your life more difficult, the compiler won't 
			really tell you what is wrong.  Take out the ; here
			and compile and see what we mean. *)


{            charcount := charcount + 1;
			(* if we took out the comment braces here, this 
			statement would always execute, even if the 
			character were a cr or lf.  By moving this
			statement around you can get different results,
			depending on what you believe a character is. *) }


             IF character = blank
                THEN blankcount := blankcount + 1
             ELSE IF character = comma
                THEN commacount := commacount + 1
             ELSE IF character = period
                THEN periodcount := periodcount + 1;  (* optional ; *)
			(* See other files about IF THEN ELSEs *)

          END; { while }
       writeln;
       writeln(charcount, ' characters');
       writeln(blankcount, ' blanks');
       writeln(commacount, ' commas');
       writeln(periodcount, ' periods');
	writeln(linecount, ' lines');

        close(infile,lock); 
				 (* this closes and saves the input file so
				it can be used again.  Don't worry about 
				how this works yet either.*)
        close(outfile,lock);
				 (* without this, the contents of the file are
				lost (!)*)

    END. { countchars }
-h- MTTCIO.PAS 30
Use MTCIO1.SRC for this file.
