Program Test;
(* Tests the speed of a random number generator.  The generator under
   consideration here uses a 32 bit integer to keep track of the seed,
   which gives an effective period of about 4 billion, however due to
   the way it has been implemented it "only" has half that period.
   This procedure takes less than 20 seconds to execute 10000 loops. *)
Type
  Seedy=Packed Array[0..3] of Byte;
Var
  i,j:integer;
  k  :seedy;

Function Rand(Var Seed:Seedy):Integer;
(* The multiplier was obtained from Knuth, Ch.3, in the section
   on the spectral test, the addend was a quasi-random pick.*)
  Var t:seedy;
      s:integer;
  Begin
    Move(Seed,t,4); 
    s:=t[3]*13+71;
    seed[3]:=Lo(s);
    s:=t[3]*102+t[2]*13+6+Hi(s);
    seed[2]:=Lo(s);
    s:=t[3]*25+t[2]*102+t[1]*13+109+Hi(s);
    seed[1]:=Lo(s);
    seed[0]:=Hi(s)+25*t[2]+102*t[1]+13*t[0];
    Move(Seed,s,2);
    clrbit(s,15);
    rand:=s
  End (*Rand*);    (*Magic, ain't it?*)


begin
  Write('Enter no. of loops to process: ');
  Readln(i);
  Write('Press <RET> to start -->');
  Readln;
  for j:=1 to i do
    I:=Rand(k);
  Writeln(Chr(7),'Stop!!!',Chr(7))
end(* silly *).