(* This is the slow version of the random # generator based in fp
    with a period with 65536.  It can be noticeably speeded up by
    using a constant variable in place of the 1173.0/65536.0 on the
    first line of Rand. This is because the expression "1173.0/65536.0"
    is not simplified by the MT+ compiler and floating point division is very
    slow (Especially software floating point, the 8080 in particular).
    this benchmark program took about 50 seconds to evaluate 10000 loops,
    whereas the version with the aforementioned
    constant stored in a variable and used took only about 35 secs.  *)
Program SBench3;
Var
  i,j:integer;
  k,l:Real;

Function Rand(Var S:Real):Real;
  Begin
    S:=S*133.0+1173.0/65536.0;
    S:=S-Trunc(S);
    Rand:=S
  End;

begin
  Write('Enter no. of loops to process: ');
  Readln(i);
  Write('Press <RET> to start -->');
  Readln;
  for j:=1 to i do
    l:=Rand(k);
  Writeln(Chr(7),'Stop!!!',Chr(7))
end(* silly *).
