(* Three examples of set usage; the two that are commented out are incorrect,
   though the third should compile and run on ANY Pascal system.  It does run
   on MT+ and M. *)

{program settest;
type movie_star = set of '1'..'9';
var garbo,greta : movie_star;
(*  garbo : char;*)

(* This program is just plain wrong.  You can't test to see if a set is in a
   set, so "if (garbo in greta)" won't compile.  It should and does give off an
   error #129: "Type conflict of operands". *)

begin
  garbo := ['3'];
  if (garbo in greta) then writeln('hello')
  else writeln ('no go, joe.');
end.
}
{
(* This program compiles, but it's implementation-dependent: note that nowhere
   is greta initialized, so it may be an empty set or whatever garbage happens
   to be in memory at load time.  Remember that declaring a type does NOT
   initialize a variable!  That's why this program LOOKS like it should print
   out "hello", instead of a random result. *)

program settest;
type characters = '0' .. '9';
     movie_star = set of characters;
var greta : movie_star;
    garbo : character;

begin
  garbo := '3';
  if (garbo in greta) then writeln('hello')
  else writeln ('no go, joe.');
end.
}

(* The reason for the procedure OZ is that Pascal M will not compile it all
  as a single main program; you will recieve error #253: procedure too long*)

program settest;
type characters = '0' .. '9';  (* this is a subrange <type> *)
     movie_star = set of characters;  (* this is a set *)
var greta, charlie : movie_star;  (* declaration of a set *)
    garbo, chaplin : characters;   (* declaration of a singleton subrange *)

procedure oz;
begin
  chaplin := '5';
  charlie := ['2' .. '4'];
(* The following construct isn't legal:
  if ( ([charlie] + chaplin) = greta) then
    writeln('set unions work.');
  If you really wanted to do that, make a set equal to charlie:

  Another_set := charlie;

  And then test against greta:

  if ( (Another_set + chaplin) = greta) ... *)
  if ( (['5'] + charlie) = greta) then
    writeln('set unions work')
  else writeln('set unions don''t work!!??');
  charlie := ['2','3','5'];
  greta   := ['9','4','5'];
  if ( chaplin in (charlie * greta)) then writeln('intersections work')
  else writeln('intersections don''t work?');
  if ( (charlie * greta) = ['5'] ) then
    writeln('intersections and literals work, no prob')
  else writeln('intersections and literals don''t work.');
  if ( (charlie + greta) = ['2','3','4','5','9'] ) then
    writeln('literals and unions work')
  else writeln('Literals and unions DON''T work !!!??');
  if ( ['5'] >= []) then writeln('A small set contains the empty set')
  else writeln('A small set doesn''t contain the empty set.');
  if ([] >= []) then writeln('One empty literal set contains another')
  else writeln('One empty literal set does NOT contain another.');
  chaplin := '3';
  if (chaplin = garbo) then writeln('Element comparison works')
  else writeln('Element comparison doesn''t work??!!');
  if ((['4'] + ['5']) = ['4','5']) and (['6','7','4'] <= ['4','6','7'])
    and ('7' in ['4'..'8']) and ( not (['6'..'9'] >= ['4']))
    and ((['1','0','2'] * ['0','8'] * ['0']) = ['0']) and
    ((['5','6','3','4'] + ['1','2'] + ['0','7'..'9']) = ['0'..'9']) then
    writeln('very complicated set literal expressions work just fine')
  else writeln('very complicated set literal expressions don''t work!!??');
end(* oz *);

begin
  greta := ['0' : '9']; (* fills the set "greta" with the elements
			   '0', '1', '2', ... '7', '8', '9' *)
			(* ":" is a synonym for "..", though ".." is clearer *)
  garbo := '3';         (* a single character goes in *)
  if (garbo in greta) then 
    writeln('''3'' is contained in the set ''0''..''9''.')
  else writeln ('''3'' isn''t in the set ''0''..''9''??!!');
  greta := []; (* empty set *)
  if (garbo in greta) then writeln('''3'' is in an empty set!!??')
  else writeln('something is not contained in nothing');
  charlie := []; (* empty set *)
  if (greta = charlie) then writeln('nothing equals nothing')
  else writeln('nothing isn''t equal to nothing ???!!');
  charlie := ['4','5'];
  if (charlie >= greta) then
    writeln('Hmm the empty set is contained by non-empty sets')
  else writeln('Empty sets are not contained by non-empty sets.');
  greta := ['3'];  (* single element set *)
  if (garbo in greta) then writeln('''3'' is in ''3'', as it ought to be.')
  else writeln('''3'' isn''t contained in ''3''??!!!');
  charlie := ['2' .. '4'];
  greta   := ['2' .. '5'];
  if (greta >= charlie) then
    writeln('The set "''2'' .. ''4''" is contained by set "''2''..''5''".')
  else writeln ('Set containment doesn''t work !!??');
  if (charlie <= greta) then writeln
    ('Set containment works in reverse.')
  else writeln('Reverse set containment doesn''t work.');
  oz;
  writeln('That''s all the tests, bye now.');
end.


