-h- SQ2.SRC 1583
PROGRAM squarerootoftwo (output);

	(* This program compiles and runs under SORCIM PASCAL M.
		To do that, go:
			 PRUN PASCAL SQ2.SRC

	When the compiler is finished, go:
			 PRUN SQ2

		This program differs from SQ3 in that we used
		write(sqrt(2)) in this, and writeln(sqrt(3)) in the
		SQ3 demonstration.  Writeln gives a NEWLINE after
		it prints.  write does not.

	This demonstration program will compile and run under MTPLUS, but
	produces NO OUTPUT when linked with the following command:
		LINKMT SQ2,PASLIB

	Curiously, if the procedure below used writeln(sqrt(2))
	then PASCAL MTPLUS would not link it at all unless the
	library routine FPREALS (floating point reals) were 
	included in the link command line.

	To make this program run under PASCAL MTPLUS, you must
	first do:
		MTPLUS SQ2
	That will trundle along, and eventually produce messages
	indicating that it is done. You will then find there is
	a file named SQ2.ERL (for relocatable code) on the disk.
	You then do:
		LINKMT SQ2,FPREALS/S,PASLIB/S

	This will take the SQ2.ERL file and make a SQ2.COM file
	from it.  The order of the two libraries is mandatory:
	that is, if PASLIB is not the last one, the linker will
	give unfriendly messages about missing symbols.
		The /S options are not strictly necessary, but
	/S tells the linker to link in only the needed routines, not
	all of them.  Leaving out the /S options (try it) will produce
	the astounding result of having a 30K .COM file to print the
	square root of two. *)

	BEGIN
		write(sqrt(2))  (* The ; is optional here. *)
	END {squarerootoftwo}.
-h- SQ3.SRC 640
PROGRAM squarerootofthree (output);

	(* This program compiles and runs under SORCIM PASCAL M.
	It will compile and link under MTPLUS, if you use the
	proper order for linking.  The command to link is:
		LINKMT SQ3,FPREALS/S,PASLIB/S

	   NOTE WELL:  IF PASLIB IS NOT THE LAST ONE NAMED, THIS
	   WILL NOT LINK!!!

	The /S options tell the linker that you want only the
	required routines from the libraries.  If you do not specify
	the /S options, you will end up with a 30K file to print
	the square root of three.
		Note that SORCIM PASCAL M gives far more decimal
		places accuracy for this program. *)

	BEGIN
		writeln(sqrt(3))
	END.
-h- SQS.SRC 94
PROGRAM squareroots (input,output);
	VAR
		x : real;
	BEGIN
		read(x);
		write(sqrt(x))
	END.
-h- SQSS.SRC 1004
PROGRAM squareroots (input,output);
	(* The STANDARD PASCAL requires the input,output gubbage.
	Neither PASCAL M nor PASCALMT PLUS requires them.  We put
	them in to conform to Grogono's usage. *)

	(* This program will accept input numbers and output
	square roots. *)

	(* This program is exactly as shown by Grogono.  Try it.  You 
	will NOT like it, because there is no provision for carriage 
	returns after the answer is given.  See SQSS2 for a better
	way to do this, and compare. *)

	(* To compile under PASCAL M go:
		PRUN PASCAL SQSS.SRC
			-- Note the SRC for source --
	   To run it, go:
		PRUN SQSS

	  To compile under PASCAL MTPLUS, go:
		MTPLUS SQSS
			-- NOte that src not needed --
		When the compiler is done, go:
		LINKMT SQSS,FPREALS/S,PASLIB/S
			You will then have a .COM file that runs
			if you do SQSS  
					*)

	VAR
		x : real;
	BEGIN
		REPEAT
			read(x);
			IF x >= 0 (* some compilers want => *)
				THEN write(sqrt(x))
				ELSE write('argument error')
		UNTIL x = 0
	END.
-h- SQSS2.SRC 2308
PROGRAM squareroots (input,output);
	(* The STANDARD PASCAL requires the input,output gubbage.
	Neither PASCAL M nor PASCALMT PLUS requires them.  We put
	them in to conform to Grogono's usage. *)

	(* This program will accept input numbers and output
	square roots. *)

	(* THIS program has been modified from Grogono to add input
	prompts, and to use writeln for output rather than write.
	Note that writeln(sqrt(x)) does a NEWLINE after it prints
	the answer.  We also put in an input prompt using write.*)

	(* To compile under PASCAL M go:
		PRUN PASCAL SQSS2.SRC
			-- Note the SRC for source --
	   To run it, go:
		PRUN SQSS2

	  To compile under PASCAL MTPLUS, go:
		MTPLUS SQSS2
			-- NOte that src not needed --
		When the compiler is done, go:
		LINKMT SQSS2,FPREALS/S,PASLIB/S
			You will then have a .COM file that runs
			if you do SQSS2  
					*)

	(* The two compiler systems treat input overflows -- that is, inputs
	too large for them to handle -- in different ways.  PASCAL M will
	simply do nothing.  It sends two BELL signals to the console, and
	shows a blank answer; there is no other error message. If you hit
	carriage return or other such it still does nothing. However, if
	you input a valid (small enough) number, then PASCAL M recovers
	completely.
		PASCALMT PLUS gives an error message about overflow, and
	asks if you want to abort the program (carriage return) or to 
	continue (space).  If the number is VERY LARGE then it may take
	MANY SPACE BAR HITS to make the program recover.  Eventually it
	prints a truncated number that isn't relevant to the input number,
	and has completely recovered from the error condition. *)

	(* The reason MTPLUS may require several space bar hits to recover
	is that the overflow could have been (can be) in many different
	floating point subroutines (these library routines have been put
	into your program although you didn't write them in explicitly).
	Each of those must be cleared of the overflow condition. *)



			(*PROGRAM BEGINS HERE*)
VAR
		x : real;  (* note the ; which is NOT optional *)
	BEGIN
		REPEAT
			write('Input a positive number: ');
			read(x);
			IF x >= 0 (* some compilers want => *)
				THEN writeln(sqrt(x))
				ELSE writeln('argument error')
		UNTIL x = 0;  (* note this  ; is an optional separator *)
	END.
