-h- TEST.SRC 1390
program testconstants;

{ note to the curious: this program does not compile under Pascal MT+
  VERSION 5.5 though it does compile under sorcim's M compiler.   On the
  line marked with a * the compiler gives out an 'error 18: error in
  declaration part'; the identifier it was looking at was the 'tons'. 
	The reason for this is instructive.  In the ISO PASCAL Standard,
  redefining global constants is not allowed.  Example: tons has been defined
  as 34; defining tonnes as being equal to tons is (according to ISO)
  redefining a global constant and is a no-no.  This is dumb, but true.  Pascal
  M as well as UCSD allow them.  PASCAL MT+ chose to conform to the 
  ISO Standard, which means it is probably more portable but also not so
  convenient.  I am told PASCAL MT+ may give up and allow
  you to assign from these constants inside a procedure in a future release;
  but there are arguments in both ways, and the point is that you simply
  have to know the compiler you are working with.  }

const
  tons = 34;
  yards = 56;
  fathoms = 6;
  schlog = tons;

procedure sock;
const
  gurf = 345;
  schneeg = ' hi! ';
  tonnes = tons;    (* * *)
  yargs = yards;
  firkins = fathoms;
begin
  writeln('tonnes = ',tonnes);
end;  

procedure wham;
var
  foot : integer;
begin
  writeln('wham!');
  foot := tons;
  writeln('foot = ',foot);
end(* wham *);

begin
  sock;
  wham;
end.

-h- TEST2.SRC 1257
program feces;
(* This program DOES work with both MT+ and M.  This proves that you may
   redefine CONSTants as long as they are redefined in the same declaration
   part.  It should also be noted that at first crack the program object code
   was 18K; that seems a bit excessive.  When relinked with the /S option (see
   MT+ p. 25) it is ensmalled considerably. *)
(* A note: passed parameters can be constants.  However, putting a var in wham:

   procedure wham( var I : integer);

   and passing a constant is a no-no -- which is the desired result.  You 
   may not redefine a constant in a procedure; it is not allowed. *)

const
  tons = 34;
  yards = 56;
  fathoms = 6;
  schlog = tons;

procedure sock;
const
  gurf = 345;
  schneeg = ' hi! ';
  tonnes = ' this is the value of tonnes ';
begin
  writeln('tonnes = ',tonnes);
end (* sock *);

procedure wham( I : integer);
var
  foot : integer;
begin
  writeln('wham!');
  writeln('I, the passed parm is : ',I);
  foot := tons;
  writeln('foot = ',foot);
end(* wham *);

begin
  sock;
  wham(tons);
  writeln(' hey world! I''ll bet you''re just dying to know that:');
  writeln(' tons = ',tons);
  writeln(' yards = ',yards);
  writeln(' fathoms = ',fathoms);
  writeln(' schlog = ',schlog);
end.
-h- TEST3.SRC 525
(* This test compiles under M and MT+ as it ought to.  Note: to access the
  (single) element in j, the following is necessary:

j[1, 1, 1, 1] := 4; *)


program foobar;  {testing the symbol table again}
type
  f = packed array [1..1] of integer;

procedure barfoo;
type
  g = packed array [1..1] of f;

procedure gumby;
type
  h = packed array [1..1] of g;
  i = packed array [1..1] of f;
Var
  j : i;
begin
  j[1, 1, 1, 1] := 4;   (* should access the one element of j *)

end(*gumby*);

begin
end(* barfoo *);

begin
end.
-h- TEST5.SRC 3105
program realtest;
var
  a:real;

function yesno(s:string):boolean;
var
  injunk : char;
begin
  write(s);
  readln(injunk);
  yesno := (injunk='y') or (injunk='Y');
end(* yesno *);              (* this semicolon is not optional; a comment can
 			        precede a semicolon the way I have done it.*)

(* After a bit of testing, I have discovered some very interesting things.
   On a floating-point underflow (P/M) on input (my example was 0E-66), the 
   program terminates and returns to CP/M, giving a "! Floating Point Overflow"
   error.  This means it is unlikely there is a separate underflow check, at
   least an explicit one. On input overflow, (example: a large number) it  
   indeed beeps twice and waits for another input.  Inputting zero ( 0 )
   resulted in  "The value of A is : 0.0000000000000000E-65".  Zero, then, is
   not stored as "0.0000000000000000E 00", if I understand what is happening.*)
 
 (*  P/M can thus cause several mysterious things to happen if you are not
 careful about what input you give it.  Note this test program does no 
 calculations at all.  The two P/M failure modes are:

1)  Doing nothing, printing nothing, and waiting for valid input.
2)  Giving a Floating Point Overflow! error message, then dying and
	returning you to CP/M.

    Note that both of these are in contrast to BASIC, which gives input error
messages and asks for re-input.

	If your application program has likelyhood of out of range numbers
	being entered, you'd better input it as a string and convert with
	appropriate value checking.  This ain't simple.  The Best of British
	luck to you...   JEP  *)

(* PASCAL MTPLUS DOES other weird things when given values it doesn't like.
If you give it a string when it expects a number, it does nothing at all;
it merely waits for more numbers.  If you give it a LONG number, such as
444444444444444444444444444444444444444444 it gives an overflow message and
offers the option of abort with ^c (control-c) or continue with space.
	It may take 8 to 15 space bar hits to clear it, but eventually
it will clear.  However, it will also think it has read a number, and that
number will have ABSOLUTELY NO RELATIONSHIP to the number that was actually
input.
	If you give it a floating point number like 3.45E19, it will
change the sign of the number and also get the exponent wrong.  This
is true for any exponent greater than 18.  Numbers with a negative
exponent greater than 18 are also treated inconsistently; the only thing
you can be sure of is that they're WRONG.
	Try this program and muck around with varius size numbers like
234.567E88 and 56.78e-45 and see what happens so you'll know how the
MTPLUS compiler is likely to treat your errors. *)


begin (* main program *)
  repeat
    write('What value for A ? ');
    read(a);
    writeln('The value of A (after read) is : ',A);
    write('What value for A now ? ');
    readln(a);
    writeln('The value of A (after readln) is : ',A);
    writeln('The following A is in '':9'' format : ',A:9,
           ' And 1 space surrounds it.');
  until not yesno('Again ? ');
end(* realtest *).
-h- TESTVARS.SRC 1841
program testvars;

(* The following will not compile in either M or MT+: 

var
  var_strg, 
  var_strg1 : string;
  kludgeamatic,
  kludge_amatic : integer;
  carstrg,
  carstrg1 : string;

  M thinks that var_strg and var_strg1 are the same variable name (error #101:
 "identifier declared twice"), which is the correct error -- remember that M
 thinks that an underscore ("_") is part of a variable name.  MT+ thinks that
 kludgeamatic and kludge_amatic are the same variable name, which is correct
 for it -- MT+ ignores underscores in variables. *)

(* The following will compile but not link properly in MT+:

var
  var_strg, 
  var_strg1 : string;
  kludgeamatic,
  kludge_matic : integer;
  carstrg,
  carstrg1 : string;

  The linker says that there's a duplicate symbol (varstrg) in the file.  This
  seems to mean that something funny is going on with underlines, since the
  carstrg bits compiled.*)

(* The following will also compile and not link:

var
  var_strg, 
  var_strg1 : string;
  kludgeamatic,
  kludge_matic : integer;
  car_strg,
  car_strg1 : string;

  This time there are two duplicate symbols: varstrg and carstrg.  This just
  about eliminates the possibility that varstrg is a reserved identifier. *)

(* Hmm, it seems it's not just a problem with underlines.  The following also
  has duplicate symbols "varstrg" (meaning the linker sees no difference
  between varstrg and varstrg1)  and "carstrg" (meaning the linker sees no
  difference between carstrg and carstrg1): *)

var
  varstrg, 
  varstrg1 : string;
  kludgeamatic,
  kludge_matic : integer;
  carstrg,
  carstrg1 : string;

(* incidentally, it DOES compile in Pascal M properly.  I think there's
  probably some major linker bug here; I don't have the time currently to
  look through the manual in search of relevant material. *)


begin
end.


-h- TESTDISP.SRC 353
PROGRAM testdispose (output);
	{ Page 270 Grogono }

	CONST
		size = 1000;
		numberofnodes = 1000;
	TYPE
		link = ^node;
		node = ARRAY[1 .. size] OF integer;
	VAR
		p : link;
		n : 1 .. numberofnodes;

	BEGIN
		for n := 1 TO numberofnodes DO
		    BEGIN
			new(p);
			dispose(p)
		    END;{ for  }
		writeln('Ran to completion.');

	END. {testdispose}
-h- TESTGOTO.PAS 660
(* This program executes under both M and MT+, as it ought to.  I don't
  advocate using GOTOs, but if you have to, here is some important data. *)

program messy;
label 99;


procedure uno;
label 99;
begin
    writeln('Entering uno');
    goto 99;
    writeln('Never should be printed');
99:
    writeln('Leaving uno');
end (* uno *);

procedure dos;
label 99;
begin
    writeln('Entering dos');
    goto 99;
    writeln('Never should be seen!');
99:
    writeln('Leaving dos');
end (* dos *);

begin (* main *)
    writeln('Entering main program');
    uno;
    dos;
    goto 99;
    writeln('Should never print');
99: writeln('Leaving main program');
end.

-h- TST2GOTO.PAS 1470
(* This program will NOT compile in Pascal M, though it will in MT+.  The error
  comes in "tres", where "99" is not declared.  The M manual states (and this 
  test confirms) that you aren't allowed to jump across routine boundaries, as
  was the intent of "tres".  A further note to MT+ hackers planning on using
  GOTOs in odd ways: be careful.  You are likely to do something odd indeed if
  you aren't careful.  Note well that GOTOing out of recursive procedures is
  both hazardous to your health and not supported by Pascal MT+ (MT+ p. 146).
  Look both ways before crossing this street.  You probably can perform error-
  testing in a procedure like ERROR (in Archive) that halts the program after
  it's done more easily than using a GOTO 9999; among other things, this allows
  returns from corrective code.  *)


program messy;
label 99;


procedure uno;
label 99;
begin
    writeln('Entering uno');
    goto 99;
    writeln('Never should be printed');
99:
    writeln('Leaving uno');
end (* uno *);

procedure dos;
label 99;
begin
    writeln('Entering dos');
    goto 99;
    writeln('Never should be seen!');
99:
    writeln('Leaving dos');
end (* dos *);

procedure tres;
begin
    writeln('Entering tres');
    goto 99;
    writeln('This should never be printed');
end (* tres *);

begin (* main *)
    writeln('Entering main program');
    uno;
    dos;
    tres;
    goto 99;
    writeln('Should never print');
99: writeln('Leaving main program');
end.-h- TESTPROC.PAS 214
(* This program will not compile, hopefully in any implementation of Pascal. 
  For why, see the error table, error # 18. *)


program testproc;

procedure tproc( t: array [1..99] of char);
begin
end;

begin
end.

-h- TESTEXIT.PAS 2318
program testexit;
(* Pascal/M counts underscores in process names as part of the actual name;
  "inter1dependent" and "inter_1_dependent" are not the same name as they
  would be in most Pascals.  See the M manual for more info. *)

(* testing M exit(programname) feature; all features tested here work *)
(* If you try to exit a process whose name the compiler hasn't seen, you will
  generate error #104: "Undeclared identifier", which is good and proper.  If 
  you try to exit an uncalled procedure, you will recieve a runtime error,
  "Exit from uncalled procedure", which is also good and proper.
*)

procedure hello;
begin
  writeln('entering hello');
  writeln('exiting hello');
end (* hello *);

{ (* "goodbye" should have caused an error -- and did.  It tried to exit a
 procedure that had not called it (hello); Pascal/M errored off as it is
 supposed to.  I have tried this to maximum levels -- go see program
 test2xit.pas for how. *)

procedure goodbye;
begin
  writeln('entering goodbye procedure');
  exit(hello); (* should cause error *)
  writeln('You shouldn''t ever see this line');
end (* goodbye *);
}

procedure nest;

procedure nested;
begin
  writeln('entering nested procedure, trying to exit outer procedure');
  exit(nest);
  writeln('You shouldn''t see this line');
end (* nested *);

begin (* nest *)
  writeln('Entered into nest');
  nested;
  writeln('You shouldn''t ever see this line!!');
end (* nest *);

procedure inter_2_dependent; forward; (* so we may reference it in inter_1 *)

procedure inter_1_dependent;
begin
  writeln('Hi ho, this is the first interdependent procedure');
  inter_2_dependent;
  writeln('You shouldn''t ever ever ever see this');
end (* inter_1_dependent *);

procedure inter_2_dependent;
begin
  writeln('Ho, ho this is the second interdependent procedure');
  exit(inter_1_dependent);
  writeln('you should not be able to read this');
end (* inter_2_dependent *);

begin (* main program *)
  writeln('Hi, this is testexit.');
  hello;
  writeln('Hi, this is testexit, once again.');
  nest;
  writeln('Hi from testexit a third time.');
  inter_1_dependent;
  writeln('Hi from testexit, time number four');
{ goodbye;	(* see the procedure for why this is commented out *) }
  writeln('Hi, this is testexit, I''m leaving now...');
end (* main program *).

-h- TEST2XIT.PAS 3003
(* This program should run fine on all Pascal/M systems. *)

program test2xit;
const
  mem_limit = 500;
  dingdong = 7;		(* bell *)
var
  bell : char;
  i : integer;

(* tests the traceback exit and halt features of Pascal/M to extremes.  With
   mem_limit set to 100, the P-system aborts -- the memory traces wrap around
   to 0000 Hex!  It takes forever, too.   It works for 500 and 1000; 400 causes
   no problems, unless you try to terminate things at the first stop for
   timing.  At that point, another "insufficient memory" error occurs;
   obviously this causes no problem in this program, but in one that has files
   to close, you'd be in big trouble.  I suggest you don't run this program, or
   any other, with mem_limit below 500.  Incidentally, on my system (Z-80
   running Prunz80) I got to level 3062 on inner_1 and inner_2; I didn't
   time it. *)

procedure write_stats;
begin
  writeln(bell, 'Stop', bell, ' tim', bell, 'ing', bell, '!', bell);
  writeln('We are at recursion level ', i);
  writeln('and we have ', memavail, '"units" of memory left.');
  write  ('All right, get your watch ready and press <return> again.');
  readln;
end (* write_stats *);

procedure outer;

(* inner_1 exits one level at a time from the recursion stack, while inner_2
  exits all its levels at once.  The differences between the two should not be
  that marked, but testing them should yield some interesting data on the
  stack operations performed by your operating system. *)

procedure inner_1;
begin
  if (memavail > mem_limit) then (* recurse again *)
  begin
    i := i + 1;
    inner_1
  end
  else 
  begin
    write_stats;
    writeln('Now exiting inner_1 ...'); (* take this line out for benchmark
					  timing. *)
    exit(inner_1);
  end;
(*writeln('You should see this "i" times.');	(* taken out because it takes
						  entirely too long. *)
end (* inner *);

procedure inner_2;
begin
  if (memavail > mem_limit) then (* curse again *)
  begin
    i := i + 1;
    inner_2
  end
  else
  begin
    write_stats;
    writeln('Now exiting inner_2 (and outer)'); (* take this line out for
						  benchmark timing. *)
    exit(outer);
  end;
  writeln('You should never ever see this massage');
end (* inner_2 *);

begin (* outer *)
  write('Ready your watch.  When you''re set, press <return>.');
  readln;
  writeln('Now entering inner_1.  Sit back and relax.');
(* previous line out for benchmarks *)
  inner_1;	(* Then you wait... *)
  i := 0; 	(* reset level counter *)
  write_stats;
  writeln('Okay, now we''re done with inner_1.  Entering inner_2.');
(* the previous line is taken out for timing *)
  inner_2;
  writeln('You should never see this message!!!');
end (* outer *);

begin (* main program *)
  bell := chr(dingdong);
  i := 0;	(* i is the recursion level counter *)
  writeln('Now entering outer.');
  outer;
  write_status;
  writeln('Now exiting main program.  If you can read this, Pascal/M has');
  writeln('good recursion routines.');
end (* main program *).

-h- TEST3XIT.PAS 321
(* This programme compiles in Pascal M, proving that you may exit your main
  program by exit(program). Useful if you forget what the name of your program 
  is. *)

program blah;

begin
  writeln('You should be able to read this.');
  exit(program);
  writeln('You shouldn''t see this printed out ever ever ever.');
end.-h- STRGTEST.SRC 2954
program readwritestringtest;
var
  longstring:string[255];
  again : boolean;
  response : char;

(* You simply won't believe this.

   Run this program under MT+ 5.5; type in a 254-long string.  It will work
  fine.  Now type in a 255-long string.  It will still work fine.  Type in
  another.  It will be printed as a single $.
  
   Now, reboot the program and type in a 255-long string (they're easy to do:
  the program stops accepting after the 255th character).  You will get a
  single '$' again.  I can't explain.  Incidentally, if you comment out the
  ",'$'", the program does not work any differently.*)

(* This program also shows some differences between M and MT+. Under M, it'll
  accept any length input, truncating at the 255th character.  Under MT+, it'll
  only accept 255 characters, after which it automagically keeps going.*)

(* On input, the behavior of the two is markedly different.  M accepts only
  the backspace (^H), uses it as a destructive backspace, erasing as it backs
  up -- including over the prompts!!  MT+ accepts the backspace as a non-
  erasing backspace, while the delete key (RUBOUT) is a destructive backspace.
  It too will backspace over the prompts, back to the beginning of the line.
  You might want to play around with this a little to familiarize yourself with
  the  characteristics of your particular system; I won't guarantee that the
  behaviour isn't different on other systems. *)

(* I might as well admit it.  I'm a hacker.  I test for strange errors,
  document them, and torment the implementers with them.  Who else but a True
  Hacker would have found this error ?

  In Pascal/M, if you type in a command line like such:

A>prunz80 echo uuuu..uu (*0 to 83 u's*)

  the program ECHO runs fine, reading in the u's (or any other character) to
  the first readln.  However, if you type in 84 U's, the M run shell (that is,
  the runtime package that supports PASCAL/M programs) gives the following
  error:

.PCO file not found
! abort 

  or somthing like it.  If you type in 85 U's, my BDOS gives this error:

BDOS error on L: select

  If you type in 86 or more U's (up to the limit that CP/M gives, which is I
 guess about 127 characters total) my BDOS gives this error:

BDOS error on M: select.

   Unless you write programs requiring great gobs of input line stuff, this
  shouldn't affect you, but as I said I'm a hacker and don't like having errors
  of any kind. *)

begin
  writeln('Long string test program, 14 July 82');
  repeat
    writeln('length(string)=',length(longstring));
    longstring := '';
    writeln('length(string)=',length(longstring));
    writeln('Please type in a very long string:');
    readln(longstring);
    writeln('length(string)=',length(longstring));
    writeln(longstring,'$');
    writeln('length(string)=',length(longstring));
    write('Again ? ');
    readln(response);
    again := ((response='y') or (response='Y'));
  until not again;
end.

-h- STRGTEST.PAS 3954
program readwritestringtest;
var
  longstring:string[255];
  again : boolean;
  response : char;

(* You simply won't believe this.

	The purpose of this program is to echo strings that you type in
	so that we can test string handling.

   Run this program under MT+ 5.5; type in a string 254 characters long. It
   will work fine.  Now type in a string 255 characters long.  It will still
   work fine.  Type in another.  It will be printed as a single $.
  
   Now, reboot the program and type in a 255-long string (they're easy to do:
  the program stops accepting after the 255th character).  You will get a
  single '$' again.  I can't explain.  Incidentally, if you comment out the
  ",'$'", the program does not give the $, but it doesn't do anything else;
  you get no output at all.  Thus, the first time you put in a 255 char string
  it works if and only if you have done a 254 char string first!  And after
  that it won't work at all.  This seems to be a bug in the implementation; but
  fortunately it doesn't seem to do anything with lengths smaller than 254. *)

  (* With Pascal M this doesn't happen; it seems to handle strings of any 
  length up to and including 255 without problems.  However, in Pascal/M
  it doesn't stop inputting after 255 (although it doesn't see any more than
  255 characters);  you can input until the end of time and it will go on
  acting as if it has accepted it, although it has quit listening after 
  character 254. *)

(* This program also shows some differences between M and MT+. Under M, it'll
  accept any length input, truncating at the 255th character.  Under MT+, it'll
  only accept 255 characters, after which it automagically keeps going.*)

(* On input, the behavior of the two is markedly different.  M accepts only
  the backspace (^H), uses it as a destructive backspace, erasing as it backs
  up -- including over the prompts!!  MT+ accepts the backspace as a non-
  erasing backspace, while the delete key (RUBOUT) is a destructive backspace.
  It too will backspace over the prompts, back to the beginning of the line.
  You might want to play around with this a little to familiarize yourself with
  the  characteristics of your particular system; I won't guarantee that the
  behaviour isn't different on other systems. *)

(* You will want to test ^H, BACKSPACE, and DELETE on YOUR system to see how
  they work; this program is useful for that.  Do that now. *)


(* I might as well admit it.  I'm a hacker.  I test for strange errors,
  document them, and torment the implementers with them.  Who else but a True
  Hacker would have found this error ?

  In Pascal/M, if you type in a command line like such:

A>prunz80 echo uuuu..uu { 0 to 83 u's }

  the program ECHO runs fine, reading in the u's (or any other character) to
  the first readln.  However, if you type in 84 U's, the M run shell (that is,
  the runtime package that supports PASCAL/M programs) gives the following
  error:

.PCO file not found
! abort 

  or somthing like it.  If you type in 85 U's, my BDOS gives this error:

BDOS error on L: select

  If you type in 86 or more U's (up to the limit that CP/M gives, which is I
 guess about 127 characters total) my BDOS gives this error:

BDOS error on M: select.

   Unless you write programs requiring great gobs of input line stuff, this
  shouldn't affect you, but as I said I'm a hacker and don't like having errors
  of any kind. *)

begin
  writeln('Long string test program, 14 July 82');
  repeat
    writeln('length(string)=',length(longstring));
    longstring := '';
    writeln('length(string)=',length(longstring));
    writeln('Please type in a very long string:');
    readln(longstring);
    writeln('length(string)=',length(longstring));
    writeln(longstring,'$');
    writeln('length(string)=',length(longstring));
    write('Quit? ');
    readln(response);
    again :=  NOT ((response='y') or (response='Y'));
  until not again;
end.

-h- TESTFMT.PAS 832
program testformat;
var
  realvalue : real;
  intvalue,
  mult,
  fmtvalue : integer;

(* note: SIZE is a predefined function in M. *)
(* The two-parameter output format seems to work in both M and MT+.  I need to
  explore how they work better, but they both have this feature. *)

begin
  realvalue := 5;
  intvalue := round(realvalue);
  for mult := 1 to 5 do
  begin
    for fmtvalue := 5 to 9 do
    begin
      writeln(
'format = ', fmtvalue, ' spaces, value = ', realvalue:fmtvalue:(fmtvalue-1),
'; int value= ', intvalue:fmtvalue);

(* MT+ will compile the following line though M will not: *)

      writeln(
'same format : ', intvalue:fmtvalue:(fmtvalue-1));

(* The error occurs at the last format descriptor; for more info, see PWRT2. *)

    end;
    intvalue := intvalue * 10;
    realvalue := intvalue;
  end;
end.

	