
{UPDATE}
{ update -- update existing files, add new ones at end }
procedure update (var aname: string; cmd : character);
var
    i : integer;
    afd, tfd : filedesc;

(* Note the change to the call to the procedure close -- close is a standard
  procedure in M and MT+, so we call a proc with a different name, tool_close.
  Tool_close calls the appropriate close procedure. *)

begin
    tfd := mustcreate(archtemp, IOWRITE);
    if (cmd = ord('u')) then begin
	afd := mustopen(aname, IOREAD);
	replace(afd, tfd, ord('u'));	{ update existing }
	tool_close(afd) 		{ see note above }
    end;
    for i := 1 to nfiles do	{ add new ones }
	if (fstat[i] = false) then begin
	    addfile(fname[i], tfd);
	    fstat[i] := true
	end;
    tool_close(tfd);
    if (errcount = 0) then
	fmove(archtemp, aname)
    else
	message('update: fatal errors - archive not altered');
    remove(archtemp)
end {UPDATE};

