/*
 *
 *			      CBC.C
 *
 *		  Brace and Parenthesis Checker
 *
 *	 	        and Comment Checker
 *
 * 
 *		for MS-DOS and Computer Innovations C86 
 * 
 *		Copyright (c) 1983,84 Solution Systems
 *
 *			  May 1984 
 * 
 */

#include "stdio.h"
#include "chelper.h"

char *Fname, Line_buf[132];

int 	Help,		/*	  Global flags		*/
	No_brace,
	Count_comments,
	No_paren,
	No_ln_num,
	Ff_on;

int  	*fd,		/*  file descriptor		*/
	num_braces,	/*  depth of curly braces	*/
	prev_num_braces, /*  prev num_braces to hilite fncs */
	ln_num, 	/*  line #			*/
	err_flg,	/*  negative nesting error	*/
	in_quote,	/*  quoted character		*/
	sgl_quote_flg,	/*  quoted by single quotes	*/
	dbl_quote_flg;	/*  quoted by double quotes	*/



/*	cbc
*/ 
main(argc,argv) 
int argc; 
char *argv[]; 
{ 

   fprintf(errmsg, 
     "CBC: Brace Checker %s, Copyright (c) 1983,84 Solution Systems\n",
	version); 

   init_flags(); 
   proc_cmdl(argc,argv); 
   program();
} 

/*  give the user some HELP */
help_msg()
{
	fprintf(errmsg,
	  "\n\tUsage: cbc [-flags] input_file [>output_file]\n");

	fprintf(errmsg, "\n\tH        Help");
	fprintf(errmsg, "\n\t?        Help");
	fprintf(errmsg, "\n\tB        No Braces Counted.");
	fprintf(errmsg, "\n\t{        No Braces Counted.");
	fprintf(errmsg, "\n\tC        Count Comments.");
	fprintf(errmsg, "\n\tP        No Parenthesis Counted.");
	fprintf(errmsg, "\n\t(        No Parenthesis Counted.");
	fprintf(errmsg, "\n\tL        No Depth and Line Numbers.");
	fprintf(errmsg, "\n\tF        FF on, A New Page At 0 Depth.\n\n");

}   	/* end help_msg */ 

/* initialize flags */ 
init_flags() 
{ 

	num_braces=0;  /*  init brace depth	       */
	prev_num_braces=0; /*  no prev nesting	       */
	err_flg=0;     /*  not close before open brace */
	ln_num=1;      /*  init line #		       */
	Help=FALSE;
	No_brace=FALSE;
	Count_comments=FALSE;
	No_paren=FALSE;
	No_ln_num=FALSE;
	Ff_on=FALSE;
	dbl_quote_flg=FALSE;

}       /* end initialize */ 

/*  process command line to set flags and open file */ 
proc_cmdl(argc,argv) 
int argc; 
char *argv[]; 
{ 
/*
 * usage message and exit if no args
 */

	if (argc < 2) {
		help_msg(); 
		exit();
	}
/*
 *  open input file
 *
 *  if can't be opened, is it help. print help or file error msg then exit.
 *
 */
	Fname=argv[--argc];
	if ((fd=fopen(Fname,"r"))==NULL) {
		if ((argv[argc][0]=='?') || (argv[argc][1]=='?'))
			help_msg();
		else {
			fprintf(errmsg, "\ncannot open: %s\n",Fname);
		}
		exit();
	}
/*
 *  while flag(s)
 *
 * test for flag validity or help and identify flag if valid
 *
 */

   while (--argc) {
	if (argv[argc][0]=='-') {
	switch(toupper(argv[argc][1])) {
		case 'H': case '?':
			Help=TRUE;
			help_msg();
			fprintf(errmsg,"\n\n");
			break;
		case 'B': case '{':
			No_brace=TRUE;
			if (Help)
				fprintf(errmsg,
				"\nDon't count braces flag\n");
			break;
		case 'C':
			Count_comments=TRUE;
			if (Help)
				fprintf(errmsg,
				"\nCount comments flag\n");
			break;
		case 'P': case '(':
			No_paren=TRUE;
			if (Help)
				fprintf(errmsg,
				"\nDon't count parenthesis flag\n");
			break;
		case 'L':
			No_ln_num=TRUE;
			if (Help)
				fprintf(errmsg,
				"\nDon't display depth of braces (etc) and line numbers flag\n");
			break;
		case 'F':
			Ff_on=TRUE;
			if (Help)
				fprintf(errmsg,
				"\nFF on at 0 count and LINESPG flag\n");
			break;
		default:
			fprintf(errmsg,
			"\nError, -%c not a valid flag\n",
			argv[argc][1]);
			break;
		}       			/* end switch */ 
	}
	else if ((argv[argc][0]=='?') ||
		  (toupper(argv[argc][0]=='h'))) {
		help_msg();
		Help=TRUE;
	}

	else fprintf(errmsg, "\nNot a valid flag, '-' missing\n");
  }

  fprintf(errmsg, "CBC: Checking File: %s\n",Fname); 

} 	/* end proc_cmdl */ 



/* do the cbc */ 
program() 
{ 
int i; 
/*
 *   while data (main program loop)
 */

	while (fgets(Line_buf,132,fd)) {

		for(i=0;Line_buf[i];++i) {

			/*
			 * is character being tested in quotes ?
			 */

			in_quote=sgl_quote_flg=single_quote(i);

			if (Line_buf[i]=='\"') {
				unless (sgl_quote_flg) {
					if (dbl_quote_flg) dbl_quote_flg=FALSE;
					else dbl_quote_flg=TRUE;
				}
			}

			if ((sgl_quote_flg) || (dbl_quote_flg)) in_quote=TRUE;

			/*
			 * count close brace and comments and parenthesis
			 */

			if (Line_buf[i]=='}')
				unless (((No_brace) || (in_quote)))
					--num_braces;
			if (Line_buf[i]==')')
				unless (((No_paren) || (in_quote)))
					--num_braces;
			if ((Count_comments) &&
			    (Line_buf[i]=='*' && Line_buf[i+1]=='/'))
					--num_braces;

			if(num_braces<0) ++err_flg;    /*  an error if < 0  */

			/*
			 * count open brace and comments and parenthesis
			 */

			if (Line_buf[i]=='{')
				unless (((No_brace) || (in_quote)))
					++num_braces;
			if (Line_buf[i]=='(')
				unless (((No_paren) || (in_quote)))
					++num_braces;
			if ((Count_comments) &&
			    (Line_buf[i]=='/' && Line_buf[i+1]=='*'))
					++num_braces;
		}
/*
 * bad nesting error test and message
 */
		if(err_flg>0) {
			fprintf(errmsg, "\n++ bad nesting: ++\n");
			err_flg=0;
		}
/*
 *    output
 */
		if(err_flg<0)
			err_flg=0;
		ln_num++;
		if (No_ln_num) fprintf(stdout, "%s",Line_buf);
		else fprintf(stdout, "%3d %2d: %s",ln_num,num_braces,Line_buf);
		if(prev_num_braces && (num_braces==0)) {	  /* just decrement to 0? */
			fprintf(stdout,"----------------------\n");
			if (Ff_on) fprintf(stdout,"%c", FF);
		}
		prev_num_braces=num_braces;
	}

}       /*  end program */ 


/* is it a single quote ? */ 
single_quote(i)
{

	return (Line_buf[i-1]=='\'') && (Line_buf[i+1]=='\'');

}       /* end single_quote */ 






                                
                                                                                                                                                                                                                                                          