/*
 *
 * binary file comparison utility
 * (from a public domain bdsc program, author unknown)
 *
 * converted to Computer Innovations C86 by Bob Green for:
 *
 * Solution Systems, Copyright (c) March, 1984, All Rights Reserved
 *
 */

#include "local.h"

/* : : : : : : : : : : : : : : : : : : : : : : : : : : : : : :
	Macros for constant definitions
   : : : : : : : : : : : : : : : : : : : : : : : : : : : : : : */

#define EOFF -1		/* end of file marker returned by getc() */
#undef EOF 		/* compiler doesn't like redundancy  */
#define EOF 0x1A	/* ascii end of file mark */
#define NOFILE -1	/* no such file indication given by fopen() */

/*	-------------------------------------------------------
	Name:		main(argc,argv)
	Result:		---
	Errors:		invocation syntax error or no such file
	Globals:	---
	Macros:		TRUE,FALSE,NOFILE
	Procedures:	fopen(),tolower(),bummer(),htoi(),fcompare()

	Action:		Byte by byte compare of 2 files and
			print their differences on console
	------------------------------------------------------- */

FILE *fdin, *fdout;

main(argc,argv)
	int argc;
	char *argv[];
	{
	int ascii;
	unsigned start_adrs,htoi();
	char *ptr;
	char *mstbuf[BUFSIZ], *chkbuf[BUFSIZ];

	ascii = FALSE;	/* assign the defaults */
	start_adrs = 0;
        fprintf(stderr, 
             "\nCMP, Binary File Comparison Utility\nUSAGE: cmp <file1> <file2> <-flg> [ >out_file]");
        fprintf(stderr,
            "\nCopyright (c) March, 1984 by Solution Systems\n");

	if( argc < 3 || argc > 5 )
	  bummer();
	else if ((fdin = fopen(argv[1],"r")) == NULL)
	  printf("No such file %s\n",argv[1]);
	else if ((fdout  = fopen(argv[2],"r")) == NULL)
	  printf("No such file %s\n",argv[2]);
	else  {
	  *mstbuf = (char *)fdin;
	  *chkbuf = (char *)fdout;
	  while( argc > 3 ) {
	    ptr = argv[--argc];
	    if( *ptr++ != '-' )
	      bummer();
	    switch ( tolower(*ptr++) ) {

	      case 'a':	ascii = TRUE;
			break;

	      case 'b':	start_adrs = htoi(ptr);
			break;

	      default:	xputs("Unrecognized option. Aborted\n\n");
			bummer();
	      }	/* end switch */
	    }	/* end while */
	  fcompare(fdin,fdout,start_adrs,ascii);
	  }	/* end else */
	exit();
	}

/*	-------------------------------------------------------
	Name:		fcompare(mfile,cfile,adrs,ascii)
	Result:		---
	Errors:		---
	Globals:	---
	Macros:		EOFF,EOF
	Procedures:	getc(),xputs(),strcpy(),printf()

	Action:		compare 2 files and print their differences
			on the console
	------------------------------------------------------- */


fcompare(fdin,fdout,adrs,ascii)
	unsigned adrs;		/* the address of begin of file */
	int ascii;		/* flag of whether these are ascii files */
	{
	int mc,cc;		/* 1 char buffers */
	char erflg;		/* flag that an error has occurred */
	char *xl();		/* function to translate control chars */
	char str1[6],str2[6];	/* temporaries for strings */
	char xlate[10];	/* string used in ascii control char translation */

	erflg = 0;
	while( ! ( (mc = getc(fdin)) == EOFF || (ascii && mc == EOF)) ) {
	  if( (cc =getc(fdout)) == EOFF || ( ascii && cc == EOF )) {
	    xputs("Checkfile shorter than Master file\n");
	    return;
	    }
	  else if( mc != cc ) {
	    if( ! erflg ) {
	      erflg = 1;
	      xputs("\nRelative");
	      xputs("\nAddress  File1  File2  Mismatch");
	      xputs("\n-------  ----   ----   --------\n");
	      }	/* end if */
	    if( ascii )	{
	      strcpy(str1,xl(mc,xlate)); /* fudge because parameters are */
	      strcpy(str2,xl(cc,xlate)); /* evaluated before being passed */
	      printf("%4x     %-4s   %-4s   %8b\n",adrs,str1,str2,mc^cc);
	      }
	    else
	      printf("%4x     %2x     %2x     %8b\n",adrs,mc,cc,mc ^ cc);
	    }		/* end else if */
	  else
	    ;
	  adrs++;
	  }		/* end while */
	if(! ( (cc = getc(fdout)) == EOFF || (ascii && cc == EOF) ) )
	  xputs("Masterfile shorter than checkfile\n");
	return;
	}		/* end fcompare() */

/*	-------------------------------------------------------
	Name:		err_exit(msg)
	Result:		---
	Errors:		---
	Globals:	---
	Macros:		---
	Procedures:	printf(),exit()

	Action:		Print a message then exit to CP/M
	------------------------------------------------------- */

err_exit(msg)
	char *msg;
	{
	exit(xputs(msg));
	}

/*	-------------------------------------------------------
	Name:		htoi(string)
	Result:		unsigned integer value of ascii hex string
	Errors:		---
	Globals:	---
	Macros:		---
	Procedures:	tolower(),isalpha(),isdigit()

	Action:		---
	------------------------------------------------------- */

unsigned htoi(string)
	char *string;
	{
	unsigned number;
	char c;

	number = 0;
	c = tolower(*string++);
	while( isalpha(c) || isdigit(c) ) {
	  if( c > 'f' )
	    return number;
	  number *= 16;
	  if( isdigit(c) )
	    number += c -'0';
	  else
	    number += c - 'a' + 10;
	  c = tolower(*string++);
	  }
	return number;
	}
/*	-------------------------------------------------------
	Name:		bummer()
	Result:		---
	Errors:		---
	Globals:	---
	Macros:		---
	Procedures:	xputs(),exit()

	Action:		Print the invocation syntax error message
			and exit to CP/M
	------------------------------------------------------- */

bummer()
	{
	xputs("Optional flags are:\n\n");
	xputs("-a          => these are ascii files (terminate on 1AH )\n");
	xputs("-b<hex-num> => begin of file is address <hex-num> ");
	xputs("default is 0\n");
	exit();
	}

/*	-------------------------------------------------------
	Name:		xl(c)
	Result:		pointer to  xlate[]
	Errors:		---
	Globals:
	Macros:		---
	Procedures:	strcpy()

	Action:		Translate the char argument c into a
			4 char string in  xlate[]
			If c is a printable ascii char its
			  translation is itself right blank padded
			Else if c is a standard control char its
			  translation is a string identifying that
			  control char
			Else its translation is "????"
	------------------------------------------------------- */

char *xl(c,xlate)
	int c;
	char *xlate;
	{
	if( c > 0x7f || c < 0 )
	  strcpy(xlate,"????");
	else if( c == 0x7f )
	  strcpy(xlate,"del ");
	else if( c > 0x1f ) {	/* then it is printable */
	  xlate[0] = c;
	  strcpy(xlate+1,"   ");
	  }
	else
	  switch (c) {
	    case 0x7:	strcpy(xlate,"bel");
			break;

	    case 0x8:	strcpy(xlate,"bs");
			break;

	    case 0x9:	strcpy(xlate,"tab");
			break;

	    case 0xa:	strcpy(xlate,"lf");
			break;

	    case 0xc:	strcpy(xlate,"ff");
			break;

	    case 0xd:	strcpy(xlate,"cr");
			break;

	    case 0x1b:	strcpy(xlate,"esc");
			break;

	    default:	xlate[0] = '^';		/* show control chars as */
			xlate[1] = c + 0x40;	/* ^ <char> e.g. ^A is */
			xlate[2] = '\0';	/* control A */
			break;
	    }
	return xlate;
	}

xputs(strng)
char *strng;
{

	 printf(strng);
}


slation is a string identifying that
			  control char
			Else its translati