
/*
 *     CUTIL -- REMOVES  TRAILING  WHITESPACES, FILTER CONTROL CHARACTERS
 *     AND REMOVES 8TH BITS, CHANGE CASE  (IN  JUST  COMMENTS,	OR  ALL).
 *     ALSO DISPLAYS LINE NUMBERS OR A SELECTED LINE, SHOW REPRESENTATION
 *     OF CONTENTS OF FILE (^ REPRESENTS CONTROL, ~ REPRESENTS	8TH  BIT
 *     SET) AND PRINTS C PROGRAMS A FUNCTION PER PAGE.	CUTIL REMOVES OR
 *     ADDS TABS INSTEAD OF SPACES, ALSO.
 *
 *
 *	   USAGE: CUTIL [-FLAGS] FILE_IN [ >FILE_OUT OR PRN:]
 *			   FOR HELP CUTIL ?
 *
 * 
 *		for MS-DOS and Computer Innovations C86 
 * 
 *		Copyright (c) 1983,84 Solution Systems
 *
 *			  May 1984 
 * 
 *
 */

#include "stdio.h"
#include "chelper.h"

iswhite(x) 
int x; 
{ 

  return x==' '||x=='\t'||x=='\n'||x=='\r'; 
} 

FILE *fp;               /*  file pointer */
char *File_name;        /*  the file name to process */


int select_ln, tab_flg, untab_flg, lpr_flg, j_show, s_show;
int a_flg, c_flg, f_flg, l_flg, u_flg, x_flg, E_flg, Ln_flg;

/*	cutil
*/
main(argc, argv)
int argc;
char **argv;
{
char *cp;	/* character pointer */ 

    /*
     * INIT ALL
     */

    select_ln=tab_flg=untab_flg=lpr_flg=j_show=s_show=FALSE;
    a_flg=c_flg=f_flg=l_flg=u_flg=x_flg=E_flg=Ln_flg=FALSE;

    File_name=EOS;	/* don't have one initially */ 

    /*
     * TEST ARGUMENTS AND OPEN INPUT FILE
     */


    fprintf(errmsg,
       "CUTIL: %s, Copyright (c) 1983,84 Solution Systems\n",version);

    if(argc<2) help_n_quit(); 

    ++argv;	/* skip argv[0] */ 

    while(--argc) { 
	cp=*argv;            /* get the argument */
	if(*cp=='-') {       /*  -flag */
	   cp++;
	   if(isdigit(*cp)) { 
		select_ln=(ABS(atoi(cp))-3); 
	   } 
	   else
	      do_switch(cp); 
	}
	else if(!File_name) {          /*  file name */
	   File_name=cp;
	   if((fp = fopen(File_name,"r")) == NULL) fnf(File_name);
	}
	++argv;				/* next victim */ 
    }

    if(!File_name) { 
      fprintf(errmsg,"CUTIL: processing stdin\n"); 
      fp=stdin; 
    } 
    else 
      fprintf(errmsg,"CUTIL: processing file %s\n", File_name);

/*
 * SELECT FUNCTION FROM FLAGS
 */

    if (select_ln) {
	lns(select_ln);
	exit(0);
    } else if (j_show) {
	show(FALSE);
	exit(0);
    } else if (s_show) {
	show(TRUE);
	exit(0);
    } else if (lpr_flg) {
	lpr();
	exit(0);
    } else if (tab_flg) {
	tabify();
	exit(0);
    } else if (untab_flg) {
	untab();
	exit(0);
    } else util();

}

/* give user some HELP messages */
help()
{

  fprintf(errmsg,"\n\tusage: cutil [-flags] infile [>outfile]\n");
  fprintf(errmsg, "\n\tflags: -number  display line entered +/- 3 lines");
  fprintf(errmsg, "\n\t      -?        display this message");
  fprintf(errmsg, "\n\t      -c        only change case if in comment");
  fprintf(errmsg, "\n\t      -d        filter 8th bit, not control characters");
  fprintf(errmsg, "\n\t      -e        display (echo) stdout with message");
  fprintf(errmsg, "\n\t      -f        don't filter form-feeds");
  fprintf(errmsg, "\n\t      -j        show special chars, including ^J (LF)");
  fprintf(errmsg, "\n\t      -l        change upper to lower case");
  fprintf(errmsg, "\n\t      -n        display line numbers");
  fprintf(errmsg, "\n\t      -p        c print");
  fprintf(errmsg, "\n\t      -r        replace tabs with spaces");
  fprintf(errmsg, "\n\t      -s        show special chars, except ^J (LF)");
  fprintf(errmsg, "\n\t      -t        replace spaces with tabs");
  fprintf(errmsg, "\n\t      -u        change lower to upper case");
  fprintf(errmsg, "\n\t      -x        only change case if not in comment\n");
  fprintf(errmsg, "\n\tIf no infile specified, stdin will be used.\n");
}

/*  take care of switches 
*/ 

do_switch(cp) 
char *cp; 
{ 

    switch(toupper(*cp)) {
	    case 'H':
	    case '?':
		help_n_quit();
		break;
	    case 'D':
		a_flg=TRUE;
		break;
	    case 'C':
		c_flg=TRUE;
		break;
	    case 'E':
		E_flg=TRUE;
		break;
	    case 'F':
		f_flg=TRUE;
		break;
	    case 'J':
		j_show=TRUE;
		break;
	    case 'L':
		l_flg=TRUE;
		break;
	    case 'N':
		Ln_flg=2;
		break;
	    case 'P':
		lpr_flg=TRUE;
		break;
	    case 'R':
		untab_flg=TRUE;
		break;
	    case 'S':
		s_show=TRUE;
		break;
	    case 'T':
		tab_flg=TRUE;
		break;
	    case 'U':
		u_flg=TRUE;
		break;
	    case 'X':
		x_flg=TRUE;
		break;
	    default:
		fprintf(errmsg,"CUTIL: %c is an unknown flag\n",*cp);
		help_n_quit();
    }   

} 

/*
 * MAIN UTILITY PROGRAM
 */

util()
{
    int ln_num, in_comnt;
    register int i, x, c;
    register char line[MAXLINE];

    i=ln_num=0;
    in_comnt=FALSE;

    while((c=getch(fp))!=EOF){
	if(c > ASCIIMASK) line[i]=c & ASCIIMASK; 
	else line[i] = c; 
	i++; 

	if (c == '\n') {
	    while (--i) {
		if (!(iswhite(line[i]))) break;
	    }
	    line[++i] = '\n';
	    line[++i] = '\0';
	    ln_num++;
	    for (x=0; x<i; x++) {
		c = line[x];
		if (c=='/') {   /* in comment ? */
		    if (line[x-1]=='*')
			in_comnt=FALSE;
		    else if (line[x+1]=='*')
			in_comnt=TRUE;
		}

		if (Ln_flg)     /*  line numbers ? */
		    if (Ln_flg!=ln_num) {
			ln_out_put(ln_num);
			Ln_flg=ln_num;
		    }
		              /* output the character */
		if ((c > 0x1f) || (a_flg) ||
		  ((c=='\f') && (f_flg)) || (c=='\t') || (c=='\n'))
		    select_out(c,in_comnt);
	    }
	    i=0;
	}
    }
    finished();
}

select_out(c,in_comnt)
int c,in_comnt;
{
    if (l_flg) {			/*  CHANGE CASE TO LOWER  */
	if (((!(c_flg)) && (!(x_flg))) ||	/*    FOR ALL	  */
	       ((c_flg) && (in_comnt)) ||	/* FOR IN COMMENT */
	       ((x_flg) && (!(in_comnt))))	/* NOT IN COMMENT */
	    out_put(tolower(c));
	else out_put(c);

    } else if (u_flg) { 		  /* CHANGE CASE TO UPPER */
	if (((!(c_flg)) && (!(x_flg))) ||
	       ((c_flg) && (in_comnt)) ||
	       ((x_flg) && (!(in_comnt))))
	    out_put(toupper(c));
	else out_put(c);

   } else out_put(c);			 /*  DO NOT CHANGE CASE	*/
}

out_put(c)
int c; 
{
    putc(c, stdout);
    if (E_flg)
	putc(c, errmsg);
}

ln_out_put(ln_num)
int ln_num;
{
    fprintf(stdout, "%3d: ",ln_num);
    if (E_flg) fprintf(errmsg, "%3d: ",ln_num);
}


fnf(s)
char *s;
{

  fprintf(errmsg,"CUTIL:  File not found: %s\n",s);
  exit(1);
}

/* give help and au revoir */
help_n_quit()
{

  help();
  exit();
}


/*
 *   SHOW: SHOW'S REPRESENTATION OF FILE CONTENTS USING ^ TO
 *     REPRESENT CONTROL  CHARACTERS AND ~ TO  REPRESENT
 *     THE 8TH BIT SET (AS IN WORDSTAR'S DOCUMENT MODE).
 *     IF THERE IS A FLAG, ALL CHARACTERS  I.E.  ^J  ARE
 *     SHOWN ( ^J IF FLAG -J IS USED).
 *
 */

show(show_flg)
int show_flg;
{
    register int c, cc, ccc;
    int ln_num=1;

    while((c=getch(fp))!=EOF){
	cc = c | CTRLMASK;
	if ((Ln_flg) && (Ln_flg!=ln_num)) {
	    ln_out_put(ln_num);
	    Ln_flg=ln_num;
	}
	if ((c=='\n') || (cc=='\n')) ln_num++;
	if (show_flg) {
	    if ((c < 0x20) && (c != '\n')) {
		out_put('^');
		out_put(cc);
	    }
	} else {
	    if (c < 0x20) {
		out_put('^');
		out_put(cc);
	    }
	}
	ccc = c & ASCIIMASK;

	if (c > ASCIIMASK) {
	    out_put('~');
	    out_put(ccc);
	} else {
	    out_put(c);
	}
    }
    finished();
}

/*
 *
 *    LNS:  PRINTS THE SPECIFIED LINES OF AN ASCII
 *	FILE, ALONG WITH 3 LINES BEFORE AND AFTER
 *
 */

lns(select_ln)
int select_ln;
{
    int ln1, ln4, ln7, print_number;
    register int c, line;

    ln1 = select_ln;
    ln4=ln1+3;
    ln7=ln4+3;

    fprintf(errmsg,"CUTIL: file: %s ", File_name);
    fprintf(errmsg,"Display lines %d to %d:\n", ln1, ln7);

    line= 0;
    while((c=getch(fp))!=EOF){
	if (c == '\n') {
	    line++ ;
	    if (line > ln7) {
		out_put('\n');
		break;
	    }
	    print_number= YES;
	} else {
	    if	((ln1 <= line) && (line <= ln7)) {
		if (print_number) {
		    out_put('\n');
		    ln_out_put(line);
		    if (line==ln4) {
			out_put('=');
			out_put('>');
		    } else {
			out_put(' ');
			out_put(' ');
		    }
		}
		out_put(c);
	    }
	    print_number= NO;
	}
    }
    finished();
}

/*
 * TABIFY
 */

int spc_count;

tabify()
{
    register int column, i, c;
    int quote_flg;
    spc_count = column = 0;
    quote_flg=FALSE;

    while((c=getch(fp))!=EOF){
     switch(c&0x7f) {
	case '\r':
	    spc_count = column = 0;
	    break;
	case '\n':
	    out_put(c);
	    column = spc_count = 0;
	    quote_flg=FALSE;
	    break;
	case ' ':
	    column++;
	    if (quote_flg) out_put(' ');
	    else {
		spc_count++;
		if (column%8==0) {
		    if (spc_count > 1)
			out_put('\t');
		    else
			out_put(' ');
		    spc_count = 0;
		}
	    }
	    break;
	case '\t':
	    spc_count = 0;
	    column += (8-column%8);
	    out_put('\t');
	    break;
	case '\"':
	    outspc('\"');
	    if (quote_flg) quote_flg=FALSE;
	    else quote_flg=TRUE;
	    break;
	case 0x1a:
	    putc(CPMEOF,stdout);
	    break;
	default:
	    outspc(c);
	    column++;
	}	/* end switch */ 
    }   /* end while */ 
    finished();
}

void outspc(c)
char *c;
{
    int i;
    for (i=0; i<spc_count; i++)
	out_put(' ');
    spc_count = 0;
    out_put(c);
}

/*
 *  UNTAB
 */
#define	TABINCR	8		/* tab increment */
void untab()
{
    register int column, i, c;
    int quote=FALSE;
    int lastchar = 0;

    column = 0;

    while((c=getch(fp))!=EOF){
	switch(c&0x7f) {

	case '\r':
	    column = 0;
	    quote=FALSE;
	    break;
	case '\n':
	    column = 0;		/* start over */
	    out_put(0x0a);
	    break;
	case '\f':
	    out_put(c);
	    column = 0;
	    break;
	case '\"' :
	    out_put(c);
	    column++;
	    if (lastchar=='\\') break;	/* escape */
	    if (quote) quote=FALSE;
	    else quote=TRUE;
	    break;
	case '\t':
	    if (quote) out_put('\t');
	    else {
		for(i= (TABINCR- (column % TABINCR)); i>0; i--) {
		   out_put(' ');
		   column++;
		}
	    }
	    break;
	default:
	    out_put(c);
	    column++;
	    break;
	}       /*  end switch */
	lastchar=c;     /* save it for a rainy day */
    }   	/* end while */

    finished();
}               /* end untab */

/*
 *
 *	C FUNCTION PRINTER
 *
 */

#define PGLEN 60	/* LINES PER LINEPRINTER PAGE */
#define ON 1
#define OFF 0

int page_flag;
int prpg, pg;
int count;
int column_num, linesleft;
int in_quote=FALSE;
int in_comment=FALSE;
int single_quote=FALSE;
int double_quote=FALSE;

lpr()
{
#define FNAMELEN 80	/* 64 for path + x:filename.ext +  NULL */ 
#define RESPONSE 130	/* response buffer size */ 

    int i, z, pgno, ln_has_char;
    FILE *fd; 
    char date[RESPONSE], linebuf[RESPONSE];
    char tempbuf[FNAMELEN], ntempbuf[FNAMELEN], fnbuf[FNAMELEN], *fname;
    char *pgstr,*cp;
    char pgnmbuf[RESPONSE];

    if(!File_name) {    		/* sorry, no stdin */ 
	fprintf(errmsg,"CUTIL: Can't use stdin with this option\n");
	help_n_quit(); 
    }

    pg = count = 0;
    page_flag= ON;
    pgno = column_num = 0;
    linesleft = PGLEN;
    fprintf(errmsg,"\nWhat is today's date? ");
    if(fgets(date,RESPONSE,stdin)==0)help_n_quit();

    while (1) {
	if (File_name) {
	    fname = File_name;
	} else {
label:
	fprintf(errmsg,"\nEnter file to print, or CR if done: ");
	    if (!(fgets(fnbuf,FNAMELEN,stdin))) break;
	    if (strlen(fnbuf)==1) exit();
	    strncpy(ntempbuf,fnbuf,(strlen(fnbuf)-1));
	    fname = ntempbuf;
	}
	fprintf(errmsg,"Enter page to print, CR for all: ");
	if (fgets(pgnmbuf,RESPONSE,stdin)) {
	    strncpy(tempbuf,pgnmbuf,(strlen(pgnmbuf)-1));
	    pgstr = tempbuf;
	    pg=atoi(pgstr);
	} else pg=0;

	if ((fd = fopen(fname,"r")) == NULL) {
	    fprintf(errmsg,"Can't open %s\n",fname);
	    goto label;
	}
	else fprintf(errmsg,"Printing %-13s\n",fname);

	/*
	 *   SELECT A PAGE ?
	 */

	for (pgno = 1; ; pgno++) {	   /* PAGE NUMBER */
	    if (pg != 0) {
		if (pg==pgno) {
		    page_flag=ON;
		} else page_flag=OFF;
	    } else page_flag=ON;
	    prpg=TRUE;
	    ln_has_char=FALSE;
loop:
	    if ((fgets(linebuf,RESPONSE,fd)) == 0)  {
		prpg=FALSE;
		end(pgno,fd);
		goto label;
	    }

	    /*
	     *	   TEST FOR KEYBOARD INTERRUPT
	     */

	    if (kbint()) {
		getchar();
		break;
	    }

	    /*
	     *	   TEST FOR TEXT TO START ANOTHER PAGE
	     */

	    if(!ln_has_char) { 
		for(cp=linebuf;*cp;cp++) { 
		   if(!isspace(cp)) { 
			ln_has_char=TRUE; 
			break; 
		   } 
		} 
	    } 

	    /*
	     *	   PRINT A TITLE IF CALLED FOR
	     */

	    if ((prpg) && (ln_has_char)) {
		fprintf(errmsg,"*");
		if (page_flag == ON)
		    fprintf(stdout,"%18s%-13s%5s%-3d%20s\n\n",
		    "file: ",fname,"page ",pgno,date);
		prpg=FALSE;
		ln_has_char=FALSE;
	    }

	    /*
	     *	   IS IT ANOTHER PAGE ?
	     */

	    if (linepr(linebuf)) continue;

	    if (linesleft > 2) goto loop;
	    formfeed();
	}
	end(pgno,fd);
    }
}       /* end lpr */

end(pgno,fd)
int pgno; 
FILE *fd; 
{
    formfeed();
    if (pgno % 2) formfeed();
    fclose(fd); 
}

/*
    PRINT A LINE OF TEXT OUT ON THE LIST DEVICE, AND
    RETURN TRUE IF A FORMFEED WAS ENCOUNTERED IN THE
    TEXT.
*/

linepr(string)
char string[135];
{
    register int cc, c;
    char *ffflag;
    int i;
    ffflag = 0;
    for (i=0;i<strlen(string);i++) {
	c = string[i];
	switch (c) {
	case '{':
	    if ((!(in_comment))  && (!(in_quote))) count+=1;
	    putlpr(c);
	    column_num++;
	    break;
	case '}':
	    if ((!(in_comment))  && (!(in_quote))) {
		count-=1;
		if (count==0) ffflag=1;
	    }
	    if (count<0) count=0;
	    putlpr(c);
	    column_num++;
	    break;
	case '\'':
	    if ((!(in_comment)) && (string[i+1]!='\'')) {
		if (single_quote) single_quote=FALSE;
		else if (string[i+2]=='\'') single_quote=TRUE;
	    }
	    putlpr(c);
	    column_num++;
	    if ((single_quote) || (double_quote)) in_quote=TRUE;
	    else in_quote=FALSE;
	    break;
	case '\"':
	    if ((!(in_comment)) && (string[i+1]!='\'')) {
		if (double_quote) double_quote=FALSE;
		else double_quote=TRUE;
	    }
	    putlpr(c);
	    column_num++;
	    if ((single_quote) || (double_quote)) in_quote=TRUE;
	    else in_quote=FALSE;
	    break;
	case '/':
	    if (string[i+1]=='*')
		in_comment=TRUE;
	    putlpr(c);
	    column_num++;
	    break;
	case '*':
	    if ((string[i+1]=='/') && (in_comment))
		in_comment=FALSE;
	    putlpr(c);
	    column_num++;
	    break;
	case '\f':
	    ffflag = 1;
	    column_num++;
	    break;
	case '\n':
/*	    PUTLPR('\R');  CR FOR DOUBLE SPACES */
	    putlpr('\n');
	    column_num = 0;
	    linesleft--;
	    break;
	case '\t':
	    do {
		putlpr(' ');
		column_num++;
	    }
	    while (column_num % 8);
	    break;
	default:
	    putlpr(c);
	    column_num++;
	}
    }
    if (ffflag) formfeed();
    return(ffflag);
}

putlpr(c)
char c;
{
    if (page_flag==ON)
	out_put(c);
}

formfeed()
{
    if (FF) putlpr(FF);
    else while (linesleft--) putlpr('\n');
    linesleft = PGLEN;
}

kbint()       /* BREAK FOR ^C */
{
    if(bdos(KEY_STAT) & 0xff) {
	if(((bdos(KEY_IN)&0xff)!=0x19) && ((bdos(KEY_IN)&0xff)!=0x20)) {
	    fprintf(errmsg,
	    "%c\n\n\t***  KEYBOARD INTERRUPT ***\n\n",  BELL);
	    return(TRUE);
	}
    }
    return(FALSE);
}

finished()
{

  if(File_name)fclose(fp);
  exit(0);
}

/* get a character, can be made simpler for your particular  
   operating system and compiler, this is set up to cover 
   everything (hopefully) 
*/ 
getch(fp)    
FILE *fp; 
{ 
int c;

  if(fread(&c,1,1,fp)){ 
	if(c==EOF || c==CPMEOF) return EOF; 
	return c&0xff; 
  }  
  return EOF;   
} 



                                                                                                                                                                                                                                                                                                                                                                                                                                            