/* compute file size */
#include "b:pt.h"
#include "b:ptdefs.h"

/*
	size:
*/
size()
{
int i;
	if(cmd_cnt==1) { message("Usage: size file1 [file2]..."); return; }
	for(i=1; i<cmd_cnt; i++) _size(cmd[i]);
}

/*
	_size:
*/
_size(fn)
char *fn;
{
long fsize();
	s_toupper(fn);
	if(index(fn,'?'))
	   { message("No wildcards accepted"); return; }
	if(exists(fn))
	  fprintf(progout,"\nSize of %15s is %6D bytes\n",fn,fsize(fn));
	else fnf(fn);
	return;
}


#define R0 33
#define R1 34
#define R2 35
#define RECLEN 128

/*
	fsize:
*/
long fsize(fn)
char *fn;
{
char *fcb;
union {
	unsigned char byte[4];
	long lval;
      } u;

	fcb = (char *) makefcb(fn);
	bdos(0x23,fcb); /* compute file size */
	u.lval = 0;

#ifdef CPM86
	if(*(fcb+R2)==1) { free(fcb); return (65536); }
#endif
	u.byte[0] = *(fcb+R0);
	u.byte[1] = *(fcb+R1);
	u.byte[2] = *(fcb+R2);
	u.lval *= RECLEN;
	return(u.lval);
}

fsize(fn));
	else fnf(fn);
	return;
}


#define R0 33
#define R1 34
