	TITLE	'IA7301 SYSTEM MONITOR ROUTINE'
;****************************************************************************
;
;	(C) 1976, IASIS CORPORATION. ALL RIGHTS RESERVED
; NO PART OF THIS PROGRAM MAY BE REPRODUCED, TRANSMITTED, TRANSCRIBED,
; STORED IN A RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER
; LANGUAGE, IN ANY FORM BY ANY MEANS, ELECTRONIC, MECHANICAL, OPTICAL,
; CHEMICAL, MANUAL OR OTHERWISE WITHOUT THE PRIOR WRITTEN PERMISSION OF
; IASIS INC., 815 W. MAUDE., SUNNYVALE, CALIFORNIA, 94086.
;
;****************************************************************************
;
; REVISION HISTORY:
;
; 1.0 -	JULY 1976
;	RELEASE
;
;****************************************************************************

NEXT	EQU	12H


;============================================================================
;
;	DEFINITIONS
;
;============================================================================
;
KERO7	EQU	0CFH
KBOSM	EQU	40H	;KEYBOARD ONE-SHOT MASK
BONCE	EQU	32H
DASH	EQU	10H
DECEM	EQU	12H
STEP	EQU	14H
DECER	EQU	13H
BLANK	EQU	11H


;############################################################################
;
;	RAM LOCATIONS
;
;############################################################################
;
	ORG	0		;RAM
;
DISP0	DS	1
DISP1	DS	1
DISP2	DS	1
DISP3	DS	1
DISP4	DS	1
DISP5	DS	1
DISP6	DS	1
DISP7	DS	1

DIRG0	DS	1
DIRG1	DS	1
DIRG2	DS	1
DIRG3	DS	1
DIRG4	DS	1
DIRG5	DS	1
DIRG6	DS	1
DIRG7	DS	1

ACIMG	DS	1
FGIMG	DS	1
BIMG	DS	1
CIMG	DS	1
DIMG	DS	1
EIMG	DS	1
LIMG	DS	1
HIMG	DS	1
SPLIM	DS	1
SPHIM	DS	1
PCLIM	DS	1
PCHIM	DS	1
;
STACK	EQU	0100H


	ORG	8000H		;ROM START
;****************************************************************************
;
;	START OF RESET CODE INITS STACK & JUMPS TO ROM
;
;****************************************************************************
;
INIT1:	LXI	SP,STACK	;0100H	;LOAD STACK POINTER
	JMP	INIT2		;ALSO CLEAR POWER UP START


;****************************************************************************
;
;	CONTINUATION OF INITIALIZATION CODE
;
;****************************************************************************
;
INIT2:	MVI	A,0		;INIT SP & PC TO 0100H
	STA	SPLIM
	STA	PCLIM
;
	MVI	A,1
	STA	SPHIM
	STA	PCHIM
;
;   INIT RESTART 7 VECTOR
;
	LXI	H,0038H
	MVI	M,0C3H
	INR	L
	MVI	M,LOW STEP1
	INR	L
	MVI	M,HIGH STEP1
;
;   LOAD DIGIT 7 WITH DECEM AND REST WITH DASHES (.-------)
;
DCM1:	MVI	A,DASH
;
L8023:	CALL	SUB5
	LXI	H,DIRG7
	MVI	M,DECEM
;
;   FETCH KEYBOARD DATA
;
DCM2:	CALL	CONV1		;SHIFT IN KEYS INTO ADDRESS FIELD
	CALL	KBDS0
	CALL	MDCCK
	CPI	NEXT
	JZ	DCM3
;
	CALL	SUB1B
	JMP	DCM2
;
;
;
;
DCM3:	CALL	SUB4		;LOAD ADDRESS DISPLAYS INTO D & E
	LDAX	D
	CALL	SUB3A		;MOVE MEMORY INTO DISPLAYS 0 & 1
;
DCM4:	CALL	CONV1
	CALL	KBDS0
	CALL	MDCCK
	CPI	NEXT
	JZ	DCM5
;
	CALL	SUB1A
	JMP	DCM4
;
;
;
;
DCM5:	CALL	SUB4		;LOAD NEW INSTRUCTION INTO MEMORY
	CALL	SUB2A
	STAX	D
;
	INX	D		;INCREMENT & RETURN
	CALL	SUB6
	JMP	DCM3


;****************************************************************************
;
;	SHIFT DATA INTO DISPLAYS
; THIS SUBROUTINE SHIFTS THE CONTENTS OF THE ACCUMULATOR INTO A SPECIFIED 
;DISPLAY FIELD FROM THE RIGHT. THE TWO RIGHT-MOST DIGITS OF THE DISPLAY WILL 
;BE USED. 
;
;	ENTRY-	A= NEW DIGIT
;
;****************************************************************************
;
SUB1A:	PUSH	H		;SAVE REGS
	PUSH	B
;
	LXI	H,DIRG1
	MVI	C,2
	JMP	SUB1D


;****************************************************************************
;
;	SHIFT DISPLAY FOUR DIGITS LEFT
; THIS SUBROUTINE SHIFTS THE CONTENTS OF THE ACCUMULATOR INTO A SPECIFIED 
;DISPLAY FIELD FROM THE RIGHT. THE FOUR DIGITS THAT MAKE UP THE ADDRESS 
;FIELD IN THE DCM DISPLAY MODE WILL BE USED. ONLY THE FLAGS WILL BE AFFECTED.
;
;	ENTRY-	A= NEW DIGIT
;
;****************************************************************************
;
SUB1B:	PUSH	H		;SAVE REGS
	PUSH	B
;
	LXI	H,DIRG6		;HL= LEFT MOST DIGIT REGISTER
	MVI	C,4		;C= DIGITS TO MOVE COUNT
	JMP	SUB1D


;****************************************************************************
;
;	SHIFT DIGITS LEFT N TIMES & INSERT NEW DIGIT
; THIS SUBROUTINE SHIFTS THE CONTENTS OF THE ACCUMULATOR INTO A SPECIFIED 
;DISPLAY FIELD FROM THE RIGHT. THE USER CAN SPECIFY THE SIZE OF THE SHIFT 
;AND ENTER FIELD BY LOADING REGISTER C WITH THE NUMBER OF DIGITS TO APPEAR 
;IN THE FIELD AND THE HL-PAIR WITH THE ADDRESS OF THE DISPLAY REGISTER 
;CORRESPONDING TO THE LEFT-MOST DIGIT IN THE FIELD.
;	ENTRY-	C= NUMBER OF DIGITS
;		A= NEW DIGIT
;		HL= PTR TO LEFTMOST DIGIT TO START SHIFTING
;	EXIT -	ALL REGS SAVED
;
;****************************************************************************
;
SUB1C:	PUSH	H		;SAVE REGS
	PUSH	B


;****************************************************************************
;
;	SHIFT DIGITS LEFT N TIMES & INSERT NEW DIGIT
;	ENTRY-	C= COUNT
;		A= NEW DIGIT
;		HL= PTR TO LEFTMOST DIGIT TO START SHIFTING
;		(SP)= BC
;		(SP+2)= HL
;
;****************************************************************************
;
SUB1D:	DCR	C		;COUNT--
;
;   MOVE DIGIT
;
SUB1D1:	DCR	L
	MOV	B,M
	INR	L
	MOV	M,B
;
;   NEXT DIGIT
;
	DCR	L
;
;   IF NOT DONE THEN REPEAT
;
	DCR	C
	JNZ	SUB1D1
;
;   STORE NEW DIGIT
;
	MOV	M,A
;
;   DONE
;
	POP	B		;RESTORE REGS
	POP	H
	RET


;****************************************************************************
;
;	MERGE CONTENT OF TWO DISPLAY REGISTERS INTO ACCUMULATOR
;THIS SUBROUTINE TREATS A PAIR OF DISPLAY REGISTERS, DIRG1 AND DIRG0, AS 
;EACH HOLDING A HEXADECIMAL NUMBER IN ITS FOUR LSB POSITIONS. THE SUBROUTINE 
;COMBINES THE CONTENTS OF THE REGISTERS IN THE ACCUMULATOR. 
;
;	EXIT -	A= ((HL) << 4) + ((HL-1) & 15)
;		F= ?
;
;****************************************************************************
;
SUB2A:	PUSH	H
	JMP	L83B0		;HL= DIRG1


;****************************************************************************
;
;	MERGE CONTENT OF TWO DISPLAY REGISTERS INTO ACCUMULATOR
;THIS SUBROUTINE TREATS A PAIR OF DISPLAY REGISTERS AS EACH HOLDING A 
;HEXADECIMAL NUMBER IN ITS FOUR LSB POSITIONS. THE SUBROUTINE COMBINES THE 
;CONTENTS OF THE REGISTERS IN THE ACCUMULATOR.
;
;	ENTRY-	HL= MOST SIGNIFICANT DISPLAY REGISTER PTR
;	EXIT -	A= (HL) << 4 + (HL-1)
;		F= ?
;
;****************************************************************************
;
SUB2:	PUSH	H
;
L8091:	MOV	A,M		;FETCH DIGIT 1
;
	RLC			;SHIFT INTO HIGH NIBBLE
	RLC
	RLC
	RLC
;
	DCR	L		;ADD IN DIGIT 2
	ORA	M
;
	POP	H
	RET


;****************************************************************************
;
;	LOAD ACCUMULATOR INTO TWO DISPLAY REGISTERS STARTING WITH DIRG1
; THIS SUBROUTINE BREAKS THE CONTENTS OF THE ACCUMULATOR INTO TWO 4-BIT
;NUMBERS AND STORES THEM IN THE 4 LSB POSITIONS OF TWO ADJACENT DISPLAY 
;REGISTERS. THE TWO RIGHT-MOST DIGITS WILL BE USED.
;
;	ENTRY-	A= REGISTER DATA IN PACKED FORM
;
;****************************************************************************
;
SUB3A:	PUSH	PSW
	PUSH	H
	PUSH	B
;
	LXI	H,DIRG1
	MVI	C,2
	JMP	SUB3C


;****************************************************************************
;
;	LOAD ACCUMULATOR INTO TWO DISPLAY REGISTERS
; THIS SUBROUTINE BREAKS THE CONTENTS OF THE ACCUMULATOR INTO TWO 4-BIT
;NUMBERS AND STORES THEM IN THE 4 LSB POSITIONS OF TWO ADJACENT DISPLAY 
;REGISTERS. 
;
;	ENTRY-	A= REGISTER DATA IN PACKED FORM
;		C= REGISTER COUNT
;		HL= LEFT-MOST DISPLAY REGISTER PTR
;
;****************************************************************************
;
SUB3:	PUSH	PSW
	PUSH	H
	PUSH	B
;
;   DO UPPER NIBBLE
;
SUB3C:	PUSH	PSW
	ANI	0F0H
	RRC
	RRC
	RRC
	RRC
	CALL	SUB1C
;
;   DO LOWER NIBBLE
;
	POP	PSW
	ANI	0FH
	CALL	SUB1C
;
;   DONE
;
	POP	B
	POP	H
	POP	PSW
	RET


;****************************************************************************
;
;	LOAD DISPLAYS 3..6 INTO DE
; THIS SUBROUTINE INTERPRETS THE CONTENTS OF DIRG6 AND DIRG5 AS A PAIR OF 
;4-BIT NUMBERS, AND LOADS AN 8-BIT EQUIVALENT INTO THE D-REGISTER. DIRG1 AND 
;DIRG0 ARE ALSO COMBINED AND LOADED INTO THE E-REGISTER. 
;
;	EXIT -	E= DISPLAY 4,3
;		A, D= DISPLAY 6,5
;		F= ?
;
;****************************************************************************
;
SUB4:	PUSH	H
;
;   FETCH 3 & 4
;
	LXI	H,DIRG4
	CALL	SUB2
	MOV	E,A
;
;   FETCH 5 & 6
;
	INR	L
	INR	L
	CALL	SUB2
	MOV	D,A
	POP	H
	RET


;****************************************************************************
;
;	BLANK ALL DISPLAYS
;	EXIT -	AF= ?
;
;****************************************************************************
;
SUB5A:
	MVI	A,BLANK
;
;   FALL INTO LOAD DISPLAYS
;


;****************************************************************************
;
;	LOAD ALL DISPLAYS WITH SAME CHARACTER
; THIS SUBROUTINE IS USED TO LOAD A CHARACTER INTO ALL OF THE DISPLAY 
;REGISTERS. IT COMMONLY USED TO BLANK OR DISPLAY DASHES.
;
;	ENTRY-	A= CHAR TO LOAD INTO ALL DISPLAYS
;	EXIT -	AF= ?
;
;****************************************************************************
;
SUB5:	PUSH	H		;SAVE REGS
	PUSH	B
;
	LXI	H,DIRG7+1
	MVI	C,8
;
SUB5B:	DCR	L
	DCR	C
	MOV	M,A
	JNZ	SUB5B
;
;   DONE
;
	POP	B
	POP	H
	RET


;****************************************************************************
;
;	LOAD DATA FROM DE INTO DISPLAY REGISTERS 3..6
; THIS IS THE COMPLEMENT TO SUB4. IT BREAKS THE CONTENTS OF EACH OF THE D AND
;E REGISTERS INTO TWO 4-BIT NUMBERS AND LOADS THEM INTO DIRG6..DIRG3.
;
;	ENTRY-	DE= DATA
;	EXIT -	AF= ?
;
;****************************************************************************
;
SUB6:	PUSH	H
	PUSH	B
;
;   DO DIGITS 5 & 6
;
	LXI	H,DIRG6
	MOV	A,D
	MVI	C,2
	CALL	SUB3
;
;   DO DIGITS 3 & 4
;
	DCR	L
	DCR	L
	MOV	A,E
	CALL	SUB3
;
;   DONE
;
	POP	B
	POP	H
	RET


;****************************************************************************
;
;	KEYBOARD DISPLAY
; READS THE KEYBOARD UNTIL A KEY CLOSURE IS FOUND.
; THIS SUBROUTINE SCANS THE KEYBOARD AND DRIVES THE DISPLAYS WITH THE CONTENTS
;OF THE DISPLAY BUFFERS AT THE SAME TIME. IF A KEY CLOSURE IS FOUND, THE 
;SUBROUTINE EXITS WITH THE KEY IMAGE IN THE ACCUMULATOR. IF NO KEY CLOSURE IS
;FOUND, THE SUBROUTINE LOOPS WITHIN ITSELF UNTIL A VALID CLOSURE IS FOUND.
;THE SUBROUTINE ALSO DEBOUNCES THE KEYS.
;
;	EXIT -	A= KEYBOARD DATA:
;			BITS 0..3= HEX KEYS
;			BIT 4= MODE KEY
;			BIT 5= STEP KEY
;			BIT 6= DIP SWITCH 2
;			BIT 7= DIP SWITCH 1
;		F= ?
;
;****************************************************************************
;
KBDS0:	PUSH	B		;SAVE REGS
	PUSH	D
	PUSH	H
	MVI	C,BONCE
;
;   FALL INTO DISPLAY ROUTINES
;
KBDS1:	MVI	D,KERO7		;DISPLAY PORT
	LXI	H,DISP7
;
KBDS2:	MOV	A,M		;MOVE NUMBER IN DISPLAY BUFFER TO A
	STAX	D		;SEND TO DISPLAY
;
;   WAIT FOR DISPLAY ONE-SHOT
;
KBDS3:	LDAX	D
	ANI	KBOSM		;40H
	JNZ	KBDS3
;
;   TEST FOR KEY CLOSURE
;
	LDAX	D		;FETCH KEY DATA
	XRI	07H		;INVERT DATA	(CLOSURE = '1')
	ANI	0FH		;MASK OUT UNUSED BITS
	JNZ	KBDS5		;IF KEY FOUND THEN EXIT
;
;   CHECK DE-BOUNCE
;
	DCR	C		;DECREMENT TIMEOUT, BUT NOT PAST 1
	JNZ	KBDS4
;
	INR	C
;
;   NEXT DIGIT/COLUMN
;
KBDS4:	DCR	D		;COLUMN ADDR DOES NOT USE BIT 8 SO DO TWICE
	DCR	D
	DCR	L		;IF DIGIT PTR < 0 THEN DONE
	JM	KBDS1
;
	JMP	KBDS2		;ELSE REPEAT FOR THIS COLUMN/DIGIT
;
;
;   KEY FOUND - CHECK DE-BOUNCE TIMEOUT
;
KBDS5:	DCR	C		;IF DEBOUNCED THEN EXIT
	JZ	KBDS6
;
	MVI	C,BONCE		;NOT DEBOUNCED YET..
	NOP
	JMP	KBDS4
;
;
;   KEY DEBOUNCED. PROCESS IT
;
KBDS6:	ANI	3EH		;MASK BITS (COL. 0 IS IMPLIED)
	RLC			;MOVE KEY DATA INTO PROPER POSITION
	RLC
	MOV	E,A		;SAVE DATA
	MOV	A,D		;MASK IN SCAN ADDRESS
	ANI	0EH
	RRC			;MOVE TO BITS 0..2
	ORA	E
;
;   DONE, RETURN SCAN CODE
;
	POP	H
	POP	D
	POP	B
	RET


;****************************************************************************
;
;	CONVERT 4 BIT BINARY NUMBER IN DISPLAY REGISTERS TO 7 SEGMENT CODES
; IN DISPLAY BUFFERS.
; THIS SUBROUTINE CONVERTS THE CONTENTS OF THE DISPLAY REGISTERS INTO 
;7-SEGMENT CODE EQUIVALENTS. THESE EQUIVALENTS ARE THEN LOADED INTO THE 
;APPROPRIATE DISPLAY BUFFERS. THIS SUBROUTINE IS COMMONLY CALLED PRIOR TO 
;CALLING THE KEYBOARD-DISPLAY SUBROUTINE SO THAT THE DISPLAY BUFFERS ARE
;LOADED WITH THE CORRECT DATA.
;
;****************************************************************************
;
CONV1:	PUSH	B		;SAVE REGS
	PUSH	D
	PUSH	H
	PUSH	PSW
;
	LXI	B,DISP7		;DISPLAY DATA PTR
	LXI	D,DIRG7		;DATA PTR
;
;   CONVERT DATA
;
CONV2:	LXI	H,SSEG4		;TABLE PTR
	LDAX	D		;ADD IN OFFSET
	ADD	L
	MOV	L,A
	MOV	A,M		;FETCH CODE
	STAX	B		;STORE INTO DISPLAY DATA
;
	DCR	E		;NEXT DISPLAY
	DCR	C		;IF COUNT NOT EXHAUSTED THEN REPEAT
	JP	CONV2
;
;   CONVERSION DONE, RESTORE & RETURN
;
	POP	PSW
	POP	H
	POP	D
	POP	B
	RET


;****************************************************************************
;
;	CHECK MODE 
;DETERMINES IF A KEY CLOSURE WAS ONE OF THE MODE KEYS
;THIS SUBROUTINE NORMALLY IS CALLED AFTER THE KEYBOARD-DISPLAY SUBROUTINE. IT
;CHECKS THE KEY CODE RETURNED IN THE ACCUMULATOR BY THAT SUBROUTINE. IF THE 
;CLOSURE WAS ONE OF THE HEX NUMBER KEYS, THE SUBROUTINE EXITS. IT THE KEY CODE
;IS ONE OF THE MODE KEYS, THEN THE STACK IS ADJUSTED AND A JUMP TO THE PROPER
;MODE SEGMENT IS EXECUTED.
;
;	ENTRY-	A= KEY CODE
;	EXIT -	AF, E= ?
;
;****************************************************************************
;
MDCCK:	MOV	E,A		;SAVE KEY DATA
;
	INX	SP		;SCRUB RETURN ADDRESS
	INX	SP
;
;   IF STEP KEY TRUE THEN EXIT
;
	RLC
	RLC
	RLC
	JC	EXEC1
;
;   IF NOT MODE CHANGE THEN EXIT
;
	RLC
	MOV	A,E
	JNC	MDCC1
;
;   CHECK MODE KEYS
;
	ANI	07H		;ONLY NEED SCAN ADDRESS
	JZ	DCM1		;IF DCM KEY THEN EXECUTE IT
;
	DCR	A		;IF DCR KEY THEN EXECUTE IT
	JZ	DCR1
;
	DCR	A		;IF NXT KEY THEN EXECUTE IT
	JZ	MDCC1
;
	DCR	A		;IF EXC KEY THEN EXECUTE IT
	JZ	EXEC1
;
	DCR	A		;IF WT KEY THEN EXECUTE IT
	JZ	TAPW
;
	DCR	A		;IF RT KEY THEN EXECUTE IT
	JZ	TAPR		;ELSE IGNORE OTHERS BY RETURNING
;
;   DONE, RESTORE & RETURN
;
MDCC1:	MOV	A,E		;KEY DATA
	DCX	SP		;RETURN TO CALLER
	DCX	SP
	RET
;
;
;   DECREMENT REGISTER COMMAND
;
DCR1:	MVI	A,DASH		;DISPLAY ALL '-'s
	CALL	SUB5
;
;   OUTPUT 'u' TO DIGIT 7
;
	LXI	H,DIRG7
	MVI	M,DECER
;
	LXI	B,ACIMG		;START WITH A
	LXI	H,SSEG1		;POINT TO REGISTER DISPLAY CODES TABLE
;
DCR1A:	MOV	A,M		;IF AT END OF TABLE THEN RESTART
	ORA	A
	JZ	DCR1
;
	DCR	M		;IF WORD ENTRY THEN EXIT
	JZ	DCR2
;
;   BYTE ENTRY, FETCH NEW DATA
;
	CALL	DCR5		;ELSE..
;
DCR3:	CALL	CONV1
	CALL	KBDS0
;
;   IF MODE == NEXT THEN EXIT
;
	CALL	MDCCK
	CPI	NEXT
	JZ	DCR4
;
;   ELSE STORE DATA & CONTINUE
;
	CALL	SUB1A
	JMP	DCR3
;
;
;   NEXT KEY PRESSED, STORE ACCUMULATED DATA AND ADVANCE TO NEXT REGISTER
;
DCR4:	CALL	SUB2A		;FETCH DIGITS 0,1 DATA INTO A
	STAX	B		;STORE NEW DATA INTO REGISTER
;
;   NEXT REGISTER
;
L81AD:	INX	H
	INX	B
;
;   REPEAT
;
	JMP	DCR1A
;
;
;   WORD ENTRY, FETCH DATA
;
DCR2:	INX	H		;GET NEXT SYMBOL & LOAD INTO DIRG5
	CALL	DCR5
	INX	H
	INX	B
	MOV	A,M
	STA	DIRG5
;
	LDAX	B		;GET HIGH ORDER BYTE INTO DIRG1
	PUSH	H
	PUSH	B
	LXI	H,DIRG3
	MVI	C,2
	CALL	SUB3
	POP	B
	POP	H
;
DCR6:	CALL	CONV1		;DISPLAY 2 BYTES OF DATA
	CALL	KBDS0		;LOAD & SHIFT IN KEYS
	CALL	MDCCK
;
;   IF NEXT KEY USED THEN SKIP MODIFICATION
;
	CPI	NEXT
	JZ	DCR7
;
;   MODIFY REGISTER
;
	PUSH	H
	PUSH	B
	LXI	H,DIRG3
	MVI	C,4
	CALL	SUB1C
	POP	B
	POP	H
	JMP	DCR6
;
;
;
;
DCR7:	CALL	SUB2A
	DCX	B
	STAX	B
	PUSH	H
	LXI	H,DIRG3
	CALL	SUB2
	POP	H
	INX	B
	STAX	B
	JMP	L81AD


;****************************************************************************
;
;	LOAD SYMBOL INTO DISPLAY REGISTER 6 & IMAGE INTO DISPLAY REGISTER 0
;	ENTRY-	HL=
;		BC=
;	EXIT -	A= ?
;
;****************************************************************************
;
DCR5:	MOV	A,M
	STA	DIRG6
;
	LDAX	B
	CALL	SUB3A		;LOAD ACCUMULATOR DATA INTO PROPER DIGITS
	RET


;****************************************************************************
;
;	EXECUTE ADDRESS COMMAND
;
;****************************************************************************
;
EXEC1:	LXI	H,6000H		;TURN ON EXECUTE LED
	MVI	M,0F7H
;
;   SET UP REGISTERS
;
	LHLD	SPLIM		;STACK
	SPHL
;
	LHLD	PCLIM		;PUSH EXECUTION ADDRESS ON STACK (RET TO X)
	PUSH	H
;
	LXI	H,ACIMG		;START OF REGISTER IMAGES
	MVI	A,3		;DO 3 TIMES
;
EXEC2:	NOP
	MOV	D,M		;PUSH REGS ON STACK
	INX	H
	MOV	E,M
	INX	H
	PUSH	D
;
	DCR	A		;IF NOT DONE THEN REPEAT
	JNZ	EXEC2
;
	NOP
	MOV	E,M		;HL IS DIFFERENT??
	INX	H
	MOV	D,M
	PUSH	D
;
	POP	H		;REMOVE REGS FROM STACK
	POP	D
	POP	B
	POP	PSW
;
	EI			;ENABLE SINGLE STEP INTERRUPT
	RET			;PC VALUE WAS PUT ON STACK FOR THIS RETURN


;****************************************************************************
;
;	SINGLE STEP INTERRUPT PROCEDURE
;	EXIT -	HL= ?
;
;****************************************************************************
;
STEP1:	SHLD	LIMG		;SAVE HL DATA
;
	PUSH	PSW		;TEMP SAVE AF DATA
;
;   SAVE REGISTER DATA
;
	LXI	H,BIMG
	MOV	M,B
	INR	L
	MOV	M,C
	INR	L
	MOV	M,D
	INR	L
	MOV	M,E
	POP	D
	JMP	L83C0		;PATCH
;
	POP	H		;PC IS RETURN ADDRESS
	SHLD	PCLIM
;
L823E:	LXI	H,0		;SAVE STACK PTR
	DAD	SP
	SHLD	SPLIM
;
;   WAIT UNTIL STEP KEY RELEASED
;
STEP1A:	MVI	D,KERO7
	LDAX	D
	ANI	08H
	JNZ	STEP1A
;
;   TURN OFF ALL LEDS
;
	LXI	H,6000H
	MVI	M,0FFH
;
;   FILL DISPLAY WITH '-'
;
	MVI	A,DASH
	CALL	SUB5
;
	LXI	H,DIRG7
	MVI	M,STEP
	LHLD	PCLIM
	XCHG
	CALL	SUB6
	LDAX	D
	CALL	SUB3A
;
STEP3:	CALL	CONV1
	CALL	KBDS0
	CALL	MDCCK
	JMP	STEP3


;############################################################################
;
;	DISPLAY CHARACTER CODES
;
;############################################################################
;
SSEG1:	DB	0AH	;
	DB	0FH	;
	DB	0BH	;
	DB	0CH	;P.
	DB	0DH	;
	DB	0EH	;F.
	DB	17H	;L
	DB	18H	;H
	DB	01H	;INDICATOR
	DB	05H	;S
	DB	16H	;P
	DB	01H	;INDICATOR
	DB	16H	;P
	DB	0CH	;C
	DB	0	;
;
SSEG4:	DB	0C0H	;0
	DB	0F9H	;1
	DB	0A4H	;2
	DB	0B0H	;3
	DB	99H	;4
;
SSEG5:	DB	92H	;5
	DB	82H	;6
	DB	0F8H	;7
	DB	80H	;8
	DB	90H	;9
;
SSEG6:	DB	88H	;A
	DB	83H	;b
	DB	0C6H	;C
	DB	0A1H	;d
	DB	86H	;E
;
SSEG7:	DB	8EH	;F
	DB	0BFH	;-
	DB	0FFH	;
	DB	0ABH	;n
	DB	0E3H	;u
	DB	8FH	;
	DB	7FH	;.
	DB	8CH	;P
	DB	0C7H	;L
	DB	89H	;H


;****************************************************************************
;
;	TAPE WRITE COMMAND
;
;****************************************************************************
;
TAPW:	PUSH	D		;SAVE END ADDRESS
	JMP	L83D0		;PATCH TO SAVE START ADDRESS
;
L829F:	LXI	D,35H		;PERIOD & # CYCLES
	MVI	B,0		;LEADER COUNTER THEN CHECKSUM
;
;   WRITE LEADER
;
LEADR:	CALL	FREQ
	DCR	B
	JNZ	LEADR
;
;   WRITE START ADDRESS ON TAPE
;
	POP	H		;START ADDR
	POP	D		;END ADDR
;
	MOV	A,H		;WRITE HIGH BYTE 1ST
	CALL	TAPX
	MOV	A,L		;THEN LOW BYTE
	CALL	TAPX
;
;   WRITE END ADDRESS
;
	MOV	A,D
	CALL	TAPX
	MOV	A,E
	CALL	TAPX
;
;   WRITE DATA FROM START ADDRESS TO END ADDRESS
;
TAPW1:	MOV	A,M
	CALL	TAPX
;
	CALL	HILO		;INCREMENT ADDRESS PTR & CHECK FOR > END
	JNC	TAPW1		;TRUE IF PTR <= END
;
;   WRITE CHECKSUM
;
	XRA	A
	SUB	B		;USE -CHECKSUM
	CALL	TAPX
;
;   TURN TAPE OFF
;
EXIT:	MVI	H,60H		;(6000H)
	MVI	M,0FFH		;CLEAR ALL LEDS & TAPE CHANNEL
;
;   RETURN TO COMMAND MODE
;
	JMP	DCM1


;****************************************************************************
;
;	WRITE DATA TO TAPE OUTPUT & ACCUMULATE CHECKSUM
;	ENTRY-	A= DATA TO OUTPUT
;		B= CHECKSUM TO DATE
;	EXIT -	B= CHECKSUM + DATA
;
;****************************************************************************
;
TAPX:	MOV	C,A		;SAVE DATA
	ADD	B		;ADD TO CHECKSUM IN B
	MOV	B,A
;
	PUSH	B		;SAVE REGS
	PUSH	D
	PUSH	H
;
	MVI	H,60H		;TAPE PORT (6000H)
	MOV	A,C		;RESTORE DATA
	ORA	A		;CLEAR CARRY FLAG
	LXI	B,0903H		;BIT COUNTERS (1 START, 8 DATA, 2 STOP)
;
;   BYTE LOOP
;
BYTE1:	CALL	HIF		;BEGIN BIT CELL WITH HIGH FREQ.
	CC	HIF		;IF DATA BIT == 1 THEN EXTEND HIGH FREQ
	CNC	LOF		;ELSE EXTEND LOW FREQ
	CALL	LOF		;END BIT CELL WITH LOW FREQ
;
	DCR	B		;IF ALL DATA BITS GONE THEN DO STOP BITS
	JM	BYTE2
;
	RAR			;PUT NEXT BIT TO WRITE INTO CARRY
	JNZ	BYTE1		;IF MORE BITS THEN REPEAT
;
;   WRITE STOP BITS
;
	STC			;STOP BITS ARE '1' BITS
;
BYTE2:	DCR	C		;IF STOP BITS REMAINING THEN REPEAT
	JNZ	BYTE1
;
;   DONE, RESTORE REGS & RETURN
;
	POP	H
	POP	D
	POP	B
	RET


;****************************************************************************
;
;	OUTPUT LOW FREQUENCY FOR 4 CYCLES
;
;****************************************************************************
;
LOF:	LXI	D,0835H		;TIMING COUNTS
	JMP	FREQ


;****************************************************************************
;
;	OUTPUT HIGH FREQUENCY FOR 8 CYCLES
;
;****************************************************************************
;
HIF:	LXI	D,101AH		;TIMING CONSTANTS
;
;   FALL INTO FREQUENCY OUTPUT PROCEDURE
;


;****************************************************************************
;
;	FREQUENCY OUTPUT PROCEDURE
;	ENTRY-	DE= TIME CONSTANT
;
;****************************************************************************
;
FREQ:	PUSH	PSW
	MVI	A,0FBH		;TAPE LED ON (BIT 1), FREQ (BIT 0) 
;
FREQ2:	XRI	1		;TOGGLE OUTPUT (BIT 0)
	MOV	M,A
	MOV	L,E		;SET PERIOD COUNTER
;
FREQ1:	DCR	L		;COUNT PERIOD
	JNZ	FREQ1
;
	DCR	D		;COUNT # OF PERIODS
	JNZ	FREQ2
;
;   DONE
;
	POP	PSW
	RET


;****************************************************************************
;
;	TAPE READ PROCEDURE
;
;****************************************************************************
;
TAPR:	MVI	H,60H		;POINT TO TAPE PORT (6000H)
	JMP	L83E5		;PATCH TO SAVE START ADDRESS
;
L831C:	MOV	M,E		;TURN ON TAPE
;
WA3:	XRA	A		;CLEAR DATA
;
;   WAIT FOR 3002H CHANGES ON TAPE (LEADER)
;
WA1:	ORA	M
	JP	WA1
;
WA2:	ANA	M
	JM	WA2
;
	DCX	D
	MOV	A,D
	ORA	E
	JNZ	WA3
;
	MVI	B,0		;CLEAR CHECKSUM
;
;   GET START ADDRESS
;
	CALL	TAPY		;HIGH BYTE
	MOV	H,C
	CALL	TAPY		;LOW BYTE
	MOV	L,C
;
;   GET STOP ADDRESS
;
	CALL	TAPY
	MOV	D,C
	CALL	TAPY
	MOV	E,C
;
;   READ DATA
;
TAPRI:	CALL	TAPY
	MOV	M,C
	CALL	HILO		;INCREMENT PTR & CHECK FOR END
	JNC	TAPRI
;
;   LAST ADDRESS, CHECK CHECKSUM
;
	CALL	TAPY
	JMP	L83EE		;PATCH TO END


;****************************************************************************
;
;	READ A BYTE FROM TAPE FUNCTION
;	EXIT -	C= DATA
;
;****************************************************************************
;
TAPY:	PUSH	H		;SAVE REGS
	PUSH	D
	PUSH	B
;
	MVI	H,0C0H		;SET SERIAL PORT ADDRESS (C000H)
;
TAPY1:	MVI	B,0FFH		;FLAG WAIT FOR START BIT
;
RBIT3:	MVI	E,3		;HIGH FREQ PERIODS
;
RBIT4:	MVI	D,38H		;PERIOD CONSTANT
	XRA	A
;
;   MEASURE TIME BETWEEN 0 TO 1 CHANGE IN D
;
CX1:	DCR	D
;
	ORA	M		;WAIT FOR 0
	JP	CX1
;
CX2:	DCR	D		;WAIT FOR 1
	ANA	M
	JM	CX2
;
	DCR	D		;SET FLAGS
	JM	RBIT3		;LONG PERIOD IF MINUS
;
	DCR	E		;SHORT PERIOD
	JP	RBIT4		;IF TRUE THEN NOT ENOUGH SHORT ONES
;
;   DELAY UNTIL END OF HIGH PERIOD
;
	MVI	A,0
;
RBIT5:	DCR	A
	JNZ	RBIT5
;
;   COUNT NUMBER OF CHANGES IN A FIXED TIME
;
	LXI	D,0D805H	;D= TIME, E= I/O THRESHOLD
	CALL	CT		;E= 1 IF E < 0
	MOV	A,E
	RAL			;CY= BIT DATA
	DCR	B		;BIT COUNTER--
	JP	RBIT8		;IF + THEN INSERT BIT INTO C
;
	JC	TAPY1		;TRUE IF NO START BIT
;
	MVI	B,8		;SET BIT COUNT
;
;   HAVE BIT, INSERT INTO DATA
;
RBIT8:	MOV	A,C
	RAR
	MOV	C,A
	JNZ	RBIT3		;GET NEXT BIT
;
;   UPDATE CHECKSUM
;
	POP	B		;RESTORE CHECKSUM
	MOV	C,A		;RETURN DATA IN C
	ADD	B		;ADD DATA TO CHECKSUM
	MOV	B,A
;
;   DONE
;
	POP	D
	POP	H
	RET


;****************************************************************************
;
;	COUNT 0 TO 1 CHANGES FOR A FIXED TIME SPECIFIED
;	ENTRY-	D= FIXED TIME VALUE
;		E= TRANSITION COUNT
;		HL= PORT ADDRESS
;
;****************************************************************************
;
CT:	XRA	A		;CLEAR DATA ACCUMULATOR
;
;   WAIT FOR 0
;
CT1:	DCR	D		;IF TIME EXHAUSTED THEN RETURN
	RZ
;
	ORA	M
	JP	CT1
;
;   WAIT FOR 1
;
CT2:	DCR	D
	RZ
;
	ANA	M
	JM	CT2
;
;   GOT A CHANGE, DECRIMENT TRANSITION COUNT & CONTINUE
;
	DCR	E		;COUNT CHANGE
	JMP	CT


;****************************************************************************
;
;	HILO INCREMENTS MEMORY POINTER & COMPARES IT TO END VALUE
; THIS SUBROUTINE INCREMENTS HL AND CHECKS AGAINST DE. IF HL EXCEEDS DE, THE
;ROUTINE RETURNS WITH THE CARRY FLAG SET. IN PRACTICE THIS IS USED IN A LOOP
;FOR OPERATING WITH MEMORY ADDRESSES. THE STARTING ADDRESS IS LOADED INTO HL
;THE ENDING ADDRESS IS LOADED INTO DE. THE CALLER CHECKS THE CARRY FLAG TO SEE
;IF THE RANGE OF ADDRESSES HAS BEEN EXCEEDED. IF NOT, THEN THE OPERATION IS
;PERFORMED AND THIS SUBROUTINE IS CALLED AGAIN.
;
;	ENTRY-	HL= PTR
;		DE= END VALUE
;	EXIT -	HL= HL - 1
;		CF= HL > DE
;		A= ?
;
;****************************************************************************
;
HILO:	INX	H		;BUMP PTR
;
;   RETURN STATE OF PTR
;
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	RET

L83A7:	DB	0B1H
	DB	0F7H
	DB	0FDH
	DB	0A5H
	DB	83H
	DB	0B9H
	DB	0FFH
	DB	0FDH
	DB	3FH
	

;****************************************************************************
;
;	PATCH #1, FROM SUB2A
;
;****************************************************************************
;
L83B0:	LXI	H,DIRG1
	JMP	L8091


L83B6:	DB	28H
	DB	4
	DB	0A5H
	DB	0BDH
	DB	0ADH
	DB	0ADH
	DB	0B5H
	DB	14H
	DB	0A5H
	DB	61H


;****************************************************************************
;
;	PATCH #2, FROM STEP
;
;****************************************************************************
;
L83C0:	MOV	H,E
	MOV	L,D
	SHLD	DISP1
;
	POP	H
	SHLD	PCLIM
	JMP	L823E

L83CC:	DB	0EH
	DB	2
	DB	0
	DB	0


;****************************************************************************
;
;	PATCH #3, FROM TAPN
;
;****************************************************************************
;
L83D0:	LHLD	DIMG		;PUT END ADDR IN DE
	MOV	D,L
	MOV	E,H
;
	LHLD	LIMG		;PUT START ADDRESS IN HL
	PUSH	D
	PUSH	H
;
	MVI	H,60H		;SET OUTPUT PORT ADDRESS
	JMP	L829F

L83DF:	DB	58H
	DB	0FDH
	DB	3DH
	DB	0FFH
	DB	0F3H
	DB	0B7H


;****************************************************************************
;
;	PATCH #4, FROM TAPR
;
;****************************************************************************
;
L83E5:	LXI	D,30FDH		;LIGHT RT LED
	MOV	M,E
;
	MVI	H,0C0H		;SET INPUT PORT ADDRESS
	JMP	L831C


;****************************************************************************
;
;	PATCH #5, FROM END OF TAPR
;
;****************************************************************************
;
L83EE:	JZ	EXIT		;IF CHECKSUM OK THEN RETURN TO COMMAND ENTRY
;
	MVI	A,0EH		;ELSE DISPLAY 'EEEEEEEE'
	JMP	L8023

L83F6:	DB	0ACH
	DB	0ADH
	DB	0A5H
	DB	0ACH
	DB	95H
	DB	0BCH
	DB	0EDH
	DB	0B5H
	DB	0B5H
	DB	0A1H

	DS	1	;<<---THIS ADDRESS BETTER BE 8400H!!

	END
