;FOR TRS-80 @ 9600BD WITH MINIMAL ERROR TESTING
;
BEGIN	ORG	4303H
INITIL	JMP	INITIU			;UART/USART INITIALATION ENTRY POINT
INSPORT	JMP	INSPRU			;STATUS PORT READ ENTRY POINT
ERRSET	JMP	ERRSTU			;UART/USART ERROR RESET ENTRY POINT
INPORT	JMP	INPRTU			;READ DATA PORT ENTRY POINT
OUTPORT	JMP	OUTPRU			;WRITE DATA PORT ENTRY POINT
;
;
;
;			IF YOU WISH TO USE OTHER REGISTERS SUCH AS HL,BC,DE
;			(NOT INCLUDING  SP  REGISTER)
;			BE SURE TO PUSH BSTAM'S REGISTERS ON TO STACK AND POP
;			THEM BACK OFF BEFORE RETURNING TO BSTAM.
;			THERE IS AMPLE ROOM TO PUSH ALL REGISTERS ONTO BSTAM'S
;			STACK, PLUS ROOM FOR 10 LEVELS OF CALL'S.
;
;			THERE ARE 300 BYTES OF USER SPACE AVAILABLE TO YOU.
;
;			THE JUMP'S CODED AT THE BEGINNING OF THIS PROGRAM
;			CANNOT BE MOVED IN ANY WAY.
;
;			GOOD LUCK AND WELCOME TO THE REAL WORLD OF
;			TELECOMMUNICATIONS.
;
;
;
;
;
TPS	EQU	0EAH			;STATUS PORT
TPBAUD	EQU	0E9H			;BAUD RATE PORT
TPCNTLO	EQU	0EAH			;CNTL PORT
TP	EQU	0EBH			;DATA IN/OUT PORT
TPRESET	EQU	0E8H			;MASTER UART RESET PORT
;
;
;
;
;
;
;
;
INITIU	EQU	$
;			THIS IS THE UART/USART INITIALATION ROUTINE.
;			TO BE COMPATIBLE WITH MOST BSTAM USERS USE FOLLOWING
;			INITIALATION GUIDE LINES:
;			1. USE 1 STOP BITS	(OPTIONAL - 2)
;			2. USE 8 DATA BITS	(MUST)
;			3. USE 1 START BIT	(MUST)
;			4. USE 16X FOR CLOCK RATE 	(MUST)
;			5. USE ASYNCHRONOUS MODE ONLY	(MUST)
;
;
;
	MVI	A,80H	;ANY THING
	OUT	TPRESET	;MUST RESET UART
	MVI	A,0ECH	;1 STOP, 8 DATA
	OUT	TPCNTLO	;SET IT NOW
	MVI	A,0EEH	;SET 9600 BAUD
	OUT	TPBAUD	;SET IT NOW
	RET		;RETURN TO BSTAM
;
;
;
;
INSPRU	EQU	$
;			THIS IS THE STATUS READ PORT ROUTINE.
;			WHEN EXITING THIS ROUTINE BSTAM EXPECTS IN REGISTER A
;			THE FOLLOWING BITS TO BE SET IF NEEDED:
;			1. 20 BIT SET IF FRAMING ERROR
;			2. 10 BIT SET IF OVERRUN ERROR
;			3. 08 BIT SET IF PARITY  ERROR
;			4. 04 BIT SET IF TRANSMITTER EMPTY
;				IF YOUR UART/USART DOES NOT HAVE TRANSMITTER
;				EMPTY FEATURE, THEN ALLWAYS SET THIS BIT ON.
;			5. 02 BIT SET IF RECEIVER READY
;			6. 01 BIT SET IF TRANSMITTER READY
;			7. DO NOT SET THE 80 BIT OR 40 BIT
;
;
;
;	IN THE FOLLOWING ROUTINES, THE TESTS FOR FRAMING, OVERRUN AND
;	PARITY ERRORS HAVE BEEN REMOVED BY CHANGING THE MARKED JUMPS FORM
;	"JZ" CONDITIONAL JUMPS
;
	PUSH	B	;SAVE BSTAM'S B + C
	IN	TPS	;GET STATUS BITS
	MOV	C,A	;SAVE STATUS BITS
	MVI	B,04H	;PRE-SET TRANSMITTTER EMPTY BIT
	ANI	80H	;CHK DATA RECEIVED
	JZ	CHKTXRD	;
	MVI	A,02H	;SET RECEIVER READY BIT
	ORA	B	;SET BIT
	MOV	B,A	;SAVE BITS
CHKTXRD	EQU	$
	MOV	A,C	;RESTORE ORGINAL STATUS
	ANI	40H	;CHK TRANSMITTER READY
	JZ	CHKOVER	;GO CHK FOR OVERRUN ERROR
	MVI	A,01H	;SET TRANSMITTER READY
	ORA	B	;SET BIT
	MOV	B,A	;SAVE BITS
CHKOVER	EQU	$
	MOV	A,C	;RESTORE ORGINAL STATUS
	ANI	20H	;CHK OVERRUN ERROR
			;THIS TEST REMOVED BY THE NEXT JUMP
	JMP	CHKFRAM	;GO CHK FOR FRAMING ERROR	
	MVI	A,10H	;SET OVERRUN ERROR
	ORA	B	;SET BIT
	MOV	B,A	;SAVE BITS
CHKFRAM	EQU	$
	MOV	A,C	;RESTORE ORGINAL STATUS
	ANI	10H	;CHK FRAMING ERROR
			;THIS TEST REMOVED BY THE NEXT JUMP
	JMP	CHKPAR	;GO CHK FOR PARITY ERROR
	MVI	A,20H	;SET FRAMING ERROR
	ORA	B	;SET BIT
	MOV	B,A	;SAVE BITS
CHKPAR	EQU	$
	MOV	A,C	;RESTORE ORGINAL STATUS
	ANI	08H	;CHK PARITY ERROR
			;THIS TEST REMOVED BY NEXT JUMP
	JMP	ENDCK	;GO TO SET REGISTER A FOR BSTAM
	MVI	A,08H	;SET PARITY ERROR
	ORA	B	;SET BIT
	MOV	B,A	;SAVE BITS
ENDCK	EQU	$
	MOV	A,B	;BITS ARE NOW SET FOR BSTAM
	POP	B	;RESTORE BSTAM'S B + C
	RET		;RETURN TO BSTAM
;
;
;
;
;
;
;
;
ERRSTU	EQU	$
;			THIS IS THE ERROR RESET FOR UART/USART ROUTINE.
;			YOUR UART/USART MAY NOT NEED TO BE RESET IF FRAMING,
;			OVERRUN, OR PARITY ERROR IS FOUND. IF THIS IS YOUR
;			CASE, JUST DO A RETURN.
;
;
;
;
	RET		;RETURN TO BSTAM
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
INPRTU	EQU	$
;			THIS IS THE READ DATA PORT ROUTINE.
;			BEFORE THIS ROUTINE IS ENTERED THE 02 BIT OF
;			STATUS READ ROUTINE MUST HAVE BEEN SET.
;			DO NOT CLEAR THE 80 BIT FROM THE DATA INPUT PORT.
;			RETURN WITH REGISTER A LOADED WITH INPUT DATA.
;
;
;
;
	IN	TP	;GET DATA FROM PORT
	RET		;RETURN TO BSTAM
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
OUTPRU	EQU	$
;			THIS IS THE WRITE DATA PORT ROUTINE.
;			BEFORE THIS ROUTINE IS ENTERED THE 04 BIT AND 01 BIT
;			OF STATUS READ MUST BE SET.
;			DO NOT CLEAR THE 80 BIT FROM THE DATA OUTPUT PORT.
;			REGISTER A CONTAINS THE OUTPUT DATA.
;
;
;
;
	OUT	TP	;SEND DATA TO REMOTE CPU
	RET		;RETURN TO BSTAM
	END	BEGIN
