;
;VERSION FOR INTERSIL IM64021 WITH 8253 BAUD RATE GENERATOR
;PER IMS 5000
;
;
BEGIN	ORG	103H
INITIL	JMP	INITIU			;UART/USART INITIALATION ENTRY POINT
INSPORT	JMP	INSPRU			;STATUS PORT READ ENTRY POINT
ERRSET	JMP	ERRSTU			;UART/USART ERROR RESET ENTRY POINT
INPORT	JMP	INPRTU			;READ DATA PORT ENTRY POINT
OUTPORT	JMP	OUTPRU			;WRITE DATA PORT ENTRY POINT
;
;
;
;			IF YOU WISH TO USE OTHER REGISTERS SUCH AS HL,BC,DE
;			(NOT INCLUDING  SP  REGISTER)
;			BE SURE TO PUSH BSTAM'S REGISTERS ON TO STACK AND POP
;			THEM BACK OFF BEFORE RETURNING TO BSTAM.
;			THERE IS AMPLE ROOM TO PUSH ALL REGISTERS ONTO BSTAM'S
;			STACK, PLUS ROOM FOR 10 LEVELS OF CALL'S.
;
;			THERE ARE 300 BYTES OF USER SPACE AVAILABLE TO YOU.
;
;			THE JUMP'S CODED AT THE BEGINNING OF THIS PROGRAM
;			CANNOT BE MOVED IN ANY WAY.
;
;			GOOD LUCK AND WELCOME TO THE REAL WORLD OF
;			TELECOMMUNICATIONS.
;
;
;
;
;
;
;
;
;
;
;
;
;
INITIU	EQU	$
;			THIS IS THE UART/USART INITIALATION ROUTINE.
;			TO BE COMPATIBLE WITH MOST BSTAM USERS USE FOLLOWING
;			INITIALATION GUIDE LINES:
;			1. USE 1 STOP BIT	(OPTIONAL - 2)
;			2. USE 8 DATA BITS	(MUST)
;			3. USE 1 START BIT	(MUST)
;			4. USE 16X FOR CLOCK RATE 	(MUST)
;			5. USE ASYNCHRONOUS MODE ONLY	(MUST)
;
;
;
;
	CALL	SIGNON		;TELL USER WHAT'S IMPLEMENTED
;
	MVI	A,76H		;COUNTER 1 FOR UART 1
	OUT	17H		;PIT CONTROL
	MVI	A,0DH		;2MHZ/(9600*16)=13=0DH FOR 9600H
	OUT	15H		;COUNT REGISTER 1
	MVI	A,0		;MSB OF COUNT
	OUT	15H
	MVI	A,19H		;8 BIT NO PARITY
	OUT	12H
;
	RET		;RETURN TO BSTAM
;
;
;
;
INSPRU	EQU	$
;			THIS IS THE STATUS READ PORT ROUTINE.
;			WHEN EXITING THIS ROUTINE BSTAM EXPECTS IN REGISTER A
;			THE FOLLOWING BITS TO BE SET IF NEEDED:
;			1. 20 BIT SET IF FRAMING ERROR
;			2. 10 BIT SET IF OVERRUN ERROR
;			3. 08 BIT SET IF PARITY  ERROR
;			4. 04 BIT SET IF TRANSMITTER EMPTY
;				IF YOUR UART/USART DOES NOT HAVE TRANSMITTER
;				EMPTY FEATURE, THEN ALLWAYS SET THIS BIT ON.
;			5. 02 BIT SET IF RECEIVER READY
;			6. 01 BIT SET IF TRANSMITTER READY
;			7. DO NOT SET THE 80 BIT OR 40 BIT
;
;
;
	IN	12H		;BIT 0 - RDA
				;BIT 1 - TBE
	RAL
	ANI	6
	ORI	1
	RET		;RETURN TO BSTAM
;
;
;
;
;
;
;
;
;
ERRSTU	EQU	$
;			THIS IS THE ERROR RESET FOR UART/USART ROUTINE.
;			YOUR UART/USART MAY NOT NEED TO BE RESET IF FRAMING,
;			OVERRUN, OR PARITY ERROR IS FOUND. IF THIS IS YOUR
;			CASE, JUST DO A RETURN.
;
;
;
;
	RET		;RETURN TO BSTAM
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
INPRTU	EQU	$
;			THIS IS THE READ DATA PORT ROUTINE.
;			BEFORE THIS ROUTINE IS ENTERED THE 02 BIT OF
;			STATUS READ ROUTINE MUST HAVE BEEN SET.
;			DO NOT CLEAR THE 80 BIT FROM THE DATA INPUT PORT.
;			RETURN WITH REGISTER A LOADED WITH INPUT DATA.
;
;
;
;
	IN	13H	;GET DATA FROM PORT
	RET		;RETURN TO BSTAM
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
OUTPRU	EQU	$
;			THIS IS THE WRITE DATA PORT ROUTINE.
;			BEFORE THIS ROUTINE IS ENTERED THE 04 BIT AND 01 BIT
;			OF STATUS READ MUST BE SET.
;			DO NOT CLEAR THE 80 BIT FROM THE DATA OUTPUT PORT.
;			REGISTER A CONTAINS THE OUTPUT DATA.
;
;
;
;
	OUT	13H	;SEND DATA TO REMOTE CPU
	RET		;RETURN TO BSTAM
;
MESSGE:	DB	0DH,0AH,0DH,0AH
	DB	'VERSION FOR IMS5000 OCTOBER 10, 1979',0DH,0AH
	DB	'$'
;
SIGNON:	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,MESSGE
	MVI	C,9
	CALL	5		;ANOUNCE VERSION TO USER
	POP	H
	POP	D
	POP	B
	RET
;
	END	BEGIN
