;EXEMPLARY BSTAM INTERFACE AS GUIDE TO GENERALIZATION
;
;THIS VERSION WILL WORK WITH IMSAI 2SIO (PORT A) OR WITH
;NORTH STAR HORIZON (LEFT SERIAL PORT)
;
;VERSION 8251/4.2 AUGUST 20, 1979
;
BEGIN	ORG	103H
INITIL	JMP	INITIU			;UART/USART INITIALATION ENTRY POINT
INSPORT	JMP	INSPRU			;STATUS PORT READ ENTRY POINT
ERRSET	JMP	ERRSTU			;UART/USART ERROR RESET ENTRY POINT
INPORT	JMP	INPRTU			;READ DATA PORT ENTRY POINT
OUTPORT	JMP	OUTPRU			;WRITE DATA PORT ENTRY POINT
;
;
;
;			IF YOU WISH TO USE OTHER REGISTERS SUCH AS HL,BC,DE
;			(NOT INCLUDING  SP  REGISTER)
;			BE SURE TO PUSH BSTAM'S REGISTERS ON TO STACK AND POP
;			THEM BACK OFF BEFORE RETURNING TO BSTAM.
;			THERE IS AMPLE ROOM TO PUSH ALL REGISTERS ONTO BSTAM'S
;			STACK, PLUS ROOM FOR 10 LEVELS OF CALL'S.
;
;			THERE ARE 300 BYTES OF USER SPACE AVAILABLE TO YOU.
;
;			THE JUMP'S CODED AT THE BEGINNING OF THIS PROGRAM
;			CANNOT BE MOVED IN ANY WAY.
;
;			GOOD LUCK AND WELCOME TO THE REAL WORLD OF
;			TELECOMMUNICATIONS.
;
;
;
;
;
TPS	EQU	3			;STATUS PORT
TP	EQU	2			;DATA PORT
MI	EQU	06EH			;1 STOP,8 DATA
CI	EQU	37H			;ERROR RESET AND CHIP ENABLE
ERESET	EQU	37H			;ERROR RESET AND CHIP ENABLE
;
;
;
;
;
;
;
;
INITIU	EQU	$
;			THIS IS THE UART/USART INITIALATION ROUTINE.
;			TO BE COMPATIBLE WITH MOST BSTAM USERS USE FOLLOWING
;			INITIALATION GUIDE LINES:
;			1. USE 1 STOP BIT	(OPTIONAL - 2)
;			2. USE 8 DATA BITS	(MUST)
;			3. USE 1 START BIT	(MUST)
;			4. USE 16X FOR CLOCK RATE 	(MUST)
;			5. USE ASYNCHRONOUS MODE ONLY	(MUST)
;
;
;
;
	CALL	SIGNON		;TELL USER WHAT'S IMPLEMENTED
;
	MVI	A,80H
	OUT	TPS
	NOP			;USART PROGRAMMING DELAY
	NOP
	NOP
	NOP
	NOP
	NOP
	MVI	A,0H
	OUT	TPS
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	OUT	TPS
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	OUT	TPS
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	MVI	A,40H	;RESET 8251
	OUT	TPS	;TO STATUS PORT
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	MVI	A,MI	;SEND MODE COMMAND 
	OUT	TPS	;TO STATUS PORT
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	MVI	A,CI	;ENABLE 8251 AND RESET ALL ERRORS IN 8251 (FE,OE,PE)
	OUT	TPS	;TO STATUS PORT
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RET		;RETURN TO BSTAM
;
;
;
;
INSPRU	EQU	$
;			THIS IS THE STATUS READ PORT ROUTINE.
;			WHEN EXITING THIS ROUTINE BSTAM EXPECTS IN REGISTER A
;			THE FOLLOWING BITS TO BE SET IF NEEDED:
;			1. 20 BIT SET IF FRAMING ERROR
;			2. 10 BIT SET IF OVERRUN ERROR
;			3. 08 BIT SET IF PARITY  ERROR
;			4. 04 BIT SET IF TRANSMITTER EMPTY
;				IF YOUR UART/USART DOES NOT HAVE TRANSMITTER
;				EMPTY FEATURE, THEN ALLWAYS SET THIS BIT ON.
;			5. 02 BIT SET IF RECEIVER READY
;			6. 01 BIT SET IF TRANSMITTER READY
;			7. DO NOT SET THE 80 BIT OR 40 BIT
;
;
;
	IN	TPS	;GET INFO BITS FROM 8251 STATUS PORT
	RET		;RETURN TO BSTAM
;
;
;
;
;
;
;
;
;
ERRSTU	EQU	$
;			THIS IS THE ERROR RESET FOR UART/USART ROUTINE.
;			YOUR UART/USART MAY NOT NEED TO BE RESET IF FRAMING,
;			OVERRUN, OR PARITY ERROR IS FOUND. IF THIS IS YOUR
;			CASE, JUST DO A RETURN.
;
;
;
;
	MVI	A,ERESET	;RESET ERRORS IN UART/USART (8251)
	OUT	TPS	;TO STATUS PORT
	RET		;RETURN TO BSTAM
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
INPRTU	EQU	$
;			THIS IS THE READ DATA PORT ROUTINE.
;			BEFORE THIS ROUTINE IS ENTERED THE 02 BIT OF
;			STATUS READ ROUTINE MUST HAVE BEEN SET.
;			DO NOT CLEAR THE 80 BIT FROM THE DATA INPUT PORT.
;			RETURN WITH REGISTER A LOADED WITH INPUT DATA.
;
;
;
;
	IN	TP	;GET DATA FROM PORT
	RET		;RETURN TO BSTAM
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
OUTPRU	EQU	$
;			THIS IS THE WRITE DATA PORT ROUTINE.
;			BEFORE THIS ROUTINE IS ENTERED THE 04 BIT AND 01 BIT
;			OF STATUS READ MUST BE SET.
;			DO NOT CLEAR THE 80 BIT FROM THE DATA OUTPUT PORT.
;			REGISTER A CONTAINS THE OUTPUT DATA.
;
;
;
;
	OUT	TP	;SEND DATA TO REMOTE CPU
	RET		;RETURN TO BSTAM
;
MESSGE:	DB	0DH,0AH,0DH,0AH
	DB	'VERSION 8251/4.2 AUGUST 20, 1979',0DH,0AH
	DB	'8251 ON PORT 2D/3S USING NO PARITY',0DH,0AH,'$'
;
SIGNON:	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,MESSGE
	MVI	C,9
	CALL	5		;ANOUNCE VERSION TO USER
	POP	H
	POP	D
	POP	B
	RET
;
	END	BEGIN
