	title	'FOXYCALC absolute and common module, version 1.0'
;
	page	58
;
;
;	foxycalc aseg and common section
;
	aseg
		org	100h		;start of TPA
;
	public	ovl$buf, tmp$fcb, ex$para, rw$flag
	public	crt$xy, era$scn, era$lin, era$eol, cur$on
	public	crt$ht, crt$vt, cur$off, crt$off, inv$spc
	public	rc$cr
;
	public	exp$mem,tmp$exp, val$mem, tmp$val, cwt$buf, exm$end
	public	exp$ptr, exp$adr, val$ptr, val$adr, vtl$ptr, eom$ptr
	public	exp$col, exp$row, val$col, val$row
;
	public	ovl$fcb, exp$fcb, val$fcb, tp1$fcb, tp2$fcb
;
	public	msg$fcb, typ$num, crt$col, crt$row
	public	column, old$col, idx$off, vl$para
;
	extrn	fst$exp, nxt$exp, add$exp, del$exp, fnd$exp
	extrn	get$val, put$val
;
	extrn	goto$xy, clr$scn, clr$lin, clr$eol, inv$on, inv$off
	extrn	dsp$msg, read$ln, char$st, char$in, chr$out
	extrn	rd$para, wr$para, rd$nx$pr, wr$nx$pr
;
;
wmboot		equ	0000h		;jump to bios warm boot code
bdos		equ	00005h		;bdos entry point
open$f		equ	15		;open file function number
;
ex$off		equ	12		;extent offset from fcb(0)
cr$off		equ	32		;current record offset from fcb(0)
;
msg19		equ	19		;signon and copyright message
;
;
ovl$buf		equ	$		;overlay buffer
;
;	initialization module, starts life in overlay buffer
;	and is discarded after initializing various pointer,
;	and opening the two overlay files.
;
;	first setup the machine stack
;
init:		lhld	bdos+1		;bdos entry address
		dcx	h
		sphl			;stack set
		mvi	l,00h
		dcr	h		;setup end of memory pointer
		shld	eom$ptr
;
;	now clear the screen, init the c.w.t table,
;	and set the expr$cell and valu$cell buffers empty
;
		call	clr$scn		;blank display
		lxi	h,cwt$buf
		lxi	b,0008h		;<b>= count, <c>= cell width
;
int$cwt:	mov	m,c
		inx	h
		dcr	b
		jnz	int$cwt		;init c.w.t loop
;
;	zero fill the temp. expr$cell and the temp. valu$cell
;
		lxi	h,tmp$exp
		lxi	b,tmp$siz*2	;512 bytes
;
int$tmps:	mvi	m,00h
		inx	h
		dcx	b
		mov	a,b
		ora	c
		jnz	int$tmps	;zero fill temps loop
;
;	init expr$mem to no cells, and init pointers
;
		lxi	h,exp$mem+cwt$siz
		shld	exp$ptr
		shld	exp$adr
		mvi	m,0ffh		;eo$flag
		inx	h
		mvi	m,0ffh		;eof$flag
;
;	do the same for valu$mem
;
		lxi	h,val$mem
		shld	val$ptr
		shld	val$adr
		mvi	m,0ffh		;eo$flag
		inx	h
		mvi	m,0ffh		;eof$flag
		inx	h
		shld	vtl$ptr		;valu$mem tail pointer
;
;	open FOXOVLAY.OVL and FOXMSG.OVL, return to cp/m
;	if any open errors occur
;
		lxi	h,ovl$fcb	;overlay file fcb
		call	open$fl
		mov	a,h
		ora	l		;error returned in <hl>
		jz	opn$ovl$err	;error, report and exit
;
		lxi	h,msg$fcb	;message file fcb
		call	open$fl
		mov	a,h
		ora	l
		jz	opn$msg$err
;
;	init done, transfer control to main line program
;
		lxi	h,msg19		;signon message
		call	dsp$msg
		jmp	fox$main
;
;
;	open file function
;	opens the file addressed by <hl>
;
;	first clear drive number, extent number ,current record
;	and random record address fields.
;
open$fl:	push	h		;save pointer to fcb
		mvi	m,00h		;clear drive auto-select
		lxi	d,ex$off
		dad	d		;pointer to extent byte
		mov	m,d		;clear extent byte
		lxi	d,cr$off-ex$off
		dad	d
		mov	m,d		;clear current record
		inx	h
		mov	m,d		;clear random record
		inx	h
		mov	m,d
		inx	h
		mov	m,d
;
open$fl$1:	pop	d		;pointer to dr_fcb field
		push	d		;re-save
		mvi	c,open$f	;open file function number
		call	bdos
		ora	a		; 0...3 0k, 0ffh file not found
		jm	try$dr$a	; try to open on drive A:
		pop	h		;return value, fcb address in <hl>
		ret
;
;	we couldn't find the file on the default drive,
;	so try on drive A:
;
try$dr$a:	pop	h		;get pointer to fcb
		mov	a,m		;get drive number
		inr	a		; 0= auto-select, 1= drive A:
		cpi	2		; try drives less than 2
		jnc	open$err
		mov	m,a
		push	h
		jmp	open$fl$1
;
open$err:	lxi	h,0000h		;file not found error code
		ret
;
;	init error handler, on open$error print message and
;	jump to warm boot entry point
;
opn$ovl$err:	lxi	h,ovl$err$msg	;cannot open overlay file
		jmp	prn$msg
;
opn$msg$err:	lxi	h,msg$err$msg	;cannot open message file
;
prn$msg:	push	h		;save message address
		lxi	h,(12 shl 8) or 18
		call	goto$xy		;position cursor
;
prn$msg$1:	pop	h		;restore message address
		mov	e,m
		mov	a,e
		inx	h
		ora	a
		jz	reboot
		push	h
		call	chr$out
		jmp	prn$msg$1
;
reboot:		lxi	h,(22 shl 8) or 00
		call	goto$xy
		jmp	wmboot		;bye kids
;
ovl$err$msg	db	'Cannot open FOXOVLAY.OVL, returning to CP/M',00
;
msg$err$msg	db	'Cannot open FOXMSG.OVL, returning to CP/M',00
;
;
;
eob		set	$
		org	0d00h
;
;	start of common section
;
;******************************************************************************
;******************************************************************************
;
;	user modification area, terminal dependent information
;
crt$xy		db	2,1bh,'Y',0,0,0,0,0	;cursor goto x/y leadin
;
era$scn		db	2,1bh,'E',0,0,0,0,0	;clear screen string
;
era$lin		db	2,1bh,'l',0,0,0,0,0	;clear single line string
;
era$eol		db	2,1bh,'K',0,0,0,0,0	;clear to end of line string
;
cur$on		db	2,1bh,'p',0,0,0,0,0	;active cell cursor on string
;
cur$off		db	2,1bh,'q',0,0,0,0,0	;active cell cursor off string
;
crt$ht		db	80		;number of display columns on crt
crt$vt		db	24		;number of display lines on crt
crt$off		db	' '		;offset to add to row and column
;
inv$spc		db	00h		; 00h, if active cell cursor does not
					;take a chr position on the screen,
					;non-zero if it does
;
rc$cr		db	00h		; 00h, if row is sent before column
					; non-zero, if column is sent before
					;row
;
;
;	end of terminal dependent area
;
;******************************************************************************
;******************************************************************************
;
;	file control blocks for FC
;
eob		set	$
		org	0d40h
;
;
;	overlay file fcb
;
ovl$fcb		db	0,'FOXOVLAYOVL'
		db	0,0,0,0
		db	0,0,0,0,0,0,0,0
		db	0,0,0,0,0,0,0,0
		db	0,0,0,0
;
;	message overlay file fcb and local variables
;
msg$fcb		db	0,'FOXMSG  OVL'
		db	0,0,0,0
		db	0,0,0,0,0,0,0,0
		db	0,0,0,0,0,0,0,0
		db	0,0,0,0
;
;	expression file primary input fcb
;
exp$fcb		db	0,'EXPPRIM FCB'
		db	0,0,0,0
		db	0,0,0,0,0,0,0,0
		db	0,0,0,0,0,0,0,0
		db	0,0,0,0
;
;	data file fcb
;
val$fcb		db	0,'VALPRIM FCB'
		db	0,0,0,0
		db	0,0,0,0,0,0,0,0
		db	0,0,0,0,0,0,0,0
		db	0,0,0,0
;
;	temporary file fcb #1
;
tp1$fcb		db	0,'FOXTEMP1$$$'
		db	0,0,0,0
		db	0,0,0,0,0,0,0,0
		db	0,0,0,0,0,0,0,0
		db	0,0,0,0
;
;	temporary file fcb #2
;
tp2$fcb		db	0,'FOXTEMP2$$$'
		db	0,0,0,0
		db	0,0,0,0,0,0,0,0
		db	0,0,0,0,0,0,0,0
		db	0,0,0,0
;
;**************************************************************
;			COMMON DATA AREA
;**************************************************************
;
eob		set	$
		org	0e20h
;
;	disk i/o data section
;
tmp$fcb		dw	0000h		;pointer to r/w fcb
ex$para		db	00h		;expression paragraph number
vl$para		db	00h		;value paragraph number
;
;	read or write flag, 00h for disk read operation,
;	non-zero for disk write operation
;
rw$flag		db	00h		;read or write flag
;
typ$num		dw	0000h		;message address
idx$off		db	00h
;
crt$col		db	00h		;current row/column to be output
crt$row		db	00h
;
column		db	00h
;
old$col		db	00h
;
;******************************************************************************
;
;	MEMORY buffer equates
;
data$mem	equ	8000h		;start of buffers
cwt$siz		equ	256		;cwt table size in paragraph zero
tmp$siz		equ	256		;temp. buffer size in bytes
exp$siz		equ	4096		;expression buffer size in bytes
;
cwt$buf		equ	data$mem	;cell width table buffer
tmp$exp		equ	cwt$buf+cwt$siz	;temporary expression buffer
tmp$val		equ	tmp$exp+tmp$siz	;temporary value buffer
;
expr$mem	equ	tmp$val+tmp$siz	;expression cell buffer memory
exp$mem		equ	expr$mem
;
valu$mem	equ	expr$mem+exp$siz	;value cell buffer memory
val$mem		equ	valu$mem
;
exm$end		equ	valu$mem	;end of expression buffer
;
eom$ptr		dw	0000h		;end of data memory pointer
;
exp$ptr		dw	0000h		;expression cell pointer
exp$adr		dw	0000h		;returned expression cell pointer
exp$col		db	00h		;expr$cell column address
exp$row		db	00h		;expr$cell row address
;
val$ptr		dw	0000h		;value cell pointer
vtl$ptr		dw	0000h		;value memory tail pointer
val$adr		dw	0000h		;returned value cell pointer
val$col		db	00h		;valu$cell column address
val$row		db	00h		;valu$cell row address
;
;
;
eob		set	$
		org	0e80h
;
;
;	overlay module jump table
;	allows overlays to access internal routines
;
		jmp	fst$exp		;get first expr (memory module)
		jmp	nxt$exp		;get next expr (memory module)
		jmp	add$exp		;append expr (memory module)
		jmp	del$exp		;delete expr (memory module)
		jmp	fnd$exp		;find expr$cell (memory module)
;
		jmp	get$val		;get valu$cell (memory module)
		jmp	put$val		;put valu$cell (memory module)
;
		jmp	goto$xy		;cursor x/y (i/o module)
		jmp	clr$scn		;clear screen
		jmp	clr$lin		;clear line
		jmp	clr$eol		;clear to end of line
		jmp	inv$on		;set highlight on (crt)
		jmp	inv$off		;set highlight off (crt)
;
		jmp	dsp$msg		;display message from ovlay
		jmp	read$ln		;read line buffer
		jmp	char$st		;return console status
		jmp	char$in		;read console char in
		jmp	chr$out		;write to console
		jmp	rd$para		;read (exp or val) file paragraph
		jmp	wr$para		;write (exp or val) file paragraph
		jmp	rd$nx$pr	;read (exp or val) file next para.
		jmp	wr$nx$pr	;write (exp or val) file next para.
;		
;
eob		set	$
		org	1000h
;
fox$main	equ	$		;start of main line program
;
		end		;of aseg, this should be at 0e00h
