	TITLE	'Floating point package'
;
	PAGE	58
;
;	Test driver for floating point routines
;	Written by C. E. Duncan 1981 October 28.
;
;	Revised 14:40 1982 April 19.
;	Version A.1
;
		ORG	0100H
;
;	Save return to CCP
;
		LXI	H,0
		DAD	SP
		SHLD	SPSAVE
		LXI	SP,STACK
;
;	Display sign-on message
;
START:		LXI	D,SGNMSG
		CALL	PUTMSG
;
;	Clear floating point fields
;
RESTART:	MVI	A,0
		LXI	B,FRGLEN
		LXI	H,FLPARG
		CALL	FILLCHAR
;
;	Clear ASCII fields
;
		MVI	C,ASCLEN
		MVI	A,' '
		MVI	B,0
		LXI	H,ASCARG
		CALL	FILLCHAR
		XRA	A		;clear number bytes
		STA	NLEN
		STA	MLEN
;
;	Request first argument
;
G01:		CALL	CLRIPB		;clear input buffer to blanks
		LXI	D,FARMSG
		CALL	REQINP
		LDA	CONSIZ		;check for no input
		ORA	A
		JZ	G01		;ask again
		LXI	D,CONLIN	;set up argument address
		LXI	H,F1		; and destination
		SHLD	AADL
		MVI	A,CASCF		;function code
		CALL	COUPLE		;string to float
		MOV	H,B		;store also
		MOV	L,C
		SHLD	RCNT
;
;	Request operation code
;
G02:		LXI	D,FCNPRMT	;request operation code
		CALL	REQINP
		LDA	CONSIZ
		ORA	A
		JZ	G02
		LXI	B,CONSIZ	;convert to binary
		CALL	STR1NBR
		JC	G02
		MOV	A,L
		STA	FLOP
;
;	Skip 2nd argument if MONOP or conversion
;
		CPI	DFMAX+1
		JNC	G05
;
;	Get 2nd argument
;
G03:		CALL	CLRIPB		;clear input buffer
		LXI	D,SARMSG
		CALL	REQINP
		LDA	CONSIZ
		ORA	A
		JZ	G03
		LXI	D,CONLIN	;convert
		LXI	H,F2
		SHLD	BADL
		MVI	A,CASCF
		CALL	COUPLE
;
;	Simulate call for dyadic functions
;
G04:		LHLD	AADL		;address of 1st arg
		MOV	B,H		; to BC
		MOV	C,L
		LHLD	BADL		;address of 2nd arg
		XCHG			; to DE
		LXI	H,F3		;place for result
		SHLD	RADL		; to HL
		LDA	FLOP		;function code
		CALL	COUPLE		;call to Ashley couple
		MOV	A,B		;return code
		STA	RCOD
;
;	Compare is different
;
		LDA	FLOP
		CPI	DFCMP
		JNZ	DISPLAY
		MOV	A,C
		STA	RCOD
;
;	Convert results and display for functions
;
DISPLAY:	LXI	H,A1		;output field
		SHLD	ADROUT		;for MOVCHAR of Ashleys FPCNV
		MVI	A,ALEN		;room for "E" form
		STA	LENOUT
		LXI	H,F1+FPLM1	;right end
		CALL	FPOUT		;convert to ASCII
;
;	Skip this if not dyadic
;
		LDA	FLOP
		CPI	DFMAX+1
		JNC	DISP01
		LXI	H,A2
		SHLD	ADROUT
		MVI	A,ALEN
		STA	LENOUT
		LXI	H,F2+FPLM1
		CALL	FPOUT
;
DISP01:		LXI	H,A3
		SHLD	ADROUT
		MVI	A,ALEN
		STA	LENOUT
		LXI	H,F3+FPLM1
		CALL	FPOUT
		LXI	D,WCR2LF	;new line
		CALL	PUTMSG
		LXI	H,A1
		MVI	A,ALEN
		CALL	PUTROW
;
;	Convert and write function code
;
		LDA	FLOP
		LXI	B,PN		;temporary 3 byte buffer
		MOV	L,A
		CALL	NBR1STR
		LXI	D,PN
		CALL	PUTMSG
		MVI	A,' '
		CALL	PUTCHAR
;
;	Skip this if not diadic
;
		LDA	FLOP
		CPI	DFMAX+1
		JNC	DISP02
		LXI	H,A2
		MVI	A,ALEN
		CALL	PUTROW
		MVI	A,' '
		CALL	PUTCHAR
;
DISP02:		MVI	A,'='
		CALL	PUTCHAR
		MVI	A,' '
		CALL	PUTCHAR
		LXI	H,A3
		MVI	A,ALEN
		CALL	PUTROW
		JMP	D03A		;return code only
;
;	Convert and display return code and count
;
D03:		LXI	D,FLSMSG	;count
		CALL	PUTMSG
		LDA	RCNT
		MOV	L,A
		LXI	B,PN
		CALL	NBR1STR
		LXI	D,PN
		CALL	PUTMSG
;
D03A:		LXI	D,RTCMSG	;return code
		CALL	PUTMSG
		LDA	RCOD
		MOV	L,A
		LXI	B,PN
		CALL	NBR1STR		;convert to ASCII
		LXI	D,PN		;display
		CALL	PUTMSG
		LXI	D,WCRLF
		CALL	PUTMSG
		JMP	RESTART
;
;	Field out the conversions
;
G05:		CPI	CFMAX+1
		JNC	G05A
		CPI	CASCF		;"C" conversion
		JZ	G08
		CPI	CDFMT		;"D"ollar conversion
		JZ	G09
		CPI	CFXFP		;Float to binary
		JZ	G10
		CPI	C8FXP		;float to 8-bit
		JZ	G10
;
;	Request field width
;
		PUSH	PSW
;
G051:		LXI	D,FLSMSG
		CALL	REQINP
		LDA	CONSIZ
		ORA	A
		JZ	G051
		LXI	B,CONSIZ
		CALL	STR1NBR
		JC	G051
		MOV	C,L
		POP	PSW
		CPI	CGFMT		;"G" conversion
		JZ	G06
		CPI	CEFMT		;"E" conversion
		JZ	G07
		JMP	G11		;trouble
;
;	Simulate call for monadic functions, float in and float out
;
G05A:		LHLD	AADL		;address of argument
		XCHG			; to DE
		LXI	H,F3		;address of result
		LDA	FLOP		;function code
		CALL	COUPLE
		MOV	A,B		;return code
		STA	RCOD
		LXI	H,F3
		SHLD	RADL
		JMP	DISPLAY		;display results
;
;	Convert float to "G" format
;
G06:		LHLD	AADL		;input float number
		SHLD	RADL
		XCHG			; to DE
		LXI	H,FPWRKA	;result field
		SHLD	RASCII
		LDA	FLOP		;function code
		CALL	COUPLE
		MOV	A,C
		STA	RCNT
		MOV	A,B
		STA	RCOD
;
;	Display results
;
DSPF:		LXI	D,CVRMSG
		CALL	PUTMSG
		LDA	RCNT		;count
		MOV	B,A
		INR	B		;count+1
		LHLD	RASCII		;result address
;
DISPF1:		DCR	B		;count down
		JZ	DISPF2		;end
		MOV	A,M		;write character from
		CALL	PUTCHAR		; memory to console
		INX	H
		JMP	DISPF1
;
DISPF2:		JMP	D03		;display count and return code
;
;	Convert from float to "E" format
;
G07:		LHLD	AADL		;argument address
		XCHG			; to DE
		LXI	H,FPWRKA	;result, receiving field
		SHLD	RASCII
		LDA	FLOP
		CALL	COUPLE		;function code is in A
		MOV	A,B		;return code
		STA	RCOD
		MOV	A,C		;count
		STA	RCNT
		JMP	DSPF		;display
;
;	"C" conversion. To get here, conversion is already done.
;	Display via Ashley FPOUT the number in F1.
;
G08:		LXI	H,A1		;ASCII receiving field
		SHLD	ADROUT
		XCHG
		LHLD	AADL		;source address
		MVI	C,FPLM1		;switch ends
		MVI	B,0
		DAD	B		; for HL
		MVI	A,ALEN		;receiving field length
		STA	LENOUT
		CALL	FPOUT		;call directly, so don't get scrunches
		LXI	D,CVRMSG	;legend
		CALL	PUTMSG
		MVI	A,ALEN		;display count
		LXI	H,A1		;converted result
		CALL	PUTROW		;write to console
		JMP	D03		;write return code and count
					; saved from input
;
;	"D" conversion. Convert to ASCII, rounded to nearest cent.
;
G09:		LHLD	AADL		;argument address
		SHLD	RADL
		XCHG			; to DE
		LXI	H,FPWRKA	;result field
		SHLD	RASCII
		LDA	FLOP		;function code
		CALL	COUPLE		;convert
		MOV	A,C		;count
		STA	RCNT
		MOV	A,B		;return code
		STA	RCOD
		JMP	DSPF		;display
;
;	Convert float to binary
;
G10:		LHLD	AADL		;argument
		SHLD	RADL
		XCHG			; to DE
		LDA	FLOP
		CALL	COUPLE
		MOV	A,B
		STA	RCOD
		LXI	B,A1
;
;	Complement if negative, and write minus sign
;
		MOV	A,H
		ANI	080H
		JZ	G10A
		MVI	A,'-'
		STA	A1
		MOV	A,H
		CMA
		MOV	H,A
		MOV	A,L
		CMA
		MOV	L,A
		INX	H
		INX	B
;
G10A:		CALL	NBR2STR		;convert binary to ASCII
		LXI	D,A1
		MVI	B,6
		CALL	DELBLNK
		MOV	A,B
		STA	RCNT
		LXI	H,A1
		SHLD	RASCII
		JMP	DSPF
;
;	Real problems
;
G11		equ	$
;
ABORT:		LXI	SP,STACK	;reset stack pointer
		JMP	START
;
;	Finished, return to CCP
;
FINIS:		LHLD	SPSAVE		;recover CCP stack pointer
		SPHL
		RET
;
;
	PAGE
;
CLRIPB:		;Clear console buffer to blanks
;
;Written by C. E. Duncan 1981 October 28
;
;--------------------------------------------------------------
;
;Input:	CONSIZ, CONLEN
;
;Calls to:	FILLCHAR
;
;--------------------------------------------------------------
;
		MVI	A,' '
		MVI	C,CONLEN
		MVI	B,0
		LXI	H,CONSIZ
		CALL	FILLCHAR
		RET
;
;	End *CLRIPB*
;
	PAGE
;
DIV111:		;Divide 8-bit number by 8-bit number.
;
;Written by C. E. Duncan 1980 August 24.
;Revised 09:55 1981 October 17
;
;--------------------------------------------------------------
;
;Input:	L = 8-bit dividend
;	A = 8-bit divisor
;
;Output:	L = 8-bit quotient
;		H = 8-bit remainder
;		Carry set for zero divisor, else reset
;
;Calls to:	none
;
;--------------------------------------------------------------
;
		ORA	A		;check for zero
		JNZ	DIV101
		STC			;report
		RET
;
DIV101:		MVI	B,9		;count
		MOV	C,A		;divisor
		MVI	H,0		;remainder register
;
DIV102:		DCR	B
		JZ	DIV104		;finished
		DAD	H		;shift left
		MOV	D,H		;save
		MOV	A,H		;try subtraction
		SUB	C
		JNC	DIV103
		MOV	H,D		;restore
		JMP	DIV102
;
DIV103:		MOV	H,A		;new dividend
		INR	L		;next digit in quotient
		JMP	DIV102
;
DIV104:		XRA	A		;ok, reset carry
		RET
;
;	End *DIV111*
;
	PAGE
;
GETMSG:		;Read console keyboard to buffer addressed by DE
;
;Written by C. E. Duncan 1981 July 3.
;Revised 12:10 1981 October 17
;
;--------------------------------------------------------------
;
;Input:	DE = address of console input buffer (at CONBUF)
;	CONLIN, CONSIZ, CTLA, CTLZ, RDCBUF
;
;Output:	Console input placed in buffer at CONBUF
;		Special returns if first buffer character is Ctl-A
;		(abort-restart) or Ctl-Z (return to CP/M)
;
;Calls to:	BDOS
;
;Jumps to:	ABORT, FINIS
;
;--------------------------------------------------------------
;
		MVI	C,RDCBUF	;request read
		CALL	BDOS
		LDA	CONSIZ		;return with no input
		ORA	A
		RZ
		LDA	CONLIN		;return to CP/M?
		CPI	CTLZ
		JZ	FINIS
		CPI	CTLA		;restart?
		JZ	ABORT
		RET
;
;	End *GETMSG*
;
	PAGE
;
MUL112:		;Multiply 8-bit number in E by 8-bit number in A, returning 16-bit
		; number in HL.
;
;Written by C. E. Duncan 1980 June 23.
;Revised 17:50 1981 October 17
;
;--------------------------------------------------------------
;
;Input:	E = 8-bit binary multiplicand
;	A = 8-bit binary multiplier
;
;Output:	HL = 16-bit binary product
;
;--------------------------------------------------------------
;
		LXI	H,0		;clear result register
		MVI	D,0		;zero, prepare double add
		MVI	B,8		;bit count
;
MUL101:		DAD	H		;shift result left
		RAL			;shift multiplier left
		JNC	MUL102
		DAD	D		;add multiplicand
;
MUL102:		DCR	B		;count
		JNZ	MUL101		;continue
		RET
;
;	End *MUL112*
;
	PAGE
;
NBR1STR:	;Convert 8-bit binary number to ASCII, replacing leading
		; zeros with blanks.
;
;Written by C. E. Duncan 1980 May 5.
;Revised 21:45 1981 October 17
;
;--------------------------------------------------------------
;
;Input:	L = 8-bit binary
;	BC = destination address for ASCII
;
;Output:	ASCII string
;
;Calls to:	DIV111
;
;--------------------------------------------------------------
;
		INX	B		;point to last position in field
		INX	B
		MVI	D,3		;count
;
NBR101:		MVI	A,10
		PUSH	B
		PUSH	D
		CALL	DIV111
		POP	D
		POP	B
		MOV	A,H		;remainder
		ADI	'0'		;convert to ASCII
		STAX	B		;to print area
		DCX	B
		DCR	D
		JNZ	NBR101
;
;	Replace leading zeros with blanks
;
		MVI	D,3		;leave least significant digit
;
NBR102:		INX	B
		LDAX	B
		CPI	'0'
		RNZ
		DCR	D		;count
		RZ
		MVI	A,' '
		STAX	B
		JMP	NBR102
;
;	End *NBR1STR*
;
	PAGE
;
NBR2STR:	;Convert 16-bit number in HL to ASCII string at location (BC) of
		; length five bytes, converting leading zeros to blanks.
;
;Written by C. E. Duncan 1980 June 15.
;Revised 14:10 1981 October 17
;
;--------------------------------------------------------------
;
;Input:	HL = 16-bit number
;	BC = address of five byte area
;
;Output:	ASCII representation of number at location (BC)
;
;Calls to:	DIV122
;
;--------------------------------------------------------------
;
		INX	B		;point to last digit space
		INX	B
		INX	B
		INX	B
		MVI	A,5		;output digit count
;
NBR201:		PUSH	PSW		;save it
		PUSH	B
		MVI	A,10		;divisor
		CALL	DIV122		;quotient in HL, remainder in E
		MOV	A,E		;convert to ASCII
		ADI	'0'
		POP	B		;store in destination
		STAX	B
		DCX	B		;point to next position
		POP	PSW		;count
		DCR	A
		JNZ	NBR201
;
;	Convert leading zeros to spaces
;
		MVI	D,5		;leave least significant figure
;
NBR202:		INX	B		;1st output character
		LDAX	B
		CPI	'0'		;zero?
		RNZ			;no, finished
		DCR	D
		RZ			;finished, return
		MVI	A,' '		;replace with space
		STAX	B
		JMP	NBR202
;
;	End *NBR2STR*
;
	PAGE
;
PUTCHAR:	;Write byte to console, each time checking for interrupt from
		; keyboard.
;
;Written by C. E. Duncan 1981 July 2.
;Revised 13:55 1981 November 3
;
;--------------------------------------------------------------
;
;Input:	A = character to send to console
;	WRCON
;
;Calls to:	BDOS
;
;--------------------------------------------------------------
;
		PUSH	B
		PUSH	D
		PUSH	H
		PUSH	PSW
		MVI	C,CONST		;check for interrupt
		CALL	BDOS
		ORA	A
		JZ	PUTC01		;nothing
		MVI	C,RDCON
		CALL	BDOS
		CPI	CTLA		;start over
		JZ	ABORT
		CPI	CTLZ		;quit
		JZ	FINIS
;
PUTC01:		POP	PSW		;go ahead and write
		MOV	E,A
		MVI	C,WRCON
		CALL	BDOS
		POP	H
		POP	D
		POP	B
		RET
;
;	End *PUTCHAR*
;
	PAGE
;
PUTMSG:		;Write sequence terminated by '$' to console.
;
;Written by C. E. Duncan 1980 June 3.
;Revised 22:05 1981 October 17
;
;--------------------------------------------------------------
;
;Input:	DE = address of character sequence
;	WRCBUF
;
;Calls to:	BDOS
;
;--------------------------------------------------------------
;
		MVI	C,WRCBUF
		CALL	BDOS
		RET
;
;	End *PUTMSG*
;
	PAGE
;
PUTROW:		;Write a row of characters, count in register A, address in HL,
		; to the console.
;
;Written by C. E. Duncan 1981 October 28.
;
;--------------------------------------------------------------
;
;Revised:
;Input:	HL = string address
;	 A = count
;
;Output:	HL = address of byte following end of string
;		String has been displayed on console
;
;Calls to:	PUTCHAR
;
;--------------------------------------------------------------
;
		ORA	A		;check for zero count
		RZ			;finished
		PUSH	B		;save
		PUSH	D
		MOV	C,A		;count
;
PUTR01:		MOV	A,M		;get character,
		PUSH	H		; write to
		PUSH	B
		CALL	PUTCHAR		;  console
		POP	B
		POP	H
		INX	H		;next character
		DCR	C		;count
		JNZ	PUTR01
		POP	D
		POP	B
		RET
;
;	End *PUTROW*
;
	PAGE
;
REQINP:		;Request console input using message pointed to by DE.
		; Update console pointer and count.
;
;Written by C. E. Duncan 1981 October 7.
;Revised 14:25 1981 October 19
;
;--------------------------------------------------------------
;
;Input:	DE = address of message
;	CONSIZ
;
;Output:	IBFCNT, IBFPTR
;
;Calls to:	GETMSG, PUTMSG
;
;--------------------------------------------------------------
;
REQI01:		PUSH	D		;save message address
		CALL	PUTMSG
		LXI	D,CONBUF
		CALL	GETMSG		;read input
		POP	D
		JC	REQI01		;try again
		LXI	H,CONSIZ	;set console buffer pointer
		SHLD	IBFPTR
		MOV	A,M
		STA	IBFCNT
		RET
;
;	End *REQINP*
;
	PAGE
;
STR1NBR:	;Convert ASCII number string at location BC to binary 8-bit number.
		; Carry set if result greater than 255, zero string length, or
		; non-numerical character in string.
;
;Written by C. E. Duncan 1980 August 24.
;Revised 15:50 1981 October 17
;
;--------------------------------------------------------------
;
;Input:	BC = ASCII string address
;
;Output:	L = 8-bit binary
;		Carry reset if ok, else set
;
;Calls to:	MUL112
;
;--------------------------------------------------------------
;
		LDAX	B		;check length
		CPI	4
		JNC	STR101		;too big
		CPI	0
		JNZ	STR102
;
STR101:		STC			;signal trouble: zero length or too big
		RET
;
STR102:		MOV	D,A		;count
		MVI	L,0		;result register
		MVI	E,10		;multiplier
		INX	B		;first digit
;
STR103:		MOV	A,L		;multiply by 10
		PUSH	B
		PUSH	D
		CALL	MUL112
		POP	D
		POP	B
		XRA	A		;check for overflow:  H should be 0
		CMP	H
		JNZ	STR101		;too big
		LDAX	B		;next digit
		SUI	030H		;convert to binary
		CPI	10
		JNC	STR101		;not a digit
		ADD	L
		JC	STR101		;too big
		MOV	L,A
		INX	B		;point to next
		DCR	D		;count
		JNZ	STR103		;continue
		ORA	A		;ok, reset carry
		RET			;finished
;
;	End *STR1NBR*
;
	PAGE
;
;**************************************************************
;**************************************************************
;
;		A S H L I N K
;
;Link to floating point routines, accompanied by the needed
; sub-routines to do additional processing.  The Ashley routines
; have been modified to insert return codes and limit checks.
;
;Written by C. E. Duncan 1981 November 3.
;Revised 16:30 1982 April 19.
;Version A.1
;
;
;	Equates
;
FPLEN		equ	7		;length of floating point word, bytes
FPLM1		equ	FPLEN-1
DIGS		equ	2*FPLEN-2	;number of digits in float number
DFLEN		equ	4*FPLEN		;max ASCII field for "D" conversion
EFLEN		equ	2*FPLEN+7	;max ASCII field for "E" conversion
QFLEN		equ	6*FPLEN		;max ASCII field for "G" conversion
;
;
;		F U N C T I O N      C O D E S
;
;	Dyadic functions
;
DFADD		equ	0		;FADD	floating add
DFCMP		equ	5		;FCMPR	floating compare
DFDIV		equ	3		;FDIV	floating divide
DFMUL		equ	2		;FMUL	floating multiply
DFPWR		equ	4		;XTOY	power function XTOY
DFSUB		equ	1		;FSUB	floating subtract
DFMOD		equ	6		;RMOD	modulus
;
DFMAX		equ	6		;largest dyadic function code
;
;	Conversion functions
;
CASCF		equ	16		;RASCF	convert ASCII to float
CDFMT		equ	17		;RDFMT	convert float to "D" format
CEFMT		equ	18		;REFMT	convert float to "E" format
CGFMT		equ	19		;RGFMT	convert float to "G" format
CFXFP		equ	20		;RFXFP	convert float integer to binary
CFLOT		equ	21		;RFLOT	convert binary to float
C8FXP		equ	22		;R8FXP  convert float to 8-bit binary
;
CFMAX		equ	22		;largest conversion function code
;
;	Monadic functions
;
MABS		equ	32		;ABSV	absolute value
MINTQ		equ	33		;TSTINT	returns 0 not integer, 'FF' integer
MTRNC		equ	34		;TRUNCL integer part of
MFLOR		equ	35		;TRUNC	greatest integer not greater than nbr
MCEIL		equ	36		;TRUNC	ceiling integer
MRND		equ	37		;TRUNC	round to nearest integer
MLG10		equ	38		;LOG10	logarithm to base 10
MLOGE		equ	39		;LOGE	logarithm to base e
MTPWR		equ	40		;TENTOX	ten to the power
MEXP		equ	41		;EXP	exponential
MSQT		equ	42		;SQRT	square root
MSIN		equ	43		;SINE	sine
MCOS		equ	44		;COSINE	cosine
MTAN		equ	45		;TANGENT tangent
MASIN		equ	46		;ASIN	arcsine
MACOS		equ	47		;ACOS	arccosine
MATAN		equ	48		;ATAN	arctangent
;
MFMAX		equ	48		;largest monadic code
;
;	Return codes
;
;EOK		equ	0		;ok return
;
EASB		equ	1		;ADD/SUB overflow
EMUL		equ	2		;MUL overflow
EDVO		equ	3		;DIV overflow
EDVZ		equ	4		;divide by zero
EFMM		equ	5		;number too large "E" conversion
EFNN		equ	6		;number too large "G" conversion
EDNN		equ	7		;number too large "D" conversion
EPOL		equ	8		;error in POLYN
ERAT		equ	9		;error in RATN
ETEN		equ	10		;error in TENTOX
EFXP		equ	11		;overflow in float to binary
EXTY		equ	12		;overflow in XTOY
EEER		equ	13		;field too small "E" conversion
EGER		equ	13		;field too small "G" conversion
ELT0		equ	14		;log of zero
ELTA		equ	15		;arithmetic error in logarithm
ELTN		equ	16		;attempted logarithm of negative
ETRG		equ	17		;trig argument too large
ETAN		equ	18		;tangent arg near PI/2
ETRA		equ	19		;arithmetic error in trig function
ESQT		equ	20		;arithmetic error in SQRT
EACT		equ	21		;error in arctangent
EARS		equ	22		;error in arcsine
EARC		equ	23		;error in arccosine
E8FX		equ	24		;overflow in R8FXP, float to 8-bit
EUNK		equ	254		;unknown function code
;
FALSE		equ	0000
TRUE		equ	NOT FALSE	;255
;
;
	PAGE
;
		ORG	02000H
;
COUPLE:		;Connect Ashley's floating point routines to a caller.
;
;Written by C. E. Duncan 30 October 1981.
;Revised 09:30 1982 January 14.
;
;--------------------------------------------------------------
;
;Input:	Diadic functions-
;	BC = address of left argument, float number
;	DE = address of right argument, float number
;	HL = address of result, float number (not used in compare)
;	 A = function code
;
;    Monadic functions-
;	DE = address of argument, float number
;	HL = address of result, float number
;	 A = function code
;
;    A conversion-
;	DE = binary number, -32767 to 32767
;	HL = address for floating point number
;
;    B and B8 conversion-
;	DE = address of argument, float number
;	 A = function code
;
;    C conversion-
;	DE = address of argument, ASCII
;	HL = address of result, float number
;	 A = function code
;
;    D conversion-
;	DE = address of argument, float
;	HL = address of receiving field for ASCII
;	 A = function code
;
;    E and G conversion-
;	DE = address of argument, float form
;	HL = address of receiving field for ASCII
;	 C = field maximum width
; 	 A = function code
;
;Output: A conversion-
;	 B = return code (always 0)
;
;    B conversion-
;	HL = 16-bit, signed binary result
;	 B = return code
;
;    B8 conversion-
;	B = return code
;	C = 8-bit binary number
;
;    C conversion-
;	B = return code
;	C = number of input characters processed
;
;    D, E and G conversion-
;	B = return code
;	C = length (count) of result, bytes
;
;    Floating point compare-
;	C = 1, 2, 4 as left argument <, =, > right argument
;
;    Diadic and Monadic functions-
;	B = return code
;
;Calls to:	ABSV, CMPEZRO, DELBLNK, DELZERO, DEROUND, DIFF2, DIV122,
;	EEROUND, EXP, FADD, FILLCHAR, FMUL, FORMT, FPCNV, FPOUT, FSUB,
;	GEROUND, LOG10, LOGE, INT2STR, MOVE, POLYN, R8FXP, RASCF,
;	RDFMT, REFMT, RFLOT, RFXFP, RGFMT, RMOD, RTRIG, TENTOX, TRUNC,
;	TSTINT, XTOY, ZEROCHEK
;
;--------------------------------------------------------------
;
		CPI	DFMAX+1		;is it binary operation?
		JNC	CVTOP		;no
;
;
;	D Y A D I C    F U N C T I O N S
;
;	Check for modulus function, no address switch needed
;
		CPI	DFMOD
		JNZ	COUP00
		CALL	RMOD
		RET
;
;	BC and DE point to start (high order end) of argument fields, but
;	Ashley wants the right end, so must switch
;
;Ashley input:	BC = right address left operand
;		DE = right address right operand
;		HL = right address of result
;
COUP00:		PUSH	H		;result
		XCHG			;right argument to HL
		LXI	D,FPLM1		;adjustment
		DAD	D
		XTHL			;right arg on stack now
		DAD	D
		PUSH	H		; and result
		MOV	H,B		;adjust left arg
		MOV	L,C
		DAD	D
		MOV	B,H
		MOV	C,L
		POP	H
		POP	D		;all set
;
;	Select binary routine according to function code
;
		CPI	DFADD		;add
		JNZ	COUP01
		CALL	FADD
		MOV	B,A		;return code
		RET
;
COUP01:		CPI	DFSUB		;subtract
		JNZ	COUP02
		CALL	FSUB
		MOV	B,A
		RET
;
COUP02:		CPI	DFMUL		;multiply
		JNZ	COUP03
		CALL	FMUL
		MOV	B,A
		RET
;
COUP03:		CPI	DFDIV		;divide
		JNZ	COUP04
		CALL	FDIV
		MOV	B,A
		RET
;
COUP04:		CPI	DFCMP		;compare
		JNZ	COUP04A
		CALL	FCMPR
		MOV	C,A		;return 1, 2, 4
		RET
;
COUP04A:	CPI	DFPWR		;X to power Y
		JNZ	COUP04B
		CALL	XTOY
		RET
;
COUP04B:	JMP	COUP0Z		;no more
;
CVTOP:		CPI	CFMAX+1
		JNC	MONOP
;
;
;		C O N V E R S I O N    R O U T I N E S
;
		CPI	CGFMT		;float to "G"
		JZ	RGFMT
		CPI	CASCF		;ASCII to float
		JZ	RASCF
		CPI	CEFMT		;float to "E" format
		JZ	REFMT
		CPI	CDFMT		;float to "D" format
		JZ	RDFMT
		CPI	CFXFP		;float to binary
		JZ	RFXFP
		CPI	CFLOT		;binary to float
		JZ	RFLOT
		CPI	C8FXP		;float to 8-bit
		JZ	R8FXP
		JMP	COUP0Z		;no further functions
;
;
;		M O N A D I C      F U N C T I O N S
;
;	Monadic operations
;
MONOP:		CPI	MFMAX+1
		JP	COUP0Z		;out of range fcn code
		CPI	MFLOR		;Floor
		JZ	TRUNC
		CPI	MABS		;absolute value
		JZ	ABSV
		CPI	MINTQ		;Test for integer
		JZ	TSTINT
		CPI	MTRNC		;integral part
		JZ	TRUNC
		CPI	MCEIL		;Ceiling
		JZ	TRUNC
		CPI	MRND		;Round
		JZ	TRUNC
		CPI	MLG10		;logarithm base 10
		JZ	LOG10
		CPI	MLOGE		;logarithm base e
		JZ	LOGE
		CPI	MTPWR		;10 to power X
		JZ	TENTOX
		CPI	MEXP		;exponential
		JZ	EXP
		CPI	MSQT		;square root
		JZ	SQRT
		CPI	MSIN		;sine
		JZ	RTRIG
		CPI	MCOS		;cosine
		JZ	RTRIG
		CPI	MTAN		;tangent
		JZ	RTRIG
		CPI	MASIN		;arcsine
		JZ	ASIN
		CPI	MACOS		;arccosine
		JZ	ACOS
		CPI	MATAN		;arctangent
		JZ	ATAN
;
COUP0Z:		XRA	A
		MVI	B,EUNK		;unknown function code
		MOV	C,A
		RET
;
;	End *COUPLE*
;
	PAGE
;
ABSV:		;Absolute value
;
;Programmed by C. E. Duncan 1981 December 23.
;
;--------------------------------------------------------------
;
;Input:	DE = address of source floating point number
;
;Output:	HL = address of result
;		 B = 0, return code
;
		PUSH	H
		LXI	B,FPLEN
		CALL	MOVE
		POP	H
		LXI	B,FPLM1
		DAD	B
		MVI	A,07FH		;reset sign bit
		ANA	M
		MOV	M,A
		MVI	B,0
		RET
;
;	End *ABSV*
;
	PAGE
;
ACOS:		;Calculate arccosine.
;
;Written by C. E. Duncan 1982 January 15.
;Revised 06:02 1982 April 19.
;
;--------------------------------------------------------------
;
;Input:	DE = address of floating point argument
;	HL = address for result
;
;Output:	B = result code
;
;--------------------------------------------------------------
;
		PUSH	H
;
;	Move to work area
;
		LXI	B,FPLEN
		LXI	H,ARCCT1L
		CALL	MOVE
;
;	Calculate arcsine of this argument
;
		LXI	D,ARCCT1L
		MOV	H,D
		MOV	L,E
		MVI	A,MASIN
		CALL	COUPLE
		XRA	A
		CMP	B
		JNZ	ARCC0Z
;
;	Complement angle for arcsine
;
		LXI	B,PIO2
		LXI	D,ARCCT1L
		POP	H		;destination
		MVI	A,DFSUB
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	ARCC0Z
;
		RET
;
;	Error return
;
ARCC0Z:		POP	H
		MVI	B,EARC
		RET
;
;	End *ACOS*
;
	PAGE
;
ASIN:		;Calculate arcsine.
;
;Written by C. E. Duncan 1982 January 15.
;Revised 08:30 1982 January 16.
;
;--------------------------------------------------------------
;
;	ARCSIN(X) = SGN(X) * (PI/2 - ARCTAN(SQRT(1 - X**2) / ABS(X)))
;
;Input:	DE = address of floating point argument
;	HL = address of result
;
;Output:	B = result code
;
;--------------------------------------------------------------
;
		PUSH	H
;
;	Move to temporary work area
;
		LXI	H,ARCST1L
		LXI	B,FPLEN
		CALL	MOVE
;
;	Check for zero input
;
		LXI	D,ARCST1L
		CALL	ZEROCHEK
		ORA	A
		JNZ	ARCS02
		POP	H
		MVI	A,0
		LXI	B,FPLEN
		CALL	MOVE
;
;	MVI	B,0
;
		RET
;
;	Check sign, set plus
;
ARCS02:		LXI	H,ARCST1
		MOV	A,M
		ANI	080H		;sign
		STA	ASSGN
		MOV	A,M
		ANI	07FH
		MOV	M,A
;
;	Check limits for ABS(X) = 1
;
		LXI	B,ARCST1L
		LXI	D,FPONEL
		MVI	A,DFCMP
		CALL	COUPLE
		MOV	A,C
		CPI	2
		JC	ARCS03		;ok, process
		JNZ	ARCS0Z		;> 1, undefined
;
;	Special cases
;
		POP	H
		PUSH	H
		LXI	D,PIO2
		LXI	B,FPLEN
		CALL	MOVE
		POP	H
		LXI	B,FPLM1
		DAD	B
		LDA	ASSGN
		ORA	M
		MOV	M,A
		MVI	B,0
		RET
;
;	ABS(X) < 1
;
ARCS03:		LXI	B,ARCST1L	;calculate X**2
		MOV	D,B
		MOV	E,C
		LXI	H,ARCST2L
		MVI	A,DFMUL
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	ARCS0Z
;
;
;	Calculate 1 - X**2
;
		LXI	B,FPONEL
		LXI	D,ARCST2L	;X**2
		MOV	H,D
		MOV	L,E
		MVI	A,DFSUB
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	ARCS0Z
;
;
;	Take square root
;
		LXI	D,ARCST2L
		MOV	H,D
		MOV	L,E
		MVI	A,MSQT
		CALL	COUPLE
		XRA	A
		CMP	B
		JNZ	ARCS0Z
;
;	Divide by ABS(X)
;
		LXI	B,ARCST2L
		LXI	D,ARCST1L
		MOV	H,D
		MOV	L,E
		MVI	A,DFDIV
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	ARCS0Z
;
;
;	Calculate ARCTAN of this argument
;
		LXI	D,ARCST1L
		LXI	H,ARCST2L
		MVI	A,MATAN
		CALL	COUPLE
		XRA	A
		CMP	B
		JNZ	ARCS0Z
;
;	Subtract from PIO2
;
		LXI	B,PIO2
		LXI	D,ARCST2L
		LXI	H,ARCST1L
		MVI	A,DFSUB
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	ARCS0Z
;
;
;	Set sign
;
		LDA	ASSGN
		LXI	H,ARCST1
		ORA	M
		MOV	M,A
;
;	Move to destination
;
		LXI	B,FPLEN
		LXI	D,ARCST1L
		POP	H
		CALL	MOVE
;
;	MVI	B,0
;
		RET
;
;	Arithmetic errors and out of bounds
;
ARCS0Z:		POP	H
		MVI	B,EARS
		RET
;
;	End *ASIN*
;
	PAGE
;
ATAN:		;Calculate arctantent.
;
;Written by C. E. Duncan 1982 January 15.
;Revised 21:40 1982 January 15.
;
;--------------------------------------------------------------
;
;Input:	DE = address of floating point argument, radians
;	HL = address for result
;
;Output:	B = result code
;
;--------------------------------------------------------------
;
;	Check for zero
;
		PUSH	H
		PUSH	D
		CALL	ZEROCHEK
		JNZ	ARCT01
		POP	D
		POP	H
		MVI	A,0
		LXI	B,FPLEN
		CALL	FILLCHAR
;
;	MVI	B,0
;
		RET
;
;	Reset flags
;
ARCT01:		XRA	A
		STA	A2FLG		;complement
		STA	A8FLG		;add PIO8
;
;	Move to work area
;
		POP	D
		LXI	H,TRGTMP1L
		LXI	B,FPLEN
		CALL	MOVE
;
;	Check sign
;
		LXI	H,TRGTMP1	;exponent byte
		MOV	A,M
		ANI	080H		;sign bit
		STA	ATSGN
		MOV	A,M		;set plus
		ANI	07FH
		MOV	M,A
;
;	Compare with TANPIO8
;
ARCT02:		LXI	B,TRGTMP1L	;X
		LXI	D,TANPIO8
		MVI	A,DFCMP
		CALL	COUPLE
		MOV	A,C
		CPI	2
		JC	ARCT03		;ok compute
;
;	Compare to TANPIO4 = 1
;
		LXI	B,TRGTMP1L	;X
		LXI	D,FPONEL
		MVI	A,DFCMP
		CALL	COUPLE
		MOV	A,C
		CPI	2
		JZ	ARCT02A		;special case
		JNC	ARCT02C		;more scaling
;
;	Set X := (X - TANPIO8)/(1 + X*TANPIO8), later add PIO8
;
		MVI	A,-1
		STA	A8FLG
		LXI	B,TRGTMP1L	;X
		LXI	D,TANPIO8
		LXI	H,TRGTMP2L
		MVI	A,DFSUB
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	ARCT0Z
;
		LXI	B,TRGTMP1L
		LXI	D,TANPIO8
		MOV	H,B
		MOV	L,C
		MVI	A,DFMUL
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	ARCT0Z
;
		LXI	B,TRGTMP1L	;X*TANPIO8
		LXI	D,FPONEL	;1
		MOV	H,B
		MOV	L,C
		MVI	A,DFADD
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	ARCT0Z
;
		LXI	B,TRGTMP2L	;X - TANPIO8
		LXI	D,TRGTMP1L	;1 + X*TANPIO8
		MOV	H,D
		MOV	L,E
		MVI	A,DFDIV
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	ARCT0Z
;
		JMP	ARCT03
;
;	Special case for ABS(X) = 1
;
ARCT02A:	POP	H
		PUSH	H
		LXI	D,PIO4
		LXI	B,FPLEN
		CALL	MOVE
		POP	H
		LXI	B,FPLM1
		DAD	B
		LDA	ATSGN
		ORA	M
		MOV	M,A
		MVI	B,0
		RET
;
;	X > TANPIO4 = 1, take reciprocal, then complement result
;
ARCT02C:	MVI	A,-1		;signal complement
		STA	A2FLG
		LXI	B,FPONEL	;1
		LXI	D,TRGTMP1L	;X
		MOV	H,D
		MOV	L,E
		MVI	A,DFDIV
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	ARCT0Z
;
		JMP	ARCT02
;
;	Calculate X**2
;
ARCT03:		LXI	B,TRGTMP1L	;X
		MOV	D,B
		MOV	E,C
		LXI	H,TRGTMP2L
		MVI	A,DFMUL
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	ARCT0Z
;
;
;	Calculate P(X**2)
;
		LXI	B,ACTCOEF+FPLM1	;coefficients #4963
		LXI	D,TRGTMP2
		LXI	H,TRGTMP3
		MVI	A,5
		CALL	POLYN
		XRA	A
		CMP	B
		JNZ	ARCT0Z
;
;	Calculate X*P(X**2)
;
		LXI	B,TRGTMP3L
		LXI	D,TRGTMP1L
		MOV	H,D
		MOV	L,E
		MVI	A,DFMUL
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	ARCT0Z
;
;
;	Check scaling
;
		LDA	A8FLG
		ORA	A
		JZ	ARCT04
;
;	add PIO8
;
		LXI	B,TRGTMP1L
		LXI	D,PIO8
		MOV	H,B
		MOV	L,C
		MVI	A,DFADD
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	ARCT0Z
;
;
;	Check complement
;
ARCT04:		LDA	A2FLG
		ORA	A
		JZ	ARCT05
;
;	Complement
;
		LXI	B,PIO2
		LXI	D,TRGTMP1L
		MOV	H,D
		MOV	L,E
		MVI	A,DFSUB
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	ARCT0Z
;
;
;	Check sign
;
ARCT05:		LDA	ATSGN
		LXI	H,TRGTMP1
		ORA	M
		MOV	M,A
;
;	Move result to destination
;
		LXI	B,FPLEN
		LXI	D,TRGTMP1L
		POP	H
		CALL	MOVE
;
;	MVI	B,0
;
		RET
;
;	Arithmetic error
;
ARCT0Z:		POP	H
		MVI	B,EACT
		RET
;
;	End *ATAN*
;
	PAGE
;
CMPEZRA:	;Replace non significant zeros and characters with blanks
;
;Written by C. E. Duncan 1981 November 1.
;Revised 10:50 1982 January 2.
;
;--------------------------------------------------------------
;
;Input:	DE = address of row of characters
;	B = length (count)
;
;Output:	DE = address of row (unchanged)
;		B = count (also unchanged)
;
;--------------------------------------------------------------
;
		PUSH	B
		MOV	H,D
		MOV	L,E
		MOV	C,B		;length
		DCR	C		;length - 1
		MVI	B,0
		DAD	B		;.HL = right end
		PUSH	D
		MVI	D,'0'		;for comparison
		MVI	E,' '		;for replacements
		INR	C		;count
;
;	Do exponent tens digit
;
		DCX	H		;tens digit
		DCR	C
		JZ	EZR06		;premature end
		MOV	A,D		;zero?
		CMP	M
		JNZ	EZR02		;leave non-zero digit
		MOV	M,E		;replace with blank
;
;	Shift back over exponent, leaving it present
;
EZR02:		DCX	H		;on "-" or "E" or "e"
		DCR	C
		JZ	EZR06		;premature end
		MVI	A,'-'
		CMP	M
		JNZ	EZR03
		DCX	H		;to "E" or "e"
		DCR	C
		JZ	EZR06		;premature end
;
EZR03:		MVI	A,'E'
		CMP	M
		JZ	EZR03A
		MVI	A,'e'
		CMP	M
		JNZ	EZR06
;
;	Process mantissa
;
EZR05:		DCX	H
		DCR	C
		JZ	EZR06		;premature end
		MOV	A,D		;check for zero
		CMP	M
		JNZ	EZR06
		MOV	M,E		;blank
		JMP	EZR05
;
EZR03A:		MVI	M,'e'		;convert to lower case
		JMP	EZR05
;
EZR06:		POP	D
		POP	B
		RET
;
;	End *CMPEZRA*
;
	PAGE
;
DELBLNK:	;Remove blanks from a row of characters.
		;Re-write row compacting to the left.
;
;Written by C. E. Duncan 1981 October 31.
;
;--------------------------------------------------------------
;
;Input:	DE = address of row of characters
;	B = count
;
;Output:	DE = address of row (unchanged)
;		B = updated count
;
;Registers:	uses A, updates B, saves remainder
;
;--------------------------------------------------------------
;
;	Check for zero length input
;
		XRA	A
		CMP	B
		RZ
		PUSH	B
		PUSH	D
		PUSH	H
		MOV	H,D		;HL pointer in revised string
		MOV	L,E
		MVI	C,0		;result count
		INR	B		;count + 1
;
DELB01:		DCR	B		;count
		JZ	DELB03		;no more left
		LDAX	D		;examine a character
		CPI	' '		;is it blank?
		JZ	DELB02		;yes, skip it
		MOV	M,A		;non-blanks I keep
		INX	H		;next of input
		INR	C		;count what is kept
;
DELB02:		INX	D		;next input character
		JMP	DELB01
;
DELB03:		MOV	A,C		;save new count
		POP	H		;restore all
		POP	D
		POP	B
		MOV	B,A		;update count
		RET
;
;	End *DELBLNK*
;
	PAGE
;
DELZERO:	;Replace zeros from the right (non-significant) with blanks in a
		; row of characters, presumably ASCII decimal digits.  Leave at
		; least one digit after the decimal point.  Replace all leading
		; zeros with blanks.
;
;Revised 12:30 1982 January 1
;
;--------------------------------------------------------------
;
;Input:	DE = address of row of characters
;	B = count
;
;Output:	DE = address of row (unchanged)
;		B = count of remaining (significant) characters
;
;Registers:	uses A, updates B, preserves remainder
;
;--------------------------------------------------------------
;
;	Check for zero length input
;
		XRA	A
		CMP	B
		RZ
		PUSH	H		;save status
		PUSH	D
		PUSH	B
		XCHG			;row address to HL
;
;	Remove leading zeros
;
		PUSH	H
		MVI	A,'-'		;skip minus sign
		CMP	M
		JNZ	DELZ06
		INX	H
;
DELZ06:		MVI	A,'0'
		CMP	M
		JNZ	DELZ07
		MVI	M,' '		;replace with blank
		INX	H
		JMP	DELZ06
;
DELZ07:		POP	H
		MOV	C,B		;set pointer to right
		DCR	C		; end of row
		MVI	B,0
		DAD	B
		INR	C		;count
		MOV	B,C		;save in B
		INR	C		; + 1
;
DELZ01:		DCR	C		;count
		JZ	DELZ03		;row exhausted
		MOV	A,M		;examine
		CPI	'0'
		JNZ	DELZ05		;no more zeros to throw away
		MVI	A,' '		;replace with blank
		MOV	M,A
		DCX	H		;point to next
		JMP	DELZ01
;
DELZ02:		MOV	A,C		;save remaining count
		POP	B		;update count
		MOV	B,A
		JMP	DELZ04		;return to caller
;
;	String is all zeros, leave one
;
DELZ03:		INX	H		;recover position
		MVI	M,'0'		;replace zero
		POP	B
		MVI	B,1		;reset count
;
DELZ04:		POP	D
		POP	H
		RET
;
;	Throw away decimal if terminal
;
DELZ05:		MVI	A,'.'
		CMP	M
		JNZ	DELZ02
		MVI	M,' '
		JMP	DELZ02
;
;	End *DELZERO*
;
	PAGE
;
DEROUND:	;Round ASCII number to nearest cent (hundredth) in "D" format.  Ashley
		; will leave either three figures after decimal, or none in case of
		; integer.
;
;Revised 06:14 1982 April 19.
;
;	Find decimal point
;
		MOV	H,D		;field address to HL to work
		MOV	L,E
		MVI	B,0		;count
		DCX	H		;location - 1
;
DRND01:		INX	H		;next position
		INR	B		;count
		MVI	A,'.'
		CMP	M
		JNZ	DRND01
;
;	Check for digits after decimal point
;
		INX	H
		INR	B
		MVI	A,' '
		CMP	M
		JNZ	DRND03
;
;	No figures after decimal:  put two zeros
;
		INX	H
		INR	B
		MVI	M,'0'
		INX	H
		INR	B
		MVI	M,'0'
		RET
;
;	Check thousandths digit
;
DRND03:		INX	H
		INR	B
		INX	H
		INR	B
		MVI	A,'4'
		CMP	M
		MVI	M,' '		;blank out last digit
		DCR	B
		RNC			;finished
;
;	Round
;
DRND04:		DCX	H
		MVI	A,'.'		;skip decimal if present
		CMP	M
		JNZ	DRND05
		DCX	H
;
DRND05:		MVI	A,'9'		;if nine, must replace with 0
		CMP	M		; and round next preceding digit
		JNZ	DRND06
		MVI	M,'0'
		JMP	DRND04
;
DRND06:		MVI	A,' '		;if blank this is start of number,
		CMP	M		; equivalent to 0, replace with 1
		JZ	DRND07
		MVI	A,'-'		;minus sign
		CMP	M
		JZ	DRND08
		INR	M		;add in carry
		RET
;
DRND07:		MVI	M,'1'
		RET
;
;	Move minus sign over one to left to make room for digit 1
;
DRND08:		MVI	M,'1'
		DCX	H
		MVI	M,'-'
		RET
;
;	End *DEROUND*
;
	PAGE
;
DIFF2:		;Calculate 16-bit difference of numbers in DE and HL.
		;  Put absolute value of difference in HL.  Set register A
		;  to -1, 0, or +1 as (HL - DE) is negative, zero or positive.
		;  Set carry if difference is not zero, else reset.
		;Preserves registers BC.
;
;Copyright 1979, 1980 by C. E. Duncan.
;Revised 12:50 1980 April 20.
;
		PUSH	B		; save
		MOV	A,D
		CMP	H
		JC	DIF3		; DE < HL
		JZ	DIF1		; further test
		JMP	DIF2		; DE > HL
;
DIF1:		MOV	A,E
		CMP	L
		JC	DIF3		; DE < HL
		JZ	DIF5		; DE = HL
;
DIF2:		MVI	B,-1		; DE > HL
		XCHG
		JMP	DIF4
;
DIF3:		MVI	B,1		; DE < HL
;
;	Do subtraction
;
DIF4:		MOV	A,L
		SUB	E
		MOV	L,A
		MOV	A,H
		SBB	D
		MOV	H,A
		MOV	A,B		;replace signal
		STC			;signal not zero
		POP	B		;restore
		RET
;
DIF5:		;HL = DE
		XRA	A		;zero, reset carry
		MOV	H,A
		MOV	L,A
		POP	B		;restore
		RET
;
;	End *DIFF2*
;
	PAGE
;
DIV122:		;Divide 16-bit NUMber in HL by 8-bit SHORT NUMber in A.
;
; Copyright C. E. Duncan 1980.
; Revised 09:30 1980 October 4.
;
;--------------------------------------------------------------
;
;Input:	HL = 16-bit binary number
;	 A = 8-bit divisor
;
;Output:	HL = 16-bit quotient
;		E = 8-bit remainder
;		Carry set for zero divisor, else reset
;
;--------------------------------------------------------------
;
		ORA	A		; check zero divisor
		JNZ	DIV122A		; ok
		STC			; abort
		RET
;
DIV122A:	MOV	C,A		; divisor
		MVI	E,0		; partial dividend
		MVI	B,17		; bit count
;
DIV122B:	;count
		DCR	B
		JZ	DIV122E		; finished
;
;	Shift registers EHL left together
;
		XRA	A		; clear carry
		MOV	A,E		; first shift E
		RAL
		MOV	E,A
		DAD	H		; then HL
		JNC	DIV122C		; take care of
		INR	E		;   carry
;
DIV122C:	MOV	D,E		;save partial dividend
		MOV	A,E		;try subtraction
		SUB	C
		JP	DIV122D		; succeed
		MOV	E,D		; restore old dividend
		JMP	DIV122B		; continue
;
DIV122D:	MOV	E,A		; new partial dividend
		INX	H		; next quotient digit
		JMP	DIV122B		; continue
;
DIV122E:	XRA	A		; signal ok
		RET
;
;	End *DIV122*
;
	PAGE
;
EEROUND:	;Fit "E" format to given field size if possible.
;
;Written by C. E. Duncan 1982 January 2.
;Revised 21:54 1982 January 3.
;
;--------------------------------------------------------------
;
;Input:	DE = address of compressed "E" format string
;	 B = length
;	 C = field width
;
;Output:	DE = address of string
;		B = return code
;		C = length
;
;--------------------------------------------------------------
;
;	Account for minus sign
;
		LXI	H,0
		LDAX	D
		CPI	'-'
		JNZ	EER0C
		MVI	L,-1
		INX	D
		DCR	C
		DCR	B
;
;	Save lengths
;
EER0C:		PUSH	H		;save sign flag
		PUSH	B		;save counts
;
;	Check if integer followed by decimal followed by "E".  If so,
;	omit the decimal
;
		MOV	H,D
		MOV	L,E
		INX	H		;past first digit
		MVI	A,'.'
		CMP	M
		JNZ	EER0B		;ok as is, no decimal
		INX	H		;digit or "E"
		MVI	A,'e'
		CMP	M
		JZ	EER0A
		MVI	A,'E'
		CMP	M
		JNZ	EER0B
;
;	Eliminate decimal
;
EER0A:		DCX	H		;back to decimal
		MVI	M,' '
		CALL	DELBLNK
		MOV	A,B		;update N
		POP	B
		MOV	B,A
		PUSH	B
;
;	Check fit
;
EER0B:		MOV	A,C
		CMP	B
		JC	EER01		;need compression
		POP	B
		MOV	C,B		;take lesser size for return
		MVI	B,0		;return code
		POP	H
		MOV	A,L
		ORA	A
		RZ
		DCX	D
		INR	C
		RET
;
;	Try to reduce size
;
EER01:		;Locate exponent
		MOV	H,D
		MOV	L,E
		MOV	C,B
		MVI	B,0
		DCX	H
;
EER02:		INX	H
		INR	B
		MVI	A,'E'
		CMP	M
		JZ	EER03
		MVI	A,'e'
		CMP	M
		JZ	EER03
		MOV	A,B
		CMP	C
		JC	EER02
		JMP	EER13		;error, no "E"
;
;	Calculate new N and W without exponent
;
EER03:		DCR	B
		MOV	H,B		;N - E
		POP	B
		PUSH	B
		MOV	A,B		;N
		SUB	H
		MOV	L,A		;E  exponent length
		STA	EXPSAV
		MOV	B,H		;N - E
		MOV	A,C
		SUB	L
		JC	EER13		;too small
		MOV	C,A		;W - E
;
;	Save exponent for later
;
		PUSH	B
		PUSH	D
		PUSH	H
		XCHG			;point DE to exponent
		MOV	C,B
		MVI	B,0
		DAD	B
		XCHG
		LXI	H,EXPSAV+1	;to
		LDA	EXPSAV		;count
		MOV	C,A
		MVI	B,0
		CALL	MOVE
		POP	H
		POP	D
		POP	B
;
;	Try rounding
;
		MOV	H,D
		MOV	L,E
		MVI	A,'9'
		CMP	M
		JNZ	EER04		;ok, normal process
		INX	H
		MVI	A,'.'		;skip decimal
		CMP	M
		JNZ	EER04A
		INX	H
;
EER04A:		MVI	A,'e'
		CMP	M
		JZ	EER04
		MVI	A,'E'
		CMP	M
		JZ	EER04
		MVI	A,'4'
		CMP	M
		JC	EER05		;special round
;
EER04:		PUSH	D
		CALL	GEROUND
		POP	D
		XRA	A
		CMP	B
		JNZ	EER13		;trouble
;
;	Re-attach exponent
;
		PUSH	B
		PUSH	D
		PUSH	H
		XCHG			;origin to HL
		DAD	B		;start of exponent
		LXI	D,EXPSAV+1	;from
		LDA	EXPSAV		;count
		MOV	C,A
		MVI	B,0
		CALL	MOVE
		POP	H
		POP	D
		POP	B
		LDA	EXPSAV
		ADD	C
		POP	B
		MOV	C,A
		MVI	B,0
		POP	H
		MOV	A,L
		ORA	A
		RZ
		DCX	H
		INR	C
		RET
;
;	Overflow special rounding
;
EER05:		PUSH	D
		MVI	A,1
		CMP	C
		JC	EER06
		MVI	C,2
;
EER06:		CALL	GEROUND
		XRA	A
		CMP	B
		JNZ	EER13
		LDA	EXPSAV		;save new length
		ADD	C
		PUSH	PSW
;
;	Attach exponent
;
		PUSH	B
		PUSH	D
		PUSH	H
		XCHG
		DAD	B		;destination
		LXI	D,EXPSAV+1
		LDA	EXPSAV
		MOV	C,A
		MVI	B,0
		CALL	MOVE
		POP	H
		POP	D
		POP	B
;
;	Terminate new number
;
		MOV	H,D
		MOV	L,E
		POP	PSW
		MOV	C,A
		MVI	B,0
		DAD	B
		MVI	M,' '
		POP	H		;reverse top two stack items
		XTHL
		PUSH	H
		LXI	H,TENTMP4	;convert to float and back
		POP	B		;recover counts
		PUSH	B
		MVI	A,CASCF
		CALL	COUPLE
		MOV	A,C
		POP	B
		MOV	B,A
		POP	D
		XCHG
		LXI	D,TENTMP4
		MVI	A,CEFMT
		CALL	COUPLE
		POP	H
		MOV	A,L
		ORA	A
		RZ
		DCX	D
		INR	C
		RET
;
EER13:		POP	B		;clear stack
		POP	H
		MVI	B,EEER
		RET
;
;	End *EEROUND*
;
	PAGE
;
EXP:		;Exponential:  E to the power X.
;
;Written by C. E. Duncan 1982 January 6.
;Revised 06:24 1982 April 19.
;
;--------------------------------------------------------------
;
;Input:	DE = addresss of source floating point number
;	HL = address of result
;
;Output:	B = result code
;
;--------------------------------------------------------------
;
		PUSH	H
		XCHG
		LXI	B,FPLM1
		DAD	B
		MOV	B,H
		MOV	C,L
		LXI	D,LOGEX
		LXI	H,TEMP1
		CALL	FDIV
		POP	H
		LXI	D,TEMP1L
		CALL	TENTOX
		RET
;
;	END *EXP*
;
	PAGE
;
FILLCHAR:	;Fill sequential bytes in memory with given byte.
		;Leave with (A) = (B) = (C) = 0, HL pointing to last position filled.
;
;Written by C. E. Duncan 1981 May 31.
;Revised 11:50 1981 October 17
;
;Part of DUMP1 Version C
;
;--------------------------------------------------------------
;
;Input:	HL = address of memory to be filled
;	BC = number of bytes to be filled
;	A = filler byte
;
;Output:	Area filled with given byte
;		HL = address of last byte filled
;		A = B = C = 0
;
;Register E not disturbed
;
;--------------------------------------------------------------
;
		MOV	D,A		;fill character
		MOV	A,B		;check for zero length
		ORA	C
		RZ			;nothing to do
;
FILL01:		MOV	M,D
		DCX	B
		MOV	A,B
		ORA	C
		RZ
		INX	H
		JMP	FILL01
;
;	End *FILLCHAR*
;
	PAGE
;
GEROUND:	;Fit "G" format ASCII into field of given width, rounding as necessary.
;
;Written by C. E. Duncan 1981 December 31.
;Revised 16:54 1982 March 24
;
;--------------------------------------------------------------
;
;Input:	DE = address of compressed ASCII "G" number
;	 B = current length
;	 C = required maximum field width
;
;Output:	DE = Address of string
;		B = return code
;		C = length of returned string
;
;--------------------------------------------------------------
;
;	Check for fit
;
		MOV	A,C
		CMP	B
		JC	GER01		;need trimming, too long as is
		MOV	C,B		;return length
		MVI	B,0		;ok
		RET
;
;	Must reduce length if possible
;
GER01:		STA	GERW1		;save width
		MOV	A,B		;save length
		STA	GERN1
		XRA	A		;reset integer flag
		STA	GERF1
;
;	Locate decimal point
;
		MOV	H,D		;address to HL
		MOV	L,E
		MOV	C,B		;string length
		MVI	B,0		;counter
		DCX	H		;location - 1
;
GER02:		INX	H		;next
		INR	B		;count
		MVI	A,'.'
		CMP	M
		JZ	GER03		;found decimal
		MOV	A,B		;check position
		CMP	C
		JC	GER02
;
;	Reached end of number, no decimal hence integer, too big, abort
;
		JMP	GER13
;
;	Found a decimal in number, is it within desired field width?
;
GER03:		LDA	GERW1		;field width
		CMP	B
		JNC	GER04		;ok, within field
;
;	If decimal is just one position past, may still be ok
;
		INR	A
		CMP	B
		JNZ	GER13		;no luck, too big
		MVI	A,-1		;signal integer
		STA	GERF1
;
;	Have possible fit. Prepare to round
;
GER04:		MOV	H,D		;start address to HL
		MOV	L,E
		LDA	GERW1		;W
		MOV	C,A
		MVI	B,0
		DAD	B		;WORD[W+1]
		MVI	A,'.'
		CMP	M
		JZ	GER04A
		MOV	A,C
		INR	A		;K = W + 1
		JMP	GER04C
;
GER04A:		LDA	GERN1		;N
		MOV	B,A
		MOV	A,C		;W
		INR	A		;W + 1
		CMP	B
		JNC	GER12C		;ok integer as is, drop decimal
		INR	A		;K = W + 2
;
;	Check digit for rounding
;
GER04C:		MOV	H,D		;start address
		MOV	L,E
		DCR	A
		MOV	C,A
		MVI	B,0
		DAD	B		;HL is addess of WORD[K]
		MOV	A,M
		CPI	'5'
		JC	GER14		;ok to truncate
		INR	C		;restore K
;
;	Now do rounding on WORD[1:K]
;
GER06:		DCR	C		;count
		JZ	GER09		;at start of field
		DCX	H		;next digit to examine
		MVI	A,'.'		; but skip decimal
		CMP	M
		JNZ	GER07
		DCR	C
		JZ	GER09
		DCX	H
;
GER07:		MVI	A,'9'		;if 9, must replace with 0
		CMP	M		; and go to next on left
		JNZ	GER08
		MVI	M,'0'
		JMP	GER06
;
GER08:		MVI	A,'-'
		CMP	M
		JZ	GER09
		INR	M		;add carry, finished
		JMP	GER12C
;
;	Must move number one place to right, drop last digit, so can insert
;	leading digit 1.
;
GER09:		LDA	GERF1		;check integer flag
		ORA	A
		JNZ	GER13		;will overflow
;
;	Move string over one position to right
;	FOR i TO w - 1 DO word[i + 1] := word[i]
;
		PUSH	D		;from
		PUSH	B
		MOV	H,D
		MOV	L,E
		INX	H		;to
		LDA	GERW1		;count
		MOV	C,A
		DCR	C
		MVI	B,0
		CALL	MOVE
		POP	B
		POP	D
		MOV	H,D		;address word[1]
		MOV	L,E
;
;	Write 1
;
		MVI	A,'-'
		CMP	M
		JNZ	GER10
		INX	H		;dont overwrite minus
;
GER10:		MVI	M,'1'
		JMP	GER12C		;finished
;
;	If zero as result of truncating, must return failure.
;
GER12:		MOV	H,D		;1st char of result
		MOV	L,E
		LDA	GERW1		;field width
		MOV	B,A		; to B
;
GER12A:		MVI	A,'.'		;zero?
		CMP	M
		JZ	GER12B		;yes
		MVI	A,'0'		;skip decimal
		CMP	M
		JNZ	GER12C		;found non-zero digit in number
;
GER12B:		DCR	B		;count
		JZ	GER13		;all zero, fail
		INX	H		;check next char
		JMP	GER12A
;
GER12C:		MVI	B,0		;signal ok
		LDA	GERW1		;width to C
		MOV	C,A
		RET
;
;	No fit return
;
GER13:		MVI	B,EGER
		RET
;
;	Check for lone decimal
;
GER14:		MOV	H,D
		MOV	L,E
		MVI	A,1
		CMP	C
		JC	GER12
		MVI	A,'.'
		CMP	M
		JNZ	GER12
		MVI	M,'0'
		JMP	GER12
;
;	End *GEROUND*
;
	PAGE
;
LOG10:		;Calculate logarithm to base ten.
;
;Written by C. E. Duncan 1982 January 4.
;Revised 06:36 1982 April 19.
;
;--------------------------------------------------------------
;
;Input:	DE = address of floating point number source
;	HL = address for floating point result
;
;Output:	B = result code
;
;--------------------------------------------------------------
;
		CALL	ZEROCHEK	;zero?
		ORA	A
		JNZ	LOG101
		MVI	B,ELT0		;report zero
		RET
;
LOG101:		XCHG			;negative?
		LXI	B,FPLM1		;point to exponent byte
		DAD	B
		MOV	A,M		;exponent
		ORA	A
		JP	LOG102
		MVI	B,ELTN		;report negative
		RET
;
;	Point to exponents, save, get fraction part = F
;
LOG102:		PUSH	D		;save destination address
		PUSH	PSW		;save exponent
		LXI	B,-FPLM1	;restore source
		DAD	B
		XCHG			;move number from source to temp
		LXI	B,FPLEN
		LXI	H,TEMP1L
		CALL	MOVE
		LXI	H,TEMP1		;address exponent
		MVI	M,40H		;set exponent to give fraction F
		XCHG			;F to DE
;
;	Have .1 <= F < 1, calculate S = F*SQRT(10)
;
		LXI	H,TEMP2		;for S
		LXI	B,SQT10		;square root of ten
		CALL	FMUL
;
;	ORA	A
;	JNZ	LOGERR
;
;
;	Have 1/SQRT(10) <= S < SQRT(10), calculate Z = (S-1)/(S+1)
;
		MOV	B,H		;S
		MOV	C,L
		LXI	D,FPONE
		LXI	H,TEMP3
		CALL	FADD		;S + 1
;
;	ORA	A
;	JNZ	LOGERR
;
		LXI	H,TEMP1
		CALL	FSUB		;S - 1
;
;	ORA	A
;	JNZ	LOGERR
;
		LXI	B,TEMP1		;S - 1
		LXI	D,TEMP3		;S + 1
		LXI	H,TEMP2		;Z = (S-1)/(S+1)
		CALL	FDIV
;
;	ORA	A
;	JNZ	LOGERR
;
		XCHG
		MOV	B,D		;Z in BC and DE
		MOV	C,E
		LXI	H,TEMP1		;Z**2
		CALL	FMUL
;
;	ORA	A
;	JNZ	LOGERR
;
		LXI	B,LOGCOEF+FPLM1	;polynomial coefficients
		XCHG			;Z**2 in DE
		LXI	H,TEMP3		;P(Z**2)
		MVI	A,6		;poly # 2285
		CALL	POLYN
		XRA	A
		CMP	B
		JNZ	LOGERR
		LXI	B,TEMP2		;Z
		XCHG			;P(Z**2) in DE
		LXI	H,TEMP1		;Z*P(Z**2)
		CALL	FMUL
;
;	ORA	A
;	JNZ	LOGERR
;
		MOV	B,H		;Z*P(Z**2)
		MOV	C,L
		LXI	D,FPHALF
		LXI	H,TEMP2
		CALL	FSUB
;
;	ORA	A
;	JNZ	LOGERR
;
		POP	PSW		;recover exponent
		SUI	040H
		MOV	E,A
		MVI	D,0
		JP	LOG103
		MVI	D,-1		;set sign minus
;
LOG103:		LXI	H,TEMP3L	;power of ten = N
		CALL	RFLOT		;convert to floating point
		LXI	D,TEMP2
		POP	H		;final destination
		LXI	B,FPLM1
		DAD	B
		LXI	B,TEMP3
		CALL	FADD
;
;	ORA	A
;	JNZ	LOGERR1
;
		MVI	B,0		;ok return code
		RET
;
LOGERR:		POP	PSW		;clear stack
		POP	H
;
LOGERR1:	MVI	B,ELTA		;arithmetic error
		RET
;
;	End *LOG10*
;
	PAGE
;
LOGE:		;Calculate the logarithm to the base e.
;
;Written by C. E. Duncan 1981 January 6.
;
;--------------------------------------------------------------
;
;Input:	DE = address of source number
;	HL = address of result
;
;Output:	B = result code
;
;--------------------------------------------------------------
;
		PUSH	H
		LXI	H,TEMP1L
		CALL	LOG10
		XRA	A
		CMP	B
		POP	H
		RNZ
		LXI	B,FPLM1
		DAD	B
		LXI	D,TEMP1
		LXI	B,LOGEX
		CALL	FMUL
		MOV	B,A
		RET
;
;	End *LOGE*
;
	PAGE
;
INT2STR:	;Convert 16-bit integer in HL to ASCII string at location (BC) of
		; length six bytes including sign. -32767 to +32767.
;
;Written by C. E. Duncan 1982 January 6.
;Revised 09:40 1982 March 25.
;
;--------------------------------------------------------------
;
;Input:	HL = 16-bit integer
;	BC = address of six byte area
;
;Output:	ASCII representation of integer at location (BC)
;		BC = address of string (unchanged)
;
;Calls to:	DIV122
;
;--------------------------------------------------------------
;
;	Check for zero
;
		MOV	A,H
		ORA	L
		JNZ	INTR02
		MVI	D,6
		MVI	A,' '
		STAX	B
		INX	B
		DCR	D
		MVI	A,'0'
;
INTR01:		STAX	B
		INX	B
		DCR	D
		JNZ	INTR01
		RET
;
;	Sign goes into first space
;
INTR02:		MOV	A,H		;check sign
		ORA	A
		PUSH	PSW
		MVI	A,'-'
		JM	INTR03
		MVI	A,'+'
;
INTR03:		STAX	B
		INX	B
;
;	Complement if negative, put into register HL
;
		POP	PSW
		JP	INTR04
		MOV	A,D
		CMA
		MOV	D,A
		MOV	A,E
		CMA
		MOV	E,A
		INX	D
		XCHG
;
;	Set byte after number to blank to stop Ashley scan, then point BC
;	to last digit position
;
INTR04:		INX	B
		INX	B
		INX	B
		INX	B
		INX	B
		MVI	A,' '
		STAX	B
		DCX	B
;
;	Convert
;
		MVI	A,5		;output digit count
;
INTR05:		PUSH	PSW		;save it
		PUSH	B
		MVI	A,10		;divisor
		CALL	DIV122		;quotient in HL, remainder in E
		MOV	A,E		;convert to ASCII
		ADI	'0'
		POP	B		;store in destination
		STAX	B
		DCX	B		;point to next position
		POP	PSW		;count
		DCR	A
		JNZ	INTR05
		RET
;
;	End *INT2STR*
;
	PAGE
;
MOVE:		;Move a string of length in BC from location in DE to location in HL.
		;  Will not overwrite for overlapping move.
;
;Written by C. E. Duncan 1980 February 28.
;
;--------------------------------------------------------------
;
;Input:	DE = address of source
;	HL = address of destination
;	BC = count
;
;Output:	A = 0
;		Move down:  DE = address of last byte + 1 of source
;		HL = address of last byte + 1 of destination
;		Move up:  DE = address of 1st byte of source
;		HL = address of 1st byte of destination
;
;Calls to:	DIFF2
;
;--------------------------------------------------------------
;
		MOV	A,B		;check zero length
		ORA	C
		RZ
		PUSH	H		;save registers
		PUSH	D
		PUSH	B
		CALL	DIFF2		;check direction of move
		POP	B
		POP	D
		POP	H
		ORA	A
		RZ		;no move, same place
		JM	MOVE02
;
;	move up, high byte first
;
		DAD	B		;get top address+1
		XCHG
		DAD	B
		XCHG
;
MOVE01:		DCX	D		;get next byte
		DCX	H
		LDAX	D		;from DE
		MOV	M,A		;to HL
		DCX	B		;count
		MOV	A,C
		ORA	B
		JNZ	MOVE01
		RET
;
;	Move down, low byte first
;
MOVE02:		LDAX	D		;next byte
		MOV	M,A
		INX	D
		INX	H
		DCX	B
		MOV	A,C
		ORA	B
		JNZ	MOVE02
		RET
;
;	End *MOVE*
;
	PAGE
;
POLYN:		;Polynomial evaluator
;
;Transcribed from Ashley by C. E. Duncan
; 1981 December 17.
;Revised 13:00 1981 December 26.
;Revised 06:40 1982 April 19.
;
;-------------------------------------------------------------
;
;Input:	BC - coefficient list address, exponent byte
;	DE - argument X address, exponent byte
;	HL - result address, exponent byte
;	 A - order of polynomial
;
;Output:	DE - argument address
;		HL - result address
;		B = return code
;
;All values are in Ashley's floating point format, length FPLEN.
; Addresses are to the exponent byte (right end of number).
;
;-------------------------------------------------------------
;
		MVI	M,0		;result exponent to zero
;
POLYN1:		STA	PSIZE		;N
		PUSH	B		;coef
		MOV	B,H		;result addr to BC
		MOV	C,L
		CALL	FMUL		;result * X
;
;	ORA	A
;	JNZ	POLYN2
;
		POP	B		;coef
		PUSH	D		;X
		MOV	D,H		;result + coef
		MOV	E,L
		CALL	FADD
;
;	ORA	A
;	JNZ	POLYN2
;
		LXI	H,FPLEN		;get addr next coef
		DAD	B
		MOV	B,H
		MOV	C,L
		XCHG			;result addr to HL
		POP	D		;X
		LDA	PSIZE
		DCR	A
		JP	POLYN1
		MVI	B,0		;set return code ok
		RET
;
POLYN2:		MVI	B,EPOL		;error
		RET
;
;	End *POLYN*
;
	PAGE
;
R8FXP:		;Convert floating point non-negative integer to 8-bit unsigned number.
;
;Written by C. E. Duncan 1982 January 17.
;Revised 06:45 1982 April 19
;
;--------------------------------------------------------------
;
;Input:	DE = address (left end) of floating point integer
;
;Output:	C = 8-bit unsigned number, 0 to 255
;		B = return code
;
;--------------------------------------------------------------
;
;	Convert to two-byte binary integer in HL
;
		CALL	RFXFP
		XRA	A
		CMP	B
		RNZ			;overflow
		CMP	H
		JNZ	R8FX01		;too large
		MOV	C,L		;return number in C
		RET
;
R8FX01:		MVI	B,E8FX		;report overflow
		RET
;
;	End *R8FXP*
;
	PAGE
;
RASCF:		;Convert ASCII to float
;
;Revised 08:37 1982 January 6.
;
;--------------------------------------------------------------
;
;Input:	DE = Address of ASCII argument, left
;	HL = Address of resulting floating point number
;
;Output:	B = return code
;		C = number characters scanned
;
;Ashley input:	DE = left address of ASCII argument
;		HL = right address of FP result
;
;Ashley output:	 DE points two past last character converted
;		HL = right address of FP result
;		A = return code (set by CED)
;
;--------------------------------------------------------------
;
		PUSH	H		;save FP left address
;
;	Scan past leading blanks
;
		DCX	D
;
CX01:		INX	D
		LDAX	D
		CPI	' '
		JZ	CX01
		PUSH	D		;save ASCII left address
;
;	Check for the case 0E, not caught by Ashley.
;
		LDAX	D		;1st input character
		CPI	'0'
		JZ	CX04
		CPI	'-'
		JZ	CX03
		CPI	'+'
		JZ	CX02
		JMP	CX05		;ok for Ashley
;
;	Leading '+' sign
;
CX02:		INX	D		;next character
		LDAX	D
		CPI	'0'
		JZ	CX04
		CPI	'-'
		JZ	CX03
		CPI	'+'
		JZ	CX02
		CPI	' '
		JZ	CX01
		JMP	CX05		;to Ashley
;
;	Leading '-' sign
;
CX03:		INX	D
		LDAX	D
		CPI	'0'
		JZ	CX04
		CPI	'-'
		JZ	CX03
		CPI	'+'
		JZ	CX02
		CPI	' '
		JZ	CX01
		JMP	CX05
;
;	Leading zeros
;
CX04:		INX	D		;ignore leading zeros
		LDAX	D
		CPI	'0'
		JZ	CX04
		CPI	'E'
		JZ	CX04A
		CPI	'e'
		JNZ	CX05		;assume digits, ok to Ashley
;
;	Have '0E', the case which Ashley mis-interprets. Return a zero in the
;	result, a two return code (ok), and a zero scan length.
;	Ashley never gets to this number, but rather it is converted here.
;
CX04A:		POP	D		;clear stack
		POP	H		;retrieve result address
		PUSH	H
		XRA	A		;zero
		LXI	B,FPLEN
		CALL	FILLCHAR	;set number to zero
		POP	H		;retrieve address
		LXI	B,0		;set return code and length
		RET
;
;	Pass parameters to Ashley
;
CX05:		POP	D		;restore input address to DE
		PUSH	D
		LXI	B,FPLM1		;adjustment to end of field
		DAD	B		;result field
		CALL	FPCNV		;call Ashley
		MOV	B,A		;return code
		POP	H		;ASCII left address
		XCHG			; then to DE, while end scan to HL
		CALL	DIFF2		;result in HL (preserves BC)
		DCR	L		;too large by 1
		MOV	C,L		;count of characters processed
		POP	H		;recover FP address
		RET
;
;	End *RASCF*
;
	PAGE
;
RATN:		;Evaluate rational polynomial function. Adapted from Ashley by
;
;C. E. Duncan 1981 December 17.
;Revised 14:15 1981 December 28.
;
;-------------------------------------------------------------
;
;Input:	BC - coefficient list, numerator before denominator
;	DE - Argument and result exponent address
;	 H - N, order of numerator
;	 L - D, order of denominator
;
;Output:	B = return code
;
;All numbers in Ashley's floating point format, length FPLEN.
;Addresses are to the exponent byte (right end).
;
;--------------------------------------------------------------
;
		MOV	A,H		;N
		PUSH	H
		LXI	H,TEMP1		;for numerator
		CALL	POLYN
		ORA	A
		JNZ	RATN1
		POP	H
		MOV	A,L		;D
		LXI	H,TEMP2		;for denominator
		CALL	POLYN
		ORA	A
		JNZ	RATN1
		XCHG			;D to DE
		LXI	B,TEMP1		;N to HL
		CALL	FDIV
		ORA	A
		RZ			;ok
;
RATN1:		MVI	A,ERAT		;error
		RET
;
;	END *RATN*
;
	PAGE
;
RDFMT:		;Convert floating point number to fixed decimal (D) format, to display
		; dollars and cents calculations.
;
;--------------------------------------------------------------
;
;Arrive here with DE = address of FP source, HL ASCII destination.
;
;Ashley input:	DE = right address ASCII output, set to blanks
;		HL = right address of FP input argument
;		(HL)+1 = address of field length
;		(HL)+2 = address of precision
;
;--------------------------------------------------------------
;
;	Check for zero input
;
		CALL	ZEROCHEK
		ORA	A
		JNZ	DXR01
;
;	Return a suitable zero
;
		MVI	M,'0'
		INX	H
		MVI	M,'.'
		INX	H
		MVI	M,'0'
		INX	H
		MVI	M,'0'
		LXI	B,4
		RET
;
DXR01:		XCHG
		PUSH	H		;source
;
;	Check maximum size
;
		LXI	B,FPLM1
		DAD	B
		MOV	A,M
		ANI	7FH		;remove sign bit
		CPI	4AH		;E 9 max
		JC	DXR02
		MVI	B,EDNN		;too big
		MVI	C,0
		POP	H		;clear stack
		RET
;
;	Clear receiving field to blank
;
DXR02:		POP	H
		PUSH	D
		PUSH	H
		XCHG
		LXI	B,DFLEN		;max field size for dollar
		MVI	A,' '
		CALL	FILLCHAR
;
;	Put input FP number into local storage so can enter N & M after
;
		POP	D		;from source in DE
		LXI	H,FNBUF		;to
		LXI	B,FPLEN		;count
		CALL	MOVE
;
;	Set sizes for M and N suitable for dollar figures
;
		LXI	H,FNBUF+FPLEN	;next byte after exponent
		MVI	M,DFLEN		;N
		INX	H
		MVI	M,DIGS		;M
		DCX	H		;point to exponent byte
		DCX	H
		POP	D		;destination
		PUSH	D
		CALL	FORMT		;call Ashley routine
		POP	D
		ORA	A		;check return code
		JZ	DXR03		;ok, continue
;
;	Error return from Ashley, return to caller
;
		MOV	B,A		;return code
		MVI	C,0		;count
		RET
;
;	Compress return from Ashley
;
DXR03:		MVI	B,DFLEN-2	;field size minus two
		INX	D		;reserve two spaces for carry
		INX	D		; and/or sign
		CALL	DELBLNK
		DCX	D		;restore address
		DCX	D
		CALL	DEROUND		;round to two decimal places
		CALL	DELBLNK
		MOV	C,B		;resulting count N
		MVI	B,0		;ok return
		RET
;
;	End *RDFMT*
;
	PAGE
;
REFMT:		;Convert float to "E" format and compress
;
;Written by C. E. Duncan 1981 December 3.
;Revised 10:05 1981 January 2.
;
;--------------------------------------------------------------
;
;Input:	DE = address of floating point number
;	HL = address of receiving ASCII field
;	 C = receiving field size
;
;Output:	B = return code
;		C = result size
;
;Ashley input:	DE = left address of ASCII output
;		HL = right address of FP argument
;
;--------------------------------------------------------------
;
;	Check for zero mantissa and/or zero exponent. Ashley does not make
;	this check.
;
		CALL	ZEROCHEK
		ORA	A
		JNZ	FZOK
;
;	Zero input, return with zero
;
		LXI	B,3		;return code = 0, length = 3
		MVI	M,'0'		;result
		INX	H
		MVI	M,'e'
		INX	H
		MVI	M,'0'
		RET
;
;	Check for maximum limit
;
FZOK:		PUSH	B		;save field size
		PUSH	D
		XCHG
		LXI	B,FPLM1
		DAD	B
		MOV	A,M
		ANI	7FH		;remove sign bit
		CPI	7FH		;E 62 max
		POP	H
		JC	FZOK1
		POP	B		;clear stack
		MVI	B,EFMM		;too large
		RET
;
;	Clear receiving field to blanks
;
FZOK1:		PUSH	D
		PUSH	H
		XCHG
		LXI	B,EFLEN
		MVI	A,' '
		CALL	FILLCHAR
		POP	H
		POP	D
		MVI	A,EFLEN		;output max field size
		STA	LENOUT		; for routine MOVCHAR
		XCHG			;  and address
		SHLD	ADROUT
		XCHG
		LXI	B,FPLM1		;adjust argument address
		DAD	B		; for Ashley
		MOV	B,A
		CALL	FPOUT		;call Ashley
		CALL	DELBLNK		;re-write w/o blanks
		CALL	CMPEZRA		;replace non-significant zeros
		CALL	DELBLNK		; with blanks, then remove them
		MOV	A,B		;count
		POP	B		;recover field size
		MOV	B,A		;number size
		CALL	EEROUND		;make fit
		RET
;
;	End *REFMT*
;
	PAGE
;
RFLOT:		;Convert binary to float.
;
;Written by C. E. Duncan 1982 January 4.
;Revised 06:40 1982 April 19.
;
;--------------------------------------------------------------
;
;Input:	DE = binary number, -32767 to +32767
;	HL = address for floating point result
;
;Output:	B = return code (always 0)
;
;--------------------------------------------------------------
;
		PUSH	H
		PUSH	D
;
;	Check for zero input
;
		MOV	A,D
		ORA	E
		JNZ	RFL02
		MVI	B,7		;set result to zero
;
RFL01:		MVI	M,0
		DCR	B
		INX	H
		JNZ	RFL01
		POP	D
		POP	H
		RET
;
;	Convert binary to ASCII
;
RFL02:		POP	H		;binary number
		LXI	B,FFAW		;ASCII work area
		CALL	INT2STR
;
;	Convert to floating point
;
		POP	H		;destination address
		MVI	A,CASCF		;convert code
		LXI	D,FFAW
		CALL	COUPLE
		RET
;
;	End *RFLOT*
;
	PAGE
;
RFXFP:		;Convert floating point integer to binary.
;
;Adapted from Ashley by C. E. Duncan 1981 December 29.
;Revised 06:55 1982 April 19.
;
;--------------------------------------------------------------
;
;Input:	DE = address (left end) of floating point integer
;
;Output:	HL = binary integer, -32767 to +32767
;		B = return code
;
;--------------------------------------------------------------
;
		CALL	ZEROCHEK	;check for zero input
		ORA	A
		JNZ	FIXF02
;
FIXF01:		LXI	H,0		;return a zero
		MVI	B,0		;ok
		RET
;
;	Check for upper limit on exponent
;
FIXF02:		PUSH	D
		XCHG
		LXI	B,FPLM1		;get exponent byte
		DAD	B
		MOV	A,M
		STA	TRUNTMP
		ANI	07FH		;remove sign bit
		SUI	041H		;unit place
		POP	D
		JC	FIXF01		;set to zero and return
		CPI	6		;exponent < 6
		JNC	FIXF06		;too large
		LXI	H,0		;result register
		INR	A
		MOV	C,A
;
FIXF1:		LDAX	D
		ANI	0F0H
		RAR
		RAR
		RAR
		RAR
		CALL	H10PA
		JC	FIXF06
		DCR	C
		JZ	FIXF2
		LDAX	D
		ANI	0FH
		CALL	H10PA
		JC	FIXF06
		INX	D
		DCR	C
		JNZ	FIXF1
;
FIXF2:		LDA	TRUNTMP		;recover exponent
		ORA	A
		JP	FIXF03
;
NEGHL:		MOV	A,L		;NEGATE HL
		CMA
		MOV	L,A
		MOV	A,H
		CMA
		MOV	H,A
		INX	H
;
FIXF03:		MVI	B,0		;ok
		RET
;
H10PA:		PUSH	D		;10*HL+A
		MOV	D,H
		MOV	E,L
		DAD	H
		JC	FIXF04
		DAD	H
		JC	FIXF04
		DAD	D
		JC	FIXF04
		DAD	H
		JNC	ADAH
;
FIXF04:		POP	D
		JMP	FIXF05		;return	overflow
;
ADAH:		POP	D
		ADD	L		;ADD A TO HL
		MOV	L,A
		RNC
		INR	H
		JZ	FIXF05		;overflow
		ORA	A		;ok, reset carry
		RET
;
FIXF05:		STC
		RET
;
FIXF06:		MVI	B,EFXP		;too large
		RET
;
;	End *RFXFP*
;
	PAGE
;
RGFMT:		;Convert floating point number to fixed decimal (G) format
;
;Written by C. E. Duncan 1981 November 26.
;Revised 06:45 1982 April 19.
;
;--------------------------------------------------------------
;
;Arrive here argument in DE, result address in HL, field width in C.
;
;Ashley input:	DE = left address ASCII output, set to blanks
;		HL = right address of FP input argument
;		(HL)+1 = address of field length
;		(HL)+2 = address of precision
;
;--------------------------------------------------------------
;
;	Check for zero input
;
		CALL	ZEROCHEK
		ORA	A
		JNZ	QFOK
;
;	Return zero
;
FXR01:		MVI	M,'0'
		LXI	B,1		;ret code = 0, length = 1
		RET
;
;	Check maximum
;
QFOK:		PUSH	B		;field width
		PUSH	D		;source
		XCHG			;source address to HL
		LXI	B,FPLM1
		DAD	B
		MOV	A,M
		ANI	7FH		;remove sign bit
		CPI	57H		;10 E 22 max
		POP	H
		JC	QFOK1
		POP	B		;clear stack
		MVI	B,EFNN		;too large
		RET
;
;	Clear receiving field to blanks
;
QFOK1:		PUSH	D		;address of destination field
		PUSH	H		;address of source number
		XCHG
		LXI	B,QFLEN
		MVI	A,' '
		CALL	FILLCHAR
		POP	D		;source
;
;	Put input FP number into local storage so can enter N & M after
;
		LXI	H,FNBUF		;to
		LXI	B,FPLEN		;count
		CALL	MOVE
;
;	Set size limits for Ashley and store in memory
;
		LXI	H,FNBUF+FPLEN	;next byte after exponent
		MVI	M,QFLEN		;N
		INX	H
		MVI	M,DIGS		;M
		DCX	H		;point to exponent byte
		DCX	H
		POP	D		;recover destination address
		PUSH	D
		CALL	FORMT		;call Ashley routine
		POP	D
		ORA	A		;check return code
		JZ	FXR03		;ok, continue
;
;	Error return from Ashley, return to caller
;
		POP	B		;clear stack
		MOV	B,A		;return code
		MVI	C,0		;count
		RET
;
;	Compress return from Ashley
;
FXR03:		CMP	C		;zero length means zero
		JZ	FXR04
		MVI	B,QFLEN		;set length
		CALL	DELBLNK		;remove blanks
		CALL	DELZERO		; and non-significant zeros
		CALL	DELBLNK
		MOV	A,B		;count
		POP	B		;field max width
		MOV	B,A		;number length
		CALL	GEROUND		;try to fit it in
		RET
;
FXR04:		POP	B
		XCHG
		JMP	FXR01
;
;	End *RGFMT*
;
	PAGE
;
RMOD:		;Calculate X MOD Y, defined as the remainder when X is divided by Y.
;
;Written by C. E. Duncan 1982 January 7.
;Revised 07:00 1982 April 19.
;
;--------------------------------------------------------------
;
;Input:	BC = address of X
;	DE = address of Y
;	HL = address of result
;
;Output:	B = result code
;
;--------------------------------------------------------------
;
;	M = X - Y*FLOOR(X/Y)
;
		PUSH	H
		PUSH	B
		PUSH	D
		LXI	H,MODTMP1L	;for X/Y
		MVI	A,DFDIV
		CALL	COUPLE
		XRA	A
		CMP	B
		JNZ	RMOD0Z
		LXI	D,MODTMP1L
		LXI	H,MODTMP2L	;for integer part
		MVI	A,MFLOR
		CALL	COUPLE
		LXI	B,MODTMP2L	;FLOOR(X/Y)
		POP	D		;Y
		LXI	H,MODTMP1L	;for Y*[X/Y]
		MVI	A,DFMUL
		CALL	COUPLE
		POP	B		;X
		POP	H		;destination
		RNZ			;error return
		LXI	D,MODTMP1L
		MVI	A,DFSUB		;subtract
		CALL	COUPLE
		RET
;
RMOD0Z:		POP	D		;clear stack
		POP	B
		POP	H
		RET
;
;	End *RMOD*
;
	PAGE
;
RTRIG:		;Calculate the triginometric functions sine, cosine and tangent.
;
;Written by C. E. Duncan 1982 January 7.
;Revised 07:02 1982 April 19.
;
;--------------------------------------------------------------
;
;Input:	DE = address of argument
;	HL = address for result
;
;Output:	B = result code
;
;--------------------------------------------------------------
;
		PUSH	H		;destination
		PUSH	D		;argument
		STA	RTFCN		;function code
		CALL	ZEROCHEK	;zero?
		JNZ	RTR04
;
;	Set to appropriate special value for X = 0
;
RTR01:		LDA	RTFCN
		POP	D
		POP	H
		CPI	MCOS
		JNZ	RTR03
;
;	cosine 0 is 1
;
RTR02:		LXI	B,FPLEN		;move floating point 1 to result
		LXI	D,FPONEL
		CALL	MOVE
		MVI	B,0		;ok result code
		RET
;
;	sine and tangent of zero are zero
;
RTR03:		LXI	B,FPLEN
		MVI	A,0
		CALL	FILLCHAR
;
;	MVI	B,0		;ok return
;
		RET
;
;	Check that argument is not too big
;
RTR04:		POP	H		;X
		PUSH	H
		LXI	B,FPLM1		;get exponent
		DAD	B
		MOV	A,M
		ANI	07FH		;remove sign
		CPI	04BH		;E11
		JC	RTR05		;ok
		POP	D		;clear stack
		POP	H
		MVI	B,ETRG		;over size
		RET
;
;	Set cosine to equivalent sine
;
RTR05:		POP	D		;argument
		LDA	RTFCN
		CPI	MCOS
		JNZ	RTR05A
		LXI	B,PIO2
		LXI	H,TRGTMP1L	;work area
		MVI	A,DFSUB		;subtract
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	RTR0Z
;
		JMP	RTR06		;error
;
;	Move argument to work area
;
RTR05A:		LXI	B,FPLEN
		LXI	H,TRGTMP1L
		CALL	MOVE
;
;	Check sign
;
RTR06:		LDA	TRGTMP1
		ANI	080H
		JNZ	RTR07		;need scaling
;
;	Check for X < PIO2
;
		LXI	B,TRGTMP1L	;argument
		LXI	D,PIO2
		MVI	A,DFCMP		;compare
		CALL	COUPLE
		MOV	A,C
		CPI	2		;equal?
		MVI	A,0		;set final sign +
		STA	RTSGN
		JNC	RTR07		;need scaling
		LDA	RTFCN
		CPI	MTAN
		JZ	DTR02		;1st quadrant
		JMP	DSR06		;1st quadrant
;
;	Need scaling
;
RTR07:		LDA	RTFCN		;function code
		LXI	B,TRGTMP1L	;argument
		LXI	D,PI
		CPI	MTAN		;tangent?
		JZ	RTR08
		LXI	D,TWOPI		;for sine and cosine
;
RTR08:		MOV	H,B		;destination = source
		MOV	L,C
		MVI	A,DFMOD		;modulus function
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	RTR0Z		;error
;
		LDA	RTFCN
		CPI	MTAN		;tangent?
		JNZ	DSR01		;process sine (and cosine)
;
;
;		T A N G E N T
;
;	Have 0 <= X < PI
;
DTR01:		LXI	D,TRGTMP1L	;arg
		CALL	ZEROCHEK
		JNZ	DTR02
		POP	H		;clear stack
		JMP	DXR03
;
;	Check < PIO2 - delta
;
DTR02:		LXI	D,PIO2M		;PI/2 - delta
		LXI	B,TRGTMP1L
		MVI	A,DFCMP
		CALL	COUPLE
		MOV	A,C
		CPI	2
		JC	DTR04		;1st quadrant
;
;	Check for 2nd quadrant
;
		LXI	B,PIO2P		;PI/2 + delta
		LXI	D,TRGTMP1L
		MVI	A,DFCMP
		CALL	COUPLE
		MOV	A,C
		CPI	2
		JC	DTR03		;2nd quadrant
		POP	H		;clear stack
		MVI	B,ETAN		;error, too near PIO2
		RET
;
;	Transform to 1st quadrant
;
DTR03:		LXI	B,PI
		LXI	D,TRGTMP1L
		MOV	H,D
		MOV	L,E
		MVI	A,DFSUB
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	RTR0Z		;error
;
;
;	Set result sign minus
;
		MVI	A,080H
		STA	RTSGN
;
;	Have 0 < arg <= PIO2 - delta, translate to 1st octant
;
DTR04:		XRA	A		;set reciprocal flag
		STA	RTRCP
;
;	Compare to PIO4
;
		LXI	D,PIO4
		LXI	B,TRGTMP1L
		MVI	A,DFCMP
		CALL	COUPLE
		MOV	A,C
		CPI	2
		POP	H
		JZ	RTR02
		PUSH	H
		JC	DTR04A		;already in 1st quad
;
;	Shift to 1st octant, signal reciprocal
;
		MVI	A,-1
		STA	RTRCP
		LXI	B,PIO2
		LXI	D,TRGTMP1L
		MOV	H,D
		MOV	L,E
		MVI	A,DFSUB
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	RTR0Z		;error
;
;
;	Divide by PIO4 so 0 < x < 1
;
DTR04A:		LXI	B,TRGTMP1L
		LXI	D,PIO4
		MOV	H,B
		MOV	L,C
		MVI	A,DFDIV
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	RTR0Z
;
;
;	Calculate X**2
;
DTR05:		LXI	B,TRGTMP1L
		MOV	D,B
		MOV	E,C
		LXI	H,TRGTMP2L
		MVI	A,DFMUL
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	RTR0Z
;
;
;	Calculate P(X**2)
;
		LXI	B,TANCOEF+FPLM1
		LXI	D,TRGTMP2
		LXI	H,TENTMP1+FPLM1
		MVI	A,7		;#4226
		CALL	POLYN
		XRA	A
		CMP	B
		JNZ	RTR0Z
;
;	Calculate X*P(X**2)
;
		LXI	B,TRGTMP1L
		LXI	D,TENTMP1
		LXI	H,TRGTMP1L
		MVI	A,DFMUL
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	RTR0Z
;
;
;	Check for sign change
;
		LDA	RTSGN
		LXI	H,TRGTMP1
		ORA	M
		MOV	M,A
;
;	Take reciprocal if called for
;
		LDA	RTRCP
		ORA	A
		JZ	DTR07
		LXI	B,FPONEL
		LXI	D,TRGTMP1L
		POP	H
		MVI	A,DFDIV
		CALL	COUPLE
		RET
;
;	Move result to destination
;
DTR07:		LXI	B,FPLEN
		LXI	D,TRGTMP1L
		POP	H
		CALL	MOVE
		MVI	B,0
		RET
;
;
;		S I N E  (and cosine)
;
;	Have 0 <= X <= TWOPI.  Transform to first quadrant
;
;	Set sign plus
;
DSR01:		XRA	A
		STA	RTSGN
;
;	Test for 1st quad
;
		LXI	B,TRGTMP1L	;X
		LXI	D,PIO2
		MVI	A,DFCMP		;compare
		CALL	COUPLE
		MOV	A,C
		CPI	2
		POP	H
		JZ	RTR02		;result = 1
		PUSH	H
		JC	DSR06		;ok, 1st quadrant
;
;	Test for 2nd quadrant
;
		LXI	B,TRGTMP1L	;X
		LXI	D,PI
		MVI	A,DFCMP
		CALL	COUPLE
		MOV	C,A
		CPI	2
		POP	H
		JZ	RTR03		;result is 0
		PUSH	H
		JNC	DSR02		;not 2nd quadrant
;
;	2nd quadrant, translate to 1st
;
		LXI	B,PI
		LXI	D,TRGTMP1L	;X
		MOV	H,D
		MOV	L,E
		MVI	A,DFSUB
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	DSR0Z		;error
;
		JMP	DSR06		;1st quadrant
;
;	Test for 3rd quadrant
;
DSR02:		LXI	B,TRGTMP1L	;X
		LXI	D,TPIO2		;3*PIO2
		MVI	A,DFCMP
		CALL	COUPLE
		MOV	C,A
		CPI	2
		JZ	DSR04		;result = -1
		JNC	DSR05		;4th quadrant
;
;	3rd quadrant, translate to 1st
;
		LXI	B,TRGTMP1L	;X
		LXI	D,PI
		MOV	H,B
		MOV	L,C
		MVI	A,DFSUB
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	RTR0Z
;
;
;	Set sign negative
;
DSR03:		MVI	A,080H
		STA	RTSGN
		JMP	DSR06		;1st quad
;
;	Special case for X = 3*PIO2
;
DSR04:		POP	H
		LXI	B,FPLEN
		LXI	D,FPMONEL	;minus 1
		CALL	MOVE
		MVI	B,0
		RET
;
;	4th quadrant
;
DSR05:		LXI	B,TWOPI
		LXI	D,TRGTMP1L
		MOV	H,D
		MOV	L,E
		MVI	A,DFSUB
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	RTR0Z		;error
;
		JMP	DSR03		;set sign to -1
;
;	Have 0 < X < PIO2, divide by PIO2 to get 0 < X < 1
;
DSR06:		LXI	B,TRGTMP1L	;X
		LXI	D,PIO2
		MOV	H,B
		MOV	L,C
		MVI	A,DFDIV
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	RTR0Z		;error
;
;
;	Calculate X**2
;
		LXI	B,TRGTMP1L
		MOV	D,B
		MOV	E,C
		LXI	H,TRGTMP2L
		MVI	A,DFMUL
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	RTR0Z		;error
;
;
;	Calculate P(X**2)
;
		LXI	B,SINCOEF+FPLM1	;coefficients #3342
		LXI	D,TRGTMP2
		LXI	H,TENTMP1+FPLM1
		MVI	A,5
		CALL	POLYN
		XRA	A
		CMP	B
		JNZ	RTR0Z		;error
;
;	Calculate X*P(X**2)
;
		LXI	B,TRGTMP1L	;X
		LXI	D,TENTMP1	;P(X**2)
		MOV	H,B
		MOV	L,C
		MVI	A,DFMUL
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	RTR0Z		;error
;
;
;	Set sign of result
;
		LDA	RTSGN
		LXI	H,TRGTMP1
		ORA	M
		MOV	M,A
;
;	Move result to destination and return
;
		JMP	DTR07
;
;	Arithmetic error
;
RTR0Z:		POP	H		;clear stack
		MVI	B,ETRA		;signal arithmetic error
		RET
;
;	End *RTRIG*
;
	PAGE
;
SQRT:		;Calculate square root of X to about 10 significant places.
;
;Written by C. E. Duncan 1982 January 14.
;Revised 07:05 1982 April 19.
;
;--------------------------------------------------------------
;
;Input:	DE = address of X, argument
;	HL = address of result
;
;Output:	B = result code
;
;--------------------------------------------------------------
;
		PUSH	H		;destination for result
		PUSH	D
;
;	Check for negative input
;
		LXI	B,FPLM1
		XCHG
		DAD	B
		MOV	A,M
		ANI	080H
		JNZ	SQRT0Z
;
;	Check for zero
;
SQRT01:		POP	D
		PUSH	D
		CALL	ZEROCHEK
		JNZ	SQRT02
		POP	D
		POP	H
		XRA	A
		LXI	B,FPLEN
		CALL	MOVE
;
;	MVI	B,0
;
		RET
;
;	Set YN initially to X with exponent = (exp - 40H)/2 + 40H
;
SQRT02:		POP	D
		PUSH	D
		LXI	B,FPLEN
		LXI	H,YNL
		CALL	MOVE
		LDA	YN		;exponent byte
		SBI	40H
		JM	SQRT03
		ORA	A
		RAR
		JMP	SQRT04
;
SQRT03:		CMA
		INR	A
		ORA	A
		RAR
		CMA
		INR	A
;
SQRT04:		ADI	40H
		STA	YN
;
;	Iterate
;
SQRT05:		POP	B
		PUSH	B
;
;	X/YN
;
		LXI	D,YNL
		LXI	H,STMP1L
		MVI	A,DFDIV
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	SQRT0Z
;
;
;	X/YN - YN
;
		LXI	B,STMP1L
		LXI	D,YNL		;YN
		MOV	H,B
		MOV	L,C
		MVI	A,DFSUB
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	SQRT0Z
;
;
;	0.5*(X/YN - YN)
;
		LXI	B,STMP1L
		LXI	D,FPHALFL
		MOV	H,B
		MOV	L,C
		MVI	A,DFMUL
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	SQRT0Z
;
;
;	YN := YN + 0.5*(X/YN - YN)
;
		LXI	B,STMP1L
		LXI	D,YNL
		MOV	H,D
		MOV	L,E
		MVI	A,DFADD
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	SQRT0Z
;
;
;	YN**2
;
		LXI	B,YNL
		MOV	D,B
		MOV	E,C
		LXI	H,STMP1L
		MVI	A,DFMUL
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	SQRT0Z
;
;
;	YN**2 - X
;
		LXI	B,STMP1L
		POP	D
		PUSH	D
		LXI	H,STMP2L
		MVI	A,DFSUB
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	SQRT0Z
;
;
;	(YN**2 - X)/X
;
		LXI	B,STMP2L
		POP	D
		PUSH	D
		LXI	H,STMP1L
		MVI	A,DFDIV
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	SQRT0Z
;
;
;	Check size
;
		LDA	STMP1		;exponent
		ANI	07FH		;remove sign
		CPI	036H		;E-11
		JNC	SQRT05		;iterate again
;
;	move result to destination
;
		POP	D		;clear stack
		POP	H		;destination
		LXI	D,YNL		;YN
		LXI	B,FPLEN
		CALL	MOVE
		MVI	B,0
		RET
;
;	Arithmetic error
;
SQRT0Z:		MVI	B,ESQT		;error in square root routine
		POP	D
		POP	H
		RET
;
;	End *SQRT*
;
	PAGE
;
TENTOX:		;Ten to the power X.
;
;Written by C. E. Duncan, patterned after Ashley, 1981 December 26.
;Revised 07:16 1982 April 19.
;
;--------------------------------------------------------------
;
;Input:	DE = address (left) of X
;	HL = address (left) of result
;
;Output:	B = result code
;
;--------------------------------------------------------------
;
;	Save some addresses, etc.
;
		PUSH	H
;
;	Move to work area
;
		LXI	B,FPLEN
		LXI	H,TEMP1L
		CALL	MOVE
;
;	Save exponent byte then set positive in number
;
		LDA	TEMP1
		STA	TENTMP2
		ANI	07FH
		STA	TEMP1
;
;	Get integral part to TENTMP1
;
		LXI	D,TEMP1L
		LXI	H,TENTMP1
		MVI	A,MTRNC
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	TENERR
;
		LXI	D,TENTMP1	;integer part to binary in HL
		MVI	A,CFXFP
		CALL	COUPLE
		XRA	A
;
;	CMP	B
;	JNZ	TENERR
;
		CMP	H
		JNZ	TENT01		;too large, > 255
		MVI	A,03DH		;value for E 61
		CMP	L
		JC	TENT01		;over- or under-flow
		MOV	A,L
		STA	TENTMP3		;power of ten (integer part)
;
;	Fractional part
;
		LXI	H,TENTMP4	;put into TENTMP4
		LXI	B,TEMP1-FPLM1
		LXI	D,TENTMP1	;FRACT = N - INTGR
		MVI	A,DFSUB
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	TENERR
;
		LXI	B,TENCOEF+FPLM1		;coefficient list
		LXI	D,TENTMP4+FPLM1		;argument X
		LXI	H,TENTMP1+FPLM1		;result
		MVI	A,9		;order of polynomial
		CALL	POLYN
		XRA	A
		CMP	B
		JNZ	TENERR
		LDA	TENTMP1+FPLM1	;add in exponent
		MOV	B,A
		LDA	TENTMP3
		ADD	B
		STA	TENTMP1+FPLM1
		LDA	TENTMP2		;check sign
		POP	H
		ANI	080H		;sign bit
		JZ	TENMOV
		LXI	B,FPONEL	;take reciprocal
		LXI	D,TENTMP1
		MVI	A,DFDIV
		CALL	COUPLE
;
;	XRA	A
;	CMP	B
;	JNZ	TENERR1
;
		RET
;
TENMOV:		LXI	B,FPLEN
		LXI	D,TENTMP1
		CALL	MOVE
		MVI	B,0
		RET
;
TENT01:		LDA	TENTMP2		;check sign of original exponent
		ORA	A
		JP	TENERR		;overflow
		POP	H		;underflow
		LXI	B,FPLEN		; set result to zero
		XRA	A
		CALL	FILLCHAR
;
;	MVI	B,0		;ok result code
;
		RET
;
TENERR:		POP	H
;
TENERR1:	MVI	B,ETEN
		RET
;
;	End *TENTOX*
;
	PAGE
;
TRUNC:		;Extract integral part of floating point number.
		;There are four ways to do this:  Truncation - drop the fraction part
		;
		;	Floor - greatest integer not greater than number
		;	Ceiling - least integer not less that number
		;	Round - "nearest" integer
		;All four functions are represented.
;
;Written by C. E. Duncan 1981 December 23 to accompany Lipsky/Ashley
; floating point package.
;Revised 15:20 1982 April 19.
;
;--------------------------------------------------------------
;
;Input:	DE = address of number
;	HL = address of returned integral number
;	A = function code
;
;Output:	B = return code
;
;--------------------------------------------------------------
;
;	Check whether integral
;
		STA	TENTMP2		;function code
		PUSH	H		;destination
		PUSH	D		;source
		CALL	TSTINT
		XRA	A
		CMP	B
		POP	D
		JZ	TRUN01		;not integer
		POP	H
		LXI	B,7		;move integer to result
		CALL	MOVE
;
;	MVI	B,0
;
		RET
;
;	Obtain and save the exponent byte
;
TRUN01:		PUSH	D		;source
		XCHG			;source
		LXI	B,FPLM1
		DAD	B
		MOV	A,M
		STA	TENTMP3		;exponent byte
		POP	D
;
;	Check for rounding
;
		LDA	TENTMP2		;function code
		CPI	MRND
		JNZ	TRUN03
;
;	Round to nearest integer by adding or subtracting 1
;
		MOV	B,D		;source to BC
		MOV	C,E
		LXI	D,FPHALFL	;one-half
		LDA	TENTMP3		;exponent byte
		ANI	080H		;sign bit
		MVI	A,DFADD		;add function
		JZ	TRUN02
		MVI	A,DFSUB		;subtract
;
TRUN02:		LXI	H,TENTMP1	;work area
		CALL	COUPLE		;add or subtract one-half
		LDA	TENTMP1+FPLM1	;new exponent
		STA	TENTMP3
		LXI	D,TENTMP1	;new source
;
;	Move number to destination
;
TRUN03:		POP	H		;recover destination
		PUSH	H
		LXI	B,FPLEN
		CALL	MOVE
;
;	Check exponent
;
		LDA	TENTMP3		;exponent byte
		ANI	7FH		;remove sign bit
		CPI	41H		;check whether ABS(N) < 1
		POP	H
		JP	TRUN05
;
;	Magnitude less than one, value is -1, 0 +1 depending on function
;
		LDA	TENTMP2		;function code
		MOV	B,A
		LDA	TENTMP3		;exponent
		ANI	080H		;sign bit
		JZ	TRUN03A
;
;	Negative, -1 if FLOOR, else 0
;
		MOV	A,B
		CPI	MFLOR
		JNZ	TRUN03B		;0
		LXI	D,FPMONEL	;-1
		JMP	TRUN03C
;
;	Positive, +1 if CEIL, else 0
;
TRUN03A:	MOV	A,B
		CPI	MCEIL
		JNZ	TRUN03B		;0
		LXI	D,FPONEL	;+1
		JMP	TRUN03C
;
TRUN03B:	LXI	D,FPZEROL	;0
;
TRUN03C:	LXI	B,FPLEN
		CALL	MOVE
;
TRUN04:		;MVI	B,0		;return code
		RET
;
;	Number greater than 1 in magnitude
;
TRUN05:		CPI	DIGS+40H	;so large it is already integer
		MOV	C,A		;save
		JNC	TRUN04
;
;	Have 1 < number magnitude < E 12
;
		PUSH	H
		PUSH	B		;point HL to exponent byte
		LXI	B,FPLM1
		DAD	B
		POP	B
		MVI	A,DIGS-1	;max number digits after decimal
		ADI	41H		;units exponent
		SUB	C		;number of zeros to fill from right
		MOV	C,A
;
TRUN06:		DCX	H		;next two digits from right
		MVI	A,0F0H
		ANA	M		;set 2nd digit of pair to zero
		MOV	M,A
		DCR	C
		JZ	TRUN07		;finished
		MVI	M,0		;set both to zero
		DCR	C
		JNZ	TRUN06
;
TRUN07:		POP	H
		LDA	TENTMP2		;recover function code
		CPI	MTRNC		;truncation
		JZ	TRUN04		;finished
		CPI	MRND		;round
		JZ	TRUN04
;
TRUN09:		CPI	MFLOR		;floor
		JNZ	TRUN10
;
;	Floor function. If negative, must decrement by 1
;
		LDA	TENTMP3		;check exponent
		ANI	080H		;sign bit
		MVI	B,0
		RZ
		MOV	B,H		;subtract 1
		MOV	C,L
		LXI	D,FPONEL
		MVI	A,DFSUB
		CALL	COUPLE
		MVI	B,0
		RET
;
TRUN10:		CPI	MCEIL
		JNZ	TRUN11
;
;	Ceiling function, must add 1 if positive.
;
		LDA	TENTMP3
		ANI	080H
		MVI	B,0
		RNZ
		MOV	B,H		;add 1
		MOV	C,L
		LXI	D,FPONEL
		MVI	A,DFADD
		CALL	COUPLE
		MVI	B,0
		RET
;
;	Error return
;
TRUN11:		MVI	B,255		;trouble
		RET
;
;	End *TRUNC*
;
	PAGE
;
TSTINT:		;Test floating point number for integral value.
;
;Programmed by C. E. Duncan 1981 December 23.
;Revised 10:00 1982 April 19.
;
;--------------------------------------------------------------
;
;Input:	DE = address of floating point number
;
;Output:	B = 0 (FALSE) if not integer
;		B = FF (hex), not zero, (TRUE) if integer
;
;--------------------------------------------------------------
;
;	Test for zero
;
		CALL	ZEROCHEK
		JZ	TSTI02		;zero is an integer
		XCHG			;source address to HL
		LXI	B,FPLM1		;point to exponent
		DAD	B
		MOV	A,M		;exponent byte
		ANI	07FH		;reset sign bit
		CPI	041H		;units
		JC	TSTI03		;not integer
		SUI	DIGS+40H	; = 4C (12 digits left of decimal)
		MOV	C,A
		JNC	TSTI02		;large enough, must be integer
;
TSTI01:		DCX	H		;next two digits from right
		MOV	A,M
		ANI	00FH		;right hand digit
		JNZ	TSTI03		;not integer
		INR	C
		JZ	TSTI02		;integer
		MOV	A,M
		ANI	0F0H		;left hand digit
		JNZ	TSTI03		;not integer
		INR	C
		JZ	TSTI02
		JMP	TSTI01
;
TSTI02:		MVI	B,TRUE		;integer, return TRUE
		RET
;
TSTI03:		MVI	B,FALSE		;not integer, return FALSE
		RET
;
;	End *TSTINT*
;
	PAGE
;
XTOY:		;Raise X to the power Y.
;
;Written by C. E. Duncan 1982 January 6.
;Revised 07:25 1982 April 19.
;
;--------------------------------------------------------------
;
;Input:	BC = exponent address of X
;	DE = exponent address of Y
;	HL = exponent address of result
;
;Output:	B = result code
;
;--------------------------------------------------------------
;
;Calculate logarithm of X
;
		PUSH	H		;result exponent address
		PUSH	D		;Y
		MOV	H,B		;X to HL
		MOV	L,C
		LXI	B,-FPLM1	;adjust address to left end
		DAD	B
		XCHG			; to DE
		LXI	H,TEMP1L	;for LOG(X)
		CALL	LOG10
		POP	D		;Y
		POP	H
		XRA	A
		CMP	B
		RNZ
;
;	Multiply by Y
;
		PUSH	H
		LXI	B,TEMP1
		LXI	H,TEMP2		;for Y*LOG(X)
		CALL	FMUL
		POP	H
;
;	XRA	A
;	CMP	B
;	JNZ	XTOY01
;
;
;	Check that number not too large, exponent (Y*LOG(X)) less than 63
;
		LDA	TEMP2		;exponent
		ANI	07FH
		CPI	07FH
		JNC	XTOY01		;overflow
;
;	Raise ten to this power
;
		LXI	B,-FPLM1	;adjust to exponent
		DAD	B
		LXI	D,TEMP2L
		CALL	TENTOX
		RET
;
XTOY01:		MVI	B,EXTY
		RET
;
;	End *XTOY*
;
	PAGE
;
ZEROCHEK:	;Check for zero floating point input.  This check is incompletely
		; done by Ashley, and is convenient for return of zero desired.
;
;Revised 07:28 1982 April 19.
;
;--------------------------------------------------------------
;
;Input:	DE = source address
;
;Output:
;--------------------------------------------------------------
;
		PUSH	H		;save inputs
		PUSH	B
		PUSH	D
		XCHG
		MVI	B,FPLM1		;mantissa length
		XRA	A		;zero
;
;	Check mantissa
;
EZ01:		CMP	M
		JNZ	EZ03		;non-zero digit(s) in mantissa
		INX	H
		DCR	B
		JNZ	EZ01		;keep looking
;
;	The mantissa is zero, so set output and return
;
EZ02:		XRA	A		;signal zero
		JMP	EZ04
;
;	Mantissa not zero, check exponent
;
EZ03:		POP	H		;recover address
		PUSH	H
		LXI	B,FPLM1
		DAD	B		;exponent byte
		CMP	M		;zero?
		JZ	EZ02		;yes, return
		MVI	A,-1		;signal non-zero
;
EZ04:		POP	D		;restore stack
		POP	B
		POP	H
		RET
;
;	End *ZEROCHEK*
;
	PAGE
;
;**************************************************************
;
ASHLEYFP:	;Group of Ashley floating point programs adapted to FORTH.
;
;Altered by C. E. Duncan 1981 October 29.
;Revised 08:15 1981 November 12.
;
;--------------------------------------------------------------
;
;	BCD FLOATING POINT PACKAGE
;
;	BC POINTS TO LEFT ARGUMENT
;
;	DE POINTS TO RIGHT ARGUMENT
;
;	HL POINTS TO ANSWER
;
;	ALL POINTERS SAVED
;
;	NUMBER OF BYTES PER FLOATING POINT NUMBER
;
;--------------------------------------------------------------
;
;Comment:
; some returns from FADD, FSUB, FMUL, FDIV are through
; RSTRG, but not all. FPLEN is set in the COUPLE routine. (CED)
;
;**************************************************************
;
;	DEFINE THE FSUB ENTRY HERE
;
;**************************************************************
;
FSUB:		CALL	SVRGS
		LXI	H,DGV65
		LDAX	D
		ORA	A
		RZ
		XRI	80H
;
FPX86:		PUSH	B
		MVI	C,FPLEN
;
FPX89:		MOV	M,A
		DCX	H
		DCX	D
		LDAX	D
		DCR	C
		JNZ	FPX89
		POP	B
		LXI	D,DGV65
		JMP	ADP3
;
;**************************************************************
;
;	DEFINE THE FADD ENTRY HERE
;
;**************************************************************
;
FADD:		CALL	SVRGS
;
ADP3:		LDAX	D
		ORA	A
		RZ
		PUSH	B
		LDAX	B
		ORA	A
		JZ	FPXB2
		ANI	7FH
		MOV	L,A
		LDAX	D
		ANI	7FH
		SUB	L
		MOV	H,B
		MOV	L,C
		JP	FPXAD
		XCHG
		CMA
		INR	A
;
FPXAD:		CPI	DIGS+1
		JC	FPXB7
;
FPXB2:		XCHG
		POP	D
		JMP	FCOPY
;
FPXB7:		PUSH	D
		MOV	D,M
		PUSH	D
		ADI	1
		RAR
		PUSH	PSW
		LXI	D,DGBF4
		MVI	C,FPLM1
		XRA	A
		STAX	D
;
FPXC5:		DCX	D
		DCX	H
		MOV	A,M
		STAX	D
		DCR	C
		JNZ	FPXC5
		POP	PSW
		PUSH	PSW
		LXI	H,DGBF4
		ORA	A
		JZ	FPXDF
		MOV	C,A
		XRA	A
;
FPXD8:		DCX	H
		DCX	D
		STAX	D
		DCR	C
		JNZ	FPXD8
;
FPXDF:		POP	PSW
		JC	FPXEB
		INX	H
		MOV	D,H
		MOV	E,L
		CALL	UNPK0
		DCX	D
		XCHG
;
FPXEB:		MOV	A,M
		CPI	50H
		DCX	H
		PUSH	H
		CNC	FPX44
		POP	D
		POP	PSW
		POP	H
		XRA	M
		MOV	B,M
		DCX	H
		PUSH	B
		JP	FPY71
		PUSH	D
		MVI	C,FPLM1
		STC
		MVI	B,99H
;
FPY03:		MVI	A,0
		ADC	B
		XCHG
		SUB	M
		XCHG
		ADD	M
		DAA
		STAX	D
		DCX	H
		DCX	D
		DCR	C
		JNZ	FPY03
		POP	H
		JC	FPY2D
		POP	PSW
		XRI	80H
		PUSH	PSW
		PUSH	H
		MVI	C,FPLM1
		MVI	B,9AH
;
FPY1F:		MOV	A,B
		SBB	M
		ADI	0
		DAA
		MOV	M,A
		DCX	H
		DCR	C
		CMC
		JNZ	FPY1F
		XCHG
		POP	H
;
FPY2D:		PUSH	D
		MOV	D,H
		MOV	E,L
		MVI	B,FPLEN-2
		XRA	A
;
FPY33:		INX	H
		MOV	M,A
		DCR	B
		JNZ	FPY33
		POP	H
		POP	B
		MVI	C,DIGS
;
FPY3D:		INX	H
		MOV	A,M
		ORA	A
		JNZ	FPY4C
		INX	D
		DCR	C
		DCR	C
		JNZ	FPY3D
		POP	B
		STAX	B
		RET
;
FPY4C:		POP	H
		ANI	0F0H
		PUSH	PSW
		JNZ	FPY54
		DCR	C
;
FPY54:		MOV	A,B
		ADD	C
		SUI	DIGS
		MOV	M,A
		XRA	B
		JP	FPY61
		POP	PSW
		MVI	M,0
		RET
;
FPY61:		POP	PSW
		JNZ	FPY6A
		XRA	A
		INX	D
		JMP	UNPK0
;
FPY6A:		DCX	H
		XCHG
		MVI	C,FPLM1
		JMP	FCOP1
;
FPY71:		PUSH	D
		MVI	B,FPLM1
		ORA	A
;
FPY75:		LDAX	D
		ADC	M
		DAA
		STAX	D
		DCX	H
		DCX	D
		DCR	B
		JNZ	FPY75
		JC	FPY8C
		POP	H
		POP	PSW
		POP	D
		STAX	D
		DCX	D
		MVI	C,FPLM1
		JMP	FCOP1
;
FPY8C:		MVI	A,1
		STAX	D
		POP	H
		POP	B
		MOV	A,M
		PUSH	H
		CALL	FPX4B
		POP	D
		POP	H
		INR	B
		MOV	A,B
		ANI	7FH
;
;	JZ	 FPERR		;YOUR ERROR ROUTINE FOR OVERFLOW
;
		JNZ	FPY9A
		MVI	A,EASB		;ADD/SUB overflow
		STA	FRCOD
		RET
;
FPY9A:		MOV M,B
		JMP UNPAK
;
;**************************************************************
;
;	DEFINE THE FMUL ENTRY HERE
;
;**************************************************************
;
FMUL:		XRA	A		;reset return code
		STA	FRCOD
;
MULT:		LDAX	B
		ORA	A
		JZ	HLR0
		LDAX	D
		ORA	A
		JZ	HLR0
		CALL	SVRGS
		PUSH	B
		PUSH	D
		LXI	H,DGBF4
		MVI	A,DIGS
;
FPR84:		MVI	M,0
		DCX	H
		DCR	A
		JNZ	FPR84
		XRA	A
		LXI	H,DGV60
		CALL	UNPK0
		MVI	A,FPLM1
		LXI	H,DGBF4
		DCX	D
;
FPR98:		PUSH	PSW
		DCX	B
		PUSH	B
		PUSH	D
		LDAX	B
		PUSH	PSW
		ANI	0FH
		JZ	FPRB3
		MVI	B,FPLM1
		MOV	C,A
;
FPRA6:		PUSH	H
		CALL	FPX6E
		MVI	A,0
		ADC	M
		MOV	M,A
		POP	H
		DCR	C
		JNZ	FPRA6
;
FPRB3:		POP	PSW
		RAR
		RAR
		RAR
		RAR
		ANI	0FH
		JZ	FPRCC
		MVI	B,FPLEN
		LXI	D,DGV5F
		MOV	C,A
;
FPRC3:		PUSH	H
		CALL	FPX6E
		POP	H
		DCR	C
		JNZ	FPRC3
;
FPRCC:		POP	D
;
FPRCD:		POP	B
		POP	PSW
		DCX	H
		DCR	A
		JNZ	FPR98
		LXI	D,DGBF1
		CALL	FPX35
		MVI	C,0
		LXI	D,DGBF1
		CALL	FPX60
		POP	D
		POP	H
		LDAX	D
		ANI	7FH
		MOV	B,A
		MOV	A,M
		ANI	7FH
		ADD	B
		ADD	C
		SUI	40H
		JZ	FPX08
		JP	FPX02
		RAL
		ORA	A
		MVI	A,00
		JM	FPX08
;
;FPERR:	JMP	FPERR   	;CHANGE THIS JUMP TO YOUR ERROR ROUTINE
;
		MVI	A,EMUL		;MUL overflow
		STA	FRCOD
		RET
;
FPX02:		MOV	B,A
		LDAX	D
		XRA	M
		ANI	80H
		ORA	B
;
FPX08:		LXI	D,DGBF3
		STAX	D
		XCHG
;
FCOPY:		MVI	C,FPLEN
;
FCOP1:		MOV	A,M
;
FCOP2:		STAX	D
		DCX	H
		DCX	D
		DCR	C
		JNZ	FCOP1
		RET
;
HLR0:		MVI	M,0
		RET
;
RSTRG:		LXI	B,FTEMP
		LHLD	FSVHL
		CALL	COPD
		LHLD	FSVBC
		MOV	B,H
		MOV	C,L
		LHLD	FSVDE
		XCHG
		LHLD	FSVHL
;
		LDA	FRCOD		;return code
		RET
;
;**************************************************************
;
;	DEFINE THE FDIV ENTRY HERE
;
;**************************************************************
;
FDIV:		XRA	A		;reset return code
		STA	FRCOD
;
DIVID:		LDAX	D
		ORA	A
;
;	JZ	FPERR		;YOUR DIVIDE BY ZERO ROUTINE
;
		JNZ	DIVOK
		MVI	A,EDVZ
		STA	FRCOD
		JMP	HLR0
;
DIVOK:		LDAX	B
		ORA	A
		JZ	HLR0
		CALL	SVRGS
		LDAX	B
		PUSH	B
		LXI	H,-FPLM1
		DAD	B
		SHLD	DGV3C
		PUSH	PSW
		PUSH	D
		PUSH	H
		PUSH	B
		PUSH	D
		LXI	H,DGV6C
		MVI	B,FPLM1
;
FPYBD:		DCX	D
		LDAX	D
		MOV	M,A
		DCX	H
		DCR	B
		JNZ	FPYBD
		MVI	M,0
		POP	D
		POP	B
		XRA	A
		LXI	H,DGV60
		CALL	UNPK0
		LXI	H,DGV57
		XRA	A
		MVI	D,FPLEN
;
FPYD6:		MOV	M,A
		DCX	H
		DCR	D
		JNZ	FPYD6
		MVI	D,FPLM1
;
FPYDE:		DCX	B
		LDAX	B
		MOV	M,A
		DCX	H
		DCR	D
		JNZ	FPYDE
		MVI	M,0
		LXI	D,DGBF2
		MVI	C,FPLEN
;
FPYED:		PUSH	D
		PUSH	B
		LXI	H,DGV6C
		CALL	FPZ43
		POP	B
		RLC
		RLC
		RLC
		RLC
		MOV	B,A
		POP	D
		INX	D
		PUSH	D
		PUSH	B
		LXI	H,DGV5F
		CALL	FPZ43
		POP	B
;
FPZ06:		ORA	B
		LHLD	DGV3C
		MOV	M,A
		INX	H
		SHLD	DGV3C
		POP	D
		DCR	C
		JNZ	FPYED
		POP	D
		CALL	FPX35
		MVI	C,00
		CALL	FPX60
		POP	D
		LDAX	D
		ANI	7FH
		SUB	C
		MOV	H,A
		POP	PSW
		MOV	L,A
		POP	B
		ANI	7FH
		SUB	H
		ADI	41H
		JZ	FPZ41
		JP	FPZ3A
		ADD	A
		MVI	A,00
		JM	FPZ41
;
;	JMP	FPERR
;
		MVI	A,EDVO		;DIV overflow
		STA	FRCOD
		RET
;
FPZ3A:		XCHG
		MOV	D,A
		MOV	A,E
		XRA	M
		ANI	80H
		ORA	D
;
FPZ41:		STAX	B
		RET
;
COPD:		PUSH	H
		PUSH	D
		MVI	E,FPLEN
;
COPD1:		LDAX	B
		MOV	M,A
		DCX	H
		DCX	B
		DCR	E
		JNZ	COPD1
		POP	D
		POP	H
		MOV	B,H
		MOV	C,L
		RET
;
FPZ43:		MVI	B,FPLEN
		MVI	C,-1
;
FPZ46:		INR	C
		PUSH	B
		PUSH	D
		PUSH	H
		STC
		MVI	C,99H
;
FPZ4D:		MVI	A,00
		ADC	C
		SUB	M
		XCHG
		ADD	M
		XCHG
		DAA
		STAX	D
		DCX	H
		DCX	D
		DCR	B
		JNZ	FPZ4D
		POP	H
		POP	D
		POP	B
		JC	FPZ46
		XCHG
		CALL	FPX6E
		MOV	A,C
		RET
;
UNPAK:		LDAX	D
;
UNPK0:		PUSH	D
		PUSH	B
		MVI	B,FPLM1
;
UNPK1:		ANI	0F0H
		MOV	C,A
		DCX	D
		LDAX	D
		PUSH	PSW
		ANI	0FH
		ORA	C
		RLC
		RLC
		RLC
		RLC
;
UNPK2:		DCX	H
		MOV	M,A
		POP	PSW
		DCR	B
		JNZ	UNPK1
		ANI	0F0H
		POP	B
		POP	D
		RZ
		RLC
		RLC
		RLC
		RLC
		DCX	H
		MOV	M,A
		RET
;
SVRGS:		;Return code is initialized to zero here
		XRA	A
		STA	FRCOD
;
		SHLD	FSVHL
		LXI	H,RSTRG
		XTHL
		PUSH	H
		XCHG
		SHLD	FSVDE
		XCHG
		MOV	H,B
		MOV	L,C
		SHLD	FSVBC
		LXI	H,FTEMP
		JMP	COPD
;
FPX35:		LDAX	D
		ANI	0F0H
		LXI	H,FPLM1
		DAD	D
		MOV	A,M
		JZ	FPX4B
		CPI	50H
		RC
;
FPX43:		DCX	H
;
FPX44:		MVI	C,FPLM1
		MVI	A,1
		JMP	FPX54
;
FPX4B:		ANI	0FH
		CPI	05H
		RC
		MVI	C,FPLEN
		MVI	A,10H
;
FPX54:		ADD	M
		DAA
		MOV	M,A
		RNC
		DCX	H
		DCR	C
		MVI	A,01
		JNZ	FPX54
		RET
;
FPX60:		LDAX	D
		ANI	0F0H
		RNZ
		DCR	C
		LXI	H,FPLM1
		DAD	D
		MOV	D,H
		MOV	E,L
		JMP	UNPAK
;
FPX6E:		PUSH	B
		PUSH	D
		ORA	A
;
FPX71:		LDAX	D
		ADC	M
		DAA
		MOV	M,A
		DCX	H
		DCX	D
		DCR	B
		JNZ	FPX71
		POP	D
		POP	B
		RET
;
	PAGE
;
;****************************************************************
;
;	FLOATING POINT I/O ROUTINES
;
BLK:		MVI	A,20H
;
;	CO IS CHARACTER OUT FROM ACCUMULATOR
;
CO:		JMP	MOVCHAR		;PATCH HERE TO YOUR ROUTINE
;
;Comment:  MOVCHAR follows routine FORMT below. (CED)
;
;
FPOUT:		;Set return code
		XRA	A
		STA	FRCOD
;
		MOV	A,M		;HL POINTS TO EXPONENT BYTE
		ORA	A
		JZ	PPZERO
		PUSH	D
		PUSH	B
		MOV	A,M
		ANI	80H
		RLC
		MVI	A,'-'
		CC	CO
		CNC	BLK
		LXI	B,1-FPLEN
		DAD	B
		MOV	A,M
		CALL	ROT4
		CALL	OUT1
		MVI	A,'.'
		CALL	CO
		MOV	A,M
		CALL	OUT1
		INX	H
		MVI	C,DIGS/2-1
;
OLOOP:		CALL	OUT2
		INX	H
		DCR	C
		JNZ	OLOOP
		CALL	BLK
		MVI	A,'E'
		CALL	CO
		MOV	A,M
		DCR	A
		ANI	7FH
		MOV	C,A
		CPI	40H
		MVI	A,'-'
		CC	CO
		CNC	BLK
		MOV	A,C
		SUI	40H
		JNC	EPLUS
		CMA
		ANI	7FH
		INR	A
;
EPLUS:		MOV	C,A
		MVI	B,10
		CALL	BOUT
		MVI	B,01
		CALL	BOUT
		POP	B
		POP	D
		CALL	BLK
;
		LDA	FRCOD
		RET
;
PPZERO:		MVI	A,'0'
		CALL	CO
		MVI	A,'.'
		CALL	CO
		JMP	BLK
;
OUT2:		MOV	A,M
		CALL	ROT4
		CALL	OUT1
		MOV	A,M
;
OUT1:		ANI	0FH
		ADI	30H
		JMP	CO
;
ROT4:		RRC
		RRC
		RRC
		RRC
		RET
;
BOUT:		MOV	A,C
		MVI	E,-1
;
BLP:		INR	E
		SUB	B
		JNC	BLP
		ADD	B
		MOV	C,A
		MOV	A,E
		JMP	OUT1
;
FPCNV:		;Set return code
		XRA	A
		STA	FRCOD
;
		PUSH	B		;HL POINT TO FLOATING POINT EXP BYTE
		LXI	B,1-FPLEN
		DAD	B
		SHLD	FPLOC		;DE POINT TO ASCII STRING
		MVI	C,DIGS/2
		CALL	CLEAR
		SHLD	LEXP
		XCHG
		SHLD	BUFP
		CALL	SCAN1
		MOV	A,B
		ORA	C
		LHLD	BUFP
		XCHG
		INX	D
		JZ	PNODIG
		DCX	D
		MVI	C,DIGS
		LHLD	FPLOC
		MVI	M,10H
		CALL	JAM
		MVI	C,40H
		CPI	'E'
		JZ	FEX1
		CPI	'e'
;
FEX1:		CZ	DEXP
		CALL	FEXP
;
PNODIG:		LHLD	LEXP
		MOV	M,C
;
FZRO:		POP	B
		DCX	D
		LDAX	D
		INX	D
;
		LDA	FRCOD
		RET
;
CLEAR:		MVI	M,00
		INX	H
		DCR	C
		JNZ	CLEAR
		RET
;
SCAN1:		XRA	A
		STA	NB4
		STA	NAFT
		MOV	B,A
		MOV	C,A
;
LOOP1:		MOV	A,M
		INX	H
		STA	TYPE
		CPI	'.'
		JC	LOP1
		DCX	H
;
LOP1:		MOV	A,M
		INX	H
		CPI	'0'
		JZ	LOP1
		DCX	H
;
NDLP1:		SHLD	BUFP
;
LOOP2:		MOV	A,M
		CALL	TEST
		JC	DUNB4
		INR	B
		INX	H
		JMP	LOOP2
;
DUNB4:		MOV	A,B
		STA	NB4
		ORA	A
		JNZ	NOAFT
		MOV	A,M
		CPI	'.'
		JNZ	TRUBL
		INR	B
;
LOOP3:		INX	H
		INR	C
		SHLD	BUFP
		MOV	A,M
		CPI	'0'
		JZ	LOOP3
		CALL	TEST
		JNC	DIG1A
		LXI	B,0000
;
DIG1A:		MOV	A,B
		STA	NB4
;
NOAFT:		MOV	A,C
		STA	NAFT
		ADD	B
		MOV	B,A
		RET
;
TRUBL:		CPI	'E'
		JZ	FEX2
		CPI	'e'
;
FEX2:		RNZ
		INR	B
		MVI	A,1
		STA	NB4
		RET
;
JAM:		MOV	B,M
		CALL	GET
		RC
		SUI	30H
		CALL	ROT4
		MOV	M,A
		DCR	C
		JZ	NOTRM
		CALL	GET
		RC
		MOV	B,M
		SUI	30H
		ORA	B
		MOV	M,A
		INX	H
		DCR	C
		JNZ	JAM
;
NOTRM:		CALL	GET
		RC
		JMP	NOTRM
;
GET:		LDAX	D
		INX	D
		CPI	'.'
		JZ	GET
;
TEST:		CPI	'0'
		RC
		CPI	'9'+1
		CMC
		RET
;
DEXP:		XCHG
		MOV	A,M
		STA	TEXP
		CPI	'0'
		JNC	EOK
		INX	H
		MOV	A,M
;
EOK:		INX	H
		SUI	30H
		MOV	B,A
		MOV	A,M
		CALL	TEST
		JC	DEXP1
		MOV	A,B
		CALL	TENA
		MOV	B,A
		MOV	A,M
		INX	H
		SUI	30H
		ADD	B
		MOV	B,A
;
DEXP1:		LDA	TEXP
		CPI	'-'
		JNZ	EPLUZ
		MOV	A,B
		CMA
		INR	A
		MOV	B,A
;
EPLUZ:		MOV	A,B
		ADD	C
		MOV	C,A
		XCHG
		INX	D
		RET
;
TENA:		PUSH	B
		MOV	B,A
		ADD	A
		ADD	A
		ADD	B
		ADD	A
		POP	B
		RET
;
FEXP:		LDA	NB4
		ADD	C
		MOV	C,A
		LDA	NAFT
		CMA
		INR	A
		ADD	C
		MOV	C,A
		LDA	TYPE
		CPI	'-'
		RNZ
		MOV	A,C
		ORI	80H
		MOV	C,A
		RET
;
	PAGE
;
;**************************************************************
;
;	FORMATTED FLOATING POINT PRINT
;	DE POINTS TO LEFT END OF PRINT FIELD
;	HL POINTS TO (EXPONENT) VARIABLE
;	VARIABLE STORAGE MODE
;	AFTER EXPONENT=FIELD LENGTH
;	THEN COMES PRECISION,NUMBER OF PLACES
;	AFTER DECIMAL
;	FIELD LENGTH MUST INCLUDE SPACE FOR
;	DECIMAL POINT AND SIGN
;
FORMT:		XRA	A		;initialize return code
		STA	FRCOD
		STA	ST2BUF
		INX	H
		MOV	B,M
		INX	H
		MOV	C,M
		DCX	H
		DCX	H
		PUSH	B
		PUSH	D
		MOV	C,B
		MVI	B,0
		XCHG
		DAD	B
		SHLD	FLEND
		XCHG
		POP	D
		CALL	FANUT
		POP	B
		MOV	A,B
		ORA	A		;reset carry
		DCR	A
		DCR	A
		JC	FORMT1A
		SUB	C
;
;	JC	FERR
;
		JNC	FORMT1
		MVI	A,EFMM		;M too large
		STA	FRCOD
		JMP	FERR
;
FORMT1:		MOV	B,A
		MOV	A,M
		STA	PWR
		ANI	7FH
		SUI	41H
		JM	NODIG
		CPI	18H		;upper limit
		JNC	FORMT1A
		INR	A
		CMP	B
;
;	JNC	OVERF
;
		JC	FORMT2
;
FORMT1A:	MVI	A,EFNN		;N too small
		STA	FRCOD
		JMP	OVERF
;
FORMT2:		STA	DBG4
		INR	C
		ADD	C
;
DIGNO:		DCR	A
		DCR	C
		CPI	DIGS+1
		JNC	DIGNO
		ADD	C
		JM	PZERO1
		XCHG
		LDA	DBG4
;
NPOS1:		CMP	B
		JP	ST1
		INX	H
		INR	A
		JMP	NPOS1
;
ST1:		CALL	PSIGN
		XCHG
		LHLD	SDIGS
		LDA	DBG4
		MOV	B,A
;
;ST2	equ	$
;
		MVI	A,12		;check digit limit
		SUB	B
		JP	ST2A		;ok
		MVI	B,12		;maximum digits in buffer
		CMA
		INR	A		;spaces remaining before
		STA	ST2BUF		; decimal to be filled with zeros
;
ST2A:		MOV	A,M
		STAX	D
		INX	D
		INX	H
		DCR	B
;
;	JNZ	ST2
;
		JNZ	ST2A
		LDA	ST2BUF		;check if zeros before decimal
		ORA	A
		JZ	ST2C
		MOV	B,A
		MVI	A,'0'
;
ST2B:		STAX	D
		INX	D
		DCR	B
		JNZ	ST2B
;
ST2C:		MVI	A,'.'
		STAX	D
		INX	D
		LDA	ST2BUF		;non-zero here means no more
		ORA	A		; digits
		JNZ	ST4		;so return
;
ST3:		DCR	C
		JM	ST4
		MOV	A,M
		STAX	D
		INX	D
		INX	H
		JMP	ST3
;
ST4:		MVI	C,-1		;signal non-zero value
		LDA	FRCOD		;pick up return code
		RET
;
PSIGN:		LDA	PWR
		INX	H
		ANI	80H
		RZ
		DCX	H
		MVI	M,'-'
		INX	H
		RET
;
FANUT:		PUSH	H
		PUSH	D
		MVI	B,FPLM1
		DCX	H
;
;	LXI	D,FANUT-1
;
		LXI	D,DGBUF+DIGS-1	;never address a data field
					; in this fashion
;
FANLP:		MOV	A,M
		ANI	0FH
		ADI	30H
		STAX	D
		DCX	D
		MOV	A,M
		RAR
		RAR
		RAR
		RAR
		ANI	0FH
		ADI	30H
		STAX	D
		DCX	D
		DCX	H
		DCR	B
		JNZ	FANLP
		XCHG
		POP	D
		INX	H
		SHLD	SDIGS
		POP	H
		RET
;
PZERO:		LHLD	FLEND
;
DZERO:		MVI	M,'0'
		INX	H
		RET
;
PZERO1:		MVI	C,0		;signal a zero
		LDA	FRCOD		;return code
		JMP	PZERO
;
NODIG:		CMA
		MOV	B,A
		SUB	C
;
;	JNC	PZERO
;
		JNC	PZERO1		;return to external caller, not an
					; internal routine this time
		LHLD	FLEND
		MOV	A,C
;
BDIG1:		DCR	A
		JM	BDIG2
		DCX	H
		JMP	BDIG1
;
BDIG2:		DCX	H
		DCX	H
		DCX	H
		CALL	PSIGN
		CALL	DZERO
		MVI	M,'.'
		INX	H
		MOV	A,B
;
BDIG3:		DCR	A
		JM	BDIG4
		CALL	DZERO
		DCR	C
		JMP	BDIG3
;
BDIG4:		XCHG
		LHLD	SDIGS
		JMP	ST3
;
FERR		EQU	$
;
OVERF:		XRA	A		;B must not be zero
		CMP	B
		JNZ	OVERF1
		MVI	B,1
;
OVERF1:		LHLD	FLEND		;OVERFLOW ROUTINE
;
OVER1:		MVI	M,'*'
		DCX	H
		DCR	B
		JNZ	OVER1
		LDA	FRCOD		;pick up return code
		RET
;
	PAGE
;
;**************************************************************
;
;	FCMPR.ASM  JRB  9/12/81    FLOATING POINT COMPARE
;	COMPARE THE TWO ELEMENTS POINTED TO BY DE AND HL
;	RETURNS A=1 IF DE<HL, A=2 IF DE=HL, A=4 IF DE>HL
;
;Altered by C. E. Duncan to fit his interface 1981 November 12.
;
FCMPR:		XCHG			;right arg to HL
		MOV	D,B		;left arg to DE
		MOV	E,C
		CALL	CMP2V		;GET Z IF =, CY IF <=
		MVI	A,2
		RZ			;RETURN A=2 IF EQUAL
		DCR	A
		RC			;RETURN A=1 IF DE<HL (left < right)
		MVI	A,4
		RET			;ELSE A=4 IF DE>HL (left > right)
;
;	THIS INTERNAL ROUTINE RETURNS Z IF =, CY IF DE<=HL
;	REMOVED BY JRB FROM ASHLEY'S
;	SOURCE FILE "NUMRSORT.ASM"
;
CMP2V:		LDAX	D
		XRA	M
		JP	SMSGN
		LDAX	D		;IF HERE, SIGNS ARE DIFFERENT
		RAL			;SIGN OF DE ARG TO CY FLAG
		RET			;DIFFERENT SIGNS EXIT
;
SMSGN:		;HERE IF SIGNS SAME
		ORA	M
		JP	NONEG
		XCHG			;IF NEG, INTERCHANGE ARGS
;
NONEG:		LDAX	D
		CMP	M		;COMPARE EXPONENTS
		RNZ			;DIFFERENT EXPONENTS EXIT:  CY IF DE<HL
		LXI	B,1-FPLEN
		DAD	B		;POINT HI ORDER BYTE OF EACH ARG
		XCHG
		DAD	B		;..
		XCHG
		MVI	B,FPLEN
;
CMPLP:		;LOOP TO COMPARE DIGITS
		LDAX	D
		CMP	M		;SET CY IF DE ARG LESS
		RNZ			;XIF DIFFERENT BYTE FOUND
		INX	D
		INX	H
		DCR	B
		JNZ	CMPLP
		STC			;EQUAL IF HERE. Z SET. SET CY!
		RET			;SO EQUAL RETURNS Z AND CY,
		   			; IE CY REPRESENTS LESS OR EQUAL.
;
	PAGE
;
;Subroutine needed by FPOUT in place of CO
;
;Character out routine:
;
MOVCHAR:	;Write character from register A to field which has length LENOUT
		; and address ADROUT.
;
;Written by C. E. Duncan 1981 October 29.
;
;--------------------------------------------------------------
;
;Input:	A = character to be written
;	ADROUT
;	LENOUT
;
;Output:	A = 0 if ok, -1 if field over-run
;		ADROUT := ADROUT + 1
;		LENOUT := LENOUT - 1
;		character has been written to address in ADROUT
;
;Calls to:
;Called from:	FPOUT
;	Must preserve carry bit for FPOUT proper function
;
;--------------------------------------------------------------
;
		PUSH	B		;save
		PUSH	D
		PUSH	H
		PUSH	PSW
		LDA	LENOUT		;check remaining space
		ORA	A
		JZ	VCP01		;no more room
		DCR	A		;count
		STA	LENOUT
		POP	PSW		;recover character
		LHLD	ADROUT		;place to put it
		MOV	M,A
		INX	H
		SHLD	ADROUT
		MVI	A,0		;0 = ok
		JMP	VCP02
;
VCP01:		POP	PSW		;clear stack
		MVI	A,-1		;signal overflow
;
VCP02:		POP	H		;restore
		POP	D
		POP	B
		RET
;
;	End *MOVCHAR*
;
	PAGE
;
;		Storage and constants
;
;		RAM AREA FROM HERE
;
;
DGV3C		DW	0
		DS	FPLM1
FTEMP		DS	1
FSVHL		DS	2
FSVDE		DS	2
FSVBC		DS	3
DGBF1		DS	FPLM1-1
DGBF2		DB	0
DGBF3		DS	FPLM1-1
DGBF4		DB	0
DGV57		DS	FPLEN+1
DGV5F		DB	0
DGV60		DS	FPLEN-2
DGV65		DS	FPLEN
DGV6C		DB	0
;
FRCOD		DB	0		;return code
;
		DS	1
BUFP		DS	2
FPLOC		DS	2
NB4		DS	1
NAFT		DS	1
LEXP		DS	2
TEXP		DS	1
TYPE		DS	1
DGBUF		DS	DIGS
FLEND		DW	0
DFLAG		DB	0
SDIGS		DW	0
DBG4		DB	0
PWR		DB	0
;
ST2BUF		db	0		;count of zeros before decimal
FNBUF		ds	FPLEN+2		;floating point work area
					; COUPLE
;
EXPSAV		db	0,'    '	;EEROUND save area
;
A8FLG		db	0		;PIO8 signal, arctangent
A2FLG		db	0		;PIO2 signal, arctangent
ATSGN		db	0		;arctangent sign
ASSGN		db	0		;arcsine sign
ARCCT1L		ds	FPLM1		;work area for arccosine
ARCCT1		db	0
;
ARCST1L		ds	FPLM1		;work area for arcsine
ARCST1		db	0
ARCST2L		ds	FPLM1
ARCST2		db	0
;
TEMP1L		ds	FPLM1		;temporary
TEMP1		db	0
TEMP2L		ds	FPLM1		; ditto
TEMP2		db	0
TEMP3L		ds	FPLM1		; ditto
TEMP3		db	0
;
MODTMP1L	ds	FPLM1		;for MOD function
MODTMP1		DB	0
MODTMP2L	ds	FPLM1
MODTMP2		DB	0
;
YNL		ds	FPLM1		;SQRT work areas
YN		db	0
;
STMP1L		ds	FPLM1
STMP1		db	0
STMP2L		ds	FPLM1
STMP2		db	0
;
RTFCN		db	0		;Function code for trig fcns
RTSGN		db	0		;sign flag
RTRCP		DB	0		;reciprocal flag, tangent
;
TRGTMP1L	ds	FPLM1		;temporary for TRIG
TRGTMP1		DB	0
TRGTMP2L	ds	FPLM1
TRGTMP2		DB	0
TRGTMP3L	ds	FPLM1
TRGTMP3		db	0
;
ADROUT		dw	0		;destination address
LENOUT		db	0		;destination field size, bytes
;
PSIZE		db	0		;polynomial order
;
TENTMP1		ds	FPLEN		;TENTOX temporary
TENTMP4		ds	FPLEN		; ditto
TENTMP2		db	0		; ditto
TENTMP3		db	0		; ditto
TRUNTMP		db	0		;TRUNC temporary
;
GERN1		db	0		;input string length GEROUND
GERW1		db	0		;field width GEROUND
GERF1		db	0		;integer flag
;
FFAW		ds	7		;conversion work area
;
FPHALFL		db	50H,00H,00H,00H,00H,00H		;float 0.5
FPHALF		db	40H
FPMONEL		db	10H,00H,00H,00H,00H,00H		;float -1
FPMONE		db	0C1H
FPZEROL		db	0,0,0,0,0,0
FPZERO		db	0
;
;	Tangent of PIO8
;
TANPIO8		db	41H,42H,13H,56H,23H,73H
		DB	40H
;
;	Square root of ten
;
SQT10L		db	31H,62H,27H,76H,60H,17H
SQT10		db	41H
;
;	Logarithm of 10 to the base e
;
LOGEXL		db	23H,02H,58H,50H,92H,99H
LOGEX		db	41H
;
;	General constants for trigonometric functions
;
TWOPI		db	62H,83H,18H,53H,07H,18H
		DB	41H
TPIO2		db	47H,12H,38H,89H,80H,38H
		DB	41H
PI		db	31H,41H,59H,26H,53H,59H
		DB	41H
PIO2		db	15H,70H,79H,63H,26H,79H
		DB	41H
PIO4		db	78H,53H,98H,16H,33H,97H
		DB	40H
PIO2M		db	15H,70H,79H,58H,00H,00H
		DB	41H
PIO2P		db	15H,70H,79H,69H,00H,00H
		DB	41H
PIO8		db	39H,26H,99H,08H,16H,99H
		DB	40H
;
;	Coefficients for logarithm to base 10, #2285
;
LOGCOEF		db	17H,92H,42H,53H,24H,00H
		DB	40H
		DB	24H,05H,69H,07H,61H,00H
		DB	3FH
		DB	10H,89H,87H,33H,98H,84H
		DB	40H
		DB	12H,26H,16H,77H,63H,94H
		DB	40H
		DB	17H,38H,04H,94H,71H,29H
		DB	40H
		DB	28H,95H,27H,39H,07H,48H
		DB	40H
		DB	86H,85H,88H,98H,07H,58H
		DB	40H
;
;	Coefficients for ten to the power X, #1625
;
TENCOEF		DB	14H,11H,93H,98H,89H,39H
		DB	3FH
		DB	23H,41H,37H,76H,80H,80H
		DB	3DH
		DB	88H,38H,98H,77H,70H,46H
		DB	3FH
		DB	19H,50H,67H,27H,44H,47H
		DB	40H
		DB	54H,34H,01H,56H,84H,92H
		DB	40H
		DB	11H,70H,50H,91H,84H,38H
		DB	41H
		DB	20H,34H,74H,66H,93H,58H
		DB	41H
		DB	26H,50H,94H,67H,08H,55H
		DB	41H
		DB	23H,02H,58H,51H,06H,99H
		DB	41H
;
FPONEL		db	10H,00H,00H,00H,00H,00H
FPONE		db	41H
;
;	Coefficients for TANgent, #4266
;
TANCOEF		db	11H,80H,26H,43H,82H,10H
		DB	3DH
		DB	68H,08H,21H,09H,00H,00H
		DB	0BAH
		DB	76H,68H,32H,82H,30H,90H
		DB	3DH
		DB	24H,14H,94H,62H,61H,86H
		DB	3EH
		DB	99H,67H,68H,08H,81H,67H
		DB	3EH
		DB	39H,84H,38H,89H,32H,25H
		DB	3FH
		DB	16H,14H,91H,14H,14H,45H
		DB	40H
		DB	78H,53H,98H,16H,24H,76H
		DB	40H
;
;	Coefficients for SINe and COSine, #3342
;
SINCOEF		db	34H,28H,79H,07H,30H,00H
		DB	0BBH
		DB	16H,02H,47H,02H,88H,30H
		DB	3DH
		DB	46H,81H,65H,10H,16H,34H
		DB	0BEH
		DB	79H,69H,26H,01H,25H,99H
		DB	3FH
		DB	64H,59H,64H,09H,52H,64H
		DB	0C0H
		DB	15H,70H,79H,63H,26H,76H
		DB	41H
;
;	Coefficients for ARCTANgent, #4963
;
ACTCOEF		db	60H,34H,68H,83H,00H,00H
		DB	0BFH
		DB	10H,57H,34H,40H,27H,50H
		DB	40H
		DB	14H,24H,00H,77H,73H,17H
		DB	0C0H
		DB	19H,99H,82H,16H,66H,65H
		DB	40H
		DB	33H,33H,33H,07H,62H,08H
		DB	0C0H
		DB	99H,99H,99H,99H,93H,97H
		DB	40H
;
ASHLEND		db	'ASHLINK VERSION A.1, 1982 APR 19'
;
	PAGE
;
;**************************************************************
;
;	Continuation of TEST program
;
;	Equates
;
ALEN		equ	2*FPLEN+6	;field length ASCII form
BDOS		equ	5		;CP/M entry
CONST		equ	11		;CP/M cmd console status
CR		equ	13		;carriage return
CTLA		equ	1		;Ctl-A, SOH
CTLZ		equ	01AH		;Ctl-Z, SUB
LF		equ	10		;line feed
RDCBUF		equ	10		;BDOS read keyboard to buffer
RDCON		equ	1		;BDOS read console character
WRCBUF		equ	9		;BDOS write string to console
WRCON		equ	2		;BDOS write console character
;
;	Messages
;
CVRMSG		db	CR,LF,'Converted result:	$'
DV0MSG		db	CR,LF,'Attempt to divide by zero.$'
FARMSG		db	CR,LF,'Enter 1st argument:	$'
FLSMSG		db	CR,LF,'Field size:	$'
PRCNSG		db	CR,LF,'Precision:	$'
RTCMSG		db	CR,LF,'Return code:	$'
SARMSG		db	CR,LF,'Enter 2nd argument:	$'
SGNMSG		db	CR,LF,'Test Ashley Floating Point Routines.$'
WCRLF		db	CR,LF,'$'
WCR2LF		db	CR,LF,LF,'$'
;
;	Storage
;
FLPARG		equ	$
F1		ds	FPLEN		;1st argument, float
		DW	0		;for possible parameters
F2		ds	FPLEN		;2nd
		DW	0
F3		ds	FPLEN		;result
		DW	0
FLOP		db	0		;function code, binary
FRGLEN		equ	$-FLPARG
;
ASCARG		equ	$
A1		ds	ALEN		;space for ASCII representation
A2		ds	ALEN
A3		ds	ALEN
ASCOP		db	' '		;operator
RETASC		ds	2		;ASCII return code
FPWRKA		ds	80		;"F" receiving field
FPWKLEN		equ	$-FPWRKA	;field size
ASCLEN		equ	$-ASCARG	;area to be cleared
NLEN		db	0		;F-conversion field length
MLEN		db	0		;F-conversion precision
;
AADL		dw	0		;A, 1st parameter, left address
BADL		dw	0		;B, 2nd parameter, left address
RADL		dw	0		;result, left address
RCNT		db	0		;result count (length), bytes
RCOD		db	0		;return code
RASCII		dw	0		;address of "F" conv rec field
;
SPSAVE		dw	0		;save CCP stack pointer
;
PN		DB	'   $'		;number conversion to ASCII
;
;	Function code prompt
;
;	Function codes
;
FCNPRMT		db	CR,LF,'                C O D E S :'
		DB	CR,LF,'     DYADIC:	               CONVERSION:'
		DB	CR,LF
		DB	CR,LF,' 0 - Add      		16 - ASCII to float'
		DB	CR,LF,' 1 - Subtract		17 - float to Dollar'
		DB	CR,LF,' 2 - Multiply		18 - float to "E"'
		DB	CR,LF,' 3 - Divide		19 - float to "G"'
		DB	CR,LF,' 4 - X to power Y	20 - float to binary'
		DB	CR,LF,' 5 - Compare	       [21 - binary to float]'
		DB	CR,LF,' 6 - X modulo Y		22 - float to 8-bit binary'
		DB	CR,LF,'              MONADIC:'
		DB	CR,LF
		DB	CR,LF,'32 - ABS     	38 - LOG10	44 - COSINE'
		DB	CR,LF,'33 - INTGR	39 - LOGE	45 - TANGENT'
		DB	CR,LF,'34 - TRUNC	40 - TNPWR	46 - ASIN'
		DB	CR,LF,'35 - FLOOR	41 - EXP	47 - ACOS'
		DB	CR,LF,'36 - CEIL	42 - SQRT	48 - ATAN'
		DB	CR,LF,'37 - ROUND	43 - SINE'
		DB	CR,LF,'$'
;
;	Stack
;
		DS	128
STACK		dw	0
;
;	Console buffer
;
CONBUF		db	CONLEN
CONSIZ		ds	1
CONLIN		ds	79
CONLEN		equ	$-CONSIZ
IBFCNT		db	0		;remaining count
IBFPTR		dw	0		;current position
;
		DW	0
ASHTEND		db	'ASHTEST A.3 1982 March 30'
		DW	0
;
;
			END
		