;
;TEXCLEAN.ASM ver 1.0 by Keith Petersen, W8SDZ
;
;This program cleans up CP/M files which where
;created with a text processor that sets bit 7
;of some characters.
;
month	equ	5	;last..
day	equ	22	;..modification..
year	equ	80	;..date
;
;Clean-up is done in place, i.e. the file is
;modified on top of itself.  Each sector is read
;into memory and the characters are all ani'ed with
;7FH to set bit 7 low, and then the same sector is
;written back to the disk.
;
;Command format:
;
;	TEXCLEAN FILENAME.TYPE
;
;This program is adapted from Ward Christensen's
;SCRAMBLE.ASM.
;
MF	SET	0	;SHOW MOVE NOT REQUESTED
CF	SET	0	;SHOW COMP NOT REQUESTED
;
;(FROM EQU8.LIB...)
;DEFINE SOME MACROS TO MAKE THINGS EASIER
;
;DEFINE DATA MOVE MACRO: MOVE from,to,length
;	from may be addr, or quoted string
;
MOVE	MACRO	?F,?T,?L
	IF	NOT NUL ?F
	IRPC	?C,?F
?Q	SET	'&?C&?C' ;;TEST FOR QUOTE
	EXITM
	ENDM
	IF	?Q EQ ''''
	LOCAL	?B,?Z
	CALL	?Z
?B	DB	?F
?Z	POP	H	;GET FROM
	LXI	B,?Z-?B	;GET LEN
	ELSE
	LXI	H,?F
	ENDIF
	ENDIF
	IF	NOT NUL ?T
	LXI	D,?T
	ENDIF
	IF	NOT NUL ?L
	LXI	B,?L
	ENDIF
	CALL	MOVER
MF	SET	-1	;;SHOW EXPANSION
	ENDM
;
;DEFINE CP/M MACRO - CPM FNC,PARM
;
CPM	MACRO	?F,?P
	PUSH	B
	PUSH	D
	PUSH	H
	IF	NOT NUL ?F
	MVI	C,?F
	ENDIF
	IF	NOT NUL ?P
	LXI	D,?P
	ENDIF
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	ENDM
;
	ORG	100H
;
;INIT LOCAL STACK
;
	LXI	H,0
	DAD	SP
	SHLD	STACK
	LXI	SP,STACK
;
;SIGN ON
;
	CALL	START
	DB	'TEXCLEAN.COM as of '
	DB	'0'+MONTH/10
	DB	'0'+MONTH MOD 10,'/'
	DB	'0'+DAY/10
	DB	'0'+DAY MOD 10,'/'
	DB	'0'+YEAR/10
	DB	'0'+YEAR MOD 10
	DB	0DH,0AH,'$'
START	POP	D	;GET ID
	MVI	C,PRINT
	CALL	BDOS	;PRINT ID
;
;SEE THAT THE INPUT FILE EXISTS
;
	CPM	OPEN,FCB
	INR	A	;OK?
	JNZ	READFLP	;YES, CLEAN IT
	CALL	ERXIT
	DB	'++NO SUCH FILE++$'
;
;READ THE FILE, RESET BIT 7 OF ALL CHARACTERS IN
;A SECTOR, RE-WRITE IT.
;
READFLP	CALL	RDSECT	;READ A SECTOR
	JC	FINISH	;EXIT LOOP IF EOF
	CALL	FIXIT	;GET RID OF ALL BIT 7'S
	CALL	BACKUP	;RE-POSITION FOR WRITE
	CALL	WRSECT	;RE-WRITE THE SECTOR
	JMP	READFLP	;LOOP UNTIL EOF
;
;ALL DONE - ON A "NORMAL" CP/M SYSTEM, WE WOULDN'T
;HAVE TO DO ANYTHING, BECAUSE WE RE-WROTE IN PLACE.
;
;HOWEVER, FOR SUCH SYSTEMS AS THE NORTHSTAR CP/M,
;WE MUST EXPLICITLY CLOSE THE FILE, BECAUSE THE WRITE
;TO THE DIRECTORY WILL CAUSE THE CLEVER LIFEBOAT-
;DESIGNED BIOS TO FLUSH IT'S MEMORY-RESIDENT DISK
;BUFFERS
;
FINISH	CPM	CLOSE,FCB
	INR	A	;THIS BETTER WORK..
	JNZ	EXIT
	DB	'++ CLOSE ERROR - FILE LEFT IN '
	DB	'UNKNOWN CONDITION ++$'
;
;SECTOR READ ROUTINE
;
RDSECT	CPM	READ,FCB
	ORA	A
	RZ		;ALL OK
;
;READ ERROR OR EOF
;
	CPI	1	;EOF?
	STC		;CARRY SHOWS EOF
	RZ		;RET, CARRY SET
	CALL	ERXIT
	DB	'++ READ ERROR - FILE MAY BE '
	DB	'DESTROYED ++$'
;
;FIX THE SECTOR
;
FIXIT	LXI	H,80H	;POINT TO SECTOR
FIXLP	MOV	A,M	;GET CHARACTER
	ANI	7FH	;STRIP BIT 7
	MOV	M,A	;RESTORE IT TO MEMORY
	INR	L	;MORE IN SECTOR?
	JNZ	FIXLP
	RET
;
;BACKUP THE FILE POINTER FOR THE RE-WRITE
;
BACKUP	LDA	FCBRNO	;GET SECTOR #
	DCR	A	;BACK UP
	STA	FCBRNO
	RP		;RETURN IF OK
;
;WE BACKED UP INTO PREVIOUS EXTENT, WILL HAVE
;TO RE-OPEN IT
;
	LDA	FCBEXT	;GET EXTENT
	DCR	A	;BACK UP 1
	STA	FCBEXT
	CPM	OPEN,FCB ;RE-OPEN
	INR	A
	JNZ	OPEN2OK
	CALL	ERXIT
	DB	'++ RE-OPENING EXTENT FAILED',0DH,0AH
	DB	'++ FILE IS CLOBBERED $'
OPEN2OK	MVI	A,7FH	;GET HI SECTOR
	STA	FCBRNO
	RET
;
;WRITE BACK THE SECTOR
;
WRSECT	XRA	A
	STA	FCB+14	;RESET S-2 BYTE IN FCB
	CPM	WRITE,FCB
	ORA	A
	RZ
	CALL	ERXIT
	DB	'++ WRITE ERROR - FILE CLOBBERED ++$'
;
;FOLLOWING FROM 'EQU7.LIB'---->
;
;MOVE SUBROUTINES
;
	IF	MF	;MACRO EXPANSION FLAG SET?
MOVER	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	MOVER
	RET
	ENDIF
;
;EXIT WITH ERROR MESSAGE
MSGEXIT	EQU	$	;EXIT W/"INFORMATIONAL" MSG
ERXIT	POP	D	;GET MSG
	MVI	C,PRINT
	CALL	BDOS
;EXIT, RESTORING STACK AND RETURN
EXIT	LHLD	STACK
	SPHL
	RET		;TO CCP
;
	DS	40H	;STACK AREA
STACK	DS	2	;OLD STACK KEPT HERE
;
;BDOS/CBIOS EQUATES (VERSION 7)	
RDCON	EQU	1
WRCON	EQU	2
PRINT	EQU	9
CONST	EQU	11
OPEN	EQU	15
CLOSE	EQU	16
SRCHF	EQU	17
SRCHN	EQU	18
ERASE	EQU	19
READ	EQU	20
WRITE	EQU	21
MAKE	EQU	22
REN	EQU	23
STDMA	EQU	26
BDOS	EQU	5
FCB	EQU	5CH 
FCB2	EQU	6CH
FCBEXT	EQU	FCB+12
FCBRNO	EQU	FCB+32
