;
; 17 JUL 80
;
;	Version 5 BIOS
; Modified for Z80 unique instructions 6 Mar 82 RBM
; Modified sector skewing algorithm  15 Feb 82  RBM
; Modified for 2719 operation  7 Feb 82 RBM
; Modified for better placement of time delays  14 Feb 82  RBM
;	Version 4 BIOS
; MODIFIED FOR HEAD LOAD DELAY 16 DEC 80
; MODIFIED FOR PROPER UNIT/STPRAT CORRELATION 9 DEC 80
; MODIFIED FOR SEEK ERROR TRAPPING 10 DEC 80
; MODIFIED FOR NOT READY TRAPPING 11 DEC 80
; MODIFIED FOR MINI/MAXI CONDITIONALS 11 DEC 80
;	Version 3 BIOS
; MODIFIED FOR UNALLOCATED WRITE CORRECTIONS 8 SEP 80
; MODIFIED FOR AUTO-BOOT OPERATION 7 SEP 80
; MODIFIED FOR COMPUTED SKEW FACTORS 7 SEP 80
; MODIFIED FOR WARM BOOTS FROM MINIS 14 AUG 80
; MODIFIED FOR PROPER DEFAULT DISK RESTORAL ON WARM BOOT 12 AUG 80
; MODIFIED FOR 2 MHZ 8080 OPERATION 12 AUG 80
;
	TITLE	'CCS 2422 Deblocked BIOS (V5.0) for CP/M 2.2'
	PAGE	56
;
; THIS BIOS IS SET UP FOR AUTO SELECT OF DISK CHAR
;
;"BIAS" IS ADDRESS OFFSET FROM 2C00H FOR MEMORY SYSTEMS
;THAN 20K (REFERRED TO AS "B" THROUGHOUT THE TEXT).
;
TRUE:	EQU	0FFFFH
FALS:	EQU	NOT TRUE
;
CCS2719:  EQU	TRUE	; TO IMPLEMENT THE CCS 2719
;
VERS:	EQU	22	;CP/M VERSION NUMBER
MSIZE:	EQU	64	;CP/M VERSION MEMORY SIZE IN KILOBYTES
BIAS:	EQU	(MSIZE-20)*1024
CCP:	EQU	2C00H+BIAS
CCPV:	EQU	CCP
BDOS:	EQU	CCP+806H	;BASE OF BDOS
BIOS:	EQU	CCP+1600H	;BASE OF BIOS
;
; Drive environment definition
;
NDISKS:	EQU	4	;NUMBER OF DRIVES TO BE SUPPORTED
;
MAXI:	EQU	TRUE	;CONDITIONAL FLAG FOR 8" DRIVE SUPPORT
DS8:	EQU	TRUE	; Double Sided 8" Drive support
;
MINI:	EQU	TRUE	;5.25" Drive support
DS5:	EQU	FALS	;Double Sided 5.25" support
;
BOTH:	EQU	MINI AND MAXI
;
; If 5.25" drives are supported, the number of tracks must be
;	specified.  Valid options are 35, 40, or 80 tracks.
;	One and only one of the equates must be TRUE.
;
T35:	EQU	true	;35 Track drives in use
T40:	EQU	fals	;40 Track drives in use
T80:	EQU	FALS	;80 Track drives in use
;
; STEP RATES MAY BE TAILORED TO MEET INDIVIDUAL DRIVE REQUIREMENTS.
;   TO DO SO, DETERMINE THE PROPER TRACK-TO-TRACK STEP RATES FROM
;   YOUR DISK DRIVE'S TECHNICAL MANUAL, AND SET THE STEP5 (FOR MINI
;   DRIVES) AND/OR STEP8 (FOR 8" DRIVES) TO THE VALUE SHOWN IN
;   THE FOLLOWING TABLE:
;
;	VALUE		MINI DISKS	8" DISKS
;	  0		  6 MS		  3 MS
;	  1		 12 MS		  6 MS
;	  2		 20 MS		 10 MS
;	  3		 30 MS		 15 MS
;
STEP5:	EQU	3	;MINI DISK STEP RATE
STEP8:	EQU	1	;8" DISK STEP RATE
;
;	CCS 2810 Serial Port equates
;
SDATA:	EQU	20H	;SERIAL DATA PORT
SINTEN:	EQU	SDATA+1	;SERIAL INTERRUPT ENABLE PORT
SIDENT:	EQU	SDATA+2	;SERIAL INTERRUPT IDENTIFICATION PORT
SLCTRL:	EQU	SDATA+3	;SERIAL LINE CONTROL PORT
SMDMCT:	EQU	SDATA+4	;SERIAL MODEM CONTROL PORT
SLSTAT:	EQU	SDATA+5	;SERIAL LINE STATUS PORT
SMDMST:	EQU	SDATA+6	;SERIAL MODEM STATUS PORT
;
RXRDY:	EQU	00000001B  ;RECEIVE DATA AVAILABLE BIT
TXMTY:	EQU	00100000B  ;TRANSMIT BUFFER EMPTY BIT
;
; WHEN THE AUTO-BOOT JUMPER IS ENABLED, THE 2810
;  SERIAL PORT WILL BE INITIALIZED TO 9600 BAUD.
;  TO SELECT A DIFFERENT BAUD RATE, CHANGE SBAUD
;  TO ONE OF THE FOLLOWING VALUES:
;
;     BAUD RATE		SBAUD
;	50		2304
;	75		1536
;	110		1047
;	134.5		857
;	150		768
;	300		384
;	600		192
;	1200		96
;	1800		64
;	2000		58
;	2400		48
;	3600		32
;	4800		24
;	7200		16
;	9600		12
;	19200		6
;	38400		3
;	56000		2
;
SBAUD:	EQU	12	;9600 BAUD DIVISOR FOR 2810
;
  IF	CCS2719
;
; 2719 PORT ADDRESS ASSIGNMENTS
;
BASE19:	EQU	50H	; BASE ADDRESS OF THE 2719 BOARD
;
CTC0:	EQU	BASE19	; CTC BASE ADDRESS
CTC1:	EQU	CTC0+1	; CTC #1
CTC2:	EQU	CTC0+2	; CTC #2
CTC3:	EQU	CTC0+3	; CTC #3
;
SIOAD:	EQU	BASE19+4  ; SIO CHANNEL A DATA REGISTER
SIOAC:	EQU	SIOAD+1	; SIO CHANNEL A COMMAND REGISTER
SIOAS:	EQU	SIOAC	; SIO CHANNEL A STATUS REGISTER
SIOBD:	EQU	BASE19+6  ; SIO CHANNEL B DATA REGISTER
SIOBC:	EQU	SIOBD+1	; SIO CHANNEL B COMMAND REGISTER
SIOBS:	EQU	SIOBC	; SIO CHANNEL B STATUS REGISTER
;
PIA1AD:	EQU	BASE19+8  ; PIA1 CHANNEL A DATA REGISTER
PIA1ADD:  EQU	PIA1AD	; PIA1 CHANNEL A DATA DIRECTION REGISTER
PIA1BD:	EQU	BASE19+9  ; PIA1 CHANNEL B DATA REGISTER
PIA1BDD:  EQU	PIA1BD	; PIA1 CHANNEL B DATA DIRECTION REGISTER
PIA1AC:	EQU	PIA1AD+2  ; PIA1 CHANNEL A COMMAND REGISTER
PIA1AS:	EQU	PIA1AC	; PIA1 CHANNEL A STATUS REGISTER
PIA1BC:	EQU	PIA1BD+2  ; PIA1 CHANNEL B COMMAND REGISTER
PIA1BS:	EQU	PIA1BC	; PIA1 CHANNEL B STATUS REGISTER
;
PIA2AD:	EQU	BASE19+12  ; PIA2 CHANNEL A DATA REGISTER
PIA2ADD:  EQU	PIA2AD	; PIA2 CHANNEL A DATA DIRECTION REGISTER
PIA2BD:	EQU	BASE19+13  ; PIA2 CHANNEL B DATA REGISTER
PIA2BDD:  EQU	PIA2BD	; PIA2 CHANNEL B DATA DIRECTION REGISTER
PIA2AC:	EQU	PIA2AD+2  ; PIA2 CHANNEL A COMMAND REGISTER
PIA2AS:	EQU	PIA2AC	; PIA2 CHANNEL A STATUS REGISTER
PIA2BC:	EQU	PIA2BD+2  ; PIA2 CHANNEL B COMMAND REGISTER
PIA2BS:	EQU	PIA2BC	; PIA2 CHANNEL B STATUS REGISTER
;
PIAMOD:	EQU	00101100B  ; PIA OPERATING MODE BYTE
DATOUT:	EQU	11111111B  ; PIA DATA DIRECTION BYTE FOR OUTPUT
;
; THE FOLLOWING EQUATES ESTABLISH THE BAUD RATES FOR THE 2719 SERIAL
;	CHANNELS.  THREE SETS OF VALUES ARE IDENTIFIED, AND MUST
;	BE SET TO MATCH THE SPECIFIC BOARD CONFIGURATION.
;
;	THE NORMAL CONFIGURATION IS FOR 4 MHZ OPERATION WITH A
;	CRYSTAL OSCILLATOR.  THE OTHER TWO ARE FOR DERIVING THE
;	BAUD RATE CLOCK FROM THE SYSTEM CLOCK DIVIDED BY 2 BY
;	U34 (74LS74).  SEE THE MANUAL TEXT FOR FURTHER DETAIL.
;
;	BAUD	CTCxMOD		CTCxDIV
;			XTAL	2MHZ	4MHZ
;	75	07H	208	104	208
;	110	07H	142	71	142
;	134.5	07H	116	58	116
;	150	07H	104	52	104
;	300	07H	 52	26	 52
;	600	47H	192	104	208
;	1200	47H	 96	 52	104
;	1800	47H	 64	 35	 69
;	2000	47H	 58	 31	 63
;	2400	47H	 48	 26	 52
;	3600	47H	 32	 17	 35
;	4800	47H	 24	 13	 26
;	7200	47H	 16	  9	 17
;	9600	47H	 12	---	 13
;	19200	47H	  6	---	---
;	38400	47H	  3	---	---
;	57600	47H	  2	---	---
;	115200	47H	  1	---	---
;
CTC0MOD:	EQU	47H	; CTC MODE FOR 9600 BAUD
CTC0DIV:	EQU	12	; CTC DIVISOR FOR 9600 BAUD (XTAL)
CTC1MOD:	EQU	47H	; CTC MODE FOR 9600 BAUD
CTC1DIV:	EQU	12	; CTC DIVISOR FOR 9600 BAUD (XTAL)
  ENDIF
;
; 2422 MULTIMODE FLOPPY DISK CONTROLLER EQUATES
;
DSTAT:	EQU	30H	;DISK STATUS PORT
;
TRK0:	EQU	4
;
DCMD:	EQU	DSTAT	;DISK COMMAND PORT
DTRK:	EQU	DSTAT+1	;DISK TRACK PORT
DSCTR:	EQU	DSTAT+2	;DISK SECTOR PORT
DDATA:	EQU	DSTAT+3	;DISK DATA PORT
DSTAT1:	EQU	DSTAT+4	;DISK FLAG PORT
;
AUTBOT:	EQU	40H
HLMSK:	EQU	20H
;
DCTRL1:	EQU	DSTAT+4	;DISK CONTROL PORT
;
AWBIT:	EQU	80H
DDENS:	EQU	40H
MOTOR:	EQU	20H
DRV8:	EQU	10H
;
DCTRL2:	EQU	4	;DISK CONTROL 2 PORT
;
SIDE0:	EQU	40H	; Side 0 select bits
SIDE1:	EQU	0	; Side 1 select bits
;
DSTAT2:	EQU	DCTRL2
;
TWOSID:	EQU	40h
MINI2:	EQU	2
;
; 1793 Type I Commands
;
RSTR:	EQU	8	;BASIS OF RESTORE COMMAND
SEEKV:	EQU	1CH	;BASIS OF SEEK COMMAND
STEPI:	EQU	58H	;BASIS OF STEP IN COMMAND
TP1MSK:	EQU	0FCH
;
; 1793 Type II Commands
;
RDSEC:	EQU	88H	;BASIS OF READ SECTOR COMMAND
WRSBIT:	EQU	20H
RSMSK:	EQU	9CH
;
; 1793 Type III Commands
;
RDADD:	EQU	0C4H	;READ ADDRESS COMMAND
;
; The following time delay constants assume 40 "ticks" per millisecond.
; This is true for the time delay subroutine when running at 4 mhz and
;	no wait states.  For other system clock rates, the value of
;	TICKPMS (ticks per millisecond) should be adjusted accordingly.
;	For instance, TICKPMS should be 20 for 2 mhz (no waits) operation.
;
TICKPMS:	EQU	40
;
SETTL:	EQU	8*tickpms
MHLWAIT:  EQU	75*tickpms-settl	;head load wait for 5" drives
HLWAIT:	EQU	35*tickpms-settl	;HEAD LOAD WAIT FOR 8" DRIVES
MOWAIT:	EQU	1000*tickpms-settl	;MOTOR ON WAIT FOR MINIS
;
TRIES:	EQU	10	;NUMBER OF ATTEMPTS
;
;DEBLOCK PARAMETERS
;
WRALL:	EQU	0
WRDIR:	EQU	1
WRUAL:	EQU	2
;
;	General System equates
;
CTRLC:	EQU	3	;ASCII ETX
BELL:	EQU	7	;ASCII BELL CHARACTER
CR:	EQU	0DH	;ASCII CARRIAGE RETURN
LF:	EQU	0AH	;ASCII LINE FEED
;
WBOOTV:	EQU	0
IOBYTE:	EQU	3	;INTEL IOBYTE LOCATION
CDISK:	EQU	4
BDOSV:	EQU	5
DISKNO:	EQU	40H	;ACTIVE DISK NUMBER
SIDE:	EQU	DISKNO+1  ;SIDE SELECT HOLD AREA
SECTOR:	EQU	DISKNO+2
TRACK:	EQU	DISKNO+3
SPT:	EQU	DISKNO+4
STATUS:	EQU	47H
CMND:	EQU	STATUS+1
LUNIT:	EQU	49H	;LAST USED DRIVE
CUNIT:	EQU	LUNIT+1	;CURRENT DRIVE
RWFLG:	EQU	4BH	; Read/Write sector flag
HSTBUF:	EQU	4CH	;HOST BUFFER ADDRESS
IDSV:	EQU	4EH	;SECTOR ID SAVE AREA
TBUF:	EQU	80H
;
	ORG	BIOS	;ORIGIN OF THIS PROGRAM
;
;JUMP VECTORS FOR INDIVIDUAL SUBROUTINES
;
	JMP	BOOT	;COLD START
WBOOTE:	JMP	IBOOT	;WARM START
	JMP	CSTS	;CONSOLE STATUS
	JMP	CONI	;CONSOLE CHARACTER IN
	JMP	CO	;CONSOLE CHARACTER OUT
	JMP	LO	;LIST CHARACTER OUT
	JMP	PO	;PUNCH CHARACTER OUT
	JMP	RI	;READER CHARACTER OUT
	JMP	HOME	;MOVE HEAD TO HOME POSITION
	JMP	SELDSK	;SELECT DISK
	JMP	SETTRK	;SET TRACK NUMBER
	JMP	SETSEC	;SET SECTOR NUMBER
	JMP	SETDMA	;SET DMA ADDRESS
	JMP	READ	;READ DISK
	JMP	WRITE	;WRITE DISK
	JMP	LSTAT	;RETURN LIST STATUS
	JMP	SECTRAN	;SECTOR TRANSLATE
;
; STEP RATE STORAGE
;
STP8:	DB	STEP8
STP5:	DB	STEP5
;
; Initial IOBYTE storage area
;
iiobyt:	dw	0	;initial IOBYTE, default drive
;
; Baud rate constants
;
B2810:	DW	SBAUD	; 2810 Console baud rate
  IF CCS2719
B2719A:	DB	CTC0MOD	; CTC mode for 2719 SIO-A
	DB	CTC0DIV	; CTC count for 2719 SIO-A
B2719B:	DB	CTC1MOD	; CTC mode for 2719 SIO-B
	DB	CTC1DIV	; CTC count for 2719 SIO-B
  ENDIF
  IF	NOT CCS2719
	DW	-1,-1
  ENDIF
;
;INDIVIDUAL SUBROUTINES TO PERFORM EACH FUNCTION
;
WBOOT0:	DCR	C
	JNZ	WBOOT1
	LXI	H,BOTMSG
	CALL	PRTRD
	CALL	PRTWA
WBOOT:	LXI	SP,TBUF
	MVI	C,TRIES	;# OF RETRIES
WBOOT1:	LXI	H,SIDE0 shl 8	;SET THE DRIVE, SIDE 0
	SHLD	DISKNO
	LXI	H,2
	SHLD	SECTOR	;SET SECTOR 2, TRACK 0
	PUSH	B
	MOV	C,H	;SELECT UNIT 0
	mov	e,h	;insure drive gets logged in
	CALL	SELDSK
	POP	B
	LXI	H,CCP
	SHLD	HSTBUF
	lda	prmtbl+1
	STA	CUNIT
  IF	MAXI
	MVI	B,26	;HOLD THE SPT IN (B)
  ENDIF
  IF	BOTH
	ANI	DRV8	;ISOLATE MINI/MAXI BIT
	JNZ	WBOOT3	;JUMP IF 8"
  ENDIF
  IF	MINI
	MVI	B,18	;SET MINI SPT
  ENDIF
WBOOT3:	PUSH	B
	CALL	DREAD
	POP	B
	ORA	A
	JNZ	WBOOT0
	SHLD	HSTBUF
	MOV	D,H	;SAVE THE PAGE ADDRESS
	LXI	H,SECTOR  ;POINT TO THE SECTOR HOLD
	MOV	A,M	;SEE IF READY FOR NEXT TRACK
	SUB	B
	JC	WBOOT4
	MOV	M,A	;RESET THE SECTOR COUNT
	INX	H	;POINT TO TRACK
	INR	M	;ADVANCE IT
	DCX	H	;POINT BACK TO SECTOR
	LDA	PRMTBL+1
  IF	BOTH
	mov	e,a	;save the selbits
	ANI	DRV8	;SEE IF MINI OR MAXI
	JNZ	WBOOT4	;CURRENT VALUE GOOD FOR MAXI, JUMP
	mov	a,e	;get the selbits
  ENDIF
  IF	MINI
	ANI	DDENS	;SEE IF DOUBLE DENSITY
	JNZ	WBOOT4	;CURRENT VALUE OK IF DDEN SET
	LDA	PRMTBL+2	;GET SECTOR SIZE INDICATOR
	DCR	A	;SEE WHICH SIZE
	JM	WBOOT4	;JUMP IF 128 BYTE SECTORS
	MVI	B,10	;SPT FOR 256 BYTE SECTORS
	JZ	WBOOT4
	MVI	B,5	;SPT FOR 512 BYTE SECTORS
  ENDIF
WBOOT4:	INR	M
	LDA	PRMTBL+2	;SEE IF ENOUGH LOADED IN
	ADD	D
	SUI	BIOS/256
	JC	WBOOT3	;JUMP IF MORE NEEDED
;
;END OF LOAD OPERATION, SET PARAMETERS AND GO TO CP/M
;
BOOT0:	XRA	A
	LXI	H,PRMTBL+3
	MVI	B,3*(NDISKS-1)	;ZERO OUT PRMTBL
WBOOT2:	MOV	M,A
	INX	H
	DCR	B
	JNZ	WBOOT2
	MVI	A,JMP	;GET A JUMP OP CODE
	STA	WBOOTV	;RESET THE JUMP VECTORS
	STA	BDOSV
	LXI	H,WBOOTE
	SHLD	WBOOTV+1
	LXI	H,BDOS
	SHLD	BDOSV+1
	LXI	H,DBUF	;SET UP BUFFER ADDRESS
	SHLD	HSTBUF
	LXI	H,TBUF	;DEFAULT DMA ADDRESS IS 80H
	SHLD	DMAAD
	mov	l,h	;insure all zeroes
	SHLD	HSTACT	;HOST NOT ACTIVE
	lxi	h,stp8	;point to 8" step rate hold
  if both
	mov	a,e  ;get the selbits
	ani	drv8	;test for 8"
	jnz	boot1	;brif 8"
  endif
  if mini
	inx	h	;point to 5" step rate
  endif
boot1:	mov	a,m	;get the step rate
	sta	prmtbl	;set the step rate
	LDA	CDISK
	MOV	C,A	;SEND TO THE CCP
	JMP	CCPV	;GO TO CPM
;
;SELECT DISK GIVEN BY REGISTER C
;
SELDSK:	MOV	A,C
	STA	SEKDSK
	LXI	H,0	;ERROR RETURN CODE
	CPI	NDISKS	;MUST BE BETWEEN 0 AND NDISKS-1
	RNC		;NO CARRY IF 4,5,...
;DISK NUMBER IS IN THE PROPER RANGE
;COMPUTE PROPER DISK PARAMETER HEADER ADDRESS
	MOV	L,A	;L=DISK NUMBER 0,1,2,...,NDISKS
	DAD	H	;*2
	DAD	H	;*4
	DAD	H	;*8
	DAD	H	;*16 (SIZE OF EACH HEADER)
	MOV	A,E	;GET THE NEW UNIT INDICATOR BIT
	RAR		;TEST THE NEW UNIT BIT
	PUSH	PSW
	LXI	D,DPBASE
	DAD	D	;HL=.DPBASE(DISKNO*16)
	PUSH	H
	CALL	FDSBA
	STA	SEKSEL
	POP	H
	POP	PSW
	MOV	A,C	;RETURN THE DISKNO
	RC		;RETURN IF NOT NEW UNIT
	PUSH	B
	PUSH	H	;SAVE (H,L)
	LHLD	LUNIT	;FIRST, SAVE CURRENT DISK ASSIGNMENTS
	PUSH	H
	LHLD	DISKNO
	PUSH	H	;save the unit and side
	MOV	L,C	;move the unit over
	MVI	H,SIDE0	;select side 0
	SHLD	DISKNO
	mvi	a,0ffh
	STA	CUNIT	;FORCE THE READ ADDRESS
	CALL	IDRD	;FIND OUT WHAT IS OUT THERE
	JNZ	SELERR
	MOV	B,A	;GET THE SECTOR SIZE
	INR	B	;prepare for later loop control
	DCX	H	;POINT TO THE SELBITS
	MOV	C,M	;GET THEM
	LXI	D,4	;ADDRESS TABLE ENTRY OFFSET
  IF	MINI
	LXI	H,MSELTBL-4  ;MINI TABLE ADDRESS
  ENDIF
  IF	BOTH
	mov	a,c
	ANI	DRV8	;TEST THE MINI/MAXI BIT
	JZ	SELDSK1	;JUMP IF MINI
  ENDIF
  IF	MAXI
	LXI	H,SELTBL-4  ;  ELSE, SET THE 8" TABLE ADDRESS
  ENDIF
  IF	DS8
	IN	DSTAT2	;CHECK FOR DOUBLE SIDED DISK
	ANI	TWOSID	;ISOLATE TWO-SIDED BIT
	JNZ	SELDSK1	;JUMP IF SINGLE-SIDED
	LXI	H,SELTBLA-4
  ENDIF
SELDSK1:  MOV	A,C	;CHECK FOR DOUBLE DENSITY
	STA	SEKSEL
	ANI	DDENS	;ISOLATE THE DENSITY BIT
	JZ	SELDSK2	;JUMP IF SINGLE-DENSITY
	DAD	D	;OFFSET TO DOUBLE DENSITY ENTRIES
	DAD	D
	DAD	D
	DAD	D
SELDSK2:	DAD	D	;OFFSET TABLE ADDRESS
	DCR	B
	JNZ	SELDSK2
	XCHG		;SAVE THE POINTER
	cmp	a	;show no error
SELERR:	POP	H	;RESTORE THE CURRENT DRIVE
	SHLD	DISKNO
	POP	H
	SHLD	LUNIT
	lxi	h,0	;set up for error return
	xthl
	JNZ	SELDSK3	;JUMP IF A SELECT ERROR
	pop	b	;get rid of error return code
	PUSH	H	;GET, RESAVE DP BLOCK POINTER
	XCHG
	call	movit2
	PUSH	H	;SAVE IT FOR A MOMENT
	LXI	H,8
	DAD	D	;OFFSET THE POINTER
	XCHG
	POP	H	;REGET TABLE ADDRESS
	call	movit2
seldsk3:  POP	H
	pop	b
	MOV	A,C
	RET
;
; HOME THE DISK TO TRACK ZERO
;
HOME:	MVI	C,0
;
;SET TRACK GIVEN BY REGISTER C
;
SETTRK:	MOV	A,C
	STA	SEKTRK
	RET
;
;SET SECTOR GIVEN BY REGISTER C
;
setsec:	lda	spt	;get the side indicator
	ora	a
	lxi	h,seksid	;point to side select
	mov	b,a
	mov	a,c
	mvi	m,side0
	jz	setsec1	;brif side 0
	sub	b
	mvi	m,side1
setsec1:  dcr	a
	sta	seksec
	ret
;
;TRANSLATE THE SECTOR GIVEN BY BC USING THE
;TRANSLATE TABLE GIVEN BY DE
;
SECTRAN:  PUSH	D	;SAVE THE TABLE ADDRESS
	MOV	A,C	;GET THE DESIRED SECTOR
	STA	CPMSEC
	CALL	PHYSC0	;GET THE PARAMETER TABLE ADDRESS
	DCR	A	;make phys sector rel 0
	POP	H	;REGET TABLE ADDRESS
  IF	DS8 or DS5
	CMP	M	;SEE IF SIDE 1
	JC	SECT1	;JUMP IF SIDE 0
	mov	b,m	;get sectors per track for side one indicator
	sub	b
  endif
SECT1:	PUSH	B
	MOV	C,M	;GET THE SECTORS PER TRACK
	INX	H	;POINT TO skew factor
	MOV	H,M	;get the skew factor
	MOV	B,A	;SET UP TO BUILD SKEW
	inr	b	;return to rel 1 number
	XRA	A	;start with (-skew factor)
	mov	e,a	;initialize the repetition count
	sub	h
SECT2:	ADD	H	;build the sector number in (a)
	CMP	C	;see if time for wrap-around
	JC	SECT3	;brif not
	SUB	C	;do the wrap-around
	JNZ	SECT3	;see if repeat pattern starting
	INR	E	;yes, keep # of repeats in (e)
SECT3:	DCR	B
	JNZ	SECT2	;keep going until desired sector is built
	ADD	E	;add on the # of repeats
	MOV	L,A	;save physical sector in (l)
	INR	A	;make rel 1 number
	MOV	E,A	;save for unalloc write anticipation logic
	pop	b	;get the side select number
	mov	h,b	;move over to (h) for expansion
	mov	b,d	;move the secmsk loop control over
	xra	a
	CALL	SECMSK	;CONVERT PHYSICAL TO LOGICAL SECTOR
	ANA	C	;STRIP OUT THE SUB-SECTOR
	ORA	L	;ADD IT TO THE SKEWED SECTOR
	add	h	;add the side bias
	MOV	L,A
	mov	a,h	;save the bias for side select logic
	sta	spt
	mov	h,b	;mov a zero over
	inr	l	;make rel 1
	RET
;
SECMS1:	STC
	ADC	A	;BUILD THE MASK
	DAD	H	;OFFSET THE SECTOR NUMBER
SECMSK:	DCR	B
	JNZ	SECMS1	;do it again
	RET
;
;SET DMA ADDRESS GIVEN BY REGISTERS B AND C
;
SETDMA:	mov	h,b
	mov	l,c
	SHLD	DMAAD	;SAVE THE ADDRESS
	RET
;
;DEBLOCK ROUTINES
;
WRITE:	MOV	A,C	;WRITE TYPE FROM CP/M
	STA	WRTYPE
	LXI	H,UNACNT  ;SEE IF ANY UNALLOCATED SPACE AVAILABLE
	CPI	WRUAL	;SEE IF UNALLOCATED
	JNZ	CHKUNA	;JUMP IF NOT
;
; UNALLOCATED WRITE, SET PARAMETERS
;
	PUSH	H
	CALL	PHYSEC	;CONVERT TO PHYSICAL SECTOR
	lxi	d,unadsk  ;point to destination
	call	movit	;do the move
	CALL	DPFND	;GET DP TABLE ADDRESS
	pop	h
	INX	D	;OFFSET TO THE BLOCK MASK
	INX	D
	INX	D
	LDAX	D	;GET THE BLOCK MASK
	INR	A	;(A) = LOGICAL RECORDS PER BLOCK
	mov	m,a	;save the sector count
CHKUNA:	XRA	A
	push	psw	;save the write indicator
	CMP	M
	JZ	ALLOC1	;JUMP IF NOT
	DCR	M	;ELSE, USE SOME OF IT
	CALL	PHYSEC	;SET THE PHYSICAL SECTOR NUMBER
	LXI	D,UNADSK
	CALL	COMP	;COMPARE THE UNITS
	JNZ	ALLOC
	CALL	DPFND
	LDA	CPMSEC	;GET LAST LOGICAL SECTOR NUMBER
	INR	A
	XCHG		;DP TABLE ADDRESS TO (H,L)
	CMP	M	;SEE IF TRACK OVERFLOW
	JNC	NXTSC2	;JUMP IF SO
	LXI	H,-11	;SAME TRACK, NOW SEE WHICH SIDE/SECTOR
	DAD	D
	MOV	E,M	;GET ADDRESS OF SKEW TABLE
	INX	H
	MOV	D,M
	MOV	C,A	;SET UP TO CALL SECTRAN
	MVI	B,0
	CALL	SECTRAN	;TRANSLATE THE SECTOR
	MVI	L,SIDE0	;SIDE 0 SELECT
  IF	DS8 or DS5
	ora	a	;test the side indicator (still in (a))
	JZ	NXTSC1	;JUMP IF SIDE 0
	MVI	L,SIDE1	;ELSE, SET SIDE 1
  endif
NXTSC1:	MOV	H,E	;SET THE SECTOR
	JMP	NXTSC3
;
NXTSC2:	LXI	H,UNATRK ;SET FOR NEXT TRACK
	INR	M
	LXI	H,100H+SIDE0 ;SIDE 0 SECTOR 1
NXTSC3:	SHLD	UNASID	;SET THE NEXT SIDE, SECTOR
	XRA	A	;GET A ZERO
	JMP	ALLOC2	;GO BACK TO MAINSTREAM
;
READ:	MVI	A,WRUAL	;TREAT READ AS UNALLOCATED
	STA	WRTYPE
	ora	a	;set flag for read operation
	push	psw
ALLOC:	XRA	A	;ALLOCATED WRITE REQUIRES PREREAD
	STA	UNACNT
ALLOC1:	INR	A
ALLOC2:	STA	RSFLAG
	XRA	A	;GET A ZERO
	STA	ERFLAG	;RESET THE ERROR FLAG
	LXI	H,HSTACT  ;SEE IF HOST ACTIVE
	ORA	M
	MVI	M,1	;MARK IT ACTIVE FOR NEXT TIME
	JZ	FILHST	;FILL THE HOST BUFFER IF EMPTY
	CALL	PHYSEC	;SET THE PHYSICAL SECTOR NUMBER
	PUSH	D	;SAVE THE SECTOR SIZE IN (D)
	LXI	D,DISKNO
	CALL	COMP	;COMPARE THE UNITS
	JZ	MATCH
	pop	d
	LDA	HSTWRT	;SEE IF BUFFER'S BEEN WRITTEN TO
	ORA	A
	CNZ	DWRITE	;PURGE THE BUFFER IF NEED BE
FILHST:	CALL	PHYSEC
	push	d	;save the sector size
	lxi	d,diskno  ;point to destination
	call	movit
	LDA	SEKSEL
	STA	CUNIT
	LDA	RSFLAG	;see if we need to read the disk
	ORA	A
	CNZ	DREAD	;FILL IT IF NEED BE
	XRA	A	;RESET PENDING WRITE FLAG
	STA	HSTWRT
MATCH:	POP	B	;GET SECTOR SIZE
	CALL	SECMSK	;build a sector mask
	LHLD	DMAAD	;GET DMA ADDRESS
	XCHG		; ADDRESS TO (D,E)
	LHLD	SEKSEC
	ANA	L	;FIND THE RELATIVE SECTOR
	LXI	H,DBUF-80H ;BUILD ADDRESS FOR CPM SECTOR
	LXI	B,80H	;# BYTES IN CPM RECORD
MATCH2:	DAD	B
	DCR	A
	JP	MATCH2
	pop	psw	;see if read or write
	JNZ	RWMOVE	;POINTERS OK IF READ
	XCHG		;ELSE, SWAP the buffer pointers
	INR	A	;  AND MARK WRITE OPERATION
	STA	HSTWRT
RWMOVE:	CALL	MOVIT1
	LDA	WRTYPE	;GET WRITE TYPE
	DCR	A	;SEE IF DIRECTORY ENTRY
	LDA	ERFLAG	;GET THE ERROR FLAG
	RNZ		;DONE IF NOT DIRECTORY ENTRY
	ORA	A	;SEE IF ANY ERRORS
	RNZ		;RETURN IF SO
	STA	HSTWRT	;RESET HOST WRITTEN
	JMP	DWRITE	;UPDATE THE DIRECTORY
;
; move 4 byte strings from sekdsk
;
movit:	lxi	h,sekdsk  ;point to source
	mvi	c,4	;move 4 bytes
	db	lda	;dummy to skip next two bytes
movit2:	mvi	c,2	;move two bytes
movit1:	mov	a,m	;get the next byte
	stax	d	;store it
	inx	h
	inx	d
	dcr	c
	jnz	movit1
	ret
;
; FIND ADDRESS OF DISK PARAMETER TABLE
;
DPFND:	LDA	SEKDSK	;FIND ADDRESS OF DP TABLE
	mov	b,a
	inr	b
	LXI	H,DPBASE-6  ;DEVELOP ADDRESS OF DPTABLE
	LXI	D,16
DPFND1:	DAD	D
	DCR	B
	JNZ	DPFND1
	MOV	E,M	;PULL UP THE ADDRESS
	INX	H
	MOV	D,M
	RET
;
; LOGICAL TO PHYSICAL SECTOR TRANSLATION ROUTINE
;
PHYSEC:	LDA	SEKSEC	;GET THE LOGICAL SECTOR NUMBER
	MOV	C,A	;SAVE THE SECTOR NUMBER
PHYSC0:	CALL	FDSBA	;GET PRMTBL POINTER
	INR	D
	MOV	B,D
	MOV	A,C	;GET THE SECTOR NUMBER
	RAL
PHYSC1:	ORA	A	;RESET THE CARRY BIT
	RAR		;CONVERT TO PHYSICAL SECTOR
	DCR	B
	JNZ	PHYSC1
	INR	A	;(A) NOW HAS PHYSICAL SECTOR #
	STA	SEKHST	;SET IT
	RET
;
;COMPARE THE UNITS
;
COMP:	LXI	H,SEKDSK
	MVI	B,4
COMP1:	LDAX	D
	SUB	M
	RNZ		;DONE IF NO COMPARE
	INX	H	;POINT TO NEXT ENTRY
	INX	D
	DCR	B
	JNZ	COMP1
	RET
;
;
; THE FOLLOWING ROUTINES DO THE PRIMITIVE DISK ACCESSES.
;	IN ALL CASES, ONE SECTOR OF DATA IS TRANSFERRED.
;  IF THE DISK HAS NOT BEEN PREVIOUSLY ACCESSED,
;	THESE ROUTINES WILL AUTOMATICALLY DETERMINE THE
;	DISK TYPE (8" OR 5"), SINGLE OR DOUBLE DENSITY,
;	AND SECTOR SIZE.
;
;	BEFORE THE DESIRED DATA IS TRANSFERRED, THE DESIRED
;	TRACK IS SEEKED OUT, THE DESIRED SECTOR AND SIDE IS
;	SET, THEN THE ACTUAL DATA TRANSFER.
;
;	UP TO TEN TRIES WILL BE ATTEMPTED BEFORE THE DATA
;	TRANSFER IS ABORTED.  ON RETURN TO THE CALLING
;	ROUTINE, THE A REGISTER WILL CONTAIN A ZERO IF THE
;	OPERATION WAS SUCCESSFUL, OR NON-ZERO IF NOT
;	SUCCESSFUL.  THE FLAG REGISTER WILL NOT NECESSARILY
;	CORRESPOND WITH THE A REGISTER CONTENT.
;
DWRITE:	DB	3EH	;SIM. MVI A INSTR
DREAD:	XRA	A	;SET READ FLAG
	ani	wrsbit	;isolate the write sector flag
	sta	rwflg	;save it
	MVI	C,TRIES	;NUMBER OF RETRIES
AGN:	PUSH	B
	CALL	SEEK
	CZ	RDWR
	POP	B
	RZ
	DCR	C	;SEE IF ALL TRIES DONE
	JZ	ERRET		;YES, ERROR RETURN
	MVI	B,RSTR	;RESTORE THE DRIVE
	CALL	EOJA	; GO DO IT
	JMP	AGN
;
ERRET:	LXI	H,ERFLAG
	ORA	M
	MOV	M,A
	RET
;
RDWR:	DI
	OUT	DCMD	;DISK COMMAND PORT
	STA	CMND
	ani	wrsbit	;see if read or write
	JNZ	WRDAT	;WRITE IF ZERO
READ1:	IN	DDATA	;GET THE DATA
	mov	m,a	;store the data
	inx	h
	IN	DDATA	;GET THE DATA
	mov	m,a	;store the data
	inx	h
read2:	IN	DDATA	;GET THE DATA
	mov	m,a	;store the data
	inx	h
	IN	DDATA	;GET THE DATA
	mov	m,a	;store the data
	inx	h
	DCR	B
	jnz	read1
	mvi	e,rsmsk	;set the error mask
	JMP	EOJ
;
WRDAT:
WRT1:	mov	a,m	;get the data
	out	ddata	;output it
	inx	h
	mov	a,m	;get the data
	out	ddata	;output it
	inx	h
	mov	a,m	;get the data
	out	ddata	;output it
	inx	h
	mov	a,m	;get the data
	out	ddata	;output it
	inx	h
	dcr	b
	jnz	wrt1
	JMP	EOJD
;
EOJB:	MVI	B,STEPI	;BASIS OF STEP IN COMMAND
EOJA:	PUSH	H	;SAVE (H,L)
	PUSH	B
	CALL	FDSB	;GET THE PRMTBL POINTER
	POP	B
	DCX	H	;POINT TO THE STEP RATE ENTRY
	MOV	A,M	;GET THE STEP RATE
	POP	H	;RESTORE (H,L)
	ORA	B	;ADD ON THE COMMAND
EOJC:	OUT	DCMD	;DO THE COMMAND
	STA	CMND
EOJD:	MVI	E,TP1MSK  ;set the error mask
EOJ:	EI
	IN	DSTAT1	;DISK FLAG PORT
	RAR
	JNC	EOJ
	lda	cmnd	;see if type I command
	ral
	jc	eoj1	;brif not
	lxi	h,settl	;else, do 8 millisecond delay
	call	hdld1
EOJ1:	IN	DSTAT	;GET THE DISK STATUS
	STA	STATUS
	ANA	E
  IF	MAXI
	RP		;DONE IF DRIVE IS READY
	push	psw	;save the masked status
	LDA	DISKNO	;GET DRIVE NUMBER
	ADI	'A'	;CONVERT TO ASCII
	STA	DNRMSGA	;PUT IT INTO MESSAGE
	PUSH	H	;SAVE (H,L)
	LXI	H,DNRMSG
	CALL	PRTRD	;PRINT THE MESSAGE
	CPI	CTRLC	; see if abort wanted
	JZ	WBOOT	; brif so
	POP	H
	pop	psw
	ret		;return with bad status
  ENDIF
  IF	NOT MAXI
	RET
  ENDIF
;
SEEK:	CALL	IDRD	;INSURE HEADER HAS BEEN READ
	RNZ		;ERROR RETURN
	LHLD	SECTOR	;SET THE SECTOR
	MOV	A,L
	OUT	DSCTR	;DISK SECTOR PORT
	IN	DTRK	;READ THE CURRENT TRACK SETTING
	CMP	H	;SEE IF SEEK NEEDED
	MOV	A,H	;GET DESIRED TRACK
	CNZ	SEEK1	;YES, DO THE SEEK
	RNZ		;DONE IF SEEK ERROR
	IN	DSTAT1	;DISK FLAG PORT
	ANI	HLMSK	;SEE IF HEAD IS LOADED
	JNZ	SEEK2	; BRIF HEAD IS LOADED
	IN	DTRK	; GET THE TRACK NUMBER
	CALL	SEEK1	; DO A DUMMY SEEK TO LOAD THE HEADS
	RNZ
	CALL	HDLD
SEEK2:	CALL	SETUP
	IN	DTRK	;SEE IF ON TRACK 0
	ORA	A
	JZ	SEEK3	;SET SECTOR SIZE = 0
	INX	H	;GET THE SECTOR SIZE
	MOV	A,M
SEEK3:	MOV	B,A	;PUT IN B FOR LOOP CONTROL
	INR	B	;ADJUST FOR LOOP CONTROL
      	MVI	A,16	;SECTOR BASE LENGTH / 4
SEEK4:	ADD	A
	DCR	B
	JNZ	SEEK4
	MOV	B,A
	LHLD	HSTBUF	;GET THE DMA ADDRESS
	lda	rwflg	;get the read/write sector flag
	ORI	RDSEC	; GET A READ SECTOR COMMAND
	CMP	A	;CLEAR THE FLAGS
	RET
;
SEEK1:	OUT	DDATA	;SET THE SEEK TRACK
	ORA	A	; CHECK FOR TRACK 00
	MVI	C,0	;NO AUTOWAIT WANTED
	LDA	CUNIT	; GET THE SELBITS
	CALL	SETUP5	;RESET THE DENSITY BIT IF SO
	MVI	B,SEEKV	;BUILD THE SEEK COMMAND
	CALL	EOJA	;DO THE SEEK
	ANI	98H	;SEEK ERROR MASK
	ret
;
IDRD:	LHLD	LUNIT
	MOV	A,H	;GET THE CUNIT VALUE
	CMP	L	;SEE IF SAME AS LUNIT
	RZ		;RETURN IF SO
	CALL	SETUP	;Select the drive
IDRD5:	CALL	EOJB	;get the heads loaded
	ora	a
	rm		;done if drive not ready
	CALL	HDLD
IDRD1:	MVI	B,tries	; SET TRY LIMIT
IDRD2:	PUSH	B	; SAVE THE TRY COUNTER
	CALL	SETUP
	PUSH	H	;SAVE THE POINTER
	LXI	H,IDSV	;SET UP TO READ ADDRESS
	mvi	b,2	;set up to read 6 bytes of data
	MVI	A,RDADD	;READ ADDRESS COMMAND
	DI
	OUT	DCMD	;START THE COMMAND
	sta	cmnd	;save the command
	CALL	READ2
	POP	H	;RESTORE POINTER
	POP	B	; RESTORE THE TRY COUNTER
	JZ	IDRD4	;JUMP IF GOOD READ
	DCR	B
	JNZ	IDRD3	; BRIF NOT
	ora	a
	RET
;
IDRD3:	MVI	A,DDENS	;TRY OTHER DENSITY
	XRA	M	; TRY opposite DEN
	MOV	M,A
	JMP	IDRD2
;
IDRD4:	IN	DSCTR	;GET THE TRACK NUMBER
	OUT	DTRK	;SET THE TRACK REGISTER
	CPI	2	;INSURE NOT ON TRACK 0 OR 1
	JC	IDRD5	;JUMP IF SO
	MOV	A,M	;REGET SELBITS
	STA	LUNIT	;UPDATE LAST USED UNIT
	STA	CUNIT
	INX	H	;SET THE SECTOR SIZE
	LDA	IDSV+3
	MOV	M,A
	CMP	A	;RESET ERROR FLAGS
	RET
;
; HEAD LOAD DELAY ROUTINE
;
HDLD:
	LXI	H,HLWAIT  ;WAIT FOR HEADS TO SETTLE
  IF	BOTH
	IN	DSTAT2	;SEE IF A MINI IS SELECTED
	ANI	MINI2
	JZ	HDLD1	;BRIF NOT
  ENDIF
  IF	MINI
	LXI	H,MOWAIT	;GET THE MINI DRIVE TIME CONSTANT
	lda	lunit	;see if motor is on
	ani	motor
	jz	hdld1	;brif not on
	lxi	h,mhlwait  ;else, use 75 ms delay
  ENDIF
HDLD1:	DCX	H	; 25 MICRO-SECOND DELAY LOOP (4 MHZ)
	XTHL		;WASTE SOME TIME
	XTHL
	XTHL
	XTHL
	MOV	A,H
	ORA	L
	JNZ	HDLD1	;NOT A JRNZ FOR TIMING PURPOSES
	RET
;
;SET UP DRIVE NUMBER
;
SETUP:	MVI	C,AWBIT	;SET THE AUTO-WAIT BIT
	CALL	FDSB	;GET THE DISK SELECT BITS
	JNZ	SETUP4	;SKIP INIT CODE IF ALREADY LOGGED IN
	STC		;DRIVE SELECT BIT
SETUP1:	RAL		;SHIFT BIT INTO POSITION
	DCR	B
	JNZ	SETUP1	;LOOP TIL BIT IS IN POSITION
  IF	MINI
	ORI	MOTOR	;ADD ON MOTOR ON BIT
	MOV	M,A	;SAVE IT
	OUT	DCTRL1	;SELECT THE DRIVE
  ENDIF
  IF	BOTH
	push	h
	MVI	A,RSTR	; Try a fast restore
	CALL	EOJC
	ANI	TRK0	; See if any Track 0 reporting
	JNZ	SETUP2	; Brif so
	MVI	A,RSTR OR 3	;GET SLOWEST RESTORE COMMAND
	CALL	EOJC	;RESTORE THE DRIVE
SETUP2:	pop	h
	IN	DSTAT2	;READ THE MINI TRK00 BIT
	RAR		;ISOLATE IT
  ENDIF
  IF	MINI
	LDA	STP5	;MINI STEP RATE BITS
  ENDIF
  IF	BOTH
	JNC	SETUP3	;JUMP IF MINI DRIVE
	MOV	A,M	;REGET THE SELBITS
  ENDIF
  IF	MAXI
	XRI	DRV8 or MOTOR	;ADD ON THE 8", MOTOR OFF BITS
	OUT	DCTRL1
	MOV	M,A
	LDA	STP8	;SET MAXI STEP RATE
  ENDIF
SETUP3:	DCX	H	;POINT TO STEP RATE HOLD
	MOV	M,A	;SET THE STEP RATE
	INX	H	;RESET POINTER
SETUP4:	IN	DTRK	;ELSE, SEE IF TRACK ZERO
	ORA	A
	IN	DDATA	;CLEAR OUT ANY JUNK
	MOV	A,M	;REGET THE SELBITS
SETUP5:	JNZ	SETUP6
	ANI	(not DDENS) and 0FFH	;INSURE DDEN IS RESET
SETUP6:	ORA	C	;ADD ON AUTOWAIT BIT
	OUT	DCTRL1	;OUTPUT THE SELBITS
  IF	DS8 OR DS5
	LDA	LSIDE
	MOV	B,A	;SEE IF SIDE CHANGED
  ENDIF
	LDA	SIDE	;SET THE SIDE SELECT
  IF	DS8 OR DS5
	CMP	B
	RZ		;DONE IF SAME SIDE AS BEFORE
  ENDIF
	OUT	DCTRL2
  IF	DS8 OR DS5
	STA	LSIDE
	MVI	B,14	;AND DELAY 100 MICRO-SECONDS
SETUP7:	DCR	B
	JNZ	SETUP7
  ENDIF
	RET
;
FDSBA:	LDA	SEKDSK
	JMP	FDSB0
;
FDSB:	LDA	DISKNO	;GET THE SELECT UNIT
FDSB0:	LXI	H,PRMTBL-1	;SEE IF DRIVE HAS BEEN LOGGED IN
	inr	a	;adjust for loop control
	MOV	B,A	;SAVE FOR LATER USE
FDSB1:	INX	H	;OFFSET TABLE POINTER
	INX	H
	INX	H
	DCR	B
	JNZ	FDSB1	;LOOP CONTROL
	mov	b,a	;get back into b register
	MOV	D,M	;GET THE SECTOR SIZE
	DCX	H
	MOV	A,M	;READ THE SELECT BITS
	ORA	A
	RET
;
;FIXED DATA TABLES FOR FOUR-DRIVE STANDARD
;IBM-COMPATIBLE 8" OR 5" DISKS
;
;DISK PARAMETER HEADER FOR DISK 00
DPBASE:	DW	0,0
	DW	0,0
	DW	DIRBF,0
	DW	CHK00,ALL00
;DISK PARAMETER HEADER FOR DISK 01
	DW	0,0
	DW	0,0
	DW	DIRBF,0
	DW	CHK01,ALL01
;DISK PARAMETER HEADER FOR DISK 02
	DW	0,0
	DW	0,0
	DW	DIRBF,0
	DW	CHK02,ALL02
;DISK PARAMETER HEADER FOR DISK 03
	DW	0,0
	DW	0,0
	DW	DIRBF,0
	DW	CHK03,ALL03
;
  IF	MAXI
SELTBL: DW	T826,DP8S0
	DW	T815,DP8S1
	DW	T88,DP8S2
	DW	T84,DP8S2
	DW	T848,DP8D0
	DW	T826,DP8D1
	DW	T815,DP8D2
	DW	T88,DP8D3
;
DP8S0:	DW	26	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	242	;BLOCKS PER DISKETTE
	DW	63	;# DIRCTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	2	;SYSTEM TRACK OFFSET
DP8S1:	DW	30	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	1	;EXTENT MASK
	DW	139	;BLOCKS PER DISKETTE
	DW	63	;# DIRCTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	2	;SYSTEM TRACK OFFSET
DP8S2:	DW	32	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	1	;EXTENT MASK
	DW	149	;BLOCKS PER DISKETTE
	DW	63	;# DIRCTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	2	;SYSTEM TRACK OFFSET
DP8D0:	DW	48	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	224	;BLOCKS PER DISKETTE
	DW	127	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	32	;DIR CHECK VECTOR SIZE
	DW	2	;SYSTEM TRACK OFFSET
DP8D1:	DW	52	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	1	;EXTENT MASK
	DW	242	;BLOCKS PER DISKETTE
	DW	127	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	32	;DIR CHECK VECTOR SIZE
	DW	2	;SYSTEM TRACK OFFSET
DP8D2:	DW	60	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	280	;BLOCKS PER DISKETTE
	DW	127	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	32	;DIR CHECK VECTOR SIZE
	DW	2	;SYSTEM TRACK OFFSET
DP8D3:	DW	64	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	299	;BLOCKS PER DISKETTE
	DW	127	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	32	;DIR CHECK VECTOR SIZE
	DW	2	;SYSTEM TRACK OFFSET
;
T848:	DB	48,1
T826:	DB	26,6
T815:	DB	15,4
T88:	DB	8,3
T84:	DB	4,2
  ENDIF
;
  IF	MAXI AND DS8
SELTBLA: DW	T826,DP8D1
	DW	T815,DP8D2
	DW	T88,DP8D3
	DW	T84,DP8D3
	DW	T848,DP8D0A
	DW	T826,DP8D1A
	DW	T815,DP8D2A
	DW	T88,DP8D3A
;
DP8D0A:	DW	96	;SECTORS PER TRACK
	DB	5	;BLOCK SHIFT FACTOR
	DB	31	;BLOCK MASK
	DB	3	;EXTENT MASK
	DW	225	;BLOCKS PER DISKETTE
	DW	127	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	32	;DIR CHECK VECTOR SIZE
	DW	2	;SYSTEM TRACK OFFSET
DP8D1A:	DW	104	;SECTORS PER TRACK
	DB	5	;BLOCK SHIFT FACTOR
	DB	31	;BLOCK MASK
	DB	3	;EXTENT MASK
	DW	242	;BLOCKS PER DISKETTE
	DW	127	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	32	;DIR CHECK VECTOR SIZE
	DW	2	;SYSTEM TRACK OFFSET
DP8D2A:	DW	120	;SECTORS PER TRACK
	DB	6	;BLOCK SHIFT FACTOR
	DB	63	;BLOCK MASK
	DB	7	;EXTENT MASK
	DW	139	;BLOCKS PER DISKETTE
	DW	127	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	32	;DIR CHECK VECTOR SIZE
	DW	2	;SYSTEM TRACK OFFSET
DP8D3A:	DW	128	;SECTORS PER TRACK
	DB	6	;BLOCK SHIFT FACTOR
	DB	63	;BLOCK MASK
	DB	7	;EXTENT MASK
	DW	149	;BLOCKS PER DISKETTE
	DW	127	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	32	;DIR CHECK VECTOR SIZE
	DW	2	;SYSTEM TRACK OFFSET
  ENDIF
;
  IF	MINI
MSELTBL: DW	T518,DP5S0
	DW	T510,DP5S1
	DW	T55,DP5S1
	DW	T52,DP5S3
	DW	T529,DP5D0
	DW	T518,DP5D1
	DW	T510,DP5D2
	DW	T55,DP5D2
;
T529:	DB	29,3
T518:	DB	18,4
T510:	DB	10,2
T55:	DB	5,2
T52:	DB	2,1
  ENDIF
;
  IF	MINI and T35 and (not DS5)
DP5S0:	DW	18	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	71	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5S1:	DW	20	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	79	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5S3:	DW	16	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	63	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5D0:	DW	29	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	115	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5D1:	DW	36	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	143	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5D2:	DW	40	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	159	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
  ENDIF
;
  IF	MINI and T40 and (not DS5)
DP5S0:	DW	18	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	82	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5S1:	DW	20	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	91	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5S3:	DW	16	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	73	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5D0:	DW	29	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	133	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5D1:	DW	36	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	165	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5D2:	DW	40	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	184	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
  ENDIF
;
  IF	MINI and T80 and (not DS5)
DP5S0:	DW	18	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	172	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5S1:	DW	20	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	191	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5S3:	DW	16	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	153	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5D0:	DW	29	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	1	;EXTENT MASK
	DW	138	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5D1:	DW	36	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	1	;EXTENT MASK
	DW	172	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5D2:	DW	40	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	1	;EXTENT MASK
	DW	191	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
  ENDIF
;
  IF	MINI and T35 and DS5
DP5S0:	DW	36	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	143	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5S1:	DW	40	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	159	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5S3:	DW	32	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	127	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5D0:	DW	58	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	231	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5D1:	DW	72	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	1	;EXTENT MASK
	DW	143	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5D2:	DW	80	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	1	;EXTENT MASK
	DW	159	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
  ENDIF
;
  IF	MINI and T40 and DS5
DP5S0:	DW	36	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	165	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5S1:	DW	40	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	184	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5S3:	DW	32	;SECTORS PER TRACK
	DB	3	;BLOCK SHIFT FACTOR
	DB	7	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	147	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	192	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5D0:	DW	58	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	1	;EXTENT MASK
	DW	133	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5D1:	DW	72	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	1	;EXTENT MASK
	DW	165	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5D2:	DW	80	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	1	;EXTENT MASK
	DW	184	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
  ENDIF
;
  IF	MINI and T80 and DS5
DP5S0:	DW	36	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	1	;EXTENT MASK
	DW	172	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5S1:	DW	40	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	1	;EXTENT MASK
	DW	191	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5S3:	DW	32	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	1	;EXTENT MASK
	DW	153	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5D0:	DW	58	;SECTORS PER TRACK
	DB	4	;BLOCK SHIFT FACTOR
	DB	15	;BLOCK MASK
	DB	0	;EXTENT MASK
	DW	278	;BLOCKS PER DISKETTE
	DW	63	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	16	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5D1:	DW	72	;SECTORS PER TRACK
	DB	5	;BLOCK SHIFT FACTOR
	DB	31	;BLOCK MASK
	DB	3	;EXTENT MASK
	DW	172	;BLOCKS PER DISKETTE
	DW	127	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	32	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
DP5D2:	DW	80	;SECTORS PER TRACK
	DB	5	;BLOCK SHIFT FACTOR
	DB	31	;BLOCK MASK
	DB	3	;EXTENT MASK
	DW	191	;BLOCKS PER DISKETTE
	DW	127	;# DIRECTORY ENTRIES
	DB	128	;ALLOC 0
	DB	0	;ALLOC 1
	DW	32	;DIR CHECK VECTOR SIZE
	DW	3	;SYSTEM TRACK OFFSET
  ENDIF
;
;END OF FIXED TABLES
;
CO:	LDA	IOBYTE
	ANI	3	;ISOLATE CONSOLE ASGT
	JZ	CO0	;TTY ACTIVE
	CPI	2
	JM	CO1	;CRT ACTIVE
	JNZ	CO3	;USER CONSOLE 1 ACTIVE
;
LO:	LDA	IOBYTE
	ANI	0C0H	;ISOLATE LIST ASGT
	JZ	LO0	;TTY ACTIVE
	CPI	80H
	JM	LO1	;CRT ACTIVE
	JZ	LO2	;LINE PRINTER ACTIVE
	JMP	LO3	;USER PRINTER 1 ACTIVE
;
CSTS:	LDA	IOBYTE
	ANI	3	;ISOLATE CONSOLE ASGT
	JZ	CI0S	;TTY ACTIVE
	CPI	2
	JM	CI1S	;CRT ACTIVE
	JNZ	CI3S	;USER CONSOLE 1 ACTIVE
;
BATST:	LDA	IOBYTE
	ANI	0CH	;ISOLATE BATCH ASGT
	JZ	RI0S	;TTY ACTIVE
	CPI	8
	JM	RI1S	;PAPER TAPE READER ACTIVE
	JZ	RI2S	;USER READER 1 ACTIVE
	JMP	RI3S	;USER READER 2 ACTIVE
;
CI:	LDA	IOBYTE
	ANI	3	;ISOLATE CONSOLE ASGT
	JZ	CI0	;KBD ACTIVE
	CPI	2
	JM	CI1	;CRT ACTIVE
	JNZ	CI3	;USER CONSOLE 1 ACTIVE
;
RI:	LDA	IOBYTE
	ANI	0CH	;ISOLATE BATCH ASGT
	JZ	RI0	;TTY ACTIVE
	CPI	8
	JM	RI1	;PAPER TAPE READER ACTIVE
	JZ	RI2	;USER READER 1 ACTIVE
	JMP	RI3	;USER READER 2 ACTIVE
;
LSTAT:	LDA	IOBYTE
	ANI	0C0H	;ISOLATE THE LIST DEVICE ASSIGNMENT
	JZ	LO0S
	CPI	80H
	JM	LO1S
	JZ	LO2S
	JMP	LO3S
;
PO:	LDA	IOBYTE
	ANI	30H	;ISOLATE PUNCH ASGT
	JZ	PO0	;TTY ACTIVE
	CPI	20H
	JM	PO1	;HIGH SPEED PUNCH ACTIVE
	JZ	PO2	;USER PUNCH 1 ACTIVE
	JMP	PO3	;USER PUNCH 2 ACTIVE
;
; ROUTINE CONI READS THE CONSOLE AND STRIPS OFF THE ASCII
;	PARITY BIT.
;
PRTRD:	CALL	PRTWD
CONI:	CALL	CI	;GET THE NEXT CHARACTER
	ANI	7FH	;STRIP OFF THE PARITY BIT
RTS:	RET
;
; ROUTINE PRTWD PRINTS AN ASCII STRING ONTO THE CONSOLE.
;	THE STRING MUST BE TERMINATED BY BIT 7 SET IN THE
;	LAST CHARACTER OF THE STRING.  THE STRING WILL START
;	A NEW LINE (EP = PRTWD) OR CONTINUE ON THE SAME
;	LINE (EP = PRTWA)
;
PRTWD:	CALL	CRLF	;START A NEW LINE
PRTWA:	PUSH	B	;SAVE (B,C)
PRTA:	MOV	C,M	;GET NEXT CHARACTER FROM MEMORY
	CALL	CO	;OUTPUT IT
	INX	H	;INCREMENT MEMORY POINTER
	MOV	A,C
	RLC		;TEST FOR BIT 7 DELIMITER
	JNC	PRTA	;NO DELIMITER, GO DO NEXT CHARACTER
PRTB:	POP	B	;RESTORE (B,C)
	RET
;
; ROUTINE CRLF GENERATES A CARRIAGE RETURN, LINE FEED
;	SEQUENCE ON THE CURRENT CONSOLE TO START A NEW LINE
;	IT INCLUDES TWO NULL CHARACTERS FOR TTY TYPE
;	DEVICES FOR THE HEAD MOVEMENT TIME.
;
CRLF:	PUSH	H	;SAVE THE CONTENTS OF (H,L)
CRLFA:	LXI	H,CRMSG	;ADDRESS OF CR,LF MESSAGE
	CALL	PRTWA	;  OUTPUT IT
	POP	H	;RESTORE (H,L)
	RET
;
IOER:	XRA	A	;RESET IOBYTE
	STA	IOBYTE
	LXI	H,IOMSG	;ADDRESS OF IO ERROR MESSAGE
COMERR:	CALL	PRTWD	;PRINT IT ON NEW LINE
	JMP	WBOOT	;GO TO WARM BOOT
;
IOMSG:	DB	BELL,'I/O ASGT ERRO','R'+80H
DNRMSG:	DB	BELL,'DRIVE '
DNRMSGA:  DB	0,' NOT READ','Y'+80H
BOTMSG:	DB	BELL,'CANNOT BOO','T'+80H
CRMSG:	DB	CR,LF+80H
;
; I/O DRIVERS FOR THE 8250 ASYNC COMM ELEMENT
;
TTOST:	IN	SMDMST
	ANI	20H	;TEST THE HAND-SHAKE LINE
	RZ
	MVI	B,TXMTY	; XMIT EMPTY BIT MASK
	DB	LDA	; DUMMY LDA INST TO SKIP 2 BYTES
TTST:	MVI	B,RXRDY	; BIT MASK FOR RX DATA AVAIL
	CALL	DRVCHK	; SEE IF DRIVES NEED SHUT-OFF
	IN	SLSTAT	;GET 8250 LINE STATUS
	ANA	B	;SEE IF DATA AVAILABLE
	RZ		;RETURN IF NOT
	ORI	0FFH	;FLAG THAT DATA IS AVAILABLE
	RET
;
DRVCHK:	IN	DSTAT1	; SEE IF HEADS UNLOADED
	ANI	20H
	RNZ		; NOT YET
	OUT	DCTRL1	; YES, TURN OFF DRIVES
	sta	lunit
	RET
;
TTYIN:	CALL	TTST	;GET 8250 LINE STATUS
	JZ	TTYIN	;LOOP UNTIL DATA IS IN
	IN	SDATA	;READ THE DATA
	RET
;
TTYOUT:	CALL	TTOST	;GET 8250 LINE STATUS
	JZ	TTYOUT	;WAIT UNTIL ONE OF THE REGISTERS EMPTIES
	MOV	A,C	;MOVE THE DATA OVER
	OUT	SDATA	;OUTPUT THE DATA
	RET
;
; 2719 SERIAL DRIVER ROUTINES
;
  IF	CCS2719
SIOAST:			; SIO CHANNEL A INPUT STATUS ROUTINE
	IN	SIOAC	; READ THE SIO STATUS BYTE
	DB	11H	; DUMMY LXI D TO SKIP TWO BYTES
SIOBST:	IN	SIOBC	; READ THE SIO STATUS BYTE
	ANI	00000001B  ; SEE IF RX CHARACTER AVAILABLE
	RZ		; DONE IF NOT
	ORI	0FFH	; ELSE, FLAG THE READY CONDITION
	RET
;
SIOAIN:			; SIO CHANNEL A INPUT ROUTINE
	CALL	SIOAST	; CHECK THE PORT STATUS
	JZ	SIOAIN	; TRY AGAIN IF NOT READY
	IN	SIOAD	; GET THE DATA BYTE
	RET
;
SIOBIN:			; SIO CHANNEL B INPUT ROUTINE
	CALL	SIOBST	; CHECK THE PORT STATUS
	JZ	SIOBIN	; TRY AGAIN IF NOT READY
	IN	SIOBD	; GET THE DATA BYTE
	RET
;
SIOBOST:		; SIO CHANNEL B OUTPUT STATUS ROUTINE
	IN	SIOBC	; READ THE STATUS
	db	11h	; dummy LXI D, to skip 2 bytes
SIOAOST:		; SIO CHANNEL A OUTPUT STATUS ROUTINE
	IN	SIOAC	; READ THE SIO STATUS BYTE
SIOCOM:	MOV	B,A	; SAVE FOR A MOMENT
	ANI	00001000B  ; CHECK THE DCD BIT (HANDSHAKE)
	RZ		; RETURN IF NOT READY
	MOV	A,B	; REGET THE SIO STATUS BYTE
	ANI	00000100B  ; SEE IF TX BUFFER IS EMPTY
	RZ		; NO, STILL BUSY
SIOCO1:	ORI	0FFH	; ELSE, FLAG THE READY CONDITION
	RET
;
SIOAOUT:		; SIO CHANNEL A OUTPUT ROUTINE
	CALL	SIOAOST	; SEE IF PORT READY FOR OUTPUT
	JZ	SIOAOUT	; TRY AGAIN IF NOT
	MOV	A,C	; ELSE, GET THE DATA FOR OUTPUT
	OUT	SIOAD	; OUTPUT IT
	RET
;
SIOBOUT:		; SIO CHANNEL B OUTPUT ROUTINE
	CALL	SIOBOST	; SEE IF PORT READY FOR OUTPUT
	JZ	SIOBOUT	; TRY AGAIN IF NOT
	MOV	A,C	; ELSE, GET THE DATA FOR OUTPUT
	OUT	SIOBD	; OUTPUT IT
	RET
;
; 2719 CENTRONICS PRINTER OUTPUT DRIVERS
;
PIA1OUT:		; PRINTER OUTPUT ENTRY POINT
	CALL	PIA1ST	; SEE IF READY FOR DATA OUT
	JZ	PIA1OUT	;  TRY AGAIN IF NOT
	IN	PIA1BD	; RESET THE DATA ACCEPTED BIT
	MOV	A,C	; GET THE DATA FOR OUTPUT
	OUT	PIA1BD	; OUTPUT IT
	RET
;
PIA2OUT:		; PRINTER OUTPUT ENTRY POINT
	CALL	PIA2ST	; SEE IF READY FOR DATA OUT
	JZ	PIA2OUT	;  TRY AGAIN IF NOT
	IN	PIA2BD	; RESET THE DATA ACCEPTED BIT
	MOV	A,C	; GET THE DATA FOR OUTPUT
	OUT	PIA2BD	; OUTPUT IT
	RET
;
PIA1ST:			; PIA1 STATUS ROUTINE
	IN	PIA1AD	; CHECK FOR PRINTER STATUS
	db	11h	; dummy LXI D, to skip 2 bytes
;
PIA2ST:			; PIA2 STATUS ROUTINE
	IN	PIA2AD	; CHECK FOR PRINTER STATUS
	ANI	00010111B ; ISOLATE THE BITS OF INTEREST
			;	FAULT (BIT 4)
			;	SELECT (BIT 2)
			;	PAPER EMPTY (BIT 1)
			;	BUSY (BIT 0)
	XRI	00010100B  ; INVERT THE -FAULT AND SELECT SIGNALS
	JZ	SIOCO1	;  ALL MUST BE ZERO FOR READY CONDITION
	XRA	A	;  ELSE, SHOW BUSY
	RET
  ENDIF
;
; EQUATES FOR CONSOLE DEVICES
;
;	CONSOLE INPUT
CI0:	EQU	TTYIN	; DEFAULT CONSOLE
CI0S:	EQU	TTST	; DEFAULT INPUT STATUS
CI1:	EQU	IOER	; CRT DEVICE
CI1S:	EQU	IOER
CI3:	EQU	IOER
CI3S:	EQU	IOER	; USER 1 CONSOLE
;	CONSOLE	OUTPUT
CO0:	EQU	TTYOUT
CO0S:	EQU	TTOST
CO1:	EQU	IOER
CO1S:	EQU	IOER
CO3:	EQU	IOER
CO3S:	EQU	IOER
;
;  EQUATES FOR PAPER TAPE PUNCH DEVICES
;
  IF	CCS2719
PO0:	EQU	SIOBOUT
PO0S:	EQU	SIOBOST
  ENDIF
  IF	NOT CCS2719
PO0:	EQU	IOER
PO0S:	EQU	IOER
  ENDIF
PO1:	EQU	IOER
PO1S:	EQU	IOER
PO2:	EQU	IOER
PO2S:	EQU	IOER
PO3:	EQU	IOER
PO3S:	EQU	IOER
;
;  EQUATES FOR LIST DEVICES
;
  IF	CCS2719
LO0:	EQU	SIOAOUT
LO0S:	EQU	SIOAOST
LO1:	EQU	IOER
LO1S:	EQU	IOER
LO2:	EQU	PIA1OUT
LO2S:	EQU	PIA1ST
LO3:	EQU	PIA2OUT
LO3S:	EQU	PIA2ST
  ENDIF
  IF	NOT CCS2719
LO0:	EQU	IOER
LO0S:	EQU	IOER
LO1:	EQU	IOER
LO1S:	EQU	IOER
LO2:	EQU	IOER
LO2S:	EQU	IOER
LO3:	EQU	IOER
LO3S:	EQU	IOER
  ENDIF
;
;   PAPER TAPE READER DEVICES
;
  IF	CCS2719
RI0:	EQU	SIOBIN
RI0S:	EQU	SIOBST
  ENDIF
  IF	NOT CCS2719
RI0:	EQU	IOER
RI0S:	EQU	IOER
  ENDIF
RI1:	EQU	IOER
RI1S:	EQU	IOER
RI2:	EQU	IOER
RI2S:	EQU	IOER
RI3:	EQU	IOER
RI3S:	EQU	IOER
;
; ONE-TIME CODE (USED ONLY DURING COLD BOOT)
;
BOOT:	LXI	SP,80H
	IN	DSTAT1	;SEE IF AUTO-BOOT IN PROGRESS
	ANI	AUTBOT	;ISOLATE THE BOOT BIT
	JNZ	BOOTA	;JUMP IF NOT AUTO-BOOT
	MVI	A,0FH	;SET MODEM CONTROL REGISTER
	OUT	SMDMCT
	MVI	A,83H	;SET BAUD RATE DIVISOR ACCESS
	OUT	SLCTRL
	LHLD	B2810	; GET THE CONSOLE BAUD RATE DIVISOR
	MOV	A,H
	OUT	SINTEN
	MOV	A,L
	OUT	SDATA	;SET DIVISOR LOW BYTE
	MVI	A,3	;SET 8250 LINE CONTROL
	OUT	SLCTRL
	XRA	A	;SET HANDSHAKE LINES ACTIVE
	OUT	SINTEN
	OUT	SLSTAT
BOOTA:
	CALL	IBOOT1	;INITIALIZE ANY I/O THAT NEEDS IT
	LXI	H,LOGMSG  ;SIGN ON TO THE SYSTEM
	CALL	PRTWD
bootc:
	LHLD	CUNIT	; SET THE DRIVE A PRMTBL
	LDA	IDSV+3
	MOV	H,A
  IF	BOTH
	mov	a,l
	ani	10h	; SEE IF MINI/MAXI IS SELECTED
  ENDIF
  IF	MAXI
	mvi	b,10h
  ENDIF
  IF	BOTH
	JNZ	BOOTB	; BRIF 8"
  ENDIF
  IF	MINI
	mvi	b,20h
  ENDIF
BOOTB:	mov	a,l
	ani	4fh
	ora	b
	mov	l,a
	mov	e,a	;save for step rate setting in BOOT0
	SHLD	PRMTBL+1
	shld	lunit
	lhld	iiobyt	;get the initial IOBYTE value
	SHLD	IOBYTE	;SET IOBYTE, CDISK
	JMP	BOOT0	;GO DO THE BOOT COMMON CODE
;
LOGMSG:	DB	MSIZE/10+'0',MSIZE MOD 10 + '0'
	DB	'k CP/M Vers '
	DB	VERS/10+'0','.',VERS MOD 10+'0'
	DB	CR,LF+80h
;
IBOOT:	LXI	H,BOOTC	;SET UP THE RIGHT RETURN ADDRESS
	PUSH	H
IBOOT1:
  IF	CCS2719
	LXI	H,SIOCMD  ; POINT TO THE SIO INIT DATA STRING
	MVI	B,SIOLGTH ; GET THE STRING LENGTH
SIOI1:	MOV	A,M	; GET THE NEXT INIT COMMAND
	OUT	SIOAC	; OUTPUT TO SIO CHANNEL A
	OUT	SIOBC	;   AND TO CHANNEL B
	INX	H	; ADVANCE STRING POINTER
	DCR	B	; CHECK THE LOOP CONTROL
	JNZ	SIOI1	; JUMP IF MORE TO DO
	LHLD	B2719A	; GET THE A SIDE BAUD RATE
	MOV	A,L
	OUT	CTC0
	MOV	A,H
	OUT	CTC0
	LHLD	B2719B	; GET THE B SIDE BAUD RATE
	MOV	A,L
	OUT	CTC1
	MOV	A,H
	OUT	CTC1
PIAINIT:
	XRA	A	; GET A ZERO INTO (A)
	OUT	PIA1AC	;  ALLOWS ACCESS TO THE DATA DIRECTION REGISTER
	OUT	PIA1BC
	OUT	PIA2AC
	OUT	PIA2BC
	OUT	PIA1AD	;   SETS THE A SIDE FOR INPUT
	OUT	PIA2AD
	MVI	A,DATOUT  ; DIRECTION CONTROL BYTE FOR OUTPUT
	OUT	PIA1BD	;   SETS THE B SIDE FOR OUTPUT
	OUT	PIA2BD
	MVI	A,PIAMOD  ; PIA MODE CONTROL BYTE
	OUT	PIA1AC	; SETS THE PIA OPERATING MODE
	OUT	PIA1BC
	OUT	PIA2AC
	OUT	PIA2BC
	IN	PIA1BD	;  INPUT TO PRIME THE HANDSHAKE LINES
	IN	PIA2BD
  ENDIF
	LXI	H,WBOOT	;SET UP THE RIGHT WARM BOOT VECTOR
	SHLD	WBOOTE+1
	RET
;
  IF	CCS2719
SIOCMD:
	DB	4	; ACCESS WRITE REGISTER 4
	DB	01000110B  ; X16 CLOCK, 1 STOP BIT, NO PARITY
	DB	5	; ACCESS WRITE REGISTER 5
	DB	11101010B  ; DTR, TX 8 BITS, TX ENABLE, RTS
	DB	3	; ACCESS WRITE REGISTER 3
	DB	11100001B  ; RX 8 BITS, AUTO ENABLES, RX ENABLE
SIOLGTH:  EQU	$-SIOCMD  ; INIT COMMAND STRING LENGTH
  ENDIF
;
	ORG	BOOT
;
;THE REMAINDER OF THE CCBIOS IS RESERVED UNINITIALIZED
;DATA AREA, AND DOES NOT NEED TO BE A PART OF THE
;BIOS IMAGE ON THE DISKETTE (MEMORY MUST BE AVAILABLE,
;HOWEVER, BETWEEN "BEGDAT" AND "ENDDAT" ADDRESSES).
;
BEGDAT	EQU	$	;BEGINNING OF DATA AREA
;
SEKDSK:	DS	4
SEKSID:	EQU	SEKDSK+1
SEKHST:	EQU	SEKDSK+2
SEKTRK:	EQU	SEKDSK+3
SEKSEC:	DS	1
SEKSEL:	DS	1
;
DMAAD:	DS	2	;DIRECT MEMORY ADDRESS
;
HSTACT:	DS	1
HSTWRT:	DS	1
;
UNADSK:	DS	4
UNASID:	EQU	UNADSK+1
UNASEC:	EQU	UNADSK+2
UNATRK:	EQU	UNADSK+3
UNACNT:	DS	1
CPMSEC:	DS	1
NXTSCT:	DS	1
LSIDE:	DS	1	;LAST SELECTED SIDE
;
ERFLAG:	DS	1
RSFLAG:	DS	1
WRTYPE:	DS	1
;
;SCRATCH RAM AREA FOR BDOS USE
;
DIRBF:	DS	128	;SCRATCH DIRECTORY AREA
;
ALL00:	DS	38	;ALLOCATION VECTOR 0
CHK00:	DS	32	;CHECK VECTOR 0
ALL01:	DS	38	;ALLOCATION VECTOR 1
CHK01:	DS	32	;CHECK VECTOR 1
ALL02:	DS	38	;ALLOCATION VECTOR 2
CHK02:	DS	32	;CHECK VECTOR 2
ALL03:	DS	38	;ALLOCATION VECTOR 3
CHK03:	DS	32	;CHECK VECTOR 3
;
;PARAMETER TABLE FOR DRIVE-UNIQUE CONSTANTS
;
PRMTBL:	DS	12	;DRIVE  STP RAT, SLCT BYTS, SCTR SZ
;
DBUF:	DS	1024	;DISK BUFFER
;
ENDDAT:	EQU	$
	END
