;
;	modified for 4 outputs/loop  RBM  6 Feb 82
;
	TITLE	'CCS DISK INITIALIZATION ROUTINE V2.1'
;
	ORG	100H	;RUN FROM THE TPA
;
WBOOTV:	EQU	0
BDOSV:	EQU	5
CTRLC:	equ	3
CR:	EQU	0DH
LF:	EQU	0AH
LCMSK:	EQU	5FH
;
;
DCMD:	EQU	30H
DSTAT:	EQU	DCMD
DTRK:	EQU	DCMD+1
DSCTR:	EQU	DCMD+2
DDATA:	EQU	DCMD+3
DCTRL:	EQU	DCMD+4
DSTAT2:	EQU	4
DCTRL2:	EQU	DSTAT2
;
TRCK:	EQU	43H
SDE:	EQU	41H	;SIDE INDICATOR LOCATION
;
START:	JMP	NEXT	; skip the lead-in
STEP8:	DB	1	; 8" step rate
STEP5:	DB	3	; 5" step rate
NEXT:	LXI	SP,SSTACK  ;SET STACK TO KNOWN VALUE
	IN	DSTAT2	;SEE IF MINI OR MAXI
	ANI	2
	MVI	A,20H	;MINI SELBITS
	JNZ	ENTR	;JUMP IF MINI IS SELECTED
	MVI	A,30H	;ELSE, SET MAXI SELBITS
ENTR:	MOV	B,A	;SAVE FOR A MOMENT
	IN	DSTAT2	;NOW, GET THE DDEN BIT
	ANI	40H
	ORA	B	;ADD ON THE MINI/MAXI BITS
	MOV	B,A	;SAVE AGAIN IN B
	IN	DCTRL	;GET THE UNIT BIT
	RAR		;SHIFT IT OVER
	ANI	0FH	;ISOLATE THE SELECT BIT
	ORA	B	;ADD ON THE REST OF THE SELBITS
	STA	SELSV	;SAVE FOR LATER RESTORAL
	IN	DTRK	;SAVE THE TRACK REGISTER
	STA	TRKSV
	LXI	H,HELLO	;ADDRESS OF SIGN-ON MESSAGE
	CALL	PRTLN	;GO PRINT IT
NXTDRV:	call	pcrlf
	lxi	h,3003h	;initialize the track counter
	shld	atrkno
	xra	a	;set message for single-sided
	sta	atrkno+2
	LXI	H,MSG1	;ASK FOR DRIVE ASSIGNMENT
	CALL	PRTRD	
	ANI	LCMSK	;SET TO UPPER CASE
	SUI	'A'	;GET RID OF ASCII ZONE
	JC	NXTDRV	;BAD ASSIGNMENT, TRY AGAIN
	CPI	4	;INSURE A GOOD ASSIGNMENT
	JNC	NXTDRV	;BAD, JUMP
	STA	DRIVE	;SAVE IT FOR LATER USE
	mov	b,a	;save in b for loop control
	xra	a	;get a zero
	stc		;set the drive select bit
drv1:	ral		;shift it into position
	dcr	b
	jp	drv1	;loop until into position
	ori	20H	;think mini for a moment
	sta	drvtyp	;save the selbits
	out	dctrl	;select the drive
drv2:	mvi	a,8	;restore the drive at a fast step rate
	call	cmdout
	jc	drv2	;try again if error
	in	dstat	;reread the status
	ani	4	;insure track 0 is reporting
	jnz	drv3	;brif if there
drv4:	mvi	a,0bh	;else, try slow step rate
	call	cmdout
	jc	drv4	;try again if error
drv3:	lda	step5	;assume mini for moment
	ori	8	;add on the head load bit
	sta	rscmd	;save it
	mvi	a,35	;default mini tracks
	sta	maxtrk
	in	dstat2	;see if mini reporting track 0
	rar		;shift into carry
	jnc	sid	;brif mini
	lda	step8	;else, set up 8"
	ori	8	;add on head load
	sta	rscmd
	lda	drvtyp	;modify the selbits also
	ori	10h
	sta	drvtyp
	MVI	A,77	;SET 8" NUMBER OF TRACKS
	STA	MAXTRK
SID:	LXI	H,MSG7	;SIDE MESSAGE
	CALL	PRTRD
	SUI	'0'	;CHECK FOR VALID SIDE # (0 OR 1)
	JC	SID
	CPI	2
	JNC	SID
	STA	SIDE	;SAVE FOR LATER USE
	ora	a	;see if single sided
	jz	den	;brif so
	mvi	a,3
	sta	atrkno+2	;set up the message
DEN:	LXI	H,MSG3	;ASK FOR DENSITY
	CALL	PRTRD
	ANI	LCMSK	;GET RID OF LOWER CASE
	SUI	'D'	;CHECK FOR VALID INPUT (S OR D)
	JZ	DEN1
	SUI	'S'-'D'
	JNZ	DEN
	INR	A	;FLAG SINGLE DENSITY
DEN1:	STA	DENS	;SAVE FOR LATER USE
TKNO:	LXI	H,MSG5	;ASK FOR TRACK NUMBER (0-4C) OR ALL (*)
	CALL	PRTLN
	CALL	GETNUM	;GO GET THE NUMBER
	mov	a,b
	STA	TRKNO	;SAVE FOR LATER USE
trkn1:	CALL	PCRLF
SECSZ:	LXI	H,MSG4	;ASK FOR SECTOR SIZE
	CALL	PRTRD
	SUI	'0'	;SEE IF VALID (0-3)
	JC	SECSZ
	CPI	4
	JNC	SECSZ
	STA	SCTSZ	;SAVE FOR LATER USE
	lda	drvtyp
	ani	10h	;see if mini is selected
	JNZ	mini1	;JUMP IF NOT
TYPDR0:	LXI	H,MSG9	;YES, ASK FOR NUMBER OF TRACKS
	CALL	PRTLN
	CALL	GETNUM	;GET THE ANSWER
	mov	a,b	;get the response
	inr	b	;see if default
	jz	mini1	;brif default
	STA	MAXTRK	;SAVE THE ANSWER
mini1:	CALL	PCRLF	;START A NEW LINE
TYPDRA:	lda	drvtyp	;reget the selbits
	ani	10h	;isolate the mini/maxi bit
	LXI	H,S5S
	LXI	D,D5S-S5S
	JZ	SORD	; brif mini drive
	LXI	H,S8S	; else, set up for 8"
SORD:	LDA	DENS	;SEE IF DDEN
	DCR	A
	JZ	SORDA	; brif single density
	DAD	D	; advance the table pointer
	lda	drvtyp	; get the selbits
	ORI	40H	; set the double density bit
	sta	drvtyp
SORDA:	MOV	E,M
	INX	H
	MOV	D,M
	INX	H
	XCHG
	SHLD	BUFEND
	lda	bdosv+2	;insure enough room exists
	cmp	h
	jnc	sord0	;brif enough room
	lxi	h,rtcpm
	push	h
	lxi	h,memsg	;tell the operator
	jmp	prtln	;go do it and return to cpm
sord0:	XCHG
	MOV	E,M
	INX	H
	MOV	D,M
	LDA	SCTSZ
	INR	A
SORDB:	INX	H
	DCR	A
	JNZ	SORDB
	MOV	A,M
	INR	A
	JZ	TRYAGN
	XCHG
	MOV	M,A
	LXI	D,-11
	DAD	D
	LDA	MAXTRK	;GET NUMBER OF TRACKS
	MOV	M,A	;PUT INTO TABLE
	LDA	TRKNO
	INR	A
	JZ	TRKLP
	CMP	M	;INSURE TRACK SEL IS IN RANGE
	JNC	TRYAGN	;JUMP IF NOT
	DCR	A	;SEE IF A SEEK IS NEEDED
	push	psw
	push	h
	lxi	h,0
atrklp:	inr	l
	sui	10
	jnc	atrklp
	dcr	l
	adi	10
	ori	30h
	mov	h,a
	mov	a,l
	ora	a
	mvi	l,20h
	jz	atrklp1
	ori	30h
	mov	l,a
atrklp1:  shld	atrkno
	pop	h
	pop	psw
	JZ	TRKLP	;JUMP IF NOT
SORDC:	OUT	DDATA
	LDA	RSCMD
	ORI	18H	; seek out the track
	push	h
	CALL	CMDOUT
	pop	h
	lda	trkno	;reget the track number
	jc	sordc	;try again if error
;
;
TRKLP:	STA	TRACK	;INITIALIZE TRACK COUNTER
	MVI	A,0D0H	;SELECT SIDE 0
	OUT	DCTRL2
	XRA	A	;SET THE CURRENT SIDE NUMBER
TRKLP1:	STA	CSIDE
	ori	'0'	;convert to ASCII
	STA	ASIDE	;put into message
	push	h
	LXI	H,CPYMSG
	CALL	PRTLN
	pop	h
	PUSH	H	;SAVE FOR LATER USE
	INX	H	;POINT TO # OF SECTORS PER TRACK
	LXI	D,BUFFER	;INIT BUFFER POINTER
	MVI	C,5	;FIRST 5 ENTRIES ARE FOR LEADER
	CALL	MMOV	;EXPAND THEM INTO TRACK IMAGE
	MVI	A,1	;INITIALIZE SECTOR COUNTER
SCTRLP:	STA	SCTR	;INIT OR UPDATE SECTOR COUNTER
	PUSH	H	;SAVE FOR SECTOR REPEAT FUNCTION
	INX	H	;POINT TO DATA DTABLE
	MVI	C,3	;NEXT 3 ARE THE PRE HEADER FILL
	CALL	MMOV	;PUT THEM INTO THE IMAGE
	LDA	TRACK
	STAX	D
	INX	D
	LDA	CSIDE
	STAX	D
	INX	D
	LDA	SCTR
	STAX	D
	INX	D
	LDA	SCTSZ
	STAX	D
	INX	D
	MVI	C,5	;DO THE PRE-DATA FILL
	CALL	MMOV
	LDA	SCTSZ	;INITIALIZE THE DATA AREA
	INR	A	;SET UP LOOP CONTROL
	PUSH	H	;SAVE (H,L)
	LXI	H,40H
SSZLP:	DAD	H	;DOUBLE (H,L)
	DCR	A
	JNZ	SSZLP	;LOOP TIL BYTE COUNT IN (H,L)
	MOV	B,H
	MOV	C,L
	POP	H	;RESTORE (H,L)
STSCLP:	MOV	A,M
	STAX	D
	INX	D
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	STSCLP
	INX	H
	MVI	C,2	;2 MORE ENTRIES COMPLETE THE SECTOR
	CALL	MMOV
	LDA	SCTR	;INCREMENT THE SECTOR COUNTER
	INR	A
	POP	H	;REGET POINTER TO SECTORS PER TRACK
	CMP	M	;ALL FOR THIS TRACK?
	JNZ	SCTRLP
	DCX	H	;POINT TO GAP 4 FILL CHARACTER
	LDA	BUFEND	;FIND THE END OF THE TRACK BUFFER
	SUB	E
	MOV	C,A	;# OF GAP 4 FILL CHAR IN (B,C)
	LDA	BUFEND+1
	SBB	D
	MOV	B,A
G4FILL:	MOV	A,M	;GET THE FILL CHARACTER
	STAX	D	;PUT IT IN THE BUFFER
	INX	D
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	G4FILL	;CONTINUE TIL FILLED
	CALL	OUTRK	;WRITE THE TRACK
	POP	H	;REGET TABLE POINTER
	LDA	SIDE	;GET SINGLE/DOUBLE SIDE FLAG
	MOV	B,A	;SAVE FOR A MOMENT
	LDA	CSIDE	;GET CURRENT SIDE INDICATOR
	SUB	B
	JZ	NXTRK	;JUMP IF DONE WITH THIS SIDE
	MVI	A,90H	;SELECT OTHER SIDE
	OUT	DCTRL2
	MVI	A,1	;SET INDICATOR
	JMP	TRKLP1	;GO DO OTHER SIDE
;
NXTRK:	LDA	TRKNO	;SEE IF SINGLE TRACK REQUEST
	INR	A
	JNZ	NXTDRV	;JUMP IF SO
nxtr1:	LDA	RSCMD	;ELSE, STEP IN ONE TRACK
	ORI	58H	; step in one track
	push	h
	CALL	CMDOUT
	pop	h
	jc	nxtr1
	push	h
	LXI	H,ATRKNO+1
	CALL	INCNUM
	pop	h
;
	LDA	TRACK	;GET TRACK COUNTER
	INR	A	;ADVANCE TRACK COUNTER
	CMP	M	;SEE IF DONE WITH DISK
	JNZ	TRKLP	;NO, JUMP
	XRA	A	;GO BACK AND DO TRACK 0
	STA	SCTSZ
;	STA	SIDE	;ONLY DO SIDE 0
	STA	TRKNO
	INR	A
	STA	DENS
	LDA	drvtyp
	ani	0BFH	;set single density
	STA	drvtyp
nxtr2:	lda	rscmd	;get the restore command
	call	cmdout	;do it
	jc	nxtr2	;try again if error
	JMP	TYPDRA	;GO DO TRACK 0
;
;
TRYAGN:	LXI	H,MSG8	;BAD SELECTION MESSAGE
	CALL	PRTLN
	JMP	DEN	;GET A NEW SELECTION
;
;
CMDOUT:	push	psw
	lda	drvtyp
	out	dctrl
	mvi	a,0d0h
	out	dctrl2
	mvi	a,14
cmdout1:  dcr	a
	jnz	cmdout1
	pop	psw
	OUT	DCMD	;OUTPUT THE COMMAND
WEOC:	IN	DCTRL	;GET THE STATUS
	RAR		;SEE IF -INTRQ IS SET
	JNC	WEOC	;NO, JUMP AND TRY AGAIN
	lxi	h,320	;do an 8ms wait
weoc1:	dcx	h
	xthl
	xthl
	xthl
	xthl
	mov	a,h
	ora	l
	jnz	weoc1
	IN	DSTAT	;GET THE 1791 CHIP STATUS
	STA	STATSV	;SAVE IT
	ANI	0D8H	;MASK OUT THE NON-ERROR BITS
	RZ
	lxi	h,dnrmsg	; address of drive not ready
	ral
	jc	errpt
	lxi	h,wprmsg	; write protect message
	ral
	jc	errpt
	ral
	ral
	lxi	h,sekmsg
	jc	errpt
	lxi	h,crcmsg
	ral
errpt:	cc	prtrd
	stc
	ret
;
MMOV:	CALL	MOVENT	;MOVE THE CURRENT TABLE ENTRY
	DCR	C	;MORE ENTRIES TO DO?
	JNZ	MMOV	;YES, JUMP
	RET
;
;
MOVENT:	MOV	B,M	;GET THE # OF BYTES
	INX	H	;POINT TO NEXT ENTRY
	MOV	A,M	;GET THE CURRENT DATA VALUE
	INX	H	;POINT TO NEXT VALUE
MOVLP:	STAX	D	;PUT VALUE INTO TRACK IMAGE
	INX	D	;POINT TO NEXT LOCATION
	DCR	B	;LOOP CONTROL
	JNZ	MOVLP
	RET
;
OUTRK:	IN	DDATA	;CLEAR ANY JUNK OUT
	LDA	DRVTYP	;GET CONTROL BITS
	ORI	80H	;ADD ON THE AUTO-WAIT BIT
	out	dctrl	;set the auto-wait
	LHLD	BUFEND	;COMPUTE THE BUFFER LENGTH
	LXI	B,-BUFFER
	DAD	B
	ora	a	;clear the carry bit
	mov	a,h	; divide by 2
	rar
	mov	b,a
	mov	a,l
	rar
	mov	c,a
	ora	a	; clear the carry again
	mov	a,b	; divide by two again
	rar
	mov	b,a
	mov	a,c
	rar
	mov	c,a
	lxi	h,buffer	; point to the buffer start
	MVI	A,0F4H	;GET THE WRITE TRACK COMMAND
	OUT	DCMD	;START IT GOING
	DI		;CAN NOT AFFORD ANY INTERRUPTS
OUTLP:	mov	a,m	; get the next byte
	out	ddata	; output it
	inx	h
	mov	a,m	; get the next byte
	out	ddata	; output it
	inx	h
	mov	a,m	; get the next byte
	out	ddata	; output it
	inx	h
	mov	a,m	; get the next byte
	out	ddata	; output it
	inx	h
	dcx	b	; do the loop control
	mov	a,b
	ora	c
	jnz	outlp	; brif more to do
	EI
EOJ:	IN	DCTRL	;WAIT FOR NOT BUSY
	RAR
	JNC	EOJ	;LOOP UNTIL NOT BUSY
;
CMDEND:	IN	DSTAT	
	STA	STATSV	
	ANI	0E4H	
	RZ	
	ral		;crack the error
	lxi	h,dnrmsg
	jc	errpt	;brif drive not ready
	ral
	lxi	h,wprmsg
	jc	errpt	;brif diskette write protected
	lxi	h,wfmsg
	ral
	jc	errpt	;brif write fault
	lxi	h,dlmsg
	ral
	ral
	ral
	jmp	errpt
;
DRVTYP:	DB	0	
;
PCRLF:	LXI	H,CRLF	
PRTLN:	MOV	A,M	
	ANA	A	
	RZ	
PCHAR:	PUSH	H	
	PUSH	D	
	PUSH	B	
	MOV	E,A	
	MVI	D,0	
	MVI	C,2	
	CALL	BDOSV	
	POP	B	
	POP	D	
	POP	H	
	INX	H	
	JMP	PRTLN	
;
PRTRD:	CALL	PRTLN	
	CALL	GETCHR	
	PUSH	PSW	
	CALL	PCRLF	
	POP	PSW	
	CPI	CTRLC
	RNZ
;
;
RTCPM:	LDA	SELSV	;RESTORE THE CURRENT UNIT SELECT
	OUT	DCTRL
	LDA	TRKSV
	OUT	DTRK
	EI		;REENABLE INTERRUPTS
	CALL	wbootv	
	HLT	
;
GETCHR:	MVI	C,1	
	JMP	BDOSV	
;
getnum:	MVI	B,0ffh
COPY2B:	PUSH	B
	CALL	GETCHR	;GET FIRST DIGIT
	POP	B
	CPI	CR
	RZ		;SELECT THE DEFAULT
	inr	b	;see if first time through
	jz	cop2c	;brif so
	dcr	b
cop2c:	SUI	'0'	;UNBIAS THE VALUE
	JC	COPY2A	;JUMP IF BAD NUMBER
	CPI	10
	push	psw	;save the new digit for a moment
	JNC	COPY2A	;JUMP IF BAD NUMBER
	MOV	A,B	;ACCUMULATE THE VALUE
	add	a	;*2
	add	a	;*4
	ADD	B	;*5
	ADD	A
	mov	b,a	;save the number
	pop	psw	;get the new number
	add	b	;add it on
	MOV	B,A
	JMP	COPY2B	;GO FINISH CURRENT DIGIT
;
COPY2A:	LXI	H,BADMSG
	call	prtln
	JMP	getnum
badmsg:	db	cr,lf,'Bad number - try again:  ',0
;
INCNUM:	lxi	h,atrkno+1
	INR	M
	MVI	A,'9'+1
	SUB	M
	RNZ
	MVI	M,'0'
	DCX	H
	mvi	a,3
	CMP	M
	JNZ	INC1
	MVI	M,'0'
INC1:	INR	M
	RET
;
CPYMSG:	DB	CR,'Formatting Track '
ATRKNO:	DB	3,'0',0
	db	' Side '
aside:	db	'0',0
;
hello:	db	cr,lf,'CCS Disk Formatter Program V2.1',0
msg1:	db	lf,'Which Drive (A-D)?                ',0
msg2:	db	'Is It a Mini (Y/N)?               ',0
msg3:	db	'Single or Double Density (S/D)?   ',0
msg4:	db	'Sector Size (0-3)?                ',0
msg5:	db	'Track Number (0-76 or CR)?        ',0
msg7:	db	'Single or Double Sided (0 or 1)?  ',0
msg8:	db	'Bad Track or Sector Size/Density Selection:',cr,lf,0
msg9:	db	'Number of Tracks (35, 40, or 80)? ',0
memsg:	db	cr,lf,'Insufficient Memory for track image.',0
dnrmsg:	db	CR,LF,'Drive is not ready.',0
wprmsg:	db	CR,LF,'Diskette is write protected.',0
sekmsg:	DB	CR,LF,'Seek error - try again.',0
crcmsg:	db	CR,LF,'CRC error - try again.',0
wfmsg:	db	CR,LF,'Write fault - check your hardware.',0
dlmsg:	db	CR,LF,'Data lost - Check your hardware.',0
;
;
S5S:	DW	BUFFER+3450
	DW	S5+11
	DB	18
	DB	10
	DB	5
	DB	2
D5S:	DW	BUFFER+6500
	DW	D5+11
	DB	29
	DB	18
	DB	10
	DB	5
S8S:	DW	BUFFER+5600
	DW	S8+11
	DB	26
	DB	15
	DB	8
	DB	4
D8S:	DW	BUFFER+11000
	DW	D8+11
	DB	0ffh
	DB	26
	DB	15
	DB	8
;
;
S8:	DB	77	;TRACKS PER SIDE
	DB	20,0FFH	;GAP 4 DATA
	DB	20,0FFH	;GAP 4 DATA
	DB	6,0
	DB	1,0FCH	;INDEX MARK
	DB	26,0FFH	;GAP 1 DATA
	DB	27	;SECTORS PER TRACK + 1
	DB	3,0
	DB	3,0
	DB	1,0FEH	;ADDRESS MARK
	DB	1,0F7H	;CRC REQUEST
	DB	5,0FFH	;GAP 2 DATA
	DB	6,0FFH
	DB	6,0
	DB	1,0FBH	;DATA MARK
	DB	0E5H	;DATA FILL
	DB	1,0F7H	;CRC REQUEST
	DB	27,0FFH	;GAP 3 DATA
;
D8:	DB	77	;TRACKS PER SIDE
	DB	80,4EH	;GAP 4 DATA
	DB	12,0	;GAP 4 DATA
	DB	3,0F6H
	DB	1,0FCH	;INDEX MARK
	DB	50,4EH	;GAP 1 DATA
	DB	27	;SECTORS PER TRACK + 1
	DB	12,0
	DB	3,0F5H
	DB	1,0FEH	;ADDRESS MARK
	DB	1,0F7H	;CRC REQUEST
	DB	22,4EH	;GAP 2 DATA
	DB	12,0
	DB	3,0F5H
	DB	1,0FBH	;DATA MARK
	DB	0E5H	;DATA FILL
	DB	1,0F7H	;CRC REQUEST
	DB	54,4EH	;START OF GAP 3 OR 4
;
S5:	DB	35	;TRACKS PER SIDE
	DB	3,0FFH	;GAP 4 DATA
	DB	3,0FFH	;GAP 4 DATA
	DB	4,0FFH	;GAP 4 DATA
	DB	3,0FFH	;GAP 4 DATA
	DB	3,0FFH	;GAP 4 DATA
	DB	19	;SECTORS PER TRACK + 1
	DB	3,0
	DB	3,0
	DB	1,0FEH	;ADDRESS MARK
	DB	1,0F7H	;CRC REQUEST
	DB	5,0FFH	;GAP 2 DATA
	DB	6,0FFH
	DB	6,0
	DB	1,0FBH	;DATA MARK
	DB	0E5H	;DATA FILL
	DB	1,0F7H	;CRC REQUEST
	DB	11,0FFH	;START OF GAP 3 OR 4
;
D5:	DB	35	;TRACKS PER SIDE
	DB	6,4EH	;GAP 4 DATA
	DB	6,4EH	;GAP 4 DATA
	DB	8,4EH	;GAP 4 DATA
	DB	6,4EH	;GAP 4 DATA
	DB	6,4EH	;GAP 4 DATA
	DB	19	;SECTORS PER TRACK + 1
	DB	10,0
	DB	3,0F5H
	DB	1,0FEH	;ADDRESS MARK
	DB	1,0F7H	;CRC REQUEST
	DB	22,04EH	;GAP 2 DATA
	DB	12,0
	DB	3,0F5H
	DB	1,0FBH	;DATA MARK
	DB	0E5H	;DATA FILL
	DB	1,0F7H	;CRC REQUEST
	DB	20,4EH	;START OF GAP 3 OR 4
;
;
SIDE:	DB	0
TRACK:	DB	0
SCTR:	DB	0
STATSV:	DB	0
RSCMD:	DB	0
BUFEND:	DW	0
DRIVE:	DB	0
DENS:	DB	0
TRKNO:	DB	0
SCTSZ:	DB	0
CRLF:	DB	CR,LF,0
DRVA:	DS	1
SELSV:	DS	1	;ENTRY DRIVE SELECT BITS SAVE
TRKSV:	DS	1	;TRACK SAVE AREA
SIDSV:	DS	1	;SIDE SAVE AREA
MAXTRK:	DS	1	;TEMP NUMBER OF TRACKS HOLD
CSIDE:	DS	1	;CURRENT SIDE HOLD
	DS	20H	;STACK AREA
SSTACK: DS	0	;START THE STACK HERE
BUFFER:	DS	10800
;
;
	END
