;
; PROGRAM TO READ IN AND DISPLAY THE VECTORSCAN FILES
;
	ORG	100H
	JMP	START
;
; NAMES OF THE FILES TO BE READ
;
NAMES:
	DB	'SHUTTL2.TXT$'
	DB	'BARCHART.TXT$'
	DB	'BULL.TXT$'
	DB	'FILL.TXT$'
	DB	'PIE.TXT$'
	DB	'PANEL.TXT$'
	DB	'DDA.TXT$'
	DB	'CAD.TXT$'
	DB	'PLOT.TXT$'
	DB	'$'		;END OF FILE NAMES
;
START:
	LXI	SP,STACK
	LXI	D,SIGNON	;SIGNON
	MVI	C,9
	CALL	5
GETDEV:
	LXI	D,DEVMSG	;PROMPT FOR DEVICE (LST OR CON)
	MVI	C,9
	CALL	5
	MVI	C,1		;GET RESPONSE FOR
	CALL	5
	CPI	'L'		;FOR LIST
	JZ	DEVLIST
	CPI	'l'
	JZ	DEVLIST
	CPI	'C'		;FOR CONSOLE
	JZ	DEVCON
	CPI	'c'
	JZ	DEVCON
	JMP	GETDEV		;ASK AGAIN
DEVLIST:
	MVI	A,5		;SET UP DEVICE FOR LIST
	JMP	SETDEVICE
DEVCON:
	MVI	A,2		;CONSOLE
SETDEVICE:
	STA	DEVICE
	LXI	H,BUFFER	;SET UP BUFFER ADDRES
	SHLD	BUFPTR
	LXI	H,NAMES 	;NOW LOAD FILES ONE AT A TIME
	SHLD	NAMPTR
DEMO1:
	CALL	LOADFILE
	LHLD	NAMPTR
	MOV	A,M
	CPI	'$'		;LIST ENDS W/$
	JNZ	DEMO1
	MVI	A,0FEH		;TERMINATE BUFFER
	CALL	STORE
DEMO2:
	LXI	H,BUFFER	;SET UP TO OUTPUT
	SHLD	BUFPTR
DEMO3:
	CALL	ENDTEST 	;CHECK FOR EXIT
	JZ	EXIT
	LHLD	BUFPTR
	MOV	A,M		;GET CHAR
	INX	H
	SHLD	BUFPTR
	CPI	0FFH		;FF TERMINATES FILE
	JZ	DEMO4		;DELAY BETWEEN FILES
	CPI	0FEH		;FE TERMINATES BUFFER
	JZ	DEMO5		;START AGAIN
	CALL	OUTPUT		;ELSE SEND CHAR
	JMP	DEMO3
DEMO4:
	CALL	DELAY		;DELAY BETWEEN FILES
	JMP	DEMO3
DEMO5:
	CALL	DELAY
	JMP	DEMO2
EXIT:
	JMP	0
;
DELAY:
	MVI	B,10
DLY0:
	LXI	D,0
DLY1:
	DCX	D
	MOV	A,D
	ORA	E
	JNZ	DLY1
	DCR	B
	JNZ	DLY0
	RET
;
LOADFILE:
	LXI	D,FCB		;SET UP FCB TO OPEN FILE
	XRA	A		;USE CURRENT DISK
	STAX	D
	INX	D
	LHLD	NAMPTR		;HL POINTS TO NAME
	MVI	B,8		;UP TO 8 LETTERS IN NAME
LDFL1:
	MOV	A,M		;GET NAME PORTION
	INX	H
	CPI	'.'		;NAME PORTION ENDS
	JZ	LDFL2		;W/.
	STAX	D		;PUT IN FCB
	INX	D
	DCR	B		;NAME LETTER CTR
	JNZ	LDFL1
	MOV	A,M		;EXIT LOOP THIS WAY IF
	INX	H
	CPI	'.'		;ALL 8 LETTERS USED
	CNZ	ERROR		;ERROR IF NO . YET
	JMP	LDFL3
LDFL2:
	MVI	A,' '		;EXIT LOOP HERE IF ALL 8
LDFL21: 			;LETTERS NOT USED
	STAX	D		;PUT IN BLANKS TIL TYPE
	INX	D		;PART OF FCB
	DCR	B
	JNZ	LDFL21
LDFL3:				;NOW DO TYPE PORTION OF NAME
	MVI	B,3		;UP TO 3 CHAR IN TYPE
LDFL4:
	MOV	A,M		;GET TYPE CHAR
	INX	H
	CPI	'$'		;ENDS W/ $
	JZ	LDFL5
	STAX	D		;ELSE PUT AWAY
	INX	D
	DCR	B		;TYPE LETTER CTR
	JNZ	LDFL4
	MOV	A,M		;EXIT LOOP HERE IF ALL 3
	INX	H		;LETTERS USED. CHK FOR $
	CPI	'$'		;ERROR IF NO $
	CNZ	ERROR
	JMP	LDFL6
LDFL5:				;EXIT LOOP HERE IF ALL 3 CHR
	MVI	A,' '		;NOT USED IN TYPE. FILL W/' '
LDFL51:
	STAX	D		;PUT IN ' '
	INX	D
	DCR	B
	JNZ	LDFL51
LDFL6:				;NAME SET UP. DO REST OF FCB
	SHLD	NAMPTR
	XRA	A		;CLEAR
	STA	FCB+12		;EX
	STA	FCB+32		;CR
	STA	FCB+14		;S2
	LXI	D,FCB		;OPEN THE FILE
	MVI	C,15
	CALL	5
	INR	A		;CHK FOR BAD OPEN
	CZ	ERROR
	MVI	A,80H		;CLEAR INPUT FILE BUFFER
	STA	BUFPTR2
LDFL7:				;NOW READ FILE INTO BUFFER
	CALL	INFILE		;GET A CHAR
	CPI	1AH		;CHK FOR END
	JZ	LDFL8
	CALL	STORE		;PUT AWAY BYTE
	JMP	LDFL7
LDFL8:
	MVI	A,0FFH		;INDICATE END OF FILE
	CALL	STORE
	RET			;DONE
;
;SUBR TO GET CHARACTERS FROM A FILE
INFILE:
	LDA	BUFPTR2 	;CHECK FOR EMPTY TEMP BUF
	CPI	80H
	JNZ	INFL1		;IF NOT EMPTY THEN OK
	LXI	D,BUFFER2	;ELSE READ IN NEXT RECORD
	MVI	C,26		;SET DMA
	CALL	5
	LXI	D,FCB
	MVI	C,20		;READ SECTOR
	CALL	5
	ORA	A		;ERROR IF FILE EMPTY
	CNZ	ERROR
	MVI	A,0
	STA	BUFPTR2
INFL1:
	MOV	L,A		;COMPUTE ADDR OF
	INR	A		;BYTE IN FILE
	STA	BUFPTR2
	MVI	H,0
	LXI	D,BUFFER2
	DAD	D
	MOV	A,M
	RET
;
;SUBR TO STORE DATA IN BUFFER
STORE:
	LHLD	BUFPTR		;GET PTR INTO BUFFER
	MOV	M,A		;PUT AWAY BYTE
	INX	H		;INC TO NEXT POSITION
	SHLD	BUFPTR
	LXI	D,BUFEND	;CHK FOR OFLO
	MOV	A,E		;PTR - END
	CMA
	MOV	E,A
	MOV	A,D
	CMA
	MOV	D,A
	INX	D
	DAD	D
	MOV	A,L
	ORA	H
	CZ	ERROR
	RET
;
;SUBR TO CHECK FOR USER ABORT
ENDTEST:
	MVI	C,11		;CHECK FOR CONSOLE
	CALL	5
	ORA	A		;IF 0 THEN NOT RDY
	JNZ	ENDTST1 	;SO RETURN
	INR	A		;W/ 0 FLAG CLEARED
	RET
ENDTST1:
	MVI	C,1		;GET CHAR
	CALL	5
	ANI	7FH
	CPI	3		;^C
	RET
;
;SUBR TO OUTPUT CHAR IN A TO DEVICE
OUTPUT:
	MOV	E,A
	LDA	DEVICE
	MOV	C,A
	CALL	5
	RET
;
;ERROR ROUTINE. PRINTS ERROR ADDRESS AND REBOOTS
ERROR:
	POP	H		;GET ADDRESS OF ERROR
	MVI	B,4		;4 HEX DIGITS
	LXI	D,ERRMSG2	;PUT ERROR ADDRESS HERE
ERR1:
	MOV	A,H		;GET HEX DIGIT
	RAR			;SHIFT IT DN
	RAR
	RAR
	RAR
	ANI	0FH		;MASK IT IN
	ADI	'0'		;ADD ASCII NUMBER BIAS
	CPI	'A'
	JC	ERR2		;IF <= 9 THEN SKIP
	ADI	'A'-'9'-1	;ELSE ADD IN LETTER BIAS
ERR2:
	STAX	D		;PUT IN BUFFER
	INX	D
	DAD	H		;DO NEXT DIGIT
	DAD	H
	DAD	H
	DAD	H
	DCR	B		;LOOP 4 TIMES
	JNZ	ERR1
	LXI	D,ERRMSG	;OUTPUT ERROR MSG
	MVI	C,9
	CALL	5
	JMP	0
;
SIGNON:
 DB 13,10,'Demonstration program for VectorScan 512',13,10,'$'
DEVMSG:
 DB 13,10,'Enter port for VectorScan ( L => LIST, C => CONSOLE): $'
ERRMSG:
 DB 13,10,'PROGRAM ERROR AT ADDRESS '
ERRMSG2:
 DB '0000H',10,13,'$'
;
		DS	64
STACK:
FCB:		DS	36
BUFPTR: 	DS	2
BUFPTR2:	DS	1
NAMPTR: 	DS	2
DEVICE: 	DS	1
BUFFER2:	DS	80H
BUFFER: 	DS	0D600H-$
BUFEND:
e.&$ There is a highlighted "activ