/* "stdio" definitions */
#ifndef FILE
struct gc_buf_rec {
	char	g_idx;
	char	g_max;
	char	g_cnt;
	char	g_data[126];
};

/* The global "gc_bp" must be initialized if getchar is to buffer */
/* (see set_gcbp() in stdio.c) */

#ifndef BDOSJUMP
#include "bdos.h"
#endif

struct file_rec {
	struct fcb	*f_fcbp;
	int		f_idx;
	int		f_max;
	int		f_cnt;
	char		*f_datap;
};

#define FILE	struct file_rec
#define TXTEOF	26	/* Stored at end of CP/M text files */
#define EOF	(-1)	/* Returned from getchar/getc on End of File */
#define NULL	0	/* Returned from fopen if fails */
#define OUTIDX	(-1)	/* Value of f_idx when open for output */

#define BIN_IO	0100000 /* Sign bit of f_max set for binary I/O */
#define BIN_EOF 0100000 /* Sign bit of f_cnt set for binary EOF */

#define INTERACTIVE  is_iactive()	/* True when input seen or logged */

#ifndef IN_STDIO
  /* getchar() is equivalent to getc(stdin) */
  extern FILE *stdin;
  /* putchar() is equivalent to putc(stdout) */
  extern FILE *stdout;
  extern FILE *stderr;
#endif

#endif
f_rec {
	char	g_idx;
	char	g_max;
	char	g_cnt;
	char	g_data[126];
};
