#include "stdio.h"
/* element of devmap */
struct dmap {
	char	m_drv;
	char	m_usr;
};

/* Structure representing beginning of cnixhigh.asm */
struct cnixhigh {
	struct jump	trapdos, realdos, trapwst, realwst;
	struct jump	loader;
	struct fcb	*calfcbp;
	char		*calsp, *calpc;
	char		ioflag;
	FILE		infile;
	FILE		logfile;
	int		dvfree;		/* First temp drive */
	int		dvlast;		/* Last temp drive */
	struct dmap	devmap[MAXDEV+1];
	int		ch_retcode;
	int		ch_lasterr;
	char		ch_pipedrv;	/* drv for pipes */
	char		ch_pathdrv;	/* drv for command path */
};

/* Bit positions within ioflag */
#define LOGINP	1	/* Log all input */
#define LOGOUT	2	/* Log all output */
#define NOPOUT	4	/* Do not send output to term */
#define DSKINP	8	/* Get input from disk */
#define SEEINP	16	/* (Re)-echo input to console */
#define LOGERR	32	/* Log all error(=Direct) output */
#define NOPERR	64	/* Do not send error(=Direct) output to term */

/* True if input being seen or logged */
#define M_INTERACTV	((cnixp->ioflag&(DSKINP|SEEINP|LOGINP)) != DSKINP)
#define MAXPATH 	128	/* max length of hierarchical path name */

#define MINUSR		6	/* Start with user # 6 == "sda" */
#define MAXUSR		31	/* Last user available under CP/M == "sdz" */
;
	struct fcb	*ca