#include "bdos.h"
#define IN_STDIO 1
#include "stdio.h"
#include "cnixhigh.h"	/* For M_INTERACTV definition */

/* Standard character Input/Output routines */

#define CTLC	3	/* ASCII code for Control/C */

/* Set up special values for stdin/stdout/stderr */
FILE *stdin = 1;
FILE *stdout = 2;
FILE *stderr = 3;

/* must be initialized (via set_gcbp or otherwise) if getchar is to buffer */
struct gc_buf_rec *gc_bp;

putchar(c)
{
	if (c == '\n') putchar('\r');	/* Preceed '\n' by '\r' */
	bdos(CNSOUT, c);
}

set_gcbp(bp)
struct gc_buf_rec *bp;
{
	/* Set up getchar buffering */
	gc_bp = bp;
}

getchar()
{
	/* Read one char, exit on CTL-C */
	/* Return EOF on text EOF */
	static int idx, c;

	if (!gc_bp) {
		/* un-buffered */
		c = _get1();
	} else do {
	/* loop to ignore '\r' */
		idx = gc_bp->g_idx&0377;
		if (idx >= (gc_bp->g_cnt&0377)) {
			/* Re-fill buffer */
			bdos(RDCNSBUF, &gc_bp->g_max);
			echo_lf();
			idx = 0;
			gc_bp->g_idx = 0;
			_gc_add('\n');
		}
		c = gc_bp->g_data[idx]&0377;
		gc_bp->g_idx++;
	} while (c == '\r');
	if (c == TXTEOF) {
		/* Flush buffer on EOF */
		if (gc_bp) gc_bp->g_cnt = 0;
		c = EOF;
	}
	return(c);
}

_gc_add(c)
{
	/* add char to getchar buf if room */
	static int cnt;

	if (!gc_bp) return;
	cnt = gc_bp->g_cnt&0377;
	if (cnt < (gc_bp->g_max&0377)) {
		gc_bp->g_data[cnt] = c;
		gc_bp->g_cnt++;
	}
}

CtlCk()
{
	/* Check if CTL-C, buffer up char typed */
	/* Exit if CTL-C typed. */
	/* Otherwise return non-zero if char found */

	if (!bdos(GETCSTAT, 0)) return(0);
	_gc_add(_get1());
	return(1);
}

_get1()
{
	/* Get one char, unbuffered.  Exit if CTL-C */
	/* Convert '\r' into '\n', and echo line feed */
	static int c;

	c = bdos(CNSINP, 0);
	if (c == CTLC) exit(-10);
	if (c == '\r') {
		c = '\n';
		/* echo only if input seen or logged */
		echo_lf();
	}
	return(c);
}

struct cnixhigh *
cnixptr()
{
	/* Return pointer to cnixhigh struct */
	/* Calculate from pointer to BIOS warm start */
	/* Return null pointer if not running under cnix */
	static char *biosp, *warmp;

	biosp = BIOSJUMP->j_target;
	warmp = biosp->j_target;
	if (warmp >= biosp)
		return(0);	/* Not under cnix */
	else
		return(warmp - (int)(&((struct cnixhigh *)0)->trapwst));
}

static struct cnixhigh *cnixp;

/* Return non-zero if input seen or logged */
is_iactive()
{
	/* Leave cnixp set as side effect */

	/* Always interactive if not under cnix */
	return (!(cnixp = cnixptr()) ||
	    (M_INTERACTV));
}

echo_lf()
{
	/* Echo line feed if interactive */
	if (is_iactive()) {
		/* Echo to where it will be seen! */
		bdos(cnixp && cnixp->ioflag&NOPOUT? DIRCNSIO: CNSOUT, '\n');
	}
}
o line feed */
	static int c;

	c = bdos(CNSINP, 0);
