/* String utilities */

char *
lowerstr(buf, str, len)
register char *buf, *str;
register int len;
{
	/* copy str into buf, converting to lower case */
	/* quit at first blank or after "len" chars */
	/* Return pointer to null at end of buf */
	/* Clear parity bits */

	while (--len >= 0) {
		if ((*buf = lower((*str++)&0x7f)) == ' ') break;
		++buf;
	}
	*buf = 0;
	return(buf);
}

char *
prepend(new, old)
register char *new, *old;
{
	/* prepend new infront of old, return addr of front */
	register char *np;

	for (np = new; *np; np++);
	while (np > new) *--old = *--np;
	return(old);
}

strany(c, str)
register char c, *str;
{
	/* return non-zero if c within str */
	while (*str) if (c == *str++) return(1);
	return(0);
}

streql(str1, str2)
char *str1, *str2;
{
	/* return non-zero if strings equal */
	while (*str1 == *str2) {
		if (*str1 == 0) return(1);
		++str1; ++str2;
	}
	return(0);
}

strcmp(str1, str2)
char *str1, *str2;
{
	/* Return <0, 0, >0 according to lexicographic comparison */
	static int c;

	while ((c = *str1 - *str2) == 0 && *str1) {
		++str1; ++str2;
	}
	return(c);
}

char *
strcpy(str1, str2)
register char *str1, *str2;
{
	/* copy str2 --> str1, return pointer to null at end of copy */
	while (*str1++ = *str2++);
	return(str1-1);
}

strlen(str)
char *str;
{
	/* Return length of string, not counting null byte */
	static char *cp;

	for (cp = str; *cp; ++cp);
	return(cp-str);
}

upper(chr)
{
	/* return upper case of chr */
	if (chr >= 'a' && chr <= 'z') return(chr - ('a' - 'A'));
	return(chr);
}

lower(chr)
{
	/* return lower case of chr */
	if (chr >= 'A' && chr <= 'Z') return(chr + ('a' - 'A'));
	return(chr);
}

mvbytes(fromptr, toptr, cnt)
register char *fromptr, *toptr;
register cnt;
{
	/* copy "cnt" chars "fromptr" --> "toptr" */
	while (--cnt >= 0)
		*toptr++ = *fromptr++;
}
*:mN*:#[8;*:	 ??H;!  ":*:	 6S*:	 #6D*:	 ##6?! A;          *t;*r;*p