.TITLE "{ALLOY TAPE UTILITY}- REV-{4.x3}"
.SBTTL "ASSEMBLY CONTROL"
.I8080	; ALLOW ONLY 8080 OPERATORS
.PABS	; ABSOLUTE ASSEMBLY FORMAT
.XLINK	; SUPRESS LINKER DATA
.PHEX	; HEXIDECIMAL OBJECT GENERATION
.XSYM	; DELETE SYMBOL TABLE
.SALL	; INHIBIT MACRO EXPANSIONS
;
;
;
; COPYRIGHT 1979 BY:
;
; ALLOY ENGINEERING COMPANY, INC.
; COMPUTER PRODUCTS DIVISION
; 12 Mercer Road
; Natick, Ma. 01760
; (617) 655-3900
;
;
;        This DOCUMENT contains INFORMATION 
; which is PROPRIETARY to ALLOY ENGINEERING
; COMPANY, INC. REPRODUCTION or USE WITHOUT
; an EXPRESS WRITTEN CONSENT from the ALLOY
; ENGINEERING COMPANY IS PROHIBITED........
;
; DOCUMENT # {FW-100065:MM}
;
.PAGE
.SBTTL "REVISION HISTORY"
;  {REVISIONS:}
;
; REV----DATE----DETAILS
;
; P0   06/05/80  PRELIM ASMBL MODULE BASED ON
;		 FW-100031:20 REV.E3A
; P1   06/05/80  PRELIM TEST MODULE
; P2   06/05/80  RELOCATE FOR ATUD TESTING
; P3   06/30/80  FIX DATA SEARCH UNDER MASK
;                ROUTINE COMPARE TERMINATION
; 2.0  07/18/80  ALTER RECORD SEARCH UNDER MASK
;		 TO CONSIDER ONLY LS 7 BITS
;		 CHANGE PROGRAM LOCATION
; 2.1  08/05/80  ADD ECODE SUPPORT
; 2.11 08/15/80	 DONT SKIP UNLATCH IN WRDY
;		 ON WRITE REL TO BOT
; 2.12 08/20/80	 FIX WRDY PROBLEMS
; 3.0  08/22/80  MOVE TO STARTING LOC 1500H
;		 TO ACCOMODATE LARGER "TIP"
; 3.1  09/30/80  INIT FIX, ECODE ON EWS WRITE
;
; 3.2  12/24/80  ADD VARIABLE REC LENGTH & LOC
; 3.3  01/07/80  FIX TOO-LONG PROBLEM
; 4.x0 03/26/81  MAKE TIP 4.0 COMPATIBLE,
;		 FIX ERROR REPROTING FROM CWEN
;		 ADD 15 SEC. DEADMAN IN WDAD,
;		 RELOCATE CODE.
; 4.x1 06/15/81  CHANGE WDAD NOT TO ABORT ON
;		 DEAD-MAN TIMER IF FILE SEARCH
;		 MOVE DEAD-MAN COUNTERS TO AGREE
;		 WITH DOCUMENTATION.
; 4.x2 06/22/81	 WRITE 2" GAP AFTER FMK
;		 DON`T REWIND IF AT BOT
; 4.x3 12/18/81	 ALLOW REWIND AT BOT IF FLG
.PAGE
.SBTTL "MISC EQUATES AND MAPPING"
;---- UNIQUE INSTRUCTIONS ----
;
.DEFINE CLA=[.BYTE 0AFH]
	; CLEAR ACCUMULATOR (XRA A)
;
;
;---- ALLOY SPECIFIC EQUATES ----
;
ATU	=1800H	; ALLOY TAPE UTILITY
		; PROGRAM START ADDR.
;
P	=\"I/O PORT GROUP?"
		; (16 LONG)
;
R.MBA	=2900H	; MASK BUFFER AREA
R.MBL	=16	; MASK BUFFER LENGTH
;
R.DBA	=3000H	; DATA BUFFER AREA
R.DBL	=8208	; DATA BUFFER LENGTH
;
;
;
;
;---- PHYSICAL RECORD I.D.'S ----
;
FMKID	=55H	; FILE MARK I.D.
RID	=22H	; NORMAL RECORD I.D.
EORID	=01H	; NORMAL END OR RECORD I.D.
DSID	=08H	; DEI SYNC I.D.
PSID	=0FFH	; PCI SYNC I.D.
MSYN1	=0BCH	; SINGLE SYNC MODE FOR PCI
MSYN2	=03CH	; DOUBLE SYNC MODE FOR PCI
RCNT	=25	; RETRY COUNT + 1
RRCNT	=50	; READ RETRY COUNT
.PAGE
.SBTTL	"PROGRAM OPERATION"
.REMARK	"

	THIS PROGRAM CONFORMS TO THE SPECIFICATIONS
OF THE 'Alloy Tape Utilities'.  PLEASE REFER TO
THIS DOCUMENT FOR FURTHER INFORMATION" 
.PAGE
.SBTTL "{ERROR CODES}"
.REMARK " WHEN THE SUBROUTINES RETURN TO THE CALLER,
  THE (B) REGISTER CONTAINS INFORMATION RELATED TO
  THE SOURCE OF THE ERROR.  THIS ERROR CODE IS VALID
  ANY TIME THE SUBROUTINE RETURNS WITH THE (CY) SET."


;---- ERROR CODES FOLLOW: (B) ----
;
;**** CODES 0-3 WILL "ABORT WITHOUT MOTION" ****
;
E0	=0	; WARNING-- SELECTED DRIVE HAS
		; EXECUTED AUTO-REWIND SEQUENCE
		; SINCE PREVIOUS INIT OR REWIND
		; CMD. ISSUE REWIND TO CLEAR.
;
E1	=1	; WRITE OPERATION REQUEST TO A
		; WRITE-PROTECTED DRIVE.
;
E2	=2	; CMD. TO NON-PRESENT DRIVE OR
		; DRIVE WITH CARTRIDGE REMOVED.
;
E3	=3	; DRIVE FAILED TO RESPOND TO THE
		; REQUESTED COMMAND. I.E. BACK-
		; SPACE AT BOT ETC.
;
;**** CODES 6-13 WILL "ABORT WITH MOTION" ****
;
E6	=6	; FILE-MARK VERIFICATION FAILURE
		; AFTER WRITING IT.
;
E7	=7	; TRANSPORT ABORT PRIOR TO COMMAND
		; COMPLETION. I.E. SKIP RECORD ON
		; BLANK TAPE
;
E8	=8	; READ FAIL- MISSING DATA OR FMK.I.D.
;
E9	=9	; READ FAIL- BAD LRCC
;
E10	=10	; READ FAIL- SHORT RECORD ERROR
;
E11	=11	; READ FAIL- BAD VERTICAL PARITY
;
E12	=12	; WRITE FAIL- R-A-W VERIFY ERROR
;
E13	=13	; WRITE FAIL- READ DATA NOT
		; DETECTED PRIOR TO RECORD
		; WRITE OPERATION COMPLETE.
;
;**** CODE 14 WILL REPORT A FILE MARK ****
;
E14	=14	; READ FAIL- FILE MARK DETECTED
.PAGE
.SBTTL "{I/O ASSIGNMENTS}"
;NOTE:	SEE DEI MANUAL FOR BIT EXPLANATIONS.
;
IDEIS1	=P+0	; INPUT DEI STATUS-1
;	
;
;	B0-	SLD	; DRIVE IS SELECTED
;	B1-	BSY	; DRIVE BUSY
;	B2-	WND	; DRIVE WRITE LOGIC ON
;	B3-	FUP	; FILE IS PROTECTED (SAFE)
;	
;	B4-	FLG	; REWIND HAS OCURRED
;	B5-	EWS	; TAPE EARLY END WARNING
;	B6-	LPS	; TAPE IN LOAD-POINT AREA
;	B7-	RDY	; DRIVE 'ON WITH CART.'
;
	;
ODEIL1	=P+5	; OUTPUT DEI LATCH-1
;
;	NOTE: THE SENSE OF THESE BITS IS LOW=TRUE
;
;	B0-	REV*	; MOVE REVERSE
;	B1-	FWD*	; MOVE FORWARD
;	B2-	HSP*	; MOVE AT HIGH-SPEED
;	B3-	WEN*	; SET WRITE-ENABLE
;
;	B4-	PASS-THROUGH BIT* ; ALLOW FLG OP'S
;	B5-	RWD*	; REWIND THE DRIVE
;	B6-	NOT USED
;	B7-	SLG (HIGH TO SELECT DRIVE)
;
	;
IMSR	=P+1	; INPUT MISC. STATUS REG. 
;
;	B0-B3	NOT ASSIGNED
;
;	B4-	PASS-THROUGH BIT
;	B5-	DATA DETECTED
;	B6-	PCI1-TXRDY
;	B7-	PCI1-RXRDY
;
	;
ODEIL2	=P+4	; OUTPUT DEI LATCH-2
;
;	NOTE: THE SENSE OF THESE BITS IS LOW=TRUE
;
;	B0-	LED1* (ON LINE)
;	B1-	LED2* (FAULT)
;	B2-	RESERVED
;	B3-	SL1*
;
;	B4-	SL2*
;	B5-	TR1*
;	B6-	TR2*
;	B7-	SL4*
.PAGE
;NOTE:	SEE SIGNETICS SPECIFICATION (2651) FOR
;	BIT ASSIGNMENTS ETC.
	;
	;
OPCIDR	=P+12	; OUTPUT PCI DATA REGISTER
;
OPCISR	=P+13	; OUTPUT PCI SYNC REGISTER
;
OPCIMR	=P+14	; OUTPUT PCI MODE REGISTERS
;
OPCICR	=P+15	; OUTPUT PCI COMMAND REGISTER
	;
	;
IPCIDR	=P+8	; READ PCI DATA REGISTER
;
IPCISR	=P+9	; READ PCI STATUS REGISTER
;
IPCIMR	=P+10	; READ PCI MODE REGISTERS
;
IPCICR	=P+11	; READ PCI COMMAND REGISTER
.PAGE
.SBTTL "{ATU PROGRAM ENTRY}"
;
;**************************************************
	.LOC	ATU
;
; NOTE: SET-UP MA/PA/CA PRIOR TO CALL
;	ALL PRIMARY REGISTERS SAVED U USED
;       BUT RESTORED ON RETURN
;
ATUS:	PUSH	PSW	; SAVE CALLING REG'S
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	H,0	; SAVE CURRENT STACK LOC
	DAD	SP	;  IN CASE OF TROUBLE
	SHLD	SSAVE
;
	LDA	CA	; GET THE REQUESTED CMD.
	STA	CSR	; SAVE FOR COORDINATION
	ANI	17H	; STRIP TO ACTUAL CMD
	CPI	2	; WRITE COMMAND?
	JZ	WDLRC	; IF SO, GO CALCULATE LRC
	ANI	10H	; CHECK IF "RESET COMMAND"
	JZ	SAP	; NO INIT IF ZERO
	CALL	INIT	; GO DO TAPE INIT THINGS
	JMP	RTRAN	; EXIT TO CALLER
.PAGE
;---- HERE WE CHECK IF RE-TRANSMIT COMMAND ----
;
SAP:	LDA	CA	; GET THE COMMAND
	ANI	7FH	; CHECK IF RE-TRANSMIT
	JZ	RTRAN	; IF SO, JUST DO IT
;
;---- HERE WE PRE-PROCESS MA ----
;
	LDA	MA	; GET CALLING MODE ARGUMENT
	ANI	8FH	; REMOVE TRANSIENT BITS
	ORI	80H	; SET DRS-232 COMPATIBLE BIT
	STA	IS	; SAVE INITIALIZED ISW
	MVI	A,80H	; GET NAKED DRIVE STATUS
	STA	DS	; SAVE INITIALIZED DSW
;
;---- HERE WE SELECT THE DRIVE & TRACK ----
;
	LDA	MA	; SET DRIVE & TRACK
	MOV	B,A
	CALL	SDAT	
;
;---- HERE WE PRE-PROCESS CA ----
;
	LDA	CA	; GET THE COMMAND
	MOV	B,A	; SAVE FOR LATER
;
;---- HERE WE INIT THE RETRY COUNT ----
;
	ANI	20H	; CHECK AUTO-REWRITE BIT
	MVI	A,RCNT	; IF FALSE, DONT'T DISABLE 
	JZ	..B
	SUI	RCNT-1	; SET RETRY TO 1
..B:	STA	RETRY
.PAGE
;---- HERE WE DECODE THE SPECIFIED COMMAND ----
;
	MOV	A,B	; GET COMMAND
	ANI	40H	; RELATIVE TO BOT?
	JZ	..C	; IF NOT, NO REWIND
	CALL	REWIND	; IF SO, REWIND
	JC	ABORT	; CHECK ABORT CAUSE & REPORT
..C:	LDA	CA	; GET COMMAND BACK
	MOV	B,A	; STORE FOR LATER
	ANI	80H	; CHECK RESERVED COMMAND
	JNZ	RDIAG	; GO DO RAM DIAGNOSTIC READ
	MOV	A,B	; GET CA BACK
	ANI	0FH	; MASK DOWN TO COMMAND
	JZ	NOC	; IF ZERO, GO SET THAT FLAG
	CPI	8	; CHECK EXTENDED COMMAND BIT
	JNC	EXT	; IF SET, GO EXTEND
	DCR	A	; READ?
	JZ	RR  	; IF SO, GO READ
	DCR	A	; WRITE?
	JZ	WR	; IF SO, GO DO THAT
	DCR	A	; WRITE FILE MARK?
	JZ	WFMR	; IF SO, GO DO THAT
;
;-- HERE IS LOW SPEED COMMAND 4-7 DISPATCH ----
;
JTRLS:	MVI	D,0FFH	; SET FOR LOW SPEED
;
;---- HERE WE DISPATCH ON CMD 4-7 ----
;
JTR:	LXI	H,SRET	; GET RETURN ADDR FOR SUBS
	PUSH	H	; SAVE AS RETURN PC
	LDA	PA	; GET POSITIONAL ARGUMENT
	MOV	C,A	; PUT IN C IN CASE IT'S USED
	MOV	A,B	; GET THE COMMAND BYTE
	ANI	7	; MASK TO COMMAND PROPER
	CPI	6	; CHECK IF FORWARD OR REVERSE
	MOV	A,D	; GET SPEED CALLING ARGUMENT
	JC	SRF	; DO FORWARD ON 4 OR 5
	JMP	SRR	; DO REVERSE ON 6 OR 7
;
;---- HERE WE RETURN FROM CMD 3-7 ----
;
SRET:	JC	ABORT	; GO SORT OUT REASON ABORTED
;
;---- FALL INTO TRANSMIT ROUTINE ----
.PAGE
.SBTTL "{TRANSMIT} DATA CIRCUIT"
;---- HERE WE DEVELOP THE DS WORD ----
;
CPRA:	LDA	DS	; GET THE DS WORD
	MOV	B,A	; SAVE FOR LATER USE
	IN	IDEIS1
	RRC
	RRC
	RRC
	ANI	1FH	; ISOLATE DEI USABLE BITS
	ORA	B
	STA	DS	; SAVE DRIVE STATUS
	STA	ODS	; SAVE AS OLD DRIVE STATUS
;
;---- WE ENTER HERE TO EXIT TO MAIN CALLER ----
;
RTRAN:	LDA	CSR	; GET SAVE CA VALUE
	STA	CA	; RESTORE CALLERS'
	LHLD	SSAVE	; RESTORE STACK -IN CASE
	SPHL
	POP	H	; AND ALL REG'S
	POP	D
	POP	B
	POP	PSW
	RET		; RETURN TO MAIN PROGRAM
.PAGE
.SBTTL "{COPY} SUBROUTINE"
;----	CALL	
;	RET	CY=1 IF ABORTED
;
;----	DYNAMICALY D= DRIVE 1 SELECTOR
;		   E= DRIVE 2 SELECTOR
;
COPYS:	LXI	D,0004H	; DR1/2 TK 0 INITIAL VALUE
	CLA		; CLEAR FMK/ DONE FLAG
	STA	FMFLG
;
;---- HERE WE REWIND BOTH DRIVES ----
;
..A:	MOV	B,D	; SELECT DRIVE 1
	CALL	SDAT
	CALL	REWIND
	LDA	ODS	; GET OLD DRIVE STATUS
	RLC		; CHECK RDY
	JNC	..A1	; IF NOT, VERIFY MODE
	MOV	B,E	; SELECT DRIVE 2
	CALL	SDAT
	CALL	REWIND
;
;---- HERE WE CLEAR FLG CONDITION ON DRIVE 2 ----
;
	CALL	WRDY	; WAIT FOR DRIVE READY
	MVI	A,0FDH	; GET DRIVE FOWARD
	OUT 	ODEIL1	
..A1:	MVI	A,0EFH	; IDLE & PTB FOR DRIVE 1
	OUT	ODEIL1
;
;---- CHECK IF ALL DONE ----
;
	LDA	FMFLG	; GET FILE MARK FLAG
	ANI	4	; CHECK ALL DONE FLAG
	RNZ		; RETURN, JOB IS COMPLETE
	STA	FMFLG	; IF NOT, CLEAR FMK FLAG
;
;---- HERE TO READ SOURCE RECORD  ----
;
..B:	PUSH	D	; SAVE DE PAIR
	MOV	B,D	; SELECT SOURCE DRIVE
	CALL	SDAT
	MVI	A,RRCNT	; GET RETRY CONSTANT
	CALL	RRS	; DO READ/RETRY
	POP	D	; GET SELECTOR BACK
	PUSH	D	; BUT KEEP IT SAFE
	JNC	..E	; GO CONTINUE ON NO ERROR
	MOV	A,B	; GET ERROR CODE
	CPI	14	; WAS IT A FILE MARK
	JZ	..C	; IF FILE MARK, WRITE SAME
	POP	D	; GET SELECTOR BACK
	STC		; SET CARRY FOR ERROR RET
	RET		; ABORT IF NOT FMK
.PAGE
;---- HERE TO WRITE A RECORD ON DESTINATION ----
;
..E:	CLA		; CLEAR FILE MARK FLAG
	STA	FMFLG
	LDA	ODS	; IF VERIFY MODE TO ..E1
	RLC
	JNC	..E1
	MOV	B,E	; SELECT DESTINATION DRIVE
	CALL	SDAT	; GO SELECT
	MVI	A,RCNT	; GET RETRY CONSTANT
	CALL	WRS	; GO WRITE/RETRY
..E1:	POP	D	; GET SELECTOR BACK
	RC		; ABORT IF CY=1
	JMP	..B	; LOOP TO GET NEXT RECORD
;
;---- HERE TO WRITE A FILE MARK ----
;
..C:	LDA	ODS	; IF VERIFY MODE TO ..C1
	RLC
	JNC	..C1
	MOV	B,E	; GET DESTINATION DRIVE
	CALL	SDAT	; SELECT IT
	MVI	A,RCNT	; GET RETRY COUNT
	CALL	WFMRS	; GO WRITE FMK/RETRY
..C1:	POP	D	; GET SELECTORS BACK
	RC		; ABORT IF CY=1
;
;---- CHECK IF 1ST OR 2ND FILE MARK ----
;
	LDA	FMFLG	; FMK ALREADY SET
	ORA	A	; SET PSW FOR LDA
	JNZ	..D	; IF SO, BUMP TRACK
	ORI	1	; IF NOT, SET IT
	STA	FMFLG
	JMP	..B	; GO GET ANOTHER RECORD
;
;---- HERE SECOND FMK IN SUCCESSION ----
;
..D:	INR	D	; BUMP SOURCE TRK.
	INR	E	; BUMP DEST.  TRK.
	MOV	A,D	; GET DEST. TK
	CPI	4	; CHECK IF LAST + 1
	JNZ	..A	; IF NOT, GO DO THIS TRACK
	STA	FMFLG	; IF SO, SAVE IT
	DCR	D	; DEC. TO PREV. TRK
	DCR	E
	JMP	..A	; GO REWIND & EXIT
.PAGE
.SBTTL "{EXTENDED} COMMAND ROUTINES"
;---- EXTENDED COMMAND HANDLER ----
;
EXT:	ANI	7	; MASK TO COMMAND PROPER
	JZ	WRRS	; WAIT READY & SEND DS/IS
			;   ON ZERO COMMAND
	CPI	4	; SEE IF HSPD SEARCH
	JC	..A	; IF NOT, GO SEE WHAT
	LDA	PA	; GET THE POSITIONAL ARG.
	ORA	A	; SET THE PSW BITS
	JZ	JTRLS	; GO SET LOW SPEED ON
			;  SINGLE SEARCH
..B:	MVI	D,0FBH	; SET HSP* TRUE
	JMP	JTR	; AND GO CALL THE ROUTINES
;
;---- CHECK IF COPY/MASK OR WRITE-RANGE ----
;
..A:	DCR	A	; CHECK IF COPY COMMAND
	JNZ	..C	; IF NOT, TRY NEXT
;
	CALL	COPYS	; CALL THE COPY SUBROUTINE
	JC	AWA	; IF BAD, SIGNAL ABORT/ATTMT
	MVI	A,80H	; INITIALIZE ISW & DSW
	STA	DS
	STA	IS
	JMP	CPRA	; AND GO RETURN
;
..C:	DCR	A	; CHECK IF WRITE-RANGE
	JZ	SRE	; IF SO, IT IS IN ERROR
; FALL INTO MASK SEARCH ROUTINE
.PAGE
.SBTTL "{MASK} ROUTINES"
;---- MASK DATA SEARCH ROUTINE ----
;
MDS:	MVI	A,RCNT	; GET RETRY CONSTANT
	CALL	RRS	; GO READ A RECORD
	JC	ABORT	; IF ERROR, ABORT/ATTMT
	LXI	H,R.DBA	; SET PTR TO RECORD
	LXI	D,R.MBA	; AND ONE TO MASK
..A:	LDAX	D	; GET MASK CHAR
	MOV	B,A	; SAVE THIS
	CPI	"?"	; IS IT A "?"?
	JZ	..B	; IF SO, IT MATCHES
	MOV	A,M	; GET CHARACTER FROM REC
	ANI	07FH	; CONSIDER ON LS 7 BITS
	CMP	B	; COMPARE WITH MASK CHAR
	JNZ	MDS	; GET NEXT REC. ON NO MATCH
..B:	INX	D	; INC TO NEXT BYTE
	INX	H
	LXI	B,R.MBA+R.MBL ; FETCH END MARKER
	MOV	A,C	; GET LS BYTE
	CMP	E	; COMPARE TO DYNAMIC
	JNZ	..A	; LOOP IF NOT EQUAL
	MOV	A,B	; GET MS BYTE
	CMP	D	; COMPARE TO DYNAMIC
	JNZ	..A	; LOOP TILL EQUAL
	JMP	CPRA	; GO SEND ON MATCHING REC.
.PAGE
.SBTTL "MISC. {STANDARD} COMMAND ROUTINES"
;---- HERE WE DETERMINE LRC FOR RECORD ----
;
WDLRC:	LHLD	WRDCNT	; GET DATA BUFFER LENGTH
	XCHG
	LHLD	R.AREA	; AND BUFFER LOCATION
	MVI	B,0	; INITIALIZE LRC VALUE
..A:	MOV	A,M	; GET THE DATA   
	XRA	B	; UPDATE LRC
	MOV	B,A	; RESTORE IT
	INX	H	; INC THE POINTER
	DCX	D	; DECRAMENT COUNTER
	MOV	A,D	; SEE IF DONE READING
	ORA	E
	JNZ	..A	; IF NOT, LOOP A WHILE
	MOV	A,B	; GET ACCUMULATED LRC
	STA	LRC	; SAVE FOR WRITE USE
	JMP	SAP	; GO SEND & PROCESS
;
;---- NOP ROUTINE ----
;
NOC:	LDA	DS	; GET DRIVE STATUS
	ORI	20H	; SET REWIND FLAG
	STA	DS
	JMP	CPRA	; AND EXIT
;
;---- HERE IS RECORD/WRITE CALLER ----
;
WR:	IN	IDEIS1	; GET DRIVE STATUS
	ANI	20H	; CHECK IF EOT/EARLY WARNING
	JNZ	AWOA	; ABORT W/O ATTEMPT IF TRUE
	LDA	RETRY	; GET SPECIFIED RETRY COUNT
	CALL	WRS	; CALL WRITE/RETRY
	JC	ABORT	; ABORT IF ERROR
	JMP	CPRA	; SEND & PROCESS
;
;---- HERE IS RECORD/READ CALLER ----
;
RR:	MVI	A,RRCNT	; GET RETRY CONSTANT
	CALL	RRS	; CALL READ/RETRY
	JC	ABORT	; ABORT IF ERROR
	JMP	CPRA	; SEND IF DATA
;
;---- HERE IS THE WRITE FILE MARK CALLER ----
;
WFMR:	MVI	A,1	; ONLY 1 RETRY ON FMK'S
	CALL	WFMRS	; CALL WFMK/RETRY SUB.
	JC	ABORT	; LET ABORT HANDLE ERRORS
	JMP	CPRA	; GO SEND & PROCESS
.PAGE
.SBTTL "{WRITE & WFM/RETRY} SUBROUTINES"
;---- HERE IS THE WRITE/RETRY SUBROUTINE ----
;
;---- 	CALL	A= RETRY COUNT
;	RET	CY=1 IF ABORT B= ABORT CODE
;
;
WRS:	STA	DRETRY	; MOVE TO DYNAMIC COUNTER
..A:	CALL	WRITE	; TRY TO WRITE PROPER
	RNC		; RETURN IF NO ERROR
	LDA	DRETRY	; GET DYNAMIC RETRY COUNTER
	DCR	A	; DEC RETRY
	RZ		; ABORT. CY=1
	STA	DRETRY	; RESTORE UPDATED RETRY COUNT
	CALL	CLRTP	; ELSE CLEAR TAPE
	IN	IDEIS1	; GET DEI STATUS
	ANI	20H	; CHECK EWS STATUS
	STC		; SET ABORT JUST IN CASE
	MVI	B,1	;   WITHOUT ATTEMPT SIGNAL
	RNZ		; ABORT IF EWS PRESENT
	JMP	..A	; IF NOT, TRY AGAIN
;
;
;---- HERE IS THE WFM/RETRY SUBROUTINE ----
;
;---- 	CALL	A= RETRY COUNT
;	RET	CY=1 IF ABORT B= ABORT CODE
;		FMK STATUS SET IN DSW IF OK.
;
;
WFMRS:	STA	DRETRY	; MOVE TO DYNAMIC COUNTER
..A:	CALL	WFM	; TRY TO WRITE FMK PROPER
	RNC		; RETURN ON NO ERRROR
	LDA	DRETRY	; GET DYNAMIC RETRY COUNTER
	DCR	A	; DEC RETRY
	RZ		; ABORT. CY=1
	STA	DRETRY	; RESTORE UPDATED RETRY COUNT
	CALL	CLRTP	; ELSE CLEAR TAPE
	JMP	..A	; AND TRY AGAIN
.PAGE
.SBTTL "{READ/RETRY} SUBROUTINE"
;----	CALL	A= RETRY COUNT
;	RET	CY=1 IF ABORT EXCEPT FMK. B=CODE
;		NON-ZERO IF FMK
;		DSW/ISW SET FOR DATA BLOCK/FMK ETC.
;	
RRS:	STA	DRETRY	; SET IN DYNAMIC COUNTER
R.A:	CALL	READ	; DO ACTUAL READ
	JC	..B	; IF ERROR, HANDLE IT
	LDA	IS	; GET INTERFACE STATUS
	ORI	40H	; SET DATA BLOCK FOLLOWS
	STA	IS
	CLA		; NO FMK, SO CLEAR ZERO
	RET		; RETURN
;
..B:	MOV	A,B	; GET THE ERROR CODE
	CPI	14	; WAS IT FMK DETECTED?
	STC		; SET CARRY FOR RETURN
	RZ		; IF SO, RETURN WITH IT
;
;---- HERE ERROR, SO CLEAR TAPE AND TRY AGAIN ----
;
R.C:	STC		; SET CY FOR ABORT
	LDA	DRETRY	; GET DYNAMIC RETRY COUNTER
	DCR	A	; DEC RETRY COUNTER
	RZ		; ABORT. CY=1
	STA	DRETRY	; RE-STORE COUNTER
	MVI	A,6	; AND BACKSPACE
	STA	CA
	MVI	C,0	; ONCE
	MVI	A,0FFH	; AT LOW SPEED
	CALL 	SRR
	JMP	R.A	; AND TRY AGAIN
;
;---- HERE FOR RAM DIAGNOSTIC READ ----
;
RDIAG:	LDA	IS	; SET DATA FOLLOWS IS ISW
	ORI	40H	
	STA	IS
	JMP	CPRA	; GO SEND THE DATA W/O READ
.PAGE
.SBTTL "{ABORT} ROUTINES"
;---- HERE ON SYNTAX/PARITY ERRORS ----
;
SRE:	LDA	IS	; GET THE ISW
	ORI	30H	; SET SYNTAX/PE BITS
	STA	IS	; SAVE FOR SEND ROUTINE
	CALL	S.L	; SET ERROR LED
TSTAT:	CLA		; CLEAR THE CA TO FAKE
	STA	CA	;   A RE-TRANSMIT
	JMP	SAP	; GO SEND & PROCESS
;
;---- HERE ABORT WITHOUT ANY ATTEMPT ----
;
AWOA:	MVI	B,10H	; SET ABORT WITHOUT ATTEMPT
	JMP	SFL	; GO SET FAULT LED
;
;---- HERE TO DETERMINE IF ATEMPT WAS MADE ----
;---- B REG. = TAPE MODULE ABORT CODE
;
ABORT:	MOV	A,B	; GET THE ABORT CODE
	STA	ECODE	; SAVE IT
	CPI	4	; CHECK IF MOTION
	JC	AWOA	; IF <4 THEN NO MOTION
			; IF >4 FALL TO AWA
;
;---- HERE ABORT WITH CONCEIVABLE ATTEMPT ----
;
AWA:	MVI	A,0FFH	; STOP TAPE MOTION
	OUT	ODEIL1
	MVI	B,20H	; SET ABORT WITH ATTEMPT
;
SFL:	LDA	IS	; GET INTERFACE STATUS
	ANI	0BFH	; CLEAR POSSIBLE BLOCK/FOL.
	ORA	B	; SET ERROR CODE
	STA	IS
	LDA	DS	; GET THE DRIVE STATUS
	ANI	40H	; CHECK IF FMK DET.
	JNZ	CPRA	; IF SO, NO FAULT LED
	CALL	S.L
	JMP	CPRA	; GO EXIT
;
;---- SET FAULT LED ----
;
S.L:	LDA	DTLS	; GET DRIVE SELECT WORD
	ANI	0FDH	; SET ERROR LED
	OUT 	ODEIL2	; AND SEND THIS
	RET		; BACK TO CALLER
.PAGE
.SBTTL "{INIT & REWIND}-PROGRAMS"
;---- HERE WE INIT THE PCI ----
;
INIT:	IN	IPCICR	; READ IT TO CLEAR TO MR(1)
	MVI	A,MSYN1	; SET MODE TO SINGLE SYNC
	OUT	OPCIMR	; SET IT
	XRA	A	; GET A CLEAR
	OUT	OPCIMR	; CLEAR MR2
	IN	IPCICR	; READ CR TO CLEAR TO SR(1)
	MVI	A,PSID	; DITTO ABOVE
	OUT	OPCISR	; SET SYN1 TO A 01
	MVI	A,RID	; SET SYN2 TO REC. ID FOR RAW
	OUT	OPCISR	; SET IT
	MVI	A,10H	; RESET ERRORS
	OUT	OPCICR	; SET IN CMD. REG.
;
;---- HERE WE INIT THE D.E.I. ----
;
	MVI	A,0FEH	; REV. TO CLEAR ERA F/F
	OUT	ODEIL1
	MVI	A,0EFH	; IDLE WITH PTB*
	OUT	ODEIL1
	CALL	DLY.5	; ALLOW ERASE HEAD TO SETTLE
	MVI	A,11010111B	; TK1, DRIVE 1,NO LEDS
	STA	DTLS	; SAVE CODE
	OUT	ODEIL2
;
;---- SET DEFAULT RECORD BUFFER LENGTH AND START ----
;
	LXI	H,R.DBL	; GET DEFAULT LENGTH
	SHLD	WRDCNT	; SAVE AS ACTIVE
	LXI	H,R.DBA	; GET DEFAULT START
	SHLD	R.AREA	; SAVE AS ACTIVE
;
;---- NORMAL -OK RETURN FOLLOWS ----
;
EOK:	CLA		; CLEAR (A) & CY
	RET		; RETURN TO CALLER -OK
;
;
;---- HERE TASK IS REWIND CMD. ----
;
REWIND:	IN	IDEIS1	; CHECK THE STATUS
	ANI	50H	; AT BOT WITH NO FLG?
	XRI	40H
	JZ	..A	; IF SO, GO RETURN
	MVI	A,0EFH	; IDLE + PTB*
	OUT	ODEIL1
	CALL	DLY2	; ALLOW SETTLEING
	CALL	WRDY	; CHECK READY STATUS
	MVI	A,0DFH	; RWD*
	CALL	DCAC
	MVI	A,0EFH	; DRIVE IDLE + PTB*
	OUT	ODEIL1	; SEND TO DRIVE
..A:	CLA		; EXIT OK
	RET
.PAGE
.SBTTL "{SDAT & CLEAR TAPE}"
;---- SELECT DRIVE AND TRACK ----
;
SDAT:	IN	IDEIS1	; GET DRIVE STATUS
	ANI	81H	; CHECK RDY & SLD
	CPI	81H	; VERIFY BOTH TRUE
	JNZ	..A	; IF NOT, ALLOW IMMEDIATE
			; RE-SELECT TO OCCUR
	IN	IMSR	; READ MISC. STATUS
	ANI	10H	; CHECK PTB
	JNZ	..A	; IF SO, IMMED. RE-SELECT
	CALL	WRDY	; GO WAIT FOR READY
..A:	MOV	A,B	; GET THE BYTE
	INR	A	; ADJUST TO DEI TRACK CODE
	ANI	3
	RRC
	RRC
	RRC
	MOV	C,A	; STORE FOR LATER
	MOV	A,B	; GET MA BACK
	ADI	4H	; ADJUST DRIVE FOR DEI
	RLC
	ANI	18H
	JNZ	..C
	ORI	80H
..C:	ORA	C	; COMBINE WITH TRACK CODE
	XRI	0FFH	; COMPLEMENT
	ORI	7	; PRESERVE LEDS
	MOV	C,A	; STORE IT AGAIN
	LDA	DTLS	; GET OLD DRIVE/TRACK/LED
	ORI	0F8H	; SAVE ONLY LED CODES
	ANA	C	; SET TO NEW DRIVE/TRACK
	STA	DTLS	; STORE AGAIN
	OUT 	ODEIL2	; AND TELL IT TO THE TAPE
	XRA	A	; EXIT OK
	RET
;
;---- CLEAR TAPE GAP PROGRAM ----
;
CLRTP:	MVI	C,0	; SET COUNTER FOR 1 REC
	MOV	A,C	; AND CA FOR RECS.
	STA	CA
	MVI	A,0FFH	; LOW SPEED PLEASE
	CALL	SRR	; DO NORMAL REVERSE SPACE
	JMP	ERASE	; GO DO ERASE AT CMD. LEVEL
.PAGE
.SBTTL "{WRITE}-RECORD ROUTINE"
WRITE:	CALL	WRDY	; CHECK READY STATUS
	CALL	CWEN	; CHECK WRITE ENABLED
	LDA	LRC	; GET PRE-DETERMINED LRC
	MOV	C,A	; SAVE IN C FOR LATER
;
;---- HERE WE SET TO 2-SYN MODE TO RAW TEST ----
;
	IN	IPCICR	; READ CR TO CLR TO MR1
	MVI	A,MSYN2	; DOUBLE SYNC MODE
	OUT	OPCIMR	; SET MODE REG.
;
;---- HERE PREAMBLE IS WRITTEN ----
;
..A:	CALL	WS1	; WRITE SEQUENCE 1
	MVI	A,0F5H	; WEN* + FWD*
	CALL	DCAC	; ISSUE CMD. AND CHECK
	CALL	WS2	; WRITE SEQUENCE 2
	CALL	WPRE	; WRITE PREAMBLE
	MVI	A,RID	; GET NORMAL RECORD I.D.
	OUT	OPCIDR	; WRITE IT
	LHLD	WRDCNT	; GET THE DATA BUFFER LENGTH
	XCHG
	LHLD	R.AREA	; DITTO STARTING ADDR.
;
;---- WRITE RECORD BODY CIRCUIT W/O DAD ----
;
WCK:	IN	IMSR	; GET TXRDY
	ADD	A
	ADD	A	; TXRDY=CY, DAD=MINUS
	JM	WCKE	; IF DAD, GO TO NEXT LOOP
	JNC	WCK	; LOOP FOR XMT ALLOW
;
	MOV	A,M	; GET BYTE FROM MEMORY
	OUT	OPCIDR	; SEND IT
	DCX	D	; DEC. THE BYTE COUNTER
	INR	L	; INC LS POS. INDEX
	JNZ	WCK	; LOOP TILL COUNTER IS ZERO
	JMP	W.D	; IF NOT, ERROR OUT
;
;---- WRITE RECORD BODY CIRCUIT WITH DAD ----
;
WCKE:	IN	IPCISR	; READ TO CLEAR TXDSG
WCK1:	IN	IMSR	; GET TXRDY
	ADD	A	; MOVE IT TO SIGN BIT
	JP	WCK1	; LOOP FOR XMT ALLOW
;
	MOV	A,M	; GET BYTE FROM MEMORY
	OUT	OPCIDR	; SEND IT
	INX	H	; INDEX NEXT BYTE OF DATA
	DCX	D	; DEC. THE BYTE COUNTER
	MOV	A,D	; CHECK FOR ZERO COUNTER
	ORA	E
	JNZ	WCK1	; LOOP TILL COUNTER IS ZERO
.PAGE
;---- WRITE THE LRC / EOR / POSTAMBLE ----
;
..A:	IN	IMSR	; GET TXRDY
	ADD	A
	JP	..A	; LOOP TILL READY FOR LRCC
	MOV	A,C	; GET LRCC
	CALL	WBYT	; GO SEND IT
	LXI	H,AMBLE	; GO SEND POSTAMBLE
	MVI	B,8
	CALL	WS
;
;---- HERE WE VALIDATE LRC & EOR ----
;
.REMARK "WE NOW REGAIN SYNC WITH THE WRITE OP.
	IN PROGRESS. THE RECEIVER HAS BEEN IN
	OPERATION DURING THE ENTIRE WRITE AND
	HAS RETAINED ANY PARITY ERROR HISTORY."
;
W.CS:	MVI	A,4	; RXEN ONLY
	OUT	OPCICR	; STOP TRANSMITTING
;
W.C:	CALL	RBYT	; GO READ A CHAR.
..E:	XRA	C	; IS THIS THE LRC?
	JNZ	W.C	; IF NOT, LOOP
	CALL	RBYT	; READ ANOTHER CHAR.
..F:	CPI	RID	; IS IT THE RECORD I.D.
	JNZ	..E	; IF NOT, FORGET LRC
	CALL	RBYT	; READ ANOTHER
	CPI	EORID	; IS IT THE EOR I.D.
	JNZ	..F	; IF NOT, TRY REC. ID.
;
;---- HERE WE VALIDATE VPE ----
;
	IN	IPCISR	; GET THE PCI STATUS
	ANI	0CH	; CHECK PARITY ERROR/TXDSG
	JNZ	W.D	; IF ERROR, EXIT
	CALL	DLY2
	MVI	A,0F7H	; WEN* ONLY
	OUT	ODEIL1	; STOP THE DRIVE
	RET		; RETURN SUCCESSFUL
;
;---- HERE IS THE WRITE ERROR EXIT ----
;
W.D:	MVI	A,10H	; RESET PCI
	OUT	OPCICR
	MVI	B,E13	; SIGNAL RCVR. FAILURE
;
WEE:	MVI	A,0F7H	; WEN* ONLY
	OUT	ODEIL1	; STOP THE DRIVE
	STC
	RET
.PAGE
.SBTTL "WRITE SUBROUTINES"
;---- WRITE SEQUENCE -1 ----
;
WS1:	MVI	A,0F7H	; WEN* - ERASE POWER
	OUT	ODEIL1
	MVI	A,10H	; RESET PCI ERRORS
	OUT	OPCICR
	CALL	DLY2
	RET		; RETURN TO CALLER
;
;---- WRITE SEQUENCE 2 ----
;
WS2:	IN	IDEIS1	; GET DEI STATUS
	ANI	40H	; CHECK LPS
	JNZ	WS2	; SKIP OVER LOAD POINT
	MVI	B,66	; INIT 33 MS. CONSTANT
..A:	CALL	DLY.5	; 33 MILLISECOND DELAY
	DCR	B
	JNZ	..A
	RET
;
;---- WRITE PREAMBLE ----
;
WPRE:	CLA		; LOAD FIRST PCI DATA
	OUT	OPCIDR
	MVI	A,37H	; TXEN+RXEN+RE+DTR
	OUT	OPCICR
	MVI	B,7	; SET BYTE COUNTER
	LXI	H,AMBLE+3 ; AND POINTER
;
;---- SUB. TO SEND PRE/POST AMBLES ----
;
WS:	MOV	A,M	; GET A BYTE
	CALL	WBYT	; GO SEND IT
	INX	H	; INC BYTE POINTER
	DCR	B	; DEC BYTE COUNTER
	RZ		; RETURN IF ALL SENT
	JMP	WS	; ELSE LOOP SOME MORE
;
AMBLE:	.BYTE	RID,EORID,0,0,0,0,0,0,DSID,PSID
;
;---- WRITE A BYTE OF DATA ----
;
WBYT:	OUT	OPCIDR	; SEND BYTE TO DRIVE
..A:	IN	IMSR	; GET MISC. STATUS
	ADD	A
	RM		; RETURN WHEN READY FOR NEXT
	JMP	..A
.PAGE
.SBTTL "{READ}-RECORD ROUTINES"
READ:	LHLD	WRDCNT	; GET THE DBUFFER LENGTH
	XCHG
	LHLD	R.AREA	; DITTO STARTING ADDR.
	CALL	WRDY	; WAIT FOR DRIVE READY
	MVI	A,0FDH	; FWD*
	CALL	DCAC	; ISSUE CMD. & CHECK TAKEN
	MVI	C,0	; INIT LRC
;
;---- WAIT 24 MS. BEFORE ALLOWING READ ----
;
	MVI	B,12	; CONSTANT FOR 24 MS.
..G:	CALL	DLY2
	DCR	B
	JNZ	..G	; LOOP FOR 12 COUNT
;
;---- HERE WE INIT. THE PCI TO READ ----
;
	MVI	A,10H	; RESET ERRORS
	OUT	OPCICR
	MVI	A,4	; RXEN
	OUT	OPCICR
	MVI	B,0	; RETURN ON DAD
	CALL	WDAD	; WAIT FOR DATA DETECT
	CALL	RBYT	; GO GET FIRST BYTE
	CPI	RID	; CHECK IF DATA RECORD
	JZ	S.C	; IF -OK, CONTINUE
	CPI	FMKID	; CHECK IF FILE-MK ID.
	CNZ	RBE	; IF NOT, USE E8 EXIT
	CALL	RBYT	; GET NEXT BYTE
	CPI	EORID	; IS IT EXPECTED
	CNZ	RBE	; IF NOT SIGNAL ERROR
	CALL	RSTP	; STOP THE DRIVE
FME:	MVI	B,E14	; SIGNAL FILE MARK
	LDA	DS	; GET DRIVE STATUS
	ORI	40H	; SIGNAL FILE MARK
	STA	DS
	STC
	RET
;
S.C:	IN	IMSR	; CHECK RXRDY
	ADD	A
	JNC	..D	; LOOP TILL READY
	IN	IPCIDR	; READ THE PCI DATA
	MOV	M,A	; PUT IN RAM
	XRA	C	; UPDATE LRC
	MOV	C,A	; RESTORE LRC
	INX	H	; INC. MEMORY POINTER
	DCX	D	; DECR. THE WORD COUNT
	MOV	A,D	; CHECK FOR ZERO CONDITION
	ORA	E
	JNZ	S.C	; LOOP TILL IT HAPPENS
.PAGE
;---- HERE BODY OF RECORD IS READ ----
;
	CALL	RBYT	; GO READ LRCC
	CMP	C	; CHECK AGAINST EXPECTED VALUE
	JZ	..A	; IF OK, CONTINUE
	CALL	RSTP	; STOP THE DRIVE
	MVI	B,E9	; SIGNAL LRC ERROR
	STC
	RET
;
;---- HERE RECORD OK ON SIZE & LRC ----
;
..A:	MOV	A,C	; GET CALCULATED LRC
	STA	LRC	; SAVE IN CASE OF COPY
	IN	IPCISR	; READ THE PCI STATUS REG.
	ANI	18H	; CHECK VPE & OVER-RUN
	JZ	..B	; IF OK, CONTINUE
	CALL	RSTP	; STOP THE DRIVE
	MVI	B,E11	; SIGNAL VPE ERROR
	STC
	RET
.PAGE
;---- HERE WE HAVE A "WINNER" ----
;
..B:	CALL	RSTP	; STOP THE DRIVE
	IN	IDEIS1	; GET DRIVE STATUS
	ANI	20H	; CHECK EWS END OF TAPE
	RZ		; EXIT OK
	ORI	80H	; SET MINUS FLAG ON EWS
	RET		; RETURN TO CALLER

;
..D:	ADD	A	; CHECK DAD STILL TRUE
	JM	S.C	; IF SO, LOOP
	CALL	RSTP	; STOP THE DRIVE
	MVI	B,E10	; SIGNAL SHORT RECORD ERROR
	STC
	RET
;
;---- HERE TO READ A BYTE ----
;
RBYT:	IN	IMSR	; GET THE MISC. STATUS
	RLC		; CY = RXRDY
	JC	RBA	; GO INPUT ON RXRDY
	ADD	A	; CHECK DAD
	JM	RBYT	; LOOP IF DAD STILL TRUE
;
RBE:	MVI	B,40H	; SET RETURN DAD*
	CALL	WDAD	; GO WAIT
	MVI	B,E8	; GET MISSING DATA/FMK ERROR
	IN	IDEIS1	; GET DEI STATUS
	ANI	4	; WERE WE WRITING?
	JZ	SEE	; IF NOT, EXIT W/O WEN
	MVI	A,0F7H	; IF SO, SET WEN/IDLE
	JMP	SEE1
;
RBA:	IN	IPCIDR	; GET THE DATA
	RET		; AND BACK TO CALLER
;
;---- STOP DRIVE MOTION SUBROUTINE ----
;
RSTP:	MVI	B,40H	; RETURN ON DAD*
	CALL	WDAD
	MVI	A,0FFH	; IDLE
	OUT	ODEIL1	; STOP THE DRIVE
	RET
.PAGE
.SBTTL "{WFM}-WRITE FILE MARK CIRCUIT"
WFM:	CALL	WRDY	; WAIT FOR DRIVE READY
	CALL	CWEN	; CHECK WRITE ENABLED
	CALL	WS1	; WRITE SEQUENCE 1
	MVI	A,0F5H	; WEN* + FWD*
	CALL	DCAC	; ISSUE CMD. AND CHECK
	CALL	WS2	; WRITE SEQUENCE 2
	MVI	B,30	; GET 2" CONSTANT
..B:	CALL	DLY2
	DCR	B
	JNZ	..B
	CALL	WPRE	; WRITE PREAMBLE
	MVI	A,FMKID	; GET FILE MK I.D.
	CALL	WBYT
	MVI	B,7	; SEND EOR & ZEROS. 
	LXI	H,AMBLE+1
	CALL	WS
	MVI	A,4	; GET RXEN
	OUT	OPCICR	; STOP THE WRITE
;
;---- HERE WE VERIFY THE FILE MARK ----
;
	MVI	B,0	; SET RETURN ON DAD
	CALL	WDAD	; LOOK FOR DATA DETECTED
	CALL	RBYT	; CHECK FOR FILE MARK I.D.
	CPI	FMKID
	JNZ	..A	; IF NONE, GO ERROR
	CALL	FME	; GO SET FMK IN DS
	MVI	B,30	; GET 2" CONSTANT
..C:	CALL	DLY2	; AND CLEAR A GAP
	DCR	B
	JNZ	..C
	JMP	WSTOP	; DO NORMAL WRITE STOP
..A:	MVI	B,E6	; GET ERROR
	JMP	WEE	; USE WRITE ERROR EXIT
.PAGE
.SBTTL "FWD./REV. SPACE/ERASE CIRCUIT"
;---- SPACE FORWARD ----
;
SRF:	ANI	0FDH	; FWD*
SSTRT:	MOV	D,A	; SAVE THE DIRECTION
	LDA	CA	; GET THE COMMMAND
	MOV	E,A	; SAVE IT FOR LATER
	MVI	H,0	; CLEAR FMK FLAG
	CALL	WRDY	; CHECK DRIVE RDY
S.A:	MOV	A,D	; GET THE DIRECTION
	CALL	DCAC	; ISSUE CMD & CHECK TAKEN
	MVI	B,0	; SET RETURN ON DATA DETECT
	CALL	WDAD	; CALL DATA DETECT SUB
;
;---- HERE TO CHECK IF FILE MARK ----
;
	CALL	DLY2	; DELAY 4 M.S.
	CALL	DLY2
	IN	IPCISR	; GET PCI STATUS
	ADD	A	; CHECK DAD*
	JM	..A	; GO DO RECORD IF HI
	MOV	H,E	; NON-ZERO THE FMK FLAG
	MOV	A,E	; GET THE COMMAND
	RRC		; RECORD OR FILE SEARCH?
	JNC	S.E	; IF RECORD SEARCH, ABORT
..B:	CLA
	ORA	C	; CHECK COUNTER
	JZ	SDONE	; IF ZERO, GO STOP
	DCR	C	; ELSE DEC THE COUNTER
	JNZ	S.A	; IF NOT LAST, LOOP
	MOV	A,D	; GET THE COMMAND
	ORI	4	; SET SLOW SPEED
	MOV	D,A	; RESTORE COUNTER
	JMP	S.A	; GO SEARCH AGAIN
;
;---- HERE FOR RECORD ----
;
..A:	MVI	B,40H	; SET RETURN NO DATA DETECT
	CALL	WDAD
	MOV	A,E	; GET THE COMMAND
	RRC		; RECORD OR FILE SEARCH?
	JC	S.A	; LOOP IF FILE SEARCH
	JMP	..B	; IF REC, DEC THE COUNTER
;
;---- SEARCH EXIT ----
;
SDONE:	MOV	A,D	; GET THE DIRECTION BACK
	ANI	1	; SEE IF REVERSE
	JNZ	S.E	; IF NOT, SKIP RVRS THING
..F:	MVI	B,32	; GET 16.0 MS. COUNT
..E:	CALL	DLY.5
	IN	IPCISR	; READ THE PCI STATUS
	ANI	40H	; CHECK DAD
	JNZ	..F	; IF DATA, LOOP TO SKIP IT
	DCR	B	; LOOP FOR THE COUNT
	JNZ	..E
;
;---- STOP THE DRIVE AND EXIT LOGIC ----
;
S.E:	MVI	A,0FFH	; IDLE
	OUT	ODEIL1	; STOP THE DRIVE
	CLA		; CHECK FMK FLAG
	ORA	H
	RZ		; RETURN OK IF LOW
	CALL	FME	; GO SET FMK STATUS
	MOV	A,H	; SEE IF REC. SEARCH
	ANI	1
	RNZ		; IF NOT, RETURN OK
	STC		; ELSE SET CARRY 
	RET		; FOR ERROR RETURN
;
;---- SPACE REVERSE ----
;
SRR:	ANI	0FEH	; REV*
	JMP	SSTRT	; GO DO IT
;
;
;---- ERASE ----
;
ERASE:	CALL	WRDY	; WAIT FOR DRIVE READY
	CALL	CWEN	; CHECK WRITE ENABLED
	CALL	WS1	; WRITE SEQUENCE 1
	MVI	A,0F5H	; GET FORWARD COMMAND +WEN*
	CALL	DCAC	; ISSUE CMD. & CHECK TAKEN
;
;---- ERASE 1/3 REC SIZE PER R.DBL ----
;
	MVI	B,(R.DBL>8)<2 ; B= APPROX COUNT
;
..A:	CALL	DLY2
	DCR	B
	JNZ	..A
;
;---- WRITE STOP CIRCUIT ----
;
WSTOP:	MVI	A,0F7H	; WEN* ONLY
	OUT	ODEIL1	; STOP THE DRIVE
	XRA	A	; SIGNAL SUCCESSFUL ACTION
	RET
.PAGE
.SBTTL "MISC. SUBROUTINES"
;---- WAIT FOR DRIVE READY ----
;
WRDY:	IN	IPCICR	; READ CR TO CLR TO MR1
	MVI	A,MSYN1	; REVERT TO SINGLE SYN
	OUT	OPCIMR	; SET IT
	IN	IDEIS1	; READ DRIVE STATUS
	ANI	81H	; CHECK RDY + SLD
	CPI	81H
	JNZ	..C	; SIGNAL ERROR
..A:	IN	IDEIS1	; GET STATUS AGAIN
	ANI	2	; CHECK BSY
	JNZ	..A	; LOOP TILL NOT BUSY
	IN	IDEIS1	; GET DRIVE STATUS
	ANI	10H	; CHECK FLG BIT
	JZ	..B	; IF NOT CONTINUE
	IN	IMSR	; GET MISC. STATUS
	ANI	10H	; CHECK PTB
	JNZ	..B	; IF SET, ALLOW OPERATION
	MVI	B,E0	; IF NOT, SIGNAL WARNING
	JMP	SEE
;
..B:	IN	IDEIS1	; GET DEI STATUS
	ANI	4	; CHECK IF WRITING
	JZ	..D	; IF NOT, NO UN-LATCH
	LDA	CSR	; GET THE CMD ARG. AGAIN
	ANI	47H	; ISOLATE REAL BITS
	CPI	2	; WRITE-CMD. QUEUED?
	JZ	..D	; IF SO, NO UN-LATCH
	MVI	A,0FEH	; UNLATCH ERA F/F
	OUT	ODEIL1	;   BY PULSING REV.
	MVI	A,0FFH	; GET DRIVE IDLE
	OUT	ODEIL1	; SET IT
	CALL	D.A	; ALLOW COMMAND TO TAKE
..E:	IN	IDEIS1	; WAIT TILL NOT BUSY
	ANI	2
	JNZ	..E
;
..D:	CALL	DLY2	; ALLOW SETTLEING
	LDA	DTLS	; GET STORED SELECT WORD
	ORI	2	; SET IT TO CLEAR FAULT LIGHT
	OUT	ODEIL2
	STA	DTLS	; AND PRESERVE CODE
	RET		; RETURN TO CALLER
;
..C:	MVI	B,E2	; CMD. TO BAD DRIVE
	JMP	SEE
.PAGE
;---- CHECK WRITE ENABLED ----
;
CWEN:	IN	IDEIS1	; READ DRIVE STATUS
	ANI	8	; CHECK FUP
	RNZ		; RETURN IF OK
	MVI	B,E1	; WRITE NOT ENABLED
	POP	PSW	; SET FOR ERROR RETURN
;
;
;---- SUBROUTINE ERROR EXIT ----
;
SEE:	MVI	A,0FFH	; GET DRIVE IDLE CMD.
SEE1:	OUT	ODEIL1	; SET IT
	CALL	DLY2	; DELAY AT LEAST 2 MS.
	POP	PSW	; POP TO CMD. LEVEL
	STC		; SET CY TO SIGNAL ERROR
	RET		; RETURN TO CALLER
;
;---- DRIVE COMMAND AND CHECK ----
;
DCAC:	OUT	ODEIL1	; NOW DO DRIVE SELECT
	MVI	A,2	; DELAY FOR SLEW
	CALL	D.A	; DELAY 20 MICROS
	IN	IDEIS1	; GET DRIVE STATUS
	ANI	2	; CHECK BSY
	RNZ		; RETURN TO CALLER -OK
	MVI	B,E3	; DRIVE -CMD. REJECTED
	JMP	SEE	; ERROR SIGNAL ETC.
.PAGE
;---- WAIT FOR DATA DETECTED ----
;
;----   B= 0   TO RETURN ON DAD TRUE
;	B= 40H TO RETURN ON DAD FALSE
;
WDAD:	XRA	A	; CLEAR DEADMAN
	STA	WCTU
	STA	WCTT
	STA	WCTH
..W:	IN	IPCISR	; GET PCI STATUS
	ANI	40H	; DCD=DAD*
	XRA	B	; CALLER OPTION
	JNZ	..A	; IF GOOD, VERIFY AFTER WAIT
	LDA	WCTU	; INCRAMENT DEADMAN
	ADI	1
	STA	WCTU
	JNC	..B
	LDA	WCTT
	ADI	1	
	STA	WCTT
	JNC	..B
	LDA	WCTH
	INR	A
	STA	WCTH
	CPI	07H	; TIMEOUT?
	JNZ	..B	; CONTINUE IF NOT
	LDA	CA	; GET CALLING COMMAND
	ANI	07H	; ISOLATE COMMAND BITS
	CPI	5	; IS IT FILE SEARCH?
	JZ	..W	; IF SO, DON'T ABORT
	POP	PSW	; DO STACK ADJUST
	JMP	..C	; AND SIGNAL ERROR
..B:	IN	IDEIS1	; READ DEI STATUS
	ANI	2	; CHECK BSY FALSE
	JNZ	..W	; LOOP IF STILL MOVING
..C:	MVI	B,E7	; SIGNAL TRANSPORT ABORT
	JMP	SEE	; USE SUBROUTINE ABORT EXIT
;
..A:	MVI	A,10	; GET 100 MICRO-SEC. CONSTANT
	CALL	D.A
	IN	IPCISR	; READ THE STATUS AGAIN
	ANI	40H
	XRA	B
	RNZ		; RETURN IF NOT FALSE ALARM
	JMP	..W	; LET'S TRY IT AGAIN, FOLKS
;
;---- DELAY 2 MILLI-SECONDS ----
;
;-- ASSUMES 4MHZ Z-80 -NO WAIT STATES
;
DLY2:	MVI	A,205	; GET 39 STATE CONSTANT
D.A:	NOP		; KILL 9.75 MICRO-SECS.
	NOP
	NOP
	NOP
	NOP
	DCR	A
	RZ
	JMP	D.A
;
;---- DELAY 0.5 MILLISECONDS ----
;
DLY.5:	MVI	A,52	; GET CONSTANT FOR .5 MS.
	JMP	D.A	; USE ABOVE CIRCUIT TO TIME
;
;
;---- WAIT READY AND RETURN CURRENT STATUS ----
;
WRRS:	CALL	..A	; LOWER PGM LEVEL FOR ABORT
	JC	AWOA	; IF ABORT, SIGNAL SAME
	JMP	CPRA	; SENT CURRENT DRIVE STATUS
;
..A:	CALL	WRDY	; WAIT FOR DRIVE READY
	CLA		; CLEAR CY FOR RETURN
	RET		; RETURN TO PSEUDO CALLER
.PAGE
.SBTTL	"{RAM VARIABLES}"
;*****************************************************
	.LOC	ATU+769H
;
;---- RESERVED RAM ----
;
WCTU:	.BYTE	0	; WDAD DEADMAN COUNTER - UNIT
WCTT:	.BYTE	0	; WDAD DEADMAN COUNTER - TEN
WCTH:	.BYTE	0	; WDAD DEADMAN COUNTER - HUNDRED
R.AREA:	.WORD	R.DBA	; READ/WRITE RECORD AREA - START
WRDCNT:	.WORD	R.DBL	; READ/WRITE RECORD SIZE (BYTES)
MA:	.BYTE	0	; MODE ARGUMENT
PA:	.BYTE	0	; POSITIONAL ARGUMENT
CA:	.BYTE	0	; COMMAND ARG.
CSR:	.BYTE	0	; CA INTERMEDIATE STORAGE
DS:	.BYTE	0	; DRIVE STATUS
IS:	.BYTE	0	; INTERFACE STATUS
RETRY:	.BYTE	0	; INTERNAL RETRY LITERAL
DRETRY:	.BYTE	0	; DYNAMIC RETRY COUNTER
LRC:	.BYTE	0	; LRC STORAGE
ODS:	.BYTE	0	; OLD DRIVE STATUS
DTLS:	.BYTE	0	; DRIVE/TRK/LED STORAGE
FMFLG:	.BYTE	0	; INTERNAL FMK COORD.
ECODE:	.BYTE	0	; ERROR CODE STORAGE
VER:	.BYTE	"3"	; VERSION NUMBER (LSB)
SSAVE:	.WORD	0	; STACK SAVE LOCATION
;
.END








