
/*
   This program works around several of the problems encountered in
   starting the initial X client.  It detaches the client process and
   puts it in its own process group to make it immune from group
   signals.  It also closes all file descriptors to allow rsh/rexec
   to exit and redirects stdout and stderr to a log file for later
   perusal if additional problems occur.
   
   To build the program use the command:
   
     cc -o xdetach [-DBSD] xdetach.c
   
   To use the program, use some variation of:
   
     xdetach xterm -ls -display displayname:0
*/

#include <stdio.h>

#define MAX_DESCS	20

main(ac, av)
int ac;
char *av[];
{
    int i;

   
    /*
       Detach the process and set our own process group.
    */
    if (fork()) exit(0);
#ifdef BSD
    setpgrp(0, getpid());
#else /* System 5 */
    setpgrp();
#endif
   
    /*
       Make sure all file descriptors are closed
    */
    for (i=0; i<MAX_DESCS; i++)
	close(i);

    /*
       Open standard streams.  Point stdout and stderr to a log file.
    */
    fopen("/dev/null", "r");	/* stdin */
    fopen("xdetach.log", "w");	/* stdout */
    dup(1);			/* stderr dup of stdout */


    execvp(av[1], &av[1]);
}
