#define TRACE(x) 	/*x*/

#define FDC(x)	(0x3f0+x)

#define DLONG	100000
#define DMED	1000
#define DSHORT	1000

#define DELAY(x)	{int i=x; while(--i) ;}

floppy_stop(drv)
{
	outp(FDC(2),0x00);

}
floppy_init(drv)
int drv;
{
	outp(FDC(2),0x00);	/* reset */
	DELAY(DLONG);
	if(drv == 0)
		outp(FDC(2),0x14);
	if(drv == 1)
		outp(FDC(2),0x25);

	outp(FDC(7),0x02);	/* 250K MFM */
	
	fdc_out(0x03);		/* specify */
	fdc_out(0xdf);		/* 3ms step, 240ms head unload time*/
	fdc_out(0x03);		/* 2ms head load time, no DMA */

}
floppy_read(drv,block,buf,len)
int drv;
unsigned block;
register unsigned char *buf;
int len;
{
int sec;
int trk;
int hd;
register int n;
unsigned char resp[7];
unsigned short x;
register unsigned char i;


	floppy_seek(drv,block);

	trk = block / 18;
	sec = (block % 9);
	hd = (block / 9) % 2;

	len = (len > ((9-sec)*512))?(9-sec)*512:len;
	n = len;

	TRACE(printf("floppy_read: trk %x sec %x hd %x len %x ",
		trk,sec,hd,len)); 

	fdc_out(0x66);		/* read command MFM,SK */
	fdc_out(drv|hd<<2);	/* drive & head select */
	fdc_out(trk);		/* cylinder */
	fdc_out(hd);		/* head address */
	fdc_out(sec+1);		/* sector address */
	fdc_out(2);		/* sector size 512 */
	fdc_out(9);		/* end of track */
	fdc_out(0x1b);		/* gap */
	fdc_out(0xff);		/* data length, only if sector size == 0 */
	
	while(n){
		/* anything happening ? */
		while(!((i = inp(FDC(4))) & 0x80))
			;

		/* still executing and has data ready */
		if((i & 0xe0) == 0xe0){
			*buf = inp(FDC(5));
			buf++;
			n--;

		/* oops, not executing, must be response data */
		}else if((i & 0xe0) == 0xc0)
			break;
	}

	for(x=0;x<7;x++){
		while((inp(FDC(4)) & 0xe0) != 0xc0)
			;
		fdc_in(&resp[x]);
	}

	if((resp[0] & 0xc0) || n){
		if(!n && (resp[0] & 0xf8) == 0x40 &&
			(resp[1] == 0x10 || resp[1] == 0x80) &&
			resp[2] == 0x00 )
			goto out;

		puthex2(i); 
		putchar(' ');
		for(x=0;x<7;x++)
			puthex2(resp[x]);
		putchar(' ');
		puthex4(n);
		putchar('\n');
		return(-1);
	}

out:
	TRACE(printf("returns %x\n",len-n));
	return(len-n);
}
floppy_write(drv,block,buf,len)
int drv;
unsigned block;
register unsigned char *buf;
int len;
{
int sec;
int trk;
int hd;
register int n;
unsigned char resp[7];
unsigned short x;
register int i;

	floppy_seek(drv,block);

	trk = block / 18;
	sec = (block % 9);
	hd = (block / 9) % 2;

	len = (len > ((9-sec)*512))?(9-sec)*512:len;
	n = len;

	TRACE(printf("floppy_write: trk %x sec %x hd %x len %x ",
		trk,sec,hd,len)); 

	fdc_out(0x45);		/* write command MFM */
	fdc_out(drv|hd<<2);	/* drive & head select */
	fdc_out(trk);		/* cylinder */
	fdc_out(hd);		/* head address */
	fdc_out(sec+1);		/* sector address */
	fdc_out(2);		/* sector size 512 */
	fdc_out(9);		/* end of track */
	fdc_out(0x1b);		/* gap */
	fdc_out(0xff);		/* data length, only if sector size == 0 */
	
	while(n){
		/* anything happening ? */
		while(!((i = inp(FDC(4))) & 0x80))
			;

		outp(FDC(5),*buf);	/* output the byte */

		/* was everything OK ? */
		if((i & 0xe0) == 0xa0){
			buf++;
			n--;
		/* oops, not executing, must be response data */
		}else if((i & 0xe0) == 0xc0)
			break;
	}

	for(x=0;x<7;x++){
		while((inp(FDC(4)) & 0xe0) != 0xc0)
			;
		fdc_in(&resp[x]);
	}

	if((resp[0] & 0xc0) || n){
		if(!n && (resp[0] & 0xf8) == 0x40 &&
			(resp[1] == 0x10 || resp[1] == 0x80) &&
			resp[2] == 0x00 )
			goto out;

		puthex2(i); 
		putchar(' ');
		for(x=0;x<7;x++)
			puthex2(resp[x]);
		putchar(' ');
		puthex4(n);
		putchar('\n');
		return(-1);
	}

out:
	TRACE(printf("returns %x\n",len-n));
	return(len-n);
}
floppy_format(drv,block)
int drv;
unsigned block;
{
int sec;
int trk;
int hd;
int n,j,b;
unsigned char resp[7];
unsigned short x;
register int i;

	floppy_seek(drv,block);

	trk = block / 18;
	sec = (block % 9);
	hd = (block / 9) % 2;

	fdc_out(0x4d);		/* format track */
	fdc_out(drv|hd<<2);	/* drive & head select */
	fdc_out(2);		/* sector size 512 */
	fdc_out(9);		/* end of track */
	fdc_out(0x54);		/* gap 3*/
	fdc_out(0x00);		/* fill */
	
	n = 9*4;	/* 4 bytes/sector */
	j = 0;
	b = trk;
	while(n){
		/* anything happening ? */
		while(!((i = inp(FDC(4))) & 0x80))
			;
		outp(FDC(5),b);
		/* still executing and wants data */
		if((i & 0xe0) == 0xa0){
			j++;
			switch(j%4){
				case 0:
					b = trk;
					break;
				case 1:
					b = hd;
					break;
				case 2:
					b = sec+1;
					sec++;
					break;
				case 3:
					b = 0x02;
					break;
				default:
					break;
			}
			n--;
		/* oops, not executing, must be response data */
		}else if((i & 0xe0) == 0xc0)
			break;
	}

	for(x=0;x<7;x++){
		while((inp(FDC(4)) & 0xe0) != 0xc0)
			;
		fdc_in(&resp[x]);
	}

	if((resp[0] & 0xc0) || n){
		if(!n && (resp[0] & 0xf8) == 0x40 &&
			(resp[1] == 0x10 || resp[1] == 0x80) &&
			resp[2] == 0x00 )
			return(0);

		puthex2(i); 
		putchar(' ');
		for(x=0;x<7;x++)
			puthex2(resp[x]);
		putchar(' ');
		puthex4(n);
		putchar('\n');
		return(-1);
	}
	return(0);
}
fdc_out(x)
unsigned char x;
{
int st;
	while(((st = inp(FDC(4))) & 0xc0) != 0x80){
		if((inp(FDC(4))& 0xc0) == 0xc0){
			putchar('<');
			puthex2(inp(FDC(5)));
			putchar('>');
		}
	}
	outp(FDC(5),x);
}
fdc_in(x)
unsigned char *x;
{
int st;

	while(((st = inp(FDC(4))) & 0xc0) != 0xc0)
		;
	*x = inp(FDC(5));
	return(0);
}

floppy_seek(drv,block)
int drv;
int block;
{
unsigned char resp[7];
int trk,sec,hd;

	trk = block / 18;
	sec = (block % 9);
	hd = (block / 9) % 2;

again:

	fdc_out(0x0f);		/* seek command */
	fdc_out(drv|hd<<2);	/* drive and head select */
	fdc_out(trk);		/* cylinder */

	DELAY(DLONG);

	fdc_out(0x08);		/* sense interrupt */
	fdc_in(resp);
	fdc_in(resp+1);
	if((resp[0] & 0xe0) != 0x20){
		printf("fdc: seek failed (%d) \n",resp[1]);
		goto again;
	}
}
floppy_recalibrate(drv)
int drv;
{
unsigned char resp[7];

again:

	fdc_out(0x07);		/* reclibrate */
	fdc_out(drv);		/* drive select */

	DELAY(2*DLONG);

	fdc_out(0x08);		/* sense interrupt */
	fdc_in(resp);
	fdc_in(resp+1);

	if((resp[0] & 0xe0) != 0x20){
		printf("fdc: recalibrate failed (%d)\n",resp[1]);
		goto again;
	}
}
