const	UP		= #11;
		DOWN	= #10;
		LEFT	= #08;
		RIGHT	= #12;

		NULL	= #0;
		DIO	= 6;
		INPUT	= -1;
		BELL = #7;
		QUIT = 'Q';
		MAX_POINT = 12;

var	response: char;
		error: boolean;
		newx, newy, newz, oldx, oldy, oldz: array[1..MAX_POINT] of real;

procedure clear_screen;
	begin
		bdos( DIO, 26 );
	end;

procedure pixoff( x1, y1: integer);
	begin
		bdos( DIO, 27 );
		bdos( DIO, 32 );
		bdos( DIO, y1 + 81 );
		bdos( DIO, x1 + 81 );
	end;

procedure pixon( x1, y1: integer);
	begin
		bdos( DIO, 27 );
		bdos( DIO, 42 );
		bdos( DIO, y1 + 81 );
		bdos( DIO, x1 + 81 );
	end;

procedure lineoff( x1, y1, x2, y2 : integer);
	begin
		bdos( DIO, 27 );
		bdos( DIO, 68 );
		bdos( DIO, y1 + 81 );
		bdos( DIO, x1 + 81 );
		bdos( DIO, y2 + 81 );
		bdos( DIO, x2 + 81 );
	end;

procedure lineon( x1, y1, x2, y2: integer );
	begin
		bdos( DIO, 27 );
		bdos( DIO, 76 );
		bdos( DIO, y1 + 81 );
		bdos( DIO, x1 + 81 );
		bdos( DIO, y2 + 81 );
		bdos( DIO, x2 + 81 );
	end;

function get_response: char;
	var	ch: char;
	begin
		repeat
			ch := chr( bdos( DIO, INPUT ) );
		until ch <> NULL;
		get_response := upcase( ch );
	end;

procedure rotate_up;
	var	i: integer;
			dist, angle, y, z: real;
	begin
		for i := 1 to MAX_POINT do begin
			y := oldy[i];
			z := oldz[i];
			dist := sqrt( sqr(y) + sqr(z) );
			if z > 0
				then angle := arctan( y/abs(z) )
				else if z < 0 then angle := PI - arctan( y/abs(z) )
						 else angle := ( PI/2 ) * ( abs(y)/y );
			angle := angle + 0.1;
			if angle >= (2 * PI) then angle := angle - (2 * PI);
			if angle < 0 then angle := angle + (2 * PI);
			newx[i] := oldx[i];
			newy[i] := dist * sin(angle);
			newz[i] := dist * cos(angle);
		end;		
	end;

procedure rotate_down;
	var	i: integer;
			dist, angle, y, z: real;
	begin
		for i := 1 to MAX_POINT do begin
			y := oldy[i];
			z := oldz[i];
			dist := sqrt( sqr(y) + sqr(z) );
			if z > 0
				then angle := arctan( y/abs(z) )
				else if z < 0 then angle := PI - arctan( y/abs(z) )
						 else angle := ( PI/2 ) * ( abs(y)/y );
			angle := angle - 0.1;
			if angle >= (2 * PI) then angle := angle - (2 * PI);
			if angle < 0 then angle := angle + (2 * PI);
			newx[i] := oldx[i];
			newy[i] := dist * sin(angle);
			newz[i] := dist * cos(angle);
		end;		
	end;

procedure rotate_left;
	var	i: integer;
			dist, angle, x, z: real;
	begin
		for i := 1 to MAX_POINT do begin
			x := oldx[i];
			z := oldz[i];
			dist := sqrt( sqr(x) + sqr(z) );
			if z > 0
				then angle := arctan( x/abs(z) )
				else if z < 0 then angle := PI - arctan( x/abs(z) )
						 else angle := ( PI/2 ) * ( abs(x)/x );
			angle := angle + 0.1;
			if angle >= (2 * PI) then angle := angle - (2 * PI);
			if angle < 0 then angle := angle + (2 * PI);
			newy[i] := oldy[i];
			newx[i] := dist * sin(angle);
			newz[i] := dist * cos(angle);
		end;		
	end;

procedure rotate_right;
	var	i: integer;
			dist, angle, x, z: real;
	begin
		for i := 1 to MAX_POINT do begin
			x := oldx[i];
			z := oldz[i];
			dist := sqrt( sqr(x) + sqr(z) );
			if z > 0
				then angle := arctan( x/abs(z) )
				else if z < 0 then angle := PI - arctan( x/abs(z) )
						 else angle := ( PI/2 ) * ( abs(x)/x );
			angle := angle - 0.1;
			if angle >= (2 * PI) then angle := angle - (2 * PI);
			if angle < 0 then angle := angle + (2 * PI);
			newy[i] := oldy[i];
			newx[i] := dist * sin(angle);
			newz[i] := dist * cos(angle);
		end;		
	end;

procedure erase;
	begin
	lineoff( round(oldx[1]), round(oldy[1]), round(oldx[2]), round(oldy[2]) );
	lineoff( round(oldx[3]), round(oldy[3]), round(oldx[2]), round(oldy[2]) );
	lineoff( round(oldx[3]), round(oldy[3]), round(oldx[4]), round(oldy[4]) );
	lineoff( round(oldx[1]), round(oldy[1]), round(oldx[4]), round(oldy[4]) );
	lineoff( round(oldx[1]), round(oldy[1]), round(oldx[5]), round(oldy[5]) );
	lineoff( round(oldx[2]), round(oldy[2]), round(oldx[6]), round(oldy[6]) );
	lineoff( round(oldx[3]), round(oldy[3]), round(oldx[7]), round(oldy[7]) );
	lineoff( round(oldx[4]), round(oldy[4]), round(oldx[8]), round(oldy[8]) );
	lineoff( round(oldx[5]), round(oldy[5]), round(oldx[6]), round(oldy[6]) );
	lineoff( round(oldx[7]), round(oldy[7]), round(oldx[6]), round(oldy[6]) );
	lineoff( round(oldx[7]), round(oldy[7]), round(oldx[8]), round(oldy[8]) );
	lineoff( round(oldx[5]), round(oldy[5]), round(oldx[8]), round(oldy[8]) );

	pixoff( round(oldx[9]),  round(oldy[9]) );
	pixoff( round(oldx[10]), round(oldy[10]) );
	pixoff( round(oldx[11]), round(oldy[11]) );
	pixoff( round(oldx[12]), round(oldy[12]) );
	end;

procedure draw;
	begin
	lineon( round(newx[1]), round(newy[1]), round(newx[2]), round(newy[2]) );
	lineon( round(newx[3]), round(newy[3]), round(newx[2]), round(newy[2]) );
	lineon( round(newx[3]), round(newy[3]), round(newx[4]), round(newy[4]) );
	lineon( round(newx[1]), round(newy[1]), round(newx[4]), round(newy[4]) );
	lineon( round(newx[1]), round(newy[1]), round(newx[5]), round(newy[5]) );
	lineon( round(newx[2]), round(newy[2]), round(newx[6]), round(newy[6]) );
	lineon( round(newx[3]), round(newy[3]), round(newx[7]), round(newy[7]) );
	lineon( round(newx[4]), round(newy[4]), round(newx[8]), round(newy[8]) );
	lineon( round(newx[5]), round(newy[5]), round(newx[6]), round(newy[6]) );
	lineon( round(newx[7]), round(newy[7]), round(newx[6]), round(newy[6]) );
	lineon( round(newx[7]), round(newy[7]), round(newx[8]), round(newy[8]) );
	lineon( round(newx[5]), round(newy[5]), round(newx[8]), round(newy[8]) );

	pixon( round(newx[9]),  round(newy[9]) );
	pixon( round(newx[10]), round(newy[10]) );
	pixon( round(newx[11]), round(newy[11]) );
	pixon( round(newx[12]), round(newy[12]) );
	end;

procedure update_old;
	var	i: integer;
	begin
		for i := 1 to MAX_POINT do begin
			oldx[i] := newx[i];
			oldy[i] := newy[i];
			oldz[i] := newz[i];
		end;
	end;

procedure initialize;
	var	i: integer;
	begin
		error := FALSE;
		clear_screen;
		newx[1] := -25.0; 	newy[1] := 25.0;		newz[1] := -25.0;
		newx[2] := 25.0;		newy[2] := 25.0;		newz[2] := -25.0;
		newx[3] := 25.0;		newy[3] := 25.0;		newz[3] := 25.0;
		newx[4] := -25.0;		newy[4] := 25.0;		newz[4] := 25.0;
		newx[5] := -25.0;		newy[5] := -25.0;		newz[5] := -25.0;
		newx[6] := 25.0;		newy[6] := -25.0;		newz[6] := -25.0;
		newx[7] := 25.0;		newy[7] := -25.0;		newz[7] := 25.0;
		newx[8] := -25.0;		newy[8] := -25.0;		newz[8] := 25.0;

		newx[9] := -11.0;		newy[9] := -23.0;		newz[9] := 20.0;
		newx[10] := 20.0;		newy[10] := 2.0;		newz[10] := 0.0;
		newx[11] := 7.0;		newy[11] := -8.0;		newz[11] := 9.0;
		newx[12] := -15.0;	newy[12] := 0.0;		newz[12] := -15.0;
		for i := 1 to MAX_POINT do begin
			oldx[i] := 0;
			oldy[i] := 0;
			oldz[i] := 0;
		end;
	end;

begin
	initialize;
	repeat
		if not error then begin
			erase;
			draw;
			update_old;
		end;
		error := FALSE;
		response := get_response;
		case response of
			UP:	rotate_up;
			DOWN:	rotate_down;
			LEFT:	rotate_left;
			RIGHT:rotate_right;
			QUIT: clear_screen;
		else
			error := TRUE;
			write( BELL );
		end;
	until response = QUIT;
end.
 25.0;		newz[3] := 25.0;
		newx[4] := -25.0;		newy[4] := 25.0;		ne