/*
Copyright 1988 Torch Computers Ltd.

Permission to use, copy, modify, and otherwise generally do what you like
with this software is hereby granted provided that the above copyright notice
appears in all copies.

Torch disclaims all warranties implied or expressed with regard to this
software.  In no event shall Torch be liable for any damages arising from
this use of software.
*/

/********************************************************
*							*
*  Title   Yorn, Gs and Alert.	    	    	    	*
*							*
*  File	   : misc.c					*
*  Author  : Gary Henderson 	    	    	    	*
*  Date	   : 23rd Aug 1988				*
*  Purpose : String to pixmap converter so user can 	*
*   	     specify background bitmaps for widgets. 	*
*							*
*********************************************************/

/*------Include files-----------------------------------*/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/Convert.h>
#include <X11/StringDefs.h>

/*------Forward delarations-----------------------------*/

/*------Constants and macros----------------------------*/

/*------Exported variables/functions--------------------*/

void AddNewConverter ();

/*------Imported variables/functions--------------------*/

/*------Static variables--------------------------------*/

/*
							*****************
							*		*
							*CVTSTRINGTOPIXMAP*
							*		*
							*****************
-------------------------------------------------------------------------
| Convert the given string (taken to be the path name of a bitmap file)	|
| into a pixmap.  This is so the user can specify background pixmaps	|
| for widgets from a .Xdefaults file.	    	    	    	    	|
-------------------------------------------------------------------------
*/
static void CvtStringToPixmap (args, num_args, fromVal, toVal)
XrmValuePtr args;
Cardinal * num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
{
    static Pixmap pixmap;
    static Pixel fore_pixel;
    static XtResource pixmap_resources[] = {
    	{XtNforeground, XtCForeground, XtRPixel, sizeof (Pixel),
 	(Cardinal) &fore_pixel, XtRString, "Black"},
    };
    
    unsigned int width, height;
    int result;
    Pixmap temp;
    XGCValues gcvalues;
    GC gc;
    Screen * screen;
    Cardinal depth;
    Pixel back_pixel;
    Widget widget;
    
    if (*num_args != 4)
    	return;

    widget = (Widget) args[0].addr;
    screen = *((Screen **) args[1].addr);
    
    /* So much for doing things properly; if you try to get the widget's
       depth with the following code: 
    	    depth = *((Cardinal *) args[2].addr);

       you always read zero !  So for the time been, assume the widget has
       the same depth as the root window */

    depth = PlanesOfScreen (screen);
    back_pixel = *((Pixel *) args[3].addr);

    result = XReadBitmapFile (DisplayOfScreen (screen),
    	    	    	      RootWindowOfScreen (screen),
			      (char *) fromVal->addr,
	    	    	      &width, 
			      &height, 
			      &temp, 
			      (int *) 0,
			      (int *) 0);

    if (result != BitmapSuccess)
        return;
    else
    {
	pixmap = XCreatePixmap (DisplayOfScreen (screen),
	    	    	        RootWindowOfScreen (screen),
				width,
				height, 
				depth);
	    
	/* Need two colours when converting a bitmap into a pixmap.  The
	   background pixel value is easy, but the foreground requires a bit
	   more work to get hold of */
	   
	gcvalues.background = back_pixel;
	
	XtGetSubresources (widget, 
	    	    	   (caddr_t) 0,
			   XtNbackgroundPixmap,
			   XtCPixmap,
    	    	    	   pixmap_resources,
			   XtNumber (pixmap_resources),
			   (ArgList) 0,
			   0);

	gcvalues.foreground = fore_pixel;
	
	gc = XCreateGC (DisplayOfScreen (screen),
	    	    	pixmap,
			GCForeground | GCBackground,
			&gcvalues);

	XCopyPlane (DisplayOfScreen (screen),
	    	    temp, 
		    pixmap, 
		    gc, 
		    0, 
		    0, 
		    width, 
		    height, 
	    	    0, 
		    0, 
		    1l);
	    
	XFreePixmap (DisplayOfScreen (screen), temp);
    	XFreeGC (DisplayOfScreen (screen), gc);
    }

    toVal->addr = (caddr_t) &pixmap;
    toVal->size = sizeof (Pixmap);
}

/*
							*****************
							*		*
							*ADDNEWCONVERTER*
							*		*
							*****************
-------------------------------------------------------------------------
| Install the string-to-pixmap converter into the toolkit's current list|
| of converters.    	    	    	    	    	    	    	|
-------------------------------------------------------------------------
*/
void AddNewConverter ()
{
    static XtConvertArgRec pixmapConvertArgs[] = {
    	{XtBaseOffset, (caddr_t) 0, sizeof (Widget)},
	{XtBaseOffset, (caddr_t) XtOffset (Widget, core.screen), 
	 sizeof (Screen *)},
    	{XtBaseOffset, (caddr_t) XtOffset (Widget, core.depth), 
	 sizeof (Cardinal)},
	{XtBaseOffset, (caddr_t) XtOffset (Widget, core.background_pixel),
	 sizeof (Pixel)},
    };

    XtAddConverter (XtRString, XtRPixmap, CvtStringToPixmap,
    	    	    pixmapConvertArgs, XtNumber (pixmapConvertArgs));
}
