/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*
 * This module handles name selection panels.
 */
#include <X11/Xos.h>
#include <stdio.h>
#include <sys/dir.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/Atoms.h>
#include <X11/Core.h>
#include <X11/CoreP.h>
#include <X11/Shell.h>
#include <X11/AsciiText.h>
#include <X11/Label.h>
#include <X11/LabelP.h>
#include <X11/Viewport.h>
#include <X11/ViewportP.h>
#include <X11/Box.h>
#include <X11/Command.h>
#include <X11/Icon.h>
#include <X11/ICommand.h>
#include "../include/tar.h"
#include "../include/help.h"
#include "../include/Xtty.h"
#include "../include/xgshconf.h"
#include "../include/xgshstate.h"
#include "../include/xgsherr.h"

/*
 * Global vars.
 */
extern Widget toplevel;
extern int cur_op;
extern void help_call();
extern NameList *creat_namelist();
extern Widget creatpopup_text();
extern void popup_text();
extern HelpList helphead, popuphead;
extern char *dirb_fgr, *dirb_bgr;
extern Boolean dirb_iconflg;
extern XFontStruct *basefont;
extern NameList *endlp;
extern Widget dirb_formw;

/* Global vars */
Widget name_w;
Widget name_dialogw;
Widget noname_labelw;
static Widget name_dialboxw;
Widget name_dialtextw;
static Widget name_diallabelw;
static Widget *name_childw;
int name_flags = 0;
Widget name_vieww;
Widget viewbox_w;
Widget newicon_w;
NameList *chainlp;
static int name_numchild;
char name_dialogresp[MAXLABEL+1];
static NameList *name_curlp;
int name_cnt;
void name_input();
static void newname_input();
void fullname_input();
void namectrl_input();

#define	NAME_UP		0x00000001
#define	NEWNAME_UP	0x00000002

#define LIST	1

/* Flags for NameList */
#define NL_MAPPED	0x00000001
#define NL_PREMAPPED	0x00000002

/*
 * This function pops down the full name panel.
 */
void fullname_input(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	Widget tw;

	if (p2 == NULL || *p2 != 'D')
		return;
	tw = (Widget) p1;
	XtPopdown(tw);
	XtDestroyWidget(tw);
}

/*
 * This function deals with input to a name selection panel.
 */
void name_input(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	register NameList *lp;
	Widget pw, tw;

	lp = (NameList *)p1;
	if (p2 != NULL) {
		if (*p2 == 'H') {
			popup_help(&(helphead), &(popuphead), w);
		}
		if (*p2 == 'P') {
			/* Popup the full name */
			pw = creatpopup_text(dirb_formw, lp->l_name, dirb_fgr, dirb_bgr,
				&tw);
			XtOverrideTranslations(tw, XtParseTranslationTable(
				"<Btn3Down>: enablenotify() \n\
				<Btn3Up>: notify(Down) disablenotify()"));
			XtAddCallback(tw, XtNcallback, fullname_input,
				(caddr_t) pw);
			popup_text(pw, -1, -1, 0);
		}
		return;
	}
	if (cur_op == LIST) {
		return;
	}
	/* Selection of a name, desensitize it and append to selected list */
	XtSetSensitive(lp->l_w, False);
	lp->l_selnext = NULL;
	chainlp->l_selnext = lp;
	chainlp = lp;
	name_cnt++;
}

/*
 * This function is called by name ctrl buttons.
 */
void namectrl_input(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	register NameList *lp;
	register int i;
	int j;
	static int xpos, ypos;
	static Arg getpos[] = {
		{XtNx,	(XtArgVal) &xpos},
		{XtNy,	(XtArgVal) &ypos},
	};
	static Arg setpos[] = {
		{XtNx,	(XtArgVal) NULL},
		{XtNy,	(XtArgVal) NULL},
	};

	if (p2 != NULL) {
		if (*p2 == 'H') {
			popup_help(&(helphead), &(popuphead), w);
		}
		return;
	}
	j = (int) p1;
	switch (j) {
	case 0:
		reset_names();
		reset_dir();
		break;
	case 1:
		/* Just reinitialize list and cnt */
		lp = name_curlp->l_selnext;
		/* Resensitize names */
		for (i = 0; i < name_cnt; i++) {
			XtSetSensitive(lp->l_w, True);
			lp = lp->l_selnext;
		}
		name_curlp->l_selnext = NULL;
		chainlp = name_curlp;
		name_cnt = 0;
		break;
	case 2:
		reset_names();
		do_op();
		break;
	};
}

/*
 * Initialize the name and newname selection panels.
 */
init_names()
{

	/* Create newname popup widget */
	dial_creat(dirb_formw, "NewDir", dirb_fgr, dirb_bgr,
		dirb_fgr, dirb_bgr,
		basefont, name_dialogresp, MAXLABEL,
		newname_input, &(helphead), dirb_iconflg,
		&name_dialogw, &name_dialboxw, &name_diallabelw,
		&name_dialtextw);
}

/*
 * Callback from buttons on dialog box
 */
static void newname_input(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	register NameList *lp;
	int j;
	static char *labelptr;
	static Pixel fgr, bgr;
	static char errstr[1024];
	static Arg	getargl[] = {
		{XtNlabel,	(XtArgVal)&labelptr},
		{XtNforeground, (XtArgVal)&fgr},
		{XtNbackground, (XtArgVal)&bgr},
	};
	static Arg	setargl[] = {
		{XtNlabel,	(XtArgVal) NULL},
		{XtNforeground, (XtArgVal) NULL},
		{XtNbackground, (XtArgVal) NULL},
	};

	/* Handle non-select input */
	if (p2 != NULL) {
		if (*p2 == 'H') {
			popup_help(&(helphead), &(popuphead), w);
		}
		return;
	}
	j = (int) p1;
	switch (j) {
	case 0:
		/* pop it down */
		XtPopdown(name_dialogw);
		name_flags &= ~NEWNAME_UP;
		break;
	case 1:
		/* Just erase text */
		XtTextErase(name_dialtextw);
		break;
	case 2:
		/* See if it passes the regular expression */
		if (strlen(name_dialogresp) > 0) {
			/* Add the new name to the list and select it */
			if (endlp->l_next == NULL)
				lp = creat_namelist();
			else
				lp = endlp->l_next;
			endlp = lp;
			strncpy(lp->l_name, name_dialogresp, MAXPATHLEN);
			lp->l_name[MAXPATHLEN] = '\0';
			lp->l_selnext = NULL;
			chainlp->l_selnext = lp;
			chainlp = lp;
			name_cnt++;
			XtPopdown(name_dialogw);
			name_flags &= ~NEWNAME_UP;
			do_op();
		} else {
			/* Pop up match pattern in rev video and wait for new string */
			strcpy(errstr, "Empty String");
			XtGetValues(name_diallabelw, getargl, XtNumber(getargl));
			setargl[0].value = (XtArgVal) errstr;
			setargl[1].value = (XtArgVal) bgr;
			setargl[2].value = (XtArgVal) fgr;
			XtSetValues(name_diallabelw, setargl, XtNumber(setargl));
			/* Kludge, but how else do i get the string redrawn */
			(*(name_diallabelw->core.widget_class->core_class.expose))(name_diallabelw, (XEvent *) NULL, (Region) NULL);
			XFlush(XtDisplay(name_diallabelw));
			/* wait a bit */
			sleep(1);
			XtTextErase(name_dialtextw);
			setargl[0].value = (XtArgVal) labelptr;
			setargl[1].value = (XtArgVal) fgr;
			setargl[2].value = (XtArgVal) bgr;
			XtSetValues(name_diallabelw, setargl, XtNumber(setargl));
		}
		break;
	};
}

/*
 * pop up the name panel with the names from the list
 */
void setnameget(listp, j, nameret)
	NameList *listp;
	int j;
	NameList *nameret;
{
	register int i;
	register NameList *lp;
	register Widget *wp;
	ViewportWidget vw;
	static Arg setlab[] = {
		{XtNlabel,	(XtArgVal) NULL},
	};

	lp = listp->l_next;
	name_numchild = j;
	name_curlp = chainlp = nameret;
	nameret->l_selnext = NULL;
	name_cnt = 0;
	vw = (ViewportWidget) name_vieww;
	if (j > (3*NAMEROWS)) {
		if (!XtIsSensitive(vw->viewport.vert_bar))
			XtSetSensitive(vw->viewport.vert_bar, True);
	} else {
		if (XtIsSensitive(vw->viewport.vert_bar))
			XtSetSensitive(vw->viewport.vert_bar, False);
	}
	/* Handle no names case */
	if (j == 0) {
		err("Empty Directory");
		reset_dir();
		return;
	} else {
		wp = name_childw = (Widget *)XtMalloc(name_numchild*sizeof(Widget));
		/* Loop thru list setting widgets to be managed by viewbox */
		for (i = 0; i < j; i++) {
			/* And the label */
			setlab[0].value = (XtArgVal) lp->l_label;
			XtSetValues(lp->l_w, setlab, 1);
			*wp++ = lp->l_w;
			if (!XtIsSensitive(lp->l_w))
				XtSetSensitive(lp->l_w, True);
			lp = lp->l_next;
		}
	}
	XtManageChildren(name_childw, name_numchild);
	name_flags |= NAME_UP;
	/* Set name box to top and pop up */
	XtViewMovechild(name_vieww, 0, 0);
	XtPopup(name_w, XtGrabNone);
	warp_pointer(viewbox_w);
}

/*
 * Reset name selection panels
 */
reset_names()
{

	if (name_flags & NEWNAME_UP) {
		name_flags &= ~NEWNAME_UP;
		XtPopdown(name_dialogw);
	}
	if (name_flags & NAME_UP) {
		name_flags &= ~NAME_UP;
		XtPopdown(name_w);
		XtUnmanageChildren(name_childw, name_numchild);
		XtFree((caddr_t) name_childw);
	}
}

