.RP
.nr PO 1.15i
.nr HM 1.15i
.nr FM 0.85i
.ND
.ds CH
.ds CF \\n(PN
.TL
G Shell Environment
.AU
Rick Macklem, Jim Linders, Hugh Smith
rick@uogvax2.Bitnet, jgl@uogvax2.Bitnet, hugh@uogvax2.Bitnet
University of Guelph
.AB
Unix running on the current generation of workstations offers support for
sophisticated window systems such as the X Window System from MIT.
However, the visual interface made possible by these window systems is at
odds with most current Unix utilities, which assume 
an ASCII terminal
interface.
Currently, the solution to this problem requires the window system
to support a
.I
terminal emulation
.R
window to which the Unix utilities are attached via.
.I
pseudo terminals.
.R
The principal intent of the G Shell Environment is to facilitate
the migration of standard
Unix utility user interaction from a
.I
tty interface
.R
to a
.I
visual interface
.R
based on the X Window System.
.sp
.LP
Of the 250 plus Unix utilities commonly available, only a small fraction
perform significant user interaction.
The majority perform short tasks such as
.B
C
.R
compiles or directory listings without user interaction.
A well designed visual top level interface (shell) should be able to provide a
run time framework sufficient for these utilities.
The Xgsh X client described in this paper is designed to fulfill this task.
The interactive utilities such as text editors, mail or conferencing
systems
require significant changes to make effective use of the workstation's
visual interactive capabilities.
Ideally, they would all be rewritten to use a visual interface on the window system,
however the Visual Interface
Filter (VIF) is proposed as an interim solution.
A key component of both of these utilities is that they are configuration
driven, providing a high degree of flexibility and permitting them to be
used as both a prototyping and production tool.
.PP
This paper describes the use of the VIF and Xgsh for the realization
of a visual interface for use within a Unix student teaching
environment.
.AE
.LP
.sp
.B
.ce
ABSTRACT
.R
.sp
.in +\n(.lu/12u
.ll -\n(.lu/12u
Unix\(dg running on the current generation of workstations offers support for
sophisticated window systems such as the X Window System\(dd from MIT.
.FS
\(dg Unix is a trademark of AT&T Bell Laboratories
.FE
.FS
\(dd X Window System is a trademark of Massachusetts Institute of Technology
.FE
However, the visual interface made possible by these window systems is at
odds with most current Unix utilities, which assume 
an ASCII terminal
interface.
Currently, the solution to this problem requires the window system
to support a
.I
terminal emulation
.R
window to which the Unix utilities are attached via.
.I
pseudo terminals.
.R
The principal intent of the G Shell Environment is to facilitate
the migration of standard
Unix utility user interaction from a
.I
tty interface
.R
to a
.I
visual interface
.R
based on the X Window System.
.sp
Of the 250 plus Unix utilities commonly available, only a small fraction
perform significant user interaction.
The majority perform short tasks such as
.B
C
.R
compiles or directory listings without user interaction.
A well designed visual top level interface (shell) should be able to provide a
run time framework sufficient for these utilities.
The Xgsh X client described in this paper is designed to fulfill this task.
The interactive utilities such as text editors, mail or conferencing
systems
require significant changes to make effective use of the workstation's
visual interactive capabilities.
Ideally, they would all be rewritten to use a visual interface on the window system,
however the Visual Interface
Filter (VIF) is proposed as an interim solution.
A key component of both of these utilities is that they are configuration
driven, providing a fair degree of flexibility and permitting them to be
used as both a prototyping and production tool.
.sp
This paper describes the use of the VIF and Xgsh for the realization
of a visual interface for use within a Unix student teaching
environment.
.br
.in 0
.ll \n(LLu
.SH
Introduction
.PP
The advent of Unix based workstations with sophisticated window systems
such as MIT's X Window System has opened up the potential for a new realm of user
interaction within Unix. This however, is juxtaposed with the 250 plus
standard Unix utilities currently in use that were written to interact
with a standard ASCII terminal. In fact, a vast majority of the utilities
don't even know about a screen display and interact in the style
reminiscent of the hardcopy teletype.
The two programs described in this paper are an effort to build a
visual interface environment around standard Unix utilities so that
user interaction may be migrated away from the
.I
tty mode
.R
of interaction without a need to re-implement these utilities.
.PP
Currently, the window systems on Unix workstations provide a
.I
tty emulation
.R
window which is connected to a standard utility via. a pseudo terminal.
The resultant interface offers little, if any, functionality beyond
that of the ASCII terminal.
The first of the two programs described in this paper (the VIF) is an enhanced
.I
tty emulator
.R
that permits a variety of mouse inputs and also
I/O stream character sequences to be translated
into specified actions including certain graphical outputs
to provide a limited
visual interface.
The second program is a visual interface shell (the Xgsh) that is intended to
replace the single line command capabilities of a standard Unix shell
by providing its functional equivalent.
It in turn runs the Unix command line attached via. a pseudo terminal
connection to an enhanced terminal emulation window
provided by the VIF.
.PP
A critical aspect of both of these programs is that they are
configurable by the system administrator so that they can provide
the kind of environment required by a specific user group.
This was done in an effort to permit the generation of a simple, and therefore easy to learn
interface, without imposing an overly restrictive structure.
As such, the onus is on the configuration builder to find a set of
appropriate
operations such that the interface fulfills the user's needs but remains
sufficiently simple to avoid the need for
complex interactions.
A structured hierarchy of selection panels, and frequent mouse warping
to a default selection,
is done in an effort to give the interface a logical conversational flow.
This structure is somewhat more defined than the
.I
desk top metaphor
.R
commonly used for screen layout and uses fewer levels of hierarchy
than is typical of graphical interfaces.
.SH
The VIF
.PP
The VIF is a program which is essentially an enhanced version of the X Window System
terminal emulation window client
.I
xterm.
.R
VIF is normally configured for a given client Unix utility and one invocation
of VIF is done for each utility started by Xgsh.
The enhancements 
to
.I
xterm
.R
are provided in two major categories.
The first is a set of mouse inputs that are translated
into actions such as sending a character sequence through the pseudo terminal
connection to the client utility.
This permits the configuration of a certain amount of mouse input for
a given client.
The second major category consists of character stream filters
for both input and output
on the pseudo terminal connection.
The filters are defined in the configuration using regular expressions
(as in Lex)
with an associated action similar to that related to a mouse input.
This action permits certain visual interface widgets to be popped up,
highlighted or sensitized upon matching of a given I/O character sequence.
As such, this provides a limited facility for generating a graphical
output translation of the character stream provided by the utility.
For example, a compiler fatal error message might be translated to
a skull and cross bones icon.
.SH
Mouse Inputs
.PP
The configured mouse inputs can be of several categories:
.IP "- "
selection on a configured visual interface widget such as a
.I
pushbutton
.R
or
a
.I
pull down menu.
.R
The widget selection will then invoke the associated action.
The widgets that can be configured are a button box for direct selection
of buttons and a button box where the selections activate associated
pull down menus.
.IP "- "
positioning of the text cursor via. a left mouse button press on the text area
subwindow. Internally, this generates the appropriate number of text cursor
.I
up/down
.R
and
.I
left/right
.R
arrow
character sequences for the emulated terminal type and sends them down
the pseudo tty connection to emulate the user pressing the arrow keys on a tty.
.IP "- "
a press of the center or right mouse button while the mouse cursor is on the
text area subwindow. This then invokes the associated action for that mouse
button.
An example of where
this can be useful is when the client utility uses menus that are selected
with the arrow keys followed by a <cr> when the text cursor is at the
appropriate item. By configuring an action of "send <cr> to client" for
the right mouse button users can then do menu selection with the mouse.
.IP "- "
manipulating a scroll bar that generates scroll up/down
actions.
This scroll bar actually functions like a unidirectional joystick in that
the thumb cursor returns to the midpoint as soon as the mouse button is
released and generates some number of the up/down actions based on how
far the thumb was displaced. (This has no relation to the
.I
xterm
.R
scroll bar.)
This is primarily useful when the VIF is used as a front end to screen
editors such as
.I
vi
.R
to allow scroll up/down operations to be generated using the mouse.
.SH
I/O Stream Filters
.PP
The Input and Output stream filters may be used as follows:
.IP "- "
The input filter can restrict or modify actions that the user may perform on the
utility by translating the input key stroke sequence to an associated action
which may include a replacement key stroke sequence.
This can prove to be useful when a novice is being interfaced to a
powerful (implies dangerous) utility such as
.I
vi.
.R
For example, the configuration could remove a control key stroke sequence
from the input stream
and display a graphical error icon.
.IP "- "
The output filter may allow output generated by the client utility to be translated to an action
that is more meaningful to the user. For example, "Bus error, core dumped"
might be replaced by "Bad pointer reference during execution" or
"Array subscript out of bounds, try using the Check option".
The replacement action may include a graphical operation such as displaying an icon
of a
.I
bell
.R
for the bell character ^G.
The second style of action in the form of making an icon visible or sensitizing
a widget for selection allows the configuration writer a limited
use of graphical output for a client.
.SH
Actions
.PP
The actions invoked by the above can be configured to be any combination of the
following:
.IP "- "
send a character sequence down the pseudo terminal connection to the
client utility.
This is the most common action and essentially translates mouse inputs
to their keyboard equivalent for the client.
.IP "- "
send a character sequence to the terminal emulation subwindow.
This must be done with caution since it leaves the terminal
emulation subwindow in a state different from that assumed by the client
utility.
It may be used for effects such as reverse video or for message replacement
if the client utility is not full screen oriented.
.IP "- "
change the visibility/sensitivity of the visual interface widgets.
This permits a limited adaptation of VIF to the current state in which the
client is functioning. For example, a screen editor in
.I
insert mode.
.R
.IP "- "
pop up a text string or icon on the window. This action allows for a graphical
translation of some of the client's outputs.
.IP "- "
change the mouse cursor momentarily or permanently.
This may be used as a visual reflection of a change in the client utility's
current state of operation.
.IP "- "
change the text cursor appearance. This may be useful as a visual reflection
of the client performing some specific text operation.
.IP "- "
pop up a dialog box to request keyboard input.
The box accepts a text string input from the keyboard that must pass a regular
expression and then sends it down the pseudo terminal to the client.
This can be used to enhance the input of a short text argument such as a
file name or search string.
.IP "- "
pop up a yes/no query button box. 
The box has two command buttons for yes/no that send the "yes" or "no"
strings down the pseudo terminal connection when the appropriate button is selected.
This can be used to enhance the input of
yes/no responses to verification queries.
.SH
Process Manipulation
.PP
The VIF also has certain standard capabilities for controlling the
client process via. mouse input.
This is necessary so that process control may be handled in a manner
analogous to that provided by the top level Xgsh.
This includes:
.IP "- "
the window may be raised/lowered to ease use of several clients
concurrently.
.IP "- "
Stop, Continue and Interrupt 
.I
signals 
.R
may be sent to the client to help
control its execution.
Depending on the configuration, the Stop/Continue signals may be
implicitly generated upon the VIF window being raised/lowered.
.IP "- "
optionally text output may be page scrolled in a manner similar to
.I
more
.R
as an aid when the client is non-interactive, to avoid loss of output.
.IP "- "
the window may be configured to remain visible after the client process terminates,
to avoid the loss of any final output.
.SH
Problems and Limitations
.PP
The major limitations of the current VIF are its limited scope of graphical
output and its very restricted knowledge of client utility state.
A greater variety of graphical outputs for actions is needed to
permit configuration builders to provide appropriate visual feedback.
There is also a need to define some kind of client state knowledge in the
configuration and relate client state to functional changes in VIF.
Currently the only state information maintained is the visibility/sensitivity
of the mouse selection widgets.
.PP
Another problem with the current VIF is that the I/O stream filters
can easily hang the I/O stream if not very carefully configured.
Any regular expressions requiring further characters to resolve
the alternatives with hang the I/O stream until the characters are received.
If the client is not doing further output or the user does not continue
to type at the keyboard, the filter is hung.
.SH
The Xgsh
.PP
The Xgsh program is intended to replace a standard Unix shell as a top level
command interface.
It is a configurable visual interface where the items that may
be mouse selected on the various panels are defined almost entirely by the
configuration.
A sequence of mouse selections are translated to the corresponding single
line shell command as defined by the configuration.
Once the command is constructed, it is run as a process subtree with a
parent controlling window, usually provided by a VIF.
The configuration file allows the configuration builder to create an
appropriate set of commands for a particular user group and also permits
a variety of restrictions to be enforced so that the novice will be
protected from
.I
dangerous
.R
actions.
For example, Pascal compiles might only allow text files ending in ".p"
to be selected as file arguments.
The screen layout (See Figures #2-5) is constructed of four panels
that must be active for initial interaction.
Other panels may then pop up to provide further interaction such as
providing name arguments for commands.
The main panels may be active at all times (as shown in the figures) or
popped up when required from a menu bar, as defined by the configuration
file.
.SH
Main Panels
.PP
The main panels allow selection of a top level (which defines a set of related
operations), for the operations within these top levels, and also operations on the
directory tree.
The top levels define a hierarchical structure that can be used to categorize
operations into related groups.
There may optionally be a directory associated with each top level to
encourage use of a directory structure relating files to the operation
groups.
Selection of the current top level defines the group of operations that
may be selected in the command panel and the current directory, if specified
by the configuration.
The directory tree operations panel exists as an independent entity to
permit file name space browsing at any time. The only affect that directory
operations have on command selections is the definition of the current
directory.
Along with these panels is a window that displays the current command
under construction and can optionally allow text editing of the command.
.SH
Panel Layout
.PP
Each panel follows a standard layout that includes
a variety of selectable items that are either text strings or icons.
In some cases a scrolling widget or a dialog box for entering a text string
at the keyboard may be included. The dialog box is used for getting
.I
new names
.R
or
.I
search patterns
.R
that are required via. keyboard input.
.SH
Command Construction
.PP
Command invocation begins with a mouse selection of one of the operations
in the command panel.
If the associated Unix command line 
string (as defined by the configuration for that command selection) does not require any name arguments
a process window is created and the process subtree is forked off.
Most often, the process window is provided by VIF but may simply be an icon
window for clients that generate their own windows.
If VIF is providing the window, the
.I
stdio
.R
of the associated Unix command line will be
connected to VIF via. a pseudo terminal.
However, if name argument(s) are required, a name selection panel is popped
up to permit mouse selection of name arguments.
Name arguments will most often be file names but may be other text strings
as defined by the configuration.
Optionally, a
.I
new name
.R
widget is included to allow keyboard input of new names as well as mouse selection
for existing ones.
The name arguments are defined by the configuration in one of three ways:
.IP "- "
File names in a given directory that match a regular expression and criteria
such as
.I
text file
.R
or
.I
executable image.
.R
An example would be text files matching *.c in the current directory, for
a C compile operation.
.IP "- "
Names written to the standard output of a given Unix filter. For example,
.I
sed "s/:.*//" /etc/passwd
.R
would generate all local user names which could be used as the name arguments for a send mail
operation.
.IP "- "
A list of names explicitly provided in the configuration file for the
operation.
.LP
Once the name argument(s) are selected, the command can then be initiated
by selecting a
.I
Start
.R
pushbutton widget.
In cases where the operation is defined as only accepting one name argument
and does not allow piping, the
.I
Start
.R
selection is not necessary.
.PP
The use of pipes has been a somewhat contentious issue, and is allowed to
happen between certain operations as defined by the configuration
file.
Although powerful, pipelining operations can be dangerous and are somewhat
at odds with the goal of a simple user interface.
As such, the choice of whether or not to allow the use of pipes is left up to the configuration
builder.
.PP
The command being built is shown in the command string window either as
the actual Unix shell command string being generated or as a
chain of bubbles labeled for each command that is being piped together.
The configuration can also allow editing of the command string in the
window using the keyboard for the case of actual Unix command line display.
This permits a primitive facility to assist in the migration from
the Xgsh interface to a standard Unix shell.
This problem is discussed later.
.SH
Directory Operations
.PP
A set of operations on the directory tree are made available in a separate
selection panel, since
directory browsing tends to be a look aside activity.
These operations may be interspersed with command synthesis to permit
more flexibility during name argument selection.
Command synthesis is only affected when a change in the current directory occurs.
The directory operations are essentially a directory tree browser and
provide the following functions:
.IP "- "
List the contents of the current directory.
.IP "- "
Change directory to the parent directory.
.IP "- "
Change directory to a subdirectory.
.IP "- "
Create a new directory.
.IP "- "
Delete an empty directory.
.IP "- "
Find names that pass a given regular expression in the current directory
subtree.
.LP
The current implementation provides these operations as mouse selectable icons
but work is in progress on a graphical representation of the tree to help traverse
directories and peek at their contents.
.SH
Configurations
.PP
The configuration files for both VIF and Xgsh are currently ".o" files
compiled from large initialized C structures and the generation of a configuration
is definitely in the domain of a Unix wizard.
Even if a front end to the initialized structures was provided, constructing
a configuration will require a good knowledge of Unix and the utilities
that VIF is being interfaced to.
The only component of the configurations that currently has a front end is
the stream filter, which is defined by a Lex program.
.SH
Design Goals
.PP
The Xgsh design is aimed at providing a visual interface which is easy
for a novice to use and may be tailored to a specific user group's needs.
It is intended to provide another layer on top of the Unix pipeline of
filters that protects the non-experts from the more
.I
dangerous
.R
aspects of the Unix command line, while allowing effective use of the system.
In an effort to achieve this the idea of a configuration, to define
and restrict the user's environment, was developed so as to make the
operations as simple and specific as possible.
The user environment is meant to be sensitive to the user's current
work context, as defined by the selected top level and
operation, by remembering context information such as the name of the file
that was most recently referenced.
To make the visual interface as
.I
natural
.R
to use as was practical, a hierarchical structure which is context sensitive
was devised and the number of mouse inputs required kept to a
minimum.
The mouse cursor is "warped" (ie. moved without mouse motion) frequently to follow the normal dialog
sequence of the user.
For example, if a "Pascal Compile" operation is selected, a panel with
all Pascal source file names pops up with the mouse cursor at the source
file name that was compiled the last time this operation was performed.
This minimizes the need for the user to move the mouse and seems to
reduce the frequency of the sensation of "Why do I have to tell it that again?".
.SH
Problems
.PP
A major problem with this type of environment is the difficulty of providing
a migration path to more sophisticated shell interaction.
A simple visual interface can never hope to be as powerful as a standard Unix shell
but then how do you provide new capabilities for the user?
The current Xgsh echoes the corresponding Unix shell command in a window
and may allow the user to text edit the command under construction.
This is a primitive attempt to address this problem, but not a particularly
good one.
.PP
A possible approach to addressing this problem could be to include
some sort of configuration extensibility facility to the Xgsh.
In other words, a way must be provided by which users can modify or add new
command operations to their configuration.
This would allow them to further customize their environment and would
act as a back door to teaching them the standard Unix shell, since the
command's operation must be defined as a
.I
csh
.R
command line.
Another simple solution is an escape to Unix shell facility
that pops up a tty emulation window tied to
an invocation of
.I
csh.
.R
It is felt that some facility of this kind is required to make the
interface useful to the non-novice.
In any case, this area definitely needs further investigation in order
to provide an appropriate facility.
.PP
Another area that is not dealt with easily is the selection of file name
arguments from different directories for the same command.
The Unix file pathname syntax is far more powerful than mouse selection
of file names created from the contents of a directory.
As such, the selection of file name arguments that span several directories
becomes difficult and cumbersome.
A possible solution lies in the use of a directory subtree browser that
displays a graphical representation of a subtree and allows mouse selection
of directories to list for selection.
If this is combined with the kind of selection criteria used by
the Unix
.I
find
.R
command, it may be possible to build a fairly effective name selection tool.
Unfortunately, this is not a simple thing to implement well and, even at
its best, will be somewhat tedious to use when compared to a standard Unix shell command.
.SH
Comparison with Existing Visual Command Interfaces
.PP
Current visual interfaces may be typified by a range in power and
complexity extending from the Apple Macintosh to the Xerox
Interlisp-D environment.
.PP
The Macintosh environment is based on the desk top metaphor and the concepts of
applications and associated documents in file folders.
The file folder essentially defines a set of user programs (applications) and their associated files
(documents)
and as such enforces a partitioning of the file system based on the various
file folders.
This is vaguely similar to the Xgsh top levels
when each top level is configured to use a separate directory subtree.
The Macintosh
.I
Finder
.R
is used to select a current application and is in some sense akin
to command selection on Xgsh.
However, Unix and therefore Xgsh, does not define any structural relationship
between an application and its associated documents.
The Xgsh allows a configuration to define a directory for each top level,
which does provide the capability to construct a somewhat similar hierarchy but
does not enforce such a structure on the configuration designer.
The standard menus on the Macintosh provide certain standard operations,
such as 
.I
save
.R
on the File menu
and are an effort to create a consistent
interface.
Xgsh does not have any similar concept, except possibly the directory operations
panel, and leaves the operations definitions up to the configuration
designer.
On Xgsh the name selections are done in response to operation invocations whereas
on the Macintosh a selection of the
.I
open
.R
operation on the File menu would be required.
The Xgsh design allows the configuration designer to use either icons or
text strings for selection items in most cases except file names, whereas the Macintosh is
heavily icon oriented.
In general, the Macintosh provides a simple consistent interface, but one that
enforces a structure that is not inherently a part of Unix.
As such, this kind of structure was avoided in Xgsh, leaving a maximum of
leeway to the configuration designer.
.PP
The Interlisp-D environment is an integrated system intended for an
expert programmer in LISP.
It makes essentially all of the system internals available
to the programmer in an environment where the many tools cooperate
in complex ways.
As such, the interface is powerful, flexible and very confusing for
the novice.
Since Xgsh was designed with the novice in mind, this aspect of
Interlisp-D was considered inappropriate.
However, several aspects of the Interlisp-D environment were considered
highly desirable.
One area where Interlisp-D shines is its extensibility. As the user brings
new LISP functions into the system it really does become their
.I
personal
.R
computing environment.
As mentioned before, although there is a great potential in extensibility,
it is not a part of the current Xgsh.
Another aspect of Interlisp-D is its presentation of a great deal
of information on system activity to the user, often in a graphical form
such as changes to the mouse cursor.
This has been incorporated into Xgsh to the limited extent extent possible within
the confines of Unix.
The actual top level commands on the Xerox Interlisp-D environment are
still lisp functions invoked via. key stroke input.
However, there are several graphical components used to assist the user
during command execution,
some of which has influenced the Xgsh design.
One such assist is a file browser that is somewhat similar to the subtree
browser planned for the directory operations panel.
Another borrowed feature is the process menu that Interlisp-D
provides to permit
users to probe and control processes.
To summarize, the Interlisp-D environment was at a level of complexity
that we wished to avoid but provides features that influenced
the current design and future directions.
.SH
User Experience
.PP
Unfortunately, do to delays in the installation of a workstation laboratory
on our campus, user experience has been limited to the developers and short
demonstrations to outside parties.
However, the design was based on a preliminary
.I
gsh
.R
that provided a menu based interface for students working on ASCII
terminals.
The experience with this
.I
gsh
.R
was promising in that our novice students quickly adapted to the
environment.
In fact, it was observed that within a few hours use many students
would type ahead menu selections before the menus were displayed.
Although this menu shell was intended strictly for introductory level
students, many continued to use the interface for several
semesters and found the transition to
.I
csh
.R
difficult.
The VIF and Xgsh software is at the stage where a fairly extensive user
evaluation is required to refine the design.
.SH
Directions
.PP
There are several areas that need to be addressed in an effort to enhance
the G shell environment. As mentioned above in the Problems section, the extensibility capability
and more flexible configurations are both required to cover a wider spectrum
of the user community.
.PP
There is a requirement of a framework for defining inter window/process
interaction.
It seems appropriate to allow the definition of stream connections
with VIF style filters that interconnect the
.I
stdio
.R
of various VIFs and their client processes.
This should be doable at the Xgsh level, since it fabricates the VIFs
and the clients processes during command invocation.
.PP
The maintenance of an AI knowledge base of recent activity and an
associated rule base to define default next selections would
provide some measure of state sensitivity and help to minimize the
requirements for mouse inputs.
Minimizing mouse input is important, since the sophisticated user rapidly tires of repetitious
mouse movements.
As a first step, the provision of hooks into an AI software system is
required to help explore the use of expert assistants.
This type of support could be incorporated at both the Xgsh and VIF level
interfaces, but requires a great deal of forethought for there to be a
reasonable chance of success.
.SH
Summary
.PP
Although the software described in this paper is only a preliminary step,
it does seem possible to build visual interfaces for shell level interaction
on a Unix workstation.
The environment described in this paper provides a simple interface to
Unix configured to a specific user group's needs.
But, in doing so, it provides
only a small subset of the Unix command interface
functionality tailored to that user group.
Critical shortcomings of the current interface come in the areas of
extensibility, inter window/process interaction and knowledge of recent
activities.
Without these capabilities, more sophisticated users rapidly outgrow their
configured visual interface and often find it tedious.
As such, the current G shell environment for Unix is probably most appropriate
for the novice or casual user.
.SH
Acknowledgements
.PP
We wish to acknowledge the information and assistance provided by
the Digital Equipment Corporation, without which this software might
never have been developed.
.SH
References
.LP
A. Averill,
.I
Macintosh User Interface Guidelines,
.R
Apple Computer Inc., 1984
.LP
S. Draper, "Display Managers as the Basis for User-Machine Communication",
.I
User Centered System Design,
.R
1986
.LP
J. Gettys, et al., "Xlib - C Language X Interface",
.I
MIT Project Athena,
.R
1988
.LP
J. Gettys, "Problems Implementing Window Systems in UNIX",
.I
Proceedings of USENIX User Group Conference,
.R
January, 1986
.LP
Daniel Gill, "A Proposal for Interwindow Communication and Translation Facilities",
.I
Proceedings of USENIX User Group Conference,
.R
January, 1986
.LP
Hewlett-Packard Company,
.I
Programming With the X Window System,
.R
1986
.LP
Stephen N. Kahane, et al., "Windows in the Hospital",
.I
Proceedings USENIX User Group Conference,
.R
January 1986
.LP
Thomas Neuendorffer, "GLO - A Tool for Developing Window-Based Programs",
.I
Proceedings USENIX User Group Conference,
.R
January 1986
.LP
R. Reichman, "Communications Paradigms for a Window System",
.I
User Centered System Design,
.R
1986
.LP
R.W. Scheifler, "X Window System Protocol, Version 11",
.I
MIT Project Athena,
.R
1988
.LP
Sun Microsystems,
.I
Windows and Window Based Tools: Beginner's Guide,
.R
February 1986
.LP
W. Teitelman and L. Masinter, "The Interlisp Programming Environment",
.I
IEEE Computer,
.R
April 1981
.LP
