/*
 * Vif configuration defs
 */
#define MAXBUTTONS	20		/* If these are changed, vif MUST be recompiled */
#define MAXACTIONS	20		/* Ditto */

/*
 * A table of these structures define the actions, each structure is an
 * action that is referred to by index in the table vc_actions[]
 */
struct vif_actc {
	int	va_flags;		/* Flags, see VAC_xx defs */
	char	*va_instring;		/* String sent to client process */
	char	*va_boolstring;		/* String sent to client iff BOOLEAN switched off */
	char	*va_outstring;		/* string put on vt100 window */
	char	*va_warpwidgetname;	/* Char name of widget to warp to */
	char	*va_dialogstring;	/* Query string for dialog box */
	char	*va_dialogregex;	/* Regular expr. for dialog resp. */
	char	*va_dialogresp;		/* String that surrounds dialog resp when sent down pty
					^ marks spot where resp is filled in */
	char	*va_yesnoquery;		/* Query string for yes/no box */
	char	*va_yesstring;		/* String to send down pty for yes selection */
	char	*va_nostring;		/* String to send down pty for no selection */
	char	*va_mousebits;		/* Bitmap for new mouse, maybe should just be a cursor font entry ?? */
	int	va_mouseheight;
	int	va_mousewidth;
	int	va_mousehotx;
	int	va_mousehoty;
	int	va_mousetime;		/* Time newmouse should remain */
	char	*va_popuptext;		/* String to poup in status area */
	char	*va_popupiconbits;	/* Bitmap to popup as icon in status area */
	int	va_popupiconwidth;
	int	va_popupiconheight;
	int	va_popuptime;		/* Time to popup text and/or icon for */
	int	va_setsensitive[MAXBUTTONS+7]; /* Set sensitive flags, see SEN_xx */
};

/*
 * A table of these structures define the mouse selection buttons configured
 * (if any) each structure defines one button
 */
struct vif_sel {
	int	vsl_flags;		/* Flags for sel, see VSL_xx */
	char	*vsl_fgr;		/* Fgr colour for button */
	char	*vsl_bgr;		/* Bgr ditto */
	char	*vsl_label;		/* Button label */
	char	*vsl_iconbits;		/* Bitmap for button icon */
	int	vsl_iconwidth;
	int	vsl_iconheight;
	int	vsl_action;		/* Index in vif_actc table of action to perform */
};

/*
 * Overall config structure for a vif configuration
 */
struct vif_config {
	int	vc_flags;		/* Flags, see VC_xx */
	char	*vc_helplib;		/* Help Library name */
	char	*vc_fgr;		/* Fgr colour for vif */
	char	*vc_bgr;		/* Bgr ditto */
	char	*vc_cursfgr;		/* Fgr colour for cursor */
	char	*vc_cursbgr;		/* Bgr colour ditto */
	char	*vc_scrollfgr;		/* Fgr colour for scrollbar */
	char	*vc_scrollbgr;		/* Bgr ditto */
	char	*vc_dialogfgr;		/* fgr colour for dialog box */
	char	*vc_dialogbgr;		/* Bgr ditto */
	char	*vc_acceptfgr;		/* Fgr colour for accept but on dialog box */
	char	*vc_acceptbgr;		/* Bgr ditto */
	char	*vc_cancelfgr;		/* Fgr colour for cancel but on dialog box */
	char	*vc_cancelbgr;		/* Bgr ditto */
	char	*vc_yesnofgr;		/* Fgr colour for yes/no box */
	char	*vc_yesnobgr;		/* Bgr ditto */
	char	*vc_yesfgr;		/* Fgr colour for yes button on yes/no */
	char	*vc_yesbgr;		/* Bgr ditto */
	char	*vc_nofgr;		/* Fgr colour for no button on yes/no */
	char	*vc_nobgr;		/* Bgr ditto */
	char	*vc_helpfgr;		/* Fgr colour for help wins */
	char	*vc_helpbgr;		/* Bgr ditto */
	char	*vc_menufgr;		/* Fgr colour for menu */
	char	*vc_menubgr;		/* Bgr ditto */
	int	vc_scrollup;		/* Action index for up scroll */
	int	vc_scrolldown;		/* Action index for scroll down */
	int	vc_scrollacel;		/* Scroll accel. defines how many actions */
	int	vc_initaction;		/* Action to perform of startup iff VC_INITALACT */
	int	vc_screenmouse2;	/* Action index for button2 on vt100 win */
	int	vc_screenmouse3;	/* Ditto for button3 */
	int	vc_screenmouse4;	/* Ditto for button4 */
	int	vc_screenmouse5;	/* Ditto for button5 */
	struct vif_sel vc_selitem[MAXBUTTONS]; /* Defs for selection buttons */
	struct vif_actc vc_actions[MAXACTIONS]; /* Action Table see above */
};

/* Flag bits for vc_flags */
#define	VC_BUTTONS	0x00000001	/* Selection buttons are defined in vif_sel */
#define	VC_SCROLLBAR	0x00000002	/* config a scrollbar */
#define	VC_MOUSE2	0x00000004	/* Use mouse button2 input on vt100 window */
#define	VC_MOUSE3	0x00000008	/* Ditto button3 */
#define	VC_PAGESCROLL	0x00000010	/* Set pagescroll mode, output page and wait for a button press */
#define	VC_INITIALACT	0x00000020	/* Perform the initial action */
#define	VC_KBFILTER	0x00000040	/* Use a lex(1) filter on keyb input */
#define	VC_PTYFILTER	0x00000080	/* Use a lex(1) filter on client output */
#define	VC_MOUSEPOS	0x00000200	/* Position text cursor on button1 press on vt100 window */
#define VC_AUTOSTOPGO	0x00000400	/* Obsolete, use a window mgr */
#define	VC_MOUSE4	0x00000800	/* Use button4 input on vt100 window */
#define	VC_MOUSE5	0x00001000	/* Ditto for button5 and MOUSE2,3 above */

/* Flag bit for vsl_flags */
#define	VSL_VALID	0x00000001	/* Valid entry */
#define	VSL_BOOLEAN	0x00000002	/* Boolean button */
#define	VSL_ICON	0x00000004	/* Use icon instead of label */

/* Flag bits for vac_flags */
#define	VAC_VALID	0x00000001	/* Valid entry */
#define	VAC_NEWMOUSE	0x00000002	/* Change mouse cursor */
#define	VAC_POPUPTEXT	0x00000010	/* Popup text string */
#define	VAC_POPUPICON	0x00000020	/* Popup icon */
#define	VAC_PTYCHARS	0x00000040	/* Send string down pty to client, fake kbd input */
#define	VAC_VTCHARS	0x00000080	/* Put chars on screen */
#define	VAC_BOOLEAN	0x00000100	/* Action for boolean button */
#define	VAC_DIALOGBOX	0x00000200	/* Pop up a dialog box */
#define	VAC_YESNOBOX	0x00000400	/* Pop up a yes/no box */
#define	VAC_WARPPOINTER	0x00000800	/* Warp pointer to widget */
#define	VAC_SETSENSTV	0x00001000	/* Set sensitivity of inputs, see SEN_xx */
#define VAC_WARPPBOOL	0x00002000	/* Warp pointer on boolean button reset action */

#define	VAC_POPUP	(VAC_POPUPTEXT|VAC_POPUPICON)

/* Values for setsensitive array */
#define	SEN_NOCHANGE	0		/* Don't change sensitivity */
#define	SEN_ON		1		/* Turn sensitivity on */
#define	SEN_OFF		2		/* Turn sensitivity off */

/* Indices of SETSENSITIVE array va_setsensitive[] in vif_actc */
#define	SCROLLSEN	0		/* Array index for scrollbar sens */
#define	KBDSEN		1		/* Array index for keyb sens */
#define	MBUT1		2		/* Array index for button1 input on vt100 screen */
#define	MBUT2		3		/* Ditto for button2 */
#define	MBUT3		4		/* Ditto for button3 */
#define	MBUT4		5		/* Ditto for button4 */
#define	MBUT5		6		/* Ditto for button5 */
/* and 7-> refer to the selection buttons */

