/*
 * defs for gsh other than conf. stuff
 */

/*
 * defined constants
 */

#define	MYMAXPATHLEN	(MAXPATHLEN-1)	/* i forgot a path was MAXPATHLEN-1 */
#define PNAMESIZE	15
#define	BSIZE		1024
#define	MAXJOBS		20
#define	LOGINSLEEP	5
#define	WINDX		15
#define	WINDY		30
#define	MAXFILTERARGS	100
#define	MAXNAMEARGS	10000
#define	MAXCMDLINE	1024
#define	OUTSTRL		1024
#define	CURDIRL		256
#define	SOMEMEM		10240	/* Big enough so widgets can be created */
#define	INFOWIDTH	70
#define	CMDWIDTH	200
#define	NAMEHEIGHT	400
#define	NENVIR		20
#define	MAXLABEL	20	/* Must be <= OUTSTRL */
#define	NAMECOLS	3
#define NAMEROWS	12
#define	MAXPREFIX	(MAXLABEL*(NAMECOLS-1))	/* Must be <= OUTSTRL */
#define	NAMEBLOCK	40
#define	FONT		"9x15"
#define	DIRPREFIX	"Cur Dir: "
#define	NONAMEMSG	"No Names Found !!"

/*
 * structure defs.
 */
typedef struct _GshState	GshState;
typedef struct _PidList		PidList;
typedef struct _PosList		PosList;
typedef struct _StatsLog	StatsLog;
typedef struct _NameList	NameList;

struct _PidList {
	PidList *next;
	int flags;
	int pid;
	TTYWindow *ttywin;
	Widget widget;
	Widget subwidget;
	char name[PNAMESIZE+15];
};

/* Name list for name argument selection */
struct _NameList {
	NameList *l_next;
	NameList *l_prev;
	NameList *l_selnext;
	int l_flags;
	Widget l_w;
	Widget l_prew;
	struct stat l_statb;
	char l_name[MYMAXPATHLEN+1];
	char l_label[MAXLABEL+1];
	char l_prelabel[MAXPREFIX+1];
};

struct _PosList {
	PosList *next;
	int x;
	int y;
};

/*
 * the stats log
 */
struct _StatsLog {
	int	sl_inputs;
	int	sl_chtopls;
	int	sl_cmds;
	int	sl_errs;
	int	sl_dirs[10];
	int	sl_helps;
	int	sl_menus;
	int	sl_mjobs;
	int	sl_pipes;
	int	sl_hist[NTOPLEVEL][NCMD];
};

struct _GshState {
	Display		*gs_disp;
	Window		gs_rootwin;
	Screen		*gs_screen;
	int		gs_dispwidth;
	int		gs_dispheight;
	Colormap	gs_dispcolorm;
	XFontStruct	*gs_basefont;
	FILE		*gs_logfile;
	StatsLog	gs_slog;
	char		*gs_username;
	char		*gs_homedir;
	Window		gs_chdirwin;
	Atom		gs_abdiratom;
	Widget		gs_toplevel;
	Widget		gs_toplw;
	Widget		gs_titlew;
	Widget		gs_curdirw;
	Widget		gs_topbbw;
	Widget		gs_topw[NTOPLEVEL];
	Widget		gs_defcmdw[NTOPLEVEL];
	Widget		gs_ctrlbbw;
	Widget		gs_infobbw;
	Widget		gs_clockw;
	Widget		gs_mboxw;
	Widget		gs_loadw;
	Widget		gs_cmdstrw;
	Widget		gs_cmdw[NTOPLEVEL];
	Widget		gs_cmdbbw[NTOPLEVEL];
	Widget		gs_cmdbw[NTOPLEVEL][NCMD];
	Widget		gs_procmenuw;
	Cursor		gs_defcursor;
	Cursor		gs_hrcursor;
	Cursor		gs_fullhrcursor;
	Cursor		gs_leftcursor;
	int		gs_noexecinput;
	int		gs_nonameinput;
	int		gs_nocmdinput;
	int		gs_notoplinput;
	int		gs_curcmd;
	PidList		*gs_curpid;
	PidList		gs_pidlist;
	HelpList	gs_helphead;
	HelpList	gs_popuphead;
	short		gs_curtoplevel;
	int		gs_toplnum;
	int		gs_cmdnum[NTOPLEVEL];
	NameList	gs_name1;
	NameList	gs_name2;
	NameList	gs_namehead;
	NameList	*gs_endlp;
	NameList	*gs_endname;
};

/* Flag values for l_flags in NameList */
#define	L_LABEL		0x00000001
#define	L_PRELABEL	0x00000002
#define	L_TREELEVEL	0x00000004

