#ifndef lint
static char rcsid[] = "$Header: Icon.c,v 1.44 88/02/26 12:12:36 swick Exp $";
#endif lint


/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/*
 * Icon.c - Icon widget: modified label widget
 *
 */

#include <X11/IntrinsicP.h>
#include <stdio.h>
#include <X11/Xos.h>
#include <X11/StringDefs.h>
#include <X11/IconP.h>

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* Private Data */

static int defIWidth = 2;
static int defIHeight = 2;
static int defPWidth = 32;
static int defPHeight = 32;

#define offset(field) XtOffset(IconWidget, field)
static XtResource resources[] = {
    {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
	offset(icon.foreground), XtRString, "Black"},
    {XtNbackground, XtCBackground, XtRPixel, sizeof(Pixel),
	offset(icon.background), XtRString, "White"},
    {XtNbitmapData,  XtCString, XtRString, sizeof(caddr_t),
	offset(icon.bitmap_data),XtRString,NULL},
    {XtNinternalWidth, XtCWidth, XtRInt,  sizeof(Dimension),
	offset(icon.internal_width), XtRInt, (caddr_t)&defIWidth},
    {XtNinternalHeight, XtCHeight, XtRInt, sizeof(Dimension),
	offset(icon.internal_height), XtRInt, (caddr_t)&defIHeight},
    {XtNiconWidth, XtCWidth, XtRInt,  sizeof(Dimension),
	offset(icon.icon_width), XtRInt, (caddr_t)&defPWidth},
    {XtNiconHeight, XtCHeight, XtRInt,  sizeof(Dimension),
	offset(icon.icon_height), XtRInt, (caddr_t)&defPHeight},
};

static void Initialize();
static void Realize();
static void Resize();
static void Redisplay();
static Boolean SetValues();
static void ClassInitialize();
IconClassRec iconClassRec = {
  {
/* core_class fields */	
#define superclass		(&simpleClassRec)
    /* superclass	  	*/	(WidgetClass) superclass,
    /* class_name	  	*/	"Icon",
    /* widget_size	  	*/	sizeof(IconRec),
    /* class_initialize   	*/	ClassInitialize,
    /* class_part_initialize	*/	NULL,
    /* class_inited       	*/	FALSE,
    /* initialize	  	*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize		  	*/	Realize,
    /* actions		  	*/	NULL,
    /* num_actions	  	*/	0,
    /* resources	  	*/	resources,
    /* num_resources	  	*/	XtNumber(resources),
    /* xrm_class	  	*/	NULLQUARK,
    /* compress_motion	  	*/	TRUE,
    /* compress_exposure  	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest	  	*/	FALSE,
    /* destroy		  	*/	NULL,
    /* resize		  	*/	Resize,
    /* expose		  	*/	Redisplay,
    /* set_values	  	*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus	 	*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private   	*/	NULL,
    /* tm_table		   	*/	NULL,
    /* query_geometry		*/	NULL,
  }
};
WidgetClass iconWidgetClass = (WidgetClass)&iconClassRec;
/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/


static void ClassInitialize()
{

} /* ClassInitialize */




static void GetnormalGC(lw)
    IconWidget lw;
{
    XGCValues	values;

    values.foreground	= lw->icon.foreground;
    values.background	= lw->icon.background;
    values.fill_style	= FillSolid;

    lw->icon.normal_GC = XtGetGC(
	(Widget)lw,
	(unsigned) GCForeground|GCBackground|GCFillStyle,
	&values);
}


static void GetinvGC(lw)
    IconWidget lw;
{
    XGCValues	values;

    values.foreground = lw->icon.background;
    values.background = lw->icon.foreground;
    values.fill_style	= FillSolid;
    lw->icon.invr_GC = XtGetGC(
	(Widget)lw, 
	(unsigned) GCForeground |GCBackground|GCFillStyle, 
	&values);
}


static void GetgrayGC(lw)
    IconWidget lw;
{
    XGCValues	values;

    values.foreground = lw->icon.foreground;
    values.tile       = XtGrayPixmap(XtScreen((Widget)lw));
    values.fill_style = FillStippled;

    lw->icon.gray_GC = XtGetGC(
	(Widget)lw, 
	(unsigned) GCForeground |  GCTile | GCFillStyle, 
	&values);
}

/* ARGSUSED */
static void Initialize(request, new)
 Widget request, new;
{
    IconWidget lw = (IconWidget) new;

    if (lw->icon.bitmap_data == NULL) 
	XtError("Icon widget bitmap data not initialized");

    GetnormalGC(lw);
    GetinvGC(lw);


    if (lw->core.width == 0)
        lw->core.width = lw->icon.icon_width + 2 * lw->icon.internal_width;
    if (lw->core.height == 0)
        lw->core.height = lw->icon.icon_height + 2*lw->icon.internal_height;

    (*XtClass(new)->core_class.resize) ((Widget)lw);
} /* Initialize */


static void Realize(w, valueMask, attributes)
    register Widget w;
    Mask *valueMask;
    XSetWindowAttributes *attributes;
{
    IconWidget lw = (IconWidget)w;

    *valueMask |= CWBitGravity;
    attributes->bit_gravity = CenterGravity; 
    (*superclass->core_class.realize) (w, valueMask, attributes);

	/*
		create normal & inverse pixmaps
	*/

    lw->icon.icon_pixmap = XCreatePixmapFromBitmapData(XtDisplay((Widget)lw),
	    XtWindow((Widget)lw),
                   lw->icon.bitmap_data,
		   lw->icon.icon_width,lw->icon.icon_height,
		   lw->icon.foreground,lw->icon.background,
		   DefaultDepthOfScreen(XtScreen((Widget)lw)));

     lw->icon.inverse_icon_pixmap = XCreatePixmapFromBitmapData(XtDisplay(lw),
	    XtWindow((Widget)lw),
                               lw->icon.bitmap_data,
			       lw->icon.icon_width,lw->icon.icon_height,
			       lw->icon.background,lw->icon.foreground,
			       DefaultDepthOfScreen(XtScreen((Widget)lw)));
     GetgrayGC(lw);    

} /* Realize */



/*
 * Repaint the widget window
 */

/* ARGSUSED */
static void Redisplay(w, event, region)
    Widget w;
    XEvent *event;
    Region region;
{

   IconWidget lw = (IconWidget) w;

   XCopyArea(XtDisplay(w),
              	lw->icon.icon_pixmap ,
         	XtWindow(w),
		XtIsSensitive(lw) ? lw->icon.normal_GC : lw->icon.gray_GC,
		0, 0,lw->icon.icon_width,lw->icon.icon_height,
		lw->icon.internal_width,lw->icon.internal_height);
}


static void Resize(w)
    Widget w;
{
    IconWidget lw = (IconWidget) w;

    if (lw->icon.icon_x < 0)
       lw->icon.icon_x = lw->core.x + lw->icon.internal_width;
    lw->icon.icon_y = lw->core.y + lw->icon.internal_height;
}

/*
 * Set specified arguments into widget
 */

/* ARGSUSED */
static Boolean SetValues(current, request, new)
    Widget current, request, new;
{
    IconWidget curlw = (IconWidget) current;
    IconWidget reqlw = (IconWidget) request;
    IconWidget newlw = (IconWidget) new;
    Boolean was_resized = False;

    if(curlw->icon.bitmap_data == NULL)
	XtError("Icon widget bitmap data struct not initialized");
    if(newlw->icon.bitmap_data == NULL)
	XtError("Icon widget bitmap data struct not initialized");
#ifdef notdef
    if(curlw->icon.icon_pixmap != NULL)
	XFreePixmap((caddr_t)curlw->icon.icon_pixmap);
    if(curlw->icon.inverse_icon_pixmap != NULL)
	XFreePixmap((caddr_t)curlw->icon.inverse_icon_pixmap);
#endif
    /* calculate the window size */
    if (curlw->core.width == reqlw->core.width)
	newlw->core.width =
	    newlw->icon.icon_width +2*newlw->icon.internal_width;

    if (curlw->core.height == reqlw->core.height)
	newlw->core.height =
	    newlw->icon.icon_height + 2*newlw->icon.internal_height;

    /* we have to know if the size change is going to take
       before calling Resize() */

    if ((curlw->core.width != newlw->core.width ||
	 curlw->core.height != newlw->core.height) &&
	(XtMakeResizeRequest(current, newlw->core.width, newlw->core.height,
			     &newlw->core.width, &newlw->core.height)
	 == XtGeometryNo)) {
	newlw->core.width = curlw->core.width;
	newlw->core.height = curlw->core.height;
    }

    if (curlw->icon.foreground != newlw->icon.foreground){
	XtDestroyGC(curlw->icon.normal_GC);
	XtDestroyGC(curlw->icon.invr_GC);
	GetnormalGC(newlw);
	GetinvGC(newlw);
    }

    if ((curlw->icon.internal_width != newlw->icon.internal_width)
        || (curlw->icon.internal_height != newlw->icon.internal_height)
	|| was_resized) {
	(*XtClass(new)->core_class.resize) ((Widget)newlw);
    }

    return( was_resized );
}
