/* 
 * Tree.c - Tree composite widget
 * 
 */
#include        <stdio.h>
#include	<X11/IntrinsicP.h>
#include	<X11/StringDefs.h>
#include	<X11/Misc.h>
#include        <X11/Tree.h>
#include	<X11/TreeP.h>

/****************************************************************
 *
 * Box Resources
 *
 ****************************************************************/

static int defThree = 2;

static XtResource resources[] = {
    {XtNhFactor, XtCHFactor, XtRInt, sizeof(int),
	 XtOffset(TreeWidget, tree.h_factor), XtRInt, (caddr_t)&defThree},
    {XtNvFactor, XtCVFactor, XtRInt, sizeof(int),
	 XtOffset(TreeWidget, tree.v_factor), XtRInt, (caddr_t)&defThree},
    {XtNwidget,XtCWidget,XtRWidget,sizeof(caddr_t),
	 XtOffset(TreeWidget,tree.parent),XtRWidget,(caddr_t)NULL},
    {XtNfg,XtCForeground,XtRPixel,sizeof(Pixel),XtOffset(TreeWidget,tree.fg),
	 XtRString,"Black"},
    {XtNbg,XtCBackground,XtRPixel,sizeof(Pixel),XtOffset(TreeWidget,tree.bg),
	 XtRString,"White"},
};

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

static void Initialize();
static void Realize();
static void Resize();
static void ChangeManaged();
static Boolean SetValues();
static XtGeometryResult GeometryManager();
static void InsertChild();
static void DeleteChild();
static void Redisplay();
TreeClassRec treeClassRec = {
  {
/* core_class fields      */
    /* superclass         */    (WidgetClass) &compositeClassRec,
    /* class_name         */    "Tree",
    /* widget_size        */    sizeof(TreeRec),
    /* class_initialize   */    NULL,
    /* class_part_init    */	NULL,
    /* class_inited       */	FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook    */	NULL,
    /* realize            */    Realize,
    /* actions            */    NULL,
    /* num_actions	  */	0,
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion	  */	TRUE,
    /* compress_exposure  */	TRUE,
    /* compress_enterleave*/	TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    Resize,
    /* expose             */    Redisplay,
    /* set_values         */    SetValues,
    /* set_values_hook    */	NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */	NULL,
    /* accept_focus       */    NULL,
    /* version            */	XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    NULL,
    /* query_geometry     */	NULL,
  },{
/* composite_class fields */
    /* geometry_manager   */    GeometryManager,
    /* change_managed     */    ChangeManaged,
    /* insert_child	  */	InsertChild,
    /* delete_child	  */	DeleteChild,
    /* move_focus_to_next */    NULL,
    /* move_focus_to_prev */    NULL
  },{
/* Box class fields */
    /* empty		  */	0,
  }
};

WidgetClass treeWidgetClass = (WidgetClass)&treeClassRec;


/****************************************************************
 *
 * Private Routines
 *
 ****************************************************************/

/*
 *
 * Do a layout, either actually assigning positions, or just calculating size.
 * Returns minimum width and height that will preserve the same layout.
 *
 */
Do_linegcs(w)
	Widget w;
{
	TreeWidget tw = (TreeWidget)w;
	XGCValues values;
	values.foreground = tw->tree.fg;
	values.background = tw->tree.bg;
	values.line_style = LineSolid;	
	values.line_width = 1;
	
        tw->tree.lineGC = XtGetGC((Widget)tw,
    	(unsigned)GCForeground|GCBackground |GCLineStyle| GCLineWidth, &values);
	values.foreground = tw->tree.bg;
	values.background = tw->tree.fg;
	values.line_style = LineSolid;	
	values.line_width = 1;
        tw->tree.invrlineGC = XtGetGC((Widget)tw,
    	(unsigned) GCForeground|GCBackground|GCLineStyle| GCLineWidth, &values);

}

/* ARGSUSED */
static DoLayout(w)
	Widget w;
{
	TreeWidget tw = (TreeWidget)w;
	TreeList *tl,*sl,*lup,*bl;
	int hf = tw->tree.h_factor;
	int vf = tw->tree.v_factor;
	int x,y,winh,winw,oldy;
	
	tl = sl = lup = tw->tree.head;
	winw = tw->tree.lchildw * tw->tree.no_level * hf;
	winh = tl->t_totalh;
	while(tl->t_leveldown != NULL){
		tl = tl->t_leveldown;
		if(tl->t_totalh > winh)
			winh = tl->t_totalh;
	}
	tl = sl;
	winh = winh * tw->tree.no_level*vf;
	x = 10;
	y = (winh - tl->t_widget->core.height)/2;
	oldy = y;
	XtMoveWidget(tl->t_widget,x,y);
	tl = tl->t_next;	
	while (tl != NULL){
			if(tl->t_flags & T_NEWLEVEL){
				x = x + ((hf - 0.5) * tw->tree.lchildw);
				y = oldy;
			}
			if(tl->t_parentwidget != sl->t_parentwidget){
				int prevy,nump;
				nump = 1;
				sl = tl->t_prev;
				bl = tl->t_next;
				while(bl!=NULL && bl->t_parentwidget == tl->t_parentwidget){
					++nump;
					bl = bl->t_next;
				}
				prevy = y + tw->tree.lchildh;
				y = tl->t_parentwidget->core.y - (0.5 * nump * vf * tw->tree.lchildh);
				if (y <= 0)
					y = 10;
				if(y <= (tl->t_prev->t_widget->core.y + tw->tree.lchildh) && x == tl->t_prev->t_widget->core.x)
					y = prevy + vf * tw->tree.lchildh;
				sl = tl;
			}
			XtMoveWidget(tl->t_widget,x,y);
			y = y + tw->tree.lchildh+ (tw->tree.lchildh/2);
			tl = tl->t_next;
			if(y > winh)
				winh = y;
	}
	if(tw->core.height!= winh || tw->core.width!= winw){
		XtGeometryResult result;
		Dimension ww,wh;
		ww = x + (hf* tw->tree.lchildw);
		wh = winh;
		result = XtMakeResizeRequest(w,ww,wh,&ww,&wh);
		if(result == XtGeometryAlmost)
			XtMakeResizeRequest(w,ww,wh,NULL,NULL);
	}	
}

static void ChangeManaged(w)
	Widget w;
{
	TreeWidget tw = (TreeWidget)w;
	WidgetList children = tw->composite.children;
	int nchild = tw->composite.num_children;
	Widget child, *childP,*unmanagedP;
/*
	unmanagedP = NULL;
	for(childP = children;childP - children < nchild;childP++){
		if(XtIsManaged(*childP)){
			if(unmanagedP){
				child = *unmanagedP;
				*unmanagedP = *childP;
				*childP = child;
				childP = unmanagedP;
			}
		} else {
				if(!unmanagedP)
					unmanagedP = childP;
		       }
	}
*/
}	
	

				




static void Redisplay(w,event,region)
	Widget w;
	XEvent event;
	Region region;
{
	TreeWidget tw = (TreeWidget)w;
	TreeList *tl;
	int x1,y1,x2,y2;
	
	tl = tw->tree.head->t_next;
	while(tl!=NULL){
	      x1 = tl->t_widget->core.x;
	      y1 = tl->t_widget->core.y + 0.5 * tl->t_widget->core.height;
       	      x2 = tl->t_parentwidget->core.x + tl->t_parentwidget->core.width;
	      y2 = tl->t_parentwidget->core.y + tl->t_parentwidget->core.height * 0.5;
	     XDrawLine(XtDisplay(w),XtWindow(w),tw->tree.lineGC,x2,y2,x1,y1);
	     tl = tl->t_next;
	}
	XFlush(XtDisplay(w));
}
				
/*
 *
 * Actually layout the box
 *
 */

static void Resize(w)
    Widget	w;
{
	if(XtIsRealized(w)){
		XClearWindow(XtDisplay(w),XtWindow(w));
		DoLayout(w);
	}
} /* Resize */

/*
 *
 * Geometry Manager
 *
 * 'reply' is unused; we say only yeay or nay, never almost.
 *
 */

/*ARGSUSED*/
static XtGeometryResult GeometryManager(w, request, reply)
    Widget		w;
    XtWidgetGeometry	*request;
    XtWidgetGeometry	*reply;	/* RETURN */

{
	return(XtGeometryNo);
}


/* ARGSUSED */
static void Initialize(request, new)
    Widget request, new;
{
    TreeWidget newbbw = (TreeWidget)new;
     if(newbbw->core.height == 0)
		newbbw->core.height = 500;
     if(newbbw->core.width == 0)
		newbbw->core.width = 500;
} /* Initialize */



static void InsertChild(w,args,argcount)
	register Widget w;
	ArgList	args;
	Cardinal *argcount;
{

TreeWidgetClass myclass;
CompositeWidgetClass superclass;
TreeWidget tw = (TreeWidget)w->core.parent;
Widget pw = (Widget)tw->tree.parent;
TreeList *tp,*tnew,*tstart,*tparent,*otp;
int index;
/*
	insert child into composite child list by calling
	superclasses insert procedure
 */
myclass = (TreeWidgetClass) treeWidgetClass;
superclass = (CompositeWidgetClass)myclass->core_class.superclass;
(*(superclass->composite_class.insert_child))(w,args,argcount);

/*
	now we can build our multi linked list of the tree structure
	given us as the children are added
*/

if(tw->tree.head == NULL){
	tnew = (TreeList *) XtMalloc(sizeof(TreeList));
        tnew->t_next = tnew->t_prev = tnew->t_leveldown = tnew->t_levelup = tnew->t_parent = NULL;
	tnew->t_num = tnew->t_index = 1;
	tnew->t_flags = 0;
        tnew->t_parentwidget = NULL;
        tnew->t_widget = w;
	tnew->t_flags |= T_NEWLEVEL;
	tnew->t_totalh = tnew->t_widget->core.height;
	tw->tree.height += tnew->t_widget->core.height;
	tw->tree.no_level = 1;
        tw->tree.lchildh = w->core.height;
        tw->tree.lchildw = w->core.width;
	tw->tree.head = tnew;
} else {
	if(tw->tree.lchildw < w->core.width)
      		tw->tree.lchildw = w->core.width;
	if(tw->tree.lchildh < w->core.height)
      		tw->tree.lchildh = w->core.height;
	tstart = tp = tw->tree.head;
	tnew = (TreeList *) XtMalloc(sizeof(TreeList));
	tnew->t_next = tnew->t_prev = tnew->t_leveldown = tnew->t_levelup = tnew->t_parent = NULL;
	tnew->t_parentwidget = pw;
	tnew->t_index = tnew->t_num = tnew->t_flags = 0;
	tnew->t_widget = w;
	tw->tree.height += tnew->t_widget->core.height;
	if(tp->t_next == NULL){
		tnew->t_levelup = tnew->t_prev = tnew->t_parent =  tw->tree.head;
		tw->tree.head->t_next = tnew;
		tw->tree.head->t_leveldown = tnew;
		tnew->t_flags |= T_NEWLEVEL;
		tw->tree.no_level += 1;
		tnew->t_num = tnew->t_index = 1;
		tnew->t_totalh = tnew->t_widget->core.height;
	} else {
		
		while(tp != NULL){
			if(tp->t_flags & T_NEWLEVEL){
				tparent = tstart;
				tstart = tp->t_leveldown;
			}
			if(tp->t_widget == pw){
				index = tp->t_index;
				tnew->t_parent = tp;
				if(tstart == NULL){
					while(tp->t_next != NULL)
						tp = tp->t_next;
					tnew->t_flags |= T_NEWLEVEL;
					tnew->t_num = tnew->t_index = 1;
					tnew->t_totalh = tnew->t_widget->core.height;
					tparent->t_leveldown = tnew;
					tnew->t_levelup = tparent;
					tnew->t_prev = tp;
					tp->t_next = tnew;
					tp = tnew;
				}  else {
					otp = tp = tstart;
					while(tp != NULL && tp->t_parent->t_index 
					< index && (((tp == tstart)||( tp->t_flags & T_NEWLEVEL) == 0))){
						otp = tp;
						tp = tp->t_next;
					}
					if(otp == tp){
						tnew->t_levelup = tp->t_levelup;
						tnew->t_leveldown = tp->t_leveldown;
						tnew->t_flags |= T_NEWLEVEL;
						tnew->t_totalh = tp->t_totalh;
						tp->t_levelup->t_leveldown = tnew;
						if(tp->t_leveldown!= NULL)
							tp->t_leveldown->t_levelup = tnew;
						tp->t_flags &= ~T_NEWLEVEL;
						otp = tp->t_prev;
						tnew->t_next = tp;
						tnew->t_prev = otp;
						tnew->t_index = 1;
						otp->t_next = tnew;
						tp->t_prev = tnew;
						tp->t_leveldown = NULL;
						tp->t_levelup = NULL;
						tstart = tnew;
					} else {
						if(tp == NULL){
							if(otp != NULL){
								otp->t_next = tnew;
								tnew->t_prev = otp;
								tnew->t_index = otp->t_index + 1;
								tnew->t_next = NULL;
							}
						} else {
							tnew->t_prev = otp;
							tnew->t_next = tp;
							otp->t_next = tnew;
							tp->t_prev = tnew;
							tnew->t_index = otp->t_index +1;
						}
					} 
					while(tp != NULL && (tp->t_flags & T_NEWLEVEL) == 0){
							tp->t_index++;
							tp = tp->t_next;
					}
					
				tstart->t_totalh += tnew->t_widget->core.height;
				tstart->t_num++;
				}
			}
			if(tp!=NULL)
				tp = tp->t_next;
		  }
   	}
  }
if(XtIsRealized(tw)){
		DoLayout((Widget)tw);
		XClearWindow(XtDisplay((Widget)tw),XtWindow((Widget)tw));
		Redisplay((Widget)tw);
}
}
			

static void DeleteChild(w)
    Widget	w;
{

TreeWidgetClass myclass;
CompositeWidgetClass superclass;
TreeWidget tw = (TreeWidget)w->core.parent;
TreeList *tp,*tstart,*tcurrent,*tabove,*tbelow,*otp;
int index;

/*
	delete child from composite child list by calling
	superclass's insert procedure
 */

myclass = (TreeWidgetClass) treeWidgetClass;
superclass = (CompositeWidgetClass)myclass->core_class.superclass;
tabove = tw->tree.head;
tcurrent = tw->tree.head->t_leveldown;
otp = tw->tree.head;
tp = tstart = tw->tree.head->t_next;
if(tp != NULL)
	tbelow = tp->t_leveldown;
while (tp != NULL && tp->t_widget != w){
	if(tp->t_flags & T_NEWLEVEL){
		tabove = tp->t_levelup;
		tcurrent = tp;
		tbelow = tp->t_leveldown;
	}
	otp = tp;
	tp = tp->t_next;
}

if (tp != NULL) {				/* found the little bugger    */
	if(tp->t_flags & T_NEWLEVEL){
		tabove = tp->t_levelup;
		tcurrent = tp;
		tbelow = tp->t_leveldown;
	}
	if((tp->t_flags & T_NEWLEVEL) == 0){    /* not beginning of new level */
		otp->t_next = tp->t_next;
		if(tp->t_next != NULL)
			tp->t_next->t_prev = otp;
		tcurrent->t_num -= 1;
		tcurrent->t_totalh -= tp->t_widget->core.height;
		otp = otp->t_next;
		while(otp!=NULL && (otp->t_flags & T_NEWLEVEL) == 0){
				otp->t_index-=1;
				otp = otp->t_next;
		}
		XtFree((char *)tp);
	} else {				/* it's at the start of a new level */
		otp->t_next = tp->t_next;
		tcurrent = tp->t_next;
		if(tp->t_next != NULL){
			tp->t_next->t_flags |= T_NEWLEVEL;
			tp->t_next->t_prev = otp;
			tp->t_next->t_totalh = tp->t_totalh - tp->t_widget->core.height;
			tp->t_next->t_num = tp->t_num - 1;
			tp->t_next->t_levelup = tp->t_levelup;
			tp->t_next->t_leveldown = tp->t_leveldown;	
			tp->t_levelup->t_leveldown = tp->t_next;
			if(tp->t_leveldown != NULL)
				tp->t_leveldown->t_levelup = tp->t_next;
		}		
		tabove->t_leveldown = tp->t_next;
		if(tbelow != NULL)
			tbelow->t_levelup = tp->t_next;
			
		tstart = tp->t_next;
		while(tstart!=NULL && (tstart->t_flags & T_NEWLEVEL) == 0){
			tstart->t_index -=1;
			tstart = tstart->t_next;
		}
		XtFree((char *)tp);	
	
	}
    }
(*(superclass->composite_class.delete_child))(w);
DoLayout((Widget)tw);
XClearWindow(XtDisplay((Widget)tw),XtWindow((Widget)tw));
Redisplay((Widget)tw);
}


static void Realize(w, valueMask, attributes)
    register Widget w;
    Mask *valueMask;
    XSetWindowAttributes *attributes;
{
    attributes->bit_gravity = NorthWestGravity;
    *valueMask |= CWBitGravity;
    DoLayout(w);
    XtCreateWindow( w, (unsigned)InputOutput, (Visual *)CopyFromParent,
		    *valueMask, attributes);
    Do_linegcs(w);
    Redisplay(w);
} /* Realize */

/* ARGSUSED */
static Boolean SetValues(current, request, new)
    Widget current, request, new;
{
    return False;
}
