/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

#include <X11/Xlib.h>
#include "Xsdemo.h"
#include <math.h>
#include <stdio.h>

initializebars(w,sortarray,bararray,numelement)
                Window w;
		int sortarray[];
		struct elementrep bararray[];
		int numelement;
{
	register int i,j;
	int tempx,tempy,orgx,orgy;
	int winwidth,width,wx,wy;


	/* check to see that the number of elements
	 * is something reasonable
	 */

	if(numelement > MAX_NUM_ELEM || numelement <= 0){
		fprintf(stderr,"\nInitbars: Error in number of elements -> %d",numelement);
		exit(1);
	}
        winwidth = SORTW - (2*FRAMESIZE);
        width = (int) ceil((double)(winwidth/(2*numelement)));
        if (width < MINPIXELS){
       		fprintf(stderr,"\nInitbars: bars too narrow %hu pixels",width);
		exit(1);
	} 

        /*
	 * We now have almost everything we need except we
	 * now have a problem with the orientation of the
         * bars. This is caused by Xs coordinate system which
         * has y increasing down the screen instead of up.
         * Why can't people all use a cartesian coordinate
         * system.
         */

	orgy = SORTH - FRAMESIZE/2;
        orgx = SORTX + FRAMESIZE*2;
	/*
	 * To get the points for the vertex which correspond
	 * to the top of each bar we will subtract the height
	 * of the bar from the height of the window. This
	 * will provide us with the translated y for that
	 * vertex.
	 */
       
        for (i = 0; i < numelement; i++){
		bararray[i].winx = orgx; 
                bararray[i].winy = orgy - sortarray[i];
		bararray[i].height = sortarray[i];
		bararray[i].width = width;
		orgx = orgx + 2 * width;
	}
}
