/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*
 * A few convenience routines to build a use a popup menu
 */
#include <X11/Xos.h>
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
#include <X11/Atoms.h>
#include <X11/Shell.h>
#include <X11/Box.h>
#include <X11/Label.h>
#include <X11/Command.h>
#include "../include/bmenu.h"

static void bm_callback();
extern Widget toplevel;
extern Pixel init_colour();
static void popup_menu();

/*
 * Build a popup menu.
 */
Widget build_menu(label, names, num_names, action_f, fgr, bgr, width, popflag)
	char *label;
	char **names;
	int num_names;
	int (*(action_f))();
	char *fgr, *bgr;
	int width, popflag;
{
	register int i;
	Pixel fg, bg;
	Widget w, bw;
	struct cmd_close *cmdp;
	static char	cmdtrans[] =
		"Button3<Enter>: enablenotify() highlight() set() \n\
		<Btn3Down>,<Btn3Up>: enablenotify() set() notify() \
			disablenotify() unset() \n\
		<Btn3Up>:	unset() notify() disablenotify() \n\
		Button1<Enter>: enablenotify() highlight() set() \n\
		<Btn1Down>,<Btn1Up>: enablenotify() set() notify() \
			disablenotify() unset() \n\
		<Btn1Up>:	unset() notify() disablenotify() \n\
		 <Enter>:	highlight() \n\
		 <Leave>: unset(NoRedisplay) unhighlight() disablenotify()";
	static char	bboxtrans[] =
		"<Btn3Up>: MenuPopdown() \n\
		<Btn1Up>: MenuPopdown() \n\
		<LeaveWindow>: MenuPopdown()";
	static XtCallbackRec	cmdcall[] = {
		{bm_callback,	NULL},
		{NULL,		NULL},
	};
	static XtCallbackRec	popupcall[] = {
		{popup_menu,	NULL},
		{NULL,		NULL},
	};
	static Arg popuplist[] = {
		{XtNx, NULL},
		{XtNy, NULL},
		{XtNgeometry, NULL},
		{XtNallowShellResize, True},
		{XtNsaveUnder, True},
		{XtNtranslations, (XtArgVal) NULL},
		{XtNpopupCallback, (XtArgVal) popupcall},
	};
	static Arg	labellist[] = {
		{XtNlabel,	(XtArgVal) NULL},
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
		{XtNwidth,	(XtArgVal) NULL},
		{XtNborderWidth,(XtArgVal) 0},
	};
	static Arg	cmdlist[] = {
		{XtNlabel,	(XtArgVal) NULL},
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
		{XtNwidth,	(XtArgVal) NULL},
		{XtNtranslations, (XtArgVal) NULL},
		{XtNcallback,	(XtArgVal) cmdcall},
		{XtNinternalHeight, (XtArgVal) 1},
		{XtNjustify,	(XtArgVal) XtJustifyLeft},
		{XtNborderWidth, (XtArgVal) 0},
	};
	static Arg	bboxlist[] = {
		{XtNcallback,	(XtArgVal) NULL},
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground, (XtArgVal) NULL},
		{XtNvSpace,	(XtArgVal) 0},
		{XtNhSpace,	(XtArgVal) 0},
	};

	fg = init_colour(fgr);
	bg = init_colour(bgr);
	bboxlist[1].value = labellist[2].value = cmdlist[1].value =
		(XtArgVal) fg;
	bboxlist[2].value = labellist[1].value = cmdlist[2].value =
		(XtArgVal) bg;
	labellist[3].value = cmdlist[3].value = (XtArgVal) width;
	if (popflag == BM_SPRUNG)
		popuplist[5].value = (XtArgVal) XtParseTranslationTable(bboxtrans);
	else
		popuplist[5].value = (XtArgVal) NULL;
	w = XtCreatePopupShell(label, overrideShellWidgetClass,
		toplevel, popuplist, XtNumber(popuplist));
	bw = XtCreateManagedWidget("bbbbbbboxxx", boxWidgetClass, w,
		bboxlist, XtNumber(bboxlist));
	labellist[0].value = (XtArgVal) label;
	XtCreateManagedWidget("lllllaabbbb", labelWidgetClass, bw, labellist,
		XtNumber(labellist));
	/* Create translations for command */
	cmdlist[4].value = (XtArgVal) XtParseTranslationTable(cmdtrans);
	/* loop through menu values */
	for (i = 0; i < num_names; i++) {
		cmdlist[0].value = (XtArgVal) *names++;
		cmdp = (struct cmd_close *)XtMalloc(sizeof(struct cmd_close));
		cmdp->pos = i;
		cmdp->bm_actionf = action_f;
		if (popflag)
			cmdp->shell = w;
		else
			cmdp->shell = (Widget)NULL;
		cmdcall[0].closure = (caddr_t) cmdp;
		XtCreateManagedWidget("cccmmmddd", commandWidgetClass, bw,
			cmdlist, XtNumber(cmdlist));
	}
	XtRealizeWidget(w);
	return(w);
}

/*
 * Callback when menu pops up
 * basically position the menu over the pointer
 */
static void popup_menu(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	Window rw, tw;
	int xpos, ypos, tx, ty, tt;
	static Arg	setpos[] = {
		{XtNx,	(XtArgVal) NULL},
		{XtNy,	(XtArgVal) NULL},
	};

	XQueryPointer(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
		&rw, &tw, &xpos, &ypos,
		&tx, &ty, &tt);
	if (xpos > 20)
		xpos -= 20;
	else
		xpos = 0;
	if (ypos > 10)
		ypos -= 10;
	else
		ypos = 0;
	setpos[0].value = (XtArgVal) xpos;
	setpos[1].value = (XtArgVal) ypos;
	XtSetValues(w, setpos, 2);
}

/*
 * Callback routine, just call action_f
 */
static void bm_callback(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	register struct cmd_close *cmdp;

	cmdp = (struct cmd_close *)p1;
	(*(cmdp->bm_actionf))(cmdp->pos);
	if (cmdp->shell != NULL)
		XtPopdown(cmdp->shell);
}

