/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*
 * The following functions deal with fatal and non-fatal errors
 * respectively.
 * They get printf style args and put up the message.
 * Fatal errors cause an exit()
 */

#include <X11/Xos.h>
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Core.h>
#include <X11/CoreP.h>
#include <X11/AsciiText.h>
#include <X11/Icon.h>
#include <X11/Label.h>
#include <X11/Shell.h>
#include "../icons/err.icn"

#define	ERRSTRSIZ	1024

extern Widget toplevel;
extern Pixel init_colour();
static void get_str();
static Widget err_iconw;
static Widget err_labw;
static Widget err_labsubw;
static Pixel err_fgr, err_bgr;
static int err_iconflg;
static char err_str[ERRSTRSIZ+1];

/*
 * Initialize the popup widget shells:
 *   flag arg tells iff non-fatal errs should be an icon
 */
void init_err(pw, flg, fgr, bgr)
	Widget pw;
	int flg;
	char *fgr, *bgr;
{
	Pixel fg, bg;
	static Arg popuplist[] = {
		{XtNx, NULL},
		{XtNy, NULL},
		{XtNgeometry, NULL},
		{XtNallowShellResize, True},
		{XtNsaveUnder, True},
	};
	static Arg iconlist[] = {
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
		{XtNbitmapData,	(XtArgVal) NULL},
		{XtNiconWidth,	(XtArgVal) NULL},
		{XtNiconHeight,	(XtArgVal) NULL},
	};
	static Arg labellist[] = {
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
		{XtNlabel,	(XtArgVal) NULL},
		{XtNwidth,	(XtArgVal) 240},
	};

	err_fgr = init_colour(fgr);
	err_bgr = init_colour(bgr);
	if (flg) {
		err_iconw = XtCreatePopupShell("erri", transientShellWidgetClass,
			pw, popuplist, XtNumber(popuplist));
		iconlist[0].value = (XtArgVal) err_fgr;
		iconlist[1].value = (XtArgVal) err_bgr;
		iconlist[2].value = (XtArgVal) err_bits;
		iconlist[3].value = (XtArgVal) err_width;
		iconlist[4].value = (XtArgVal) err_height;
		XtCreateManagedWidget("eeriw", iconWidgetClass, err_iconw,
			iconlist, XtNumber(iconlist));
		XtRealizeWidget(err_iconw);
	}
	err_labw = XtCreatePopupShell("pope",
		transientShellWidgetClass, pw,
		popuplist, XtNumber(popuplist));
	labellist[0].value = (XtArgVal) err_fgr;
	labellist[1].value = (XtArgVal) err_bgr;
	labellist[2].value = (XtArgVal) err_str;
	err_labsubw = XtCreateManagedWidget("errl", labelWidgetClass,
		err_labw, labellist, XtNumber(labellist));
	XtRealizeWidget(err_labw);
	err_iconflg = flg;
}

/*
 * Pop down the err widget
 * actually a timer callback routine
 *   if a text widget destroy it
 */
void popdown_err(p1, tid)
	caddr_t p1;
	XtIntervalId *tid;
{
	Widget w;

	w = (Widget) p1;
	XtPopdown(w);
}

/*
 * Popup the error widget at the pointer cursor
 */
static void popup_err(secs, flg)
	int secs;
	int flg;
{
	register Screen *scr;
	int x, y, xt, yt, mt;
	Widget widg;
	Window w, wt;
	char *p;
	static int wid, high;
	static Arg getsiz[] = {
		{XtNwidth,	(XtArgVal) &wid},
		{XtNheight,	(XtArgVal) &high},
	};
	static Arg setpos[] = {
		{XtNx,		(XtArgVal) 0},
		{XtNy,		(XtArgVal) 0},
	};
	static Arg setlab[] = {
		{XtNlabel,	(XtArgVal) err_str},
	};

	if (!flg) {
		if ((p = index(err_str, '\n')) != NULL)
			*p = '\0';
		widg = err_labw;
	} else {
		widg = err_iconw;
	}
	XtGetValues(widg, getsiz, 2);
	scr = XtScreen(toplevel);
	XQueryPointer(XtDisplay(toplevel), RootWindowOfScreen(scr),
		&w, &wt, &x, &y, &xt, &yt, &mt);
	if ((x+(wid+10)) > WidthOfScreen(scr))
		x = WidthOfScreen(scr)-(wid+10);
	if ((y+(high+10)) > HeightOfScreen(scr))
		y = HeightOfScreen(scr)-(high+10);
	setpos[0].value = (XtArgVal) x;
	setpos[1].value = (XtArgVal) y;
	XtSetValues(widg, setpos, 2);
	if (!flg)
		XtSetValues(err_labsubw, setlab, 1);
	XtPopup(widg, XtGrabNone);
	XSync(XtDisplay(widg), False);
	if (secs != 0)
		XtAddTimeOut(secs*1000, popdown_err, (caddr_t) widg);
}

/*
 * Called for non-fatal errs:
 *   generate the error string
 *   and pop up the error message of icon per err_iconflg
 */
void err(e_str)
	char *e_str;
{
	Widget w;

	get_str("Error: ",&e_str);
	popup_err(4, err_iconflg);
}

/*
 * Called for fatal errors:
 *   pop up the error message and then exit
 */
void ferr(e_str)
	char *e_str;
{
	Widget tw;

	get_str("Fatal Err: ",&e_str);
	popup_err(0, 0);
	(*(err_labsubw->core.widget_class->core_class.expose))
		(err_labsubw, (XEvent *) NULL, (Region) NULL);
	XFlush(XtDisplay(toplevel));
	sleep(5);
	exit(1);
}

/*
 * Called for fatal errors before attached to X11 server:
 *   just write the message to stderr
 */
void serr(e_str)
	char *e_str;
{

	get_str("Fatal Err: ", &e_str);
	fprintf(stderr, err_str);
	fprintf(stderr, "\n");
	exit(3);
}

/*
 * Generate the string from the printf args and fill into err_str
 * MAX 10 args printf args handled...
 */
static void get_str(prefix, e_msg)
	char *prefix;
	char **e_msg;
{
	register int *p;
	static str[ERRSTRSIZ+1];

	/* Kludge, assumes sizeof(char *) == sizeof(int *) */
	p = (int *) e_msg;
	p += 10;		/* Handles 10 int args */
	strcpy(str, prefix);
	strncat(str, *e_msg, ERRSTRSIZ);
	str[ERRSTRSIZ] = '\0';	/* Ensure null termination */
	sprintf(err_str,str,*p,*p--,*p--,*p--,*p--,*p--,*p--,*p--,*p--,*p--);
}

