/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*
 * Modified yylook() to take argument structure of state vars and
 * knows how to continue after a no_next_char flag is set.
 * (indicated data coming but not here yet on stream)
 */
#include "yylook.h"
# include "stdio.h"
# define U(x) x
# define NLSTATE yy->previous=YYNEWLINE
# define BEGIN yy->bgin = yy->svec + 1 +
# define INITIAL 0
# define YYLERR yy->svec
# define YYSTATE (yy->estate-yy->svec-1)
# define YYOPTIM 1
# define output(c) yy->yyputc(c)
# define input() (((yy->tchar=yy->sptr>yy->sbuf?U(*--yy->sptr):yy->yygetc())==10?(yy->lineno++,yy->tchar):yy->tchar)==EOF?0:yy->tchar)
# define unput(c) {yy->tchar= (c);if(yy->tchar=='\n')yy->lineno--;*yy->sptr++=yy->tchar;}
# define YYNEWLINE 10
# define YYU(x) x

yylook(yy)
	register struct yylookvars *yy;
{

	if (yy->jmp1) {
		yy->jmp1 = 0;
		goto jmp1;
	}
	if (yy->jmp2) {
		yy->jmp2 = 0;
		goto jmp2;
	}
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	if (!yy->morfg)
		yy->lastch = yy->text;
	else {
		yy->morfg=0;
		yy->lastch = yy->text+yy->leng;
		}
	for(;;){
		yy->llsp = yy->lstate;
		yy->estate = yy->state = yy->bgin;
		if (yy->previous==YYNEWLINE) yy->state++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yy->out,"state %d\n",yy->state-yy->svec-1);
# endif
			yy->t = yy->state->stoff;
			if(yy->t == yy->crank){		/* may not be any transitions */
				yy->z = yy->state->other;
				if(yy->z == 0)break;
				if(yy->z->stoff == yy->crank)break;
				}
			if (yy->no_next_char && yy->sptr == yy->sbuf) {
				yy->jmp1++;
				return(0);
			}
		jmp1:
			*yy->lastch++ = yy->ch = input();
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yy->out,"char ");
				allprint(yy->ch);
				putchar('\n');
				}
# endif
			yy->r = yy->t;
			if ( (int)yy->t > (int)yy->crank){
				yy->t = yy->r + yy->ch;
				if (yy->t <= yy->top && yy->t->verify+yy->svec == yy->state){
					if(yy->t->advance+yy->svec == YYLERR)	/* error transitions */
						{unput(*--yy->lastch);break;}
					*yy->llsp++ = yy->state = yy->t->advance+yy->svec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yy->t < (int)yy->crank) {		/* r < yy->crank */
				yy->t = yy->r = yy->crank+(yy->crank-yy->t);
# ifdef LEXDEBUG
				if(debug)fprintf(yy->out,"compressed state\n");
# endif
				yy->t = yy->t + yy->ch;
				if(yy->t <= yy->top && yy->t->verify+yy->svec == yy->state){
					if(yy->t->advance+yy->svec == YYLERR)	/* error transitions */
						{unput(*--yy->lastch);break;}
					*yy->llsp++ = yy->state = yy->t->advance+yy->svec;
					goto contin;
					}
				yy->t = yy->r + YYU(yy->match[yy->ch]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yy->out,"try fall back character ");
					allprint(YYU(yy->match[yy->ch]));
					putchar('\n');
					}
# endif
				if(yy->t <= yy->top && yy->t->verify+yy->svec == yy->state){
					if(yy->t->advance+yy->svec == YYLERR)	/* error transition */
						{unput(*--yy->lastch);break;}
					*yy->llsp++ = yy->state = yy->t->advance+yy->svec;
					goto contin;
					}
				}
			if ((yy->state = yy->state->other) && (yy->t= yy->state->stoff) != yy->crank){
# ifdef LEXDEBUG
				if(debug)fprintf(yy->out,"fall back to state %d\n",yy->state-yy->svec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yy->lastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yy->out,"state %d char ",yy->state-yy->svec-1);
				allprint(yy->ch);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yy->out,"stopped at %d with ",*(yy->llsp-1)-yy->svec-1);
			allprint(yy->ch);
			putchar('\n');
			}
# endif
		while (yy->llsp-- > yy->lstate){
			*yy->lastch-- = 0;
			if (*(yy->llsp) != 0 && (yy->fnd= (*(yy->llsp))->stops) && *yy->fnd > 0){
				yy->olsp = yy->llsp;
				if(yy->extra[*yy->fnd]){		/* must backup */
					while(yyyyback((*(yy->llsp))->stops,-*yy->fnd) != 1 && (yy->llsp) > yy->lstate){
						yy->llsp--;
						unput(*yy->lastch--);
						}
					}
				yy->previous = YYU(*yy->lastch);
				yy->lsp = yy->llsp;
				yy->leng = yy->lastch-yy->text+1;
				yy->text[yy->leng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yy->out,"\nmatch ");
					sprint(yy->text);
					fprintf(yy->out," action %d\n",*yy->fnd);
					}
# endif
				return(*yy->fnd++);
				}
			unput(*yy->lastch);
			}
		if (yy->text[0] == 0  /* && feof(yy->in) */)
			{
			yy->sptr=yy->sbuf;
			return(0);
			}
		if (yy->no_next_char && yy->sptr == yy->sbuf) {
			yy->jmp2++;
			return(0);
		}
	jmp2:
		yy->previous = yy->text[0] = input();
		if (yy->previous>0)
			output(yy->previous);
		yy->lastch=yy->text;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyyyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}

/*
 * Initialization function for the yylookvars struct.
 */
yylookinit(yy,yydfa,getf,putf)
	register struct yylookvars *yy;
	register struct yylookdfa *yydfa;
	int	(*(getf))();
	int	(*(putf))();
{
	yy->lineno = 1;
	yy->sptr = yy->sbuf;
	yy->previous = YYNEWLINE;
	yy->no_next_char = 0;
	yy->yygetc = getf;
	yy->yyputc = putf;
	yy->vstop = yydfa->vstop;
	yy->crank = yydfa->crank;
	yy->svec = yydfa->svec;
	yy->top = *(yydfa->top);
	yy->bgin = *(yydfa->bgin);
	yy->match = yydfa->match;
	yy->extra = yydfa->extra;
}
