/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*
 * The following function generates a popup text window and pops it
 * up either at x,y or current mouse position if x == -1
 * If the timeout parameter is non-zero, it pops down after tim milliseconds.
 * Otherwise, you should explicitly XtPopdown(w); XtDestroyWidget(w);
 * on the 'w' returned by the function.
 */

#include <X11/Xos.h>
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/AsciiText.h>
#include <X11/Shell.h>

#define	STRSIZ	1024

extern Widget toplevel;
extern Pixel init_colour();
static char pop_str[STRSIZ+1];

/*
 * Pop down the text widget
 * actually a timer callback routine
 */
void popdown_text(p1, tid)
	caddr_t p1;
	XtIntervalId *tid;
{
	Widget w;

	w = (Widget) p1;
	XtPopdown(w);
	XtDestroyWidget(w);
}

/*
 * Create and popup the string and return the popup shell widget.
 */
Widget creatpopup_text(pw, str, fgr, bgr, textw)
	Widget pw;		/* Parent Widget */
	char *str;		/* Char string */
	char *fgr, *bgr;	/* Colours for text widget */
	Widget *textw;		/* Text widget (return) */
{
	int len;
	char *pstr;
	Widget widg, tw;
	static char newtrans[] =
		"<Btn2Down>: enablenotify() \n\
		<Btn2Up>: notify(Help) disablenotify()";
	static XtCallbackRec argcall[] = {
		{NULL,		NULL},
	};
	static Arg arglist[] = {
		{XtNstring, (XtArgVal) NULL},
		{XtNlength, (XtArgVal) NULL},
		{XtNwidth,	(XtArgVal) 2},
		{XtNheight,	(XtArgVal) 2000},
		{XtNtextOptions, (XtArgVal) (resizeHeight|resizeWidth)},
		{XtNeditType, (XtArgVal) XttextRead},
		{XtNtranslations, (XtArgVal) NULL},
		{XtNcallback,	(XtArgVal) argcall},
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
	};
	static Arg popuplist[] = {
		{XtNx, (XtArgVal) NULL},
		{XtNy, (XtArgVal) NULL},
		{XtNgeometry,	(XtArgVal) NULL},
		{XtNallowShellResize, True},
		{XtNsaveUnder, True},
	};

	len = strlen(str);
	if (len > STRSIZ) {
		len = STRSIZ;
		bcopy(str, pop_str, STRSIZ);
		pop_str[STRSIZ] = '\0';
		pstr = pop_str;
	} else {
		pstr = str;
	}
	/* It's fun trying to make Text do this */
	arglist[0].value = (XtArgVal) pstr;
	arglist[1].value=(XtArgVal) len;
	arglist[6].value = (XtArgVal) XtParseTranslationTable(newtrans);
	arglist[8].value = (XtArgVal) init_colour(fgr);
	arglist[9].value = (XtArgVal) init_colour(bgr);
	widg = XtCreatePopupShell("pope",
		transientShellWidgetClass, pw,
		popuplist, XtNumber(popuplist));
	*textw = tw = XtCreateManagedWidget("errt", asciiStringWidgetClass,
		widg, arglist,
		XtNumber(arglist));
	XtTextResize(tw);
	return(widg);
}

/*
 * Popup the string
 */
void popup_text(widg, x, y, tim)
	Widget widg;
	int x, y;
	int tim;
{
	register Screen *scr;
	int xt, yt, mt;
	Window w, wt;
	static int wid, high;
	static Arg getsiz[] = {
		{XtNwidth,	(XtArgVal) &wid},
		{XtNheight,	(XtArgVal) &high},
	};
	static Arg setpos[] = {
		{XtNx,		(XtArgVal) 0},
		{XtNy,		(XtArgVal) 0},
	};

	XtRealizeWidget(widg);
	XtGetValues(widg, getsiz, 2);
	scr = XtScreen(toplevel);
	if (x == -1)
		XQueryPointer(XtDisplay(toplevel), RootWindowOfScreen(scr),
		&w, &wt, &x, &y, &xt, &yt, &mt);
	if ((x+(wid+10)) > WidthOfScreen(scr))
		x = WidthOfScreen(scr)-(wid+10);
	if ((y+(high+10)) > HeightOfScreen(scr))
		y = HeightOfScreen(scr)-(high+10);
	setpos[0].value = (XtArgVal) x;
	setpos[1].value = (XtArgVal) y;
	XtSetValues(widg, setpos, 2);
	XtPopup(widg, XtGrabNone);
	if (tim > 0)
		XtAddTimeOut(tim, popdown_text, (caddr_t) widg);
}

