program fertilize (input,output);

{ written by: Therese Corbeil     ID: 882 101 070      VAX: cs140030 }

const
   runlimit = 5;                   {feel free to change}
var
   crop,herd  : real;              {crop > herd}     
   yearlimit,                      {1 and 10}
   run        : integer;
kjlkjlkjlkjlkjklj
{***************** procedure declarations **************}

{}{}{}{}{}{}{   input/output section    }{}{}{}{}{}{}{}{}


procedure alert;
{displays messages black on white}
   begin
      write (chr(27),'[7m')
   end;

procedure nonalert;
{returns the screen to normal}
   begin
      write (chr(27),'[0m')
   end;

procedure paramcheck (var value : real; lower,upper : real);

{this procedure checks the validity of the input data}

   begin
      readln(value);
      if (value < lower) or (value > upper) then
         begin
            alert;
            nnnnmmmwriteln ('value must be larger or equal to ',lower:5:2,' and less or equal to ',upper:5:2);
            write ('Please re-enter: ');
            readln (value);
            nonalert;
            writeln
         end;
   end;  { paramcheck }


procedure mainparams (var  crop,herd : real;
                      var  yearlimit : integer );

   const
      sentinel = 0;
   var
       duration : real;  

   begin
      write('initial crop (0 to stop): ');
      paramcheck (crop,0,maxint);
      if crop <> sentinel then
         begin
            write('initial herd: ');
            paramcheck (herd,0,crop);
            write('number of years: ');
            paramcheck (duration,1,100);
            yearlimit:= trunc(duration);
            writeln;
         end  
   end; {procedure mainparams}


procedure seriesparam (var rainfall,dose:integer);

{this procedure obtains & checks the parameters for the procedure testseries}

   var
      fertilizer,          {dose of fertilizer}
      rainfactor : real;   {rainfall.  These parameters are converted to 
                           integer data types after their values return
                           from the procedure paramcheck}
   begin
      write ('Enter rainfall (negative to stop): ');
      paramcheck (rainfactor,-maxint,20);
      rainfall := trunc(rainfactor);
      if rainfall >= 0 then
         begin
            write ('Enter dose: ');
            paramcheck (fertilizer,0,maxint);
            dose := trunc(fertilizer)
         end
      else
         begin
            writeln;
            alert;
            writeln ('End of simulation with an initial crop size of ');
            writeln (crop:5:2,' and an initial herd size of ',herd:5:2,'.');
            nonalert;
            writeln
         end
   end;  {procedure seriesparam}



{}{}{}{}{}{}{}{   HERD AND CROP ACTIVITIES  }{}{}{}{}{}{}{}{}

procedure mortality (var  herd : real;
                          dose : integer);
   const
      naturodeath = 0.2;    {death rate from natural cause}
   var
      dead,                 {number of gryphon that die in the fall}
      totalrate,            {combined death rate}
      toxicity : real;      {additional toxic effect from the dose of ferilizer}

   {reduce one segment of the herd by the appropriate death rate}
   begin
      toxicity := 0.002 * dose * dose;
      totalrate := naturodeath + toxicity;
      dead := herd * totalrate;
      herd := herd - dead;
      if herd < 0 then herd := 0;
   end; {procedure mortality}



procedure reproduce (var  grazers : real);
   const
      growth = 1.2;    {growth rate of grazers}
   var
      gals,            {number of gryphon-bearing females}
      newborns : real;

   {add new young to the grazers}
   begin
      gals := grazers * 0.40;
      newborns := gals * growth;
      grazers := grazers + newborns
   end; {procedure reproduce}


procedure grow (var    crop : real;
                   rainfall : real;
                       dose : integer);

   const
      maxR = 1.6;      {maximum value that R can have}
   var
      addtocrop,       {crop * final growth rate}
      basicgrowth,     {growth rate of the crop that depends on the dose
                       of ferilizer in the soil.}
      finalgrowth,     {growth rate of the crop that depends on both the
                       dose and the rainfall}
      R   : real;      {the rain factor}

   {provide for one month's growth of the crop}
   begin
      basicgrowth := 0.15-(0.004 * (dose-5) * (dose-5));
      R := 0.15 * rainfall-0.5;
      if R > 1.6 then 
         R := maxR;
      finalgrowth := basicgrowth * R;
      addtocrop := crop * finalgrowth;
      crop := crop + addtocrop;
      if crop < 0 then crop := 0;
   end; {procedure grow}



procedure graze (var  crop : real;
                      herd : real;
               var grazers : real);

   var
      fraction,      {fraction of the herd that feeds on berries}
      ratio : real;  

   {reduce crop by one month's worth of grazing}
   begin
      if crop <= 0 then {not possible to graze}
         grazers := 0
      else
         begin
            ratio := herd/crop;
            if ratio <= 0.2 then
               fraction := 1.0
            else
               if ratio < 1.0 then
                  fraction := 1.25 * (1 - ratio)
               else
                  fraction := 0.0;
            grazers := herd * fraction
         end; {else}
      crop := crop - (grazers / 3)     {each grazer will eat 1/3 of a berry}
   end; {procedure graze}              {each month}



{}{}{}{}{}{}{}{  LEVELS OF CONTROL OF EXPERIMENT   }{}{}{}{}{}{}



function viable( crop,herd : real ):boolean;

   {tests to see whether crop and herd remain in balance}
   begin
      viable := (herd > 0) and (crop > 0) and (herd >= 0.01 * crop) and (herd <= 2 * crop);
   end; {function viable}


procedure oneyear (var  crop,herd : real;
                    rainfall,dose : integer);

   {coordinates the activities of a single year. . .}

   var
      grazers,
      nongrazers : real;
      month : integer;
   begin

      {beginning of summer . . .}
      month := 1;
      while (month <= 3) and viable(crop,herd) do
         begin
             grow (crop,rainfall,dose);
             graze (crop,herd,grazers);
            month := month + 1
         end; {summer}

      {fall & winter aftermath . . .}
      nongrazers := herd - grazers;
      mortality (grazers,dose);
      mortality (nongrazers,dose);
      reproduce (grazers);

      {spring roundup}
      herd := grazers + nongrazers;

   end; {procedure oneyear}


procedure graph (ratio:real);

   const
      ch = 'a';
   var
      star,   {loop index}
      unit: integer; {ratio converted to integer}
   begin
      unit := round(ratio/0.05);
      write (chr(27),'(0');
      for star := 1 to unit do
         write (ch);
      write (chr(27),'(B')
   end;   {procedure graph}


procedure heading;
   begin
      writeln;
      write ('Year':4,'Crop':10,'Herd':10,'Ratio':10,'Graph (':10);
      graph (0.05);
      writeln (' = .05)');
      writeln;
   end; { procedure heading }


procedure showline (year:integer; crop,herd:real);
   var
      ratio:real;

   begin
      if crop <= 0 then
         ratio := 0
      else
         ratio := herd/crop;
      write (year:4,crop:10:2,herd:10:2,ratio:10:2,'   ');
      graph (ratio);
      writeln
   end; {procedure showline}
    
	
procedure reason (crop,herd:real);

{This procedure gives the user a reason for the termination of the present
test}
   type
      quo = (deadherd,deadcrop,toosmall,toobig);
   var
      status : quo;
   begin
      if herd <= 0 then status := deadherd
      else if crop <=0 then status := deadcrop
      else if herd < 0.01 * crop then status := toosmall
      else status := toobig;
      alert;
      case status of
      deadherd : writeln ('The herd has perished. ');
      deadcrop : writeln ('The crop has perished. ');
      toosmall : writeln ('The gryphon to crop ratio has become too small.');
      toobig : writeln ('The gryphon to crop ratio has become too large.')
      end; {case}
      nonalert;
      writeln
   end; {procedure reason}


procedure maketest (var  crop,herd     : real;
                         yearlimit,
                         rainfall,dose : integer);

   {given specific parameter values, perform a single test,
   possibly spanning several years. This procedure is responsible
   for generating column headings and displaying annual results}

   var
      year : integer;
   begin

      heading;
      showline (0,crop,herd);

      year := 1;
      while (year <= yearlimit) and (rainfall >= 0)
            and viable(crop,herd) do
         begin
            oneyear(crop,herd,rainfall,dose);
            showline (year,crop,herd);
            year := year + 1
         end; {another year}
      writeln;

      if not viable(crop,herd) then
         reason(crop,herd);  
   end; {procedure maketest}


procedure testseries ( givencrop,givenherd : real;
                               yearlimit : integer );

   {for a given crop, herd, and number of years, perform a series
   of experiments, each having a different value of rainfall and dose}
   {Eventually, replace explicit i/o statements by procedure calls}

   const
      testlimit = 20;
   var
      crop,herd   : real;
      test,dose,
      rainfall    : integer;
   begin

      seriesparam (rainfall,dose);
      test := 1;
      while (rainfall >= 0) and (test <= testlimit) do
         begin
            crop := givencrop;
            herd := givenherd;
            maketest(crop,herd,yearlimit,rainfall,dose);
            seriesparam (rainfall,dose);
            test := test + 1
         end; {another year}
   end; {procedure runtests}


{********************* main program ********************}

begin
   mainparams(crop,herd,yearlimit);

   run := 1;
   while (crop > 0) and (run <= runlimit) do
      begin
         testseries(crop,herd,yearlimit);
         mainparams(crop,herd,yearlimit);
         run := run + 1
      end; {one test series}

   writeln;
   alert;
   writeln('end of simulation');
   nonalert;
end.
