/*
 * Vif configuration defs
 */
#define MAXBUTTONS	20
#define MAXACTIONS	20

struct vif_actc {
	int	va_flags;
	char	*va_instring;
	char	*va_boolstring;
	char	*va_outstring;
	char	*va_warpwidgetname;	/* Char name of widget to warp to */
	char	*va_dialogstring;
	char	*va_dialogregex;
	char	*va_dialogresp;
	char	*va_yesnoquery;
	char	*va_yesstring;
	char	*va_nostring;
	char	*va_mousebits;
	int	va_mouseheight;
	int	va_mousewidth;
	int	va_mousehotx;
	int	va_mousehoty;
	int	va_mousetime;
	char	*va_popuptext;
	char	*va_popupiconbits;
	int	va_popupiconwidth;
	int	va_popupiconheight;
	int	va_popuptime;
	int	va_setsensitive[MAXBUTTONS+7];
};

struct vif_sel {
	int	vsl_flags;
	char	*vsl_fgr;
	char	*vsl_bgr;
	char	*vsl_label;
	char	*vsl_iconbits;
	int	vsl_iconwidth;
	int	vsl_iconheight;
	int	vsl_action;
};

struct vif_config {
	int	vc_flags;
	char	*vc_helplib;		/* Help Library name */
	char	*vc_fgr;
	char	*vc_bgr;
	char	*vc_cursfgr;
	char	*vc_cursbgr;
	char	*vc_scrollfgr;
	char	*vc_scrollbgr;
	char	*vc_dialogfgr;
	char	*vc_dialogbgr;
	char	*vc_acceptfgr;
	char	*vc_acceptbgr;
	char	*vc_cancelfgr;
	char	*vc_cancelbgr;
	char	*vc_yesnofgr;
	char	*vc_yesnobgr;
	char	*vc_yesfgr;
	char	*vc_yesbgr;
	char	*vc_nofgr;
	char	*vc_nobgr;
	char	*vc_helpfgr;
	char	*vc_helpbgr;
	char	*vc_menufgr;
	char	*vc_menubgr;
	int	vc_scrollup;
	int	vc_scrolldown;
	int	vc_scrollacel;
	int	vc_initaction;		/* Action to perform of startup iff VC_INITALACT */
	int	vc_screenmouse2;
	int	vc_screenmouse3;
	int	vc_screenmouse4;
	int	vc_screenmouse5;
	struct vif_sel vc_selitem[MAXBUTTONS];
	struct vif_actc vc_actions[MAXACTIONS];
};

/* Flag bits for vc_flags */
#define	VC_BUTTONS	0x00000001
#define	VC_SCROLLBAR	0x00000002
#define	VC_MOUSE2	0x00000004
#define	VC_MOUSE3	0x00000008
#define	VC_PAGESCROLL	0x00000010
#define	VC_INITIALACT	0x00000020
#define	VC_KBFILTER	0x00000040
#define	VC_PTYFILTER	0x00000080
#define	VC_MOUSEPOS	0x00000200
#define VC_AUTOSTOPGO	0x00000400
#define	VC_MOUSE4	0x00000800
#define	VC_MOUSE5	0x00001000

/* Flag bit for vsl_flags */
#define	VSL_VALID	0x00000001
#define	VSL_BOOLEAN	0x00000002
#define	VSL_ICON	0x00000004

/* Flag bits for vac_flags */
#define	VAC_VALID	0x00000001
#define	VAC_NEWMOUSE	0x00000002
#define	VAC_POPUPTEXT	0x00000010
#define	VAC_POPUPICON	0x00000020
#define	VAC_PTYCHARS	0x00000040
#define	VAC_VTCHARS	0x00000080
#define	VAC_BOOLEAN	0x00000100
#define	VAC_DIALOGBOX	0x00000200
#define	VAC_YESNOBOX	0x00000400
#define	VAC_WARPPOINTER	0x00000800
#define	VAC_SETSENSTV	0x00001000
#define VAC_WARPPBOOL	0x00002000

#define	VAC_POPUP	(VAC_POPUPTEXT|VAC_POPUPICON)

/* Values for setsensitive array */
#define	SEN_NOCHANGE	0
#define	SEN_ON		1
#define	SEN_OFF		2

/* Indices of SETSENSITIVE array */
#define	SCROLLSEN	0
#define	KBDSEN		1
#define	MBUT1		2
#define	MBUT2		3
#define	MBUT3		4
#define	MBUT4		5
#define	MBUT5		6
/* and 7-> refer to the selection buttons */

