/*
 * Here are the defs for the configuration structure.
 */

#define	NTOPLEVEL	10
#define	NCMD		40

/*
 * Here are the typedefs for the structs.
 */

typedef	struct _GshConf		GshConf;
typedef	struct _LevelConf	LevelConf;
typedef	struct _CmdConf		CmdConf;
typedef	struct _NameConf	NameConf;

/*
 * This structure configures an individual command in the command panel.
 * There is one of these for each command of each top level. The command
 * is displayed as either a static text sting or a small static raster (icon).
 * in the command panel for the appropriate top level. When selected the
 * c_string field gives the associated "sh" command line with the special
 * char. '^' designating the point at which name args. are to be inserted,
 * if there are any. If required, a name panel is generated using either
 * the c_dirpath and c_modeset, c_modeclear to select elements from a dir.
 * or alternately the list c_namevals. The c_namereg field is a regular
 * expression (ala. regex(3)) that all names must pass to be selectable.
 * c_flags is a bit array that controls name selection and execution. See
 * the comments associated with the C_xxx bits.
 */
struct _NameConf {
	int		n_flags;	/* Flags see N_xxx */
	char		*n_namereg;	/* Regular expression for names req. */
	char		*n_dirpath;	/* Directory pathname for name sel */
	int		n_access;	/* Access bits per access(2) */
	u_short		n_modes;	/* Fstat mode bits that must be '1' */
	char		*n_namefilter;	/* Pathname of filter program */
	char		**n_namevals;	/* List of names instead of files */
};

struct _CmdConf {
	int		c_flags;	/* Flags or'd together, see C_ defs */
	char		*c_bits;	/* Icon data */
	int		c_width;	/* Icon width */
	int		c_height;	/* Icon height */
	char		*c_fgr;		/* Foreground color for disp in panel */
	char		*c_bgr;		/* Background color '' */
	char		*c_label;	/* Name of command for static text */
	char		*c_string;	/* single line csh cmd string */
	char		*c_vifconf;	/* Vif config file name */
	int		c_ttyrow;	/* Rows in vif window */
	int		c_ttycol;	/* Cols in vif window */
	NameConf	c_name1;	/* Spec for first name field in c_string */
	NameConf	c_name2;	/* ditto for second name field */
};

/*
 * This structure configures a top level. It consists of control flags,
 * a name and an array of CmdConf structures for the commands associated with
 * the top level. Basically each top level defines the set of commands for
 * the command panel.
 */
struct _LevelConf {
	int		l_flags;	/* Flag bits for level */
	char		*l_fgr;		/* Fgr colour */
	char		*l_bgr;		/* Bgr ditto */
	char		*l_bboxfgr;	/* Fgr bbox colour */
	char		*l_bboxbgr;	/* Bgr bbox ditto */
	char		*l_label;	/* Name for this top level */
	char		*l_chdir;	/* Dir for this top level */
	char		*l_bits;		/* Icon bits */
	int		l_width;	/* Icon width in bits */
	int		l_height;	/* Icon height in bits */
	CmdConf		l_cmd[NCMD];	/* Array of cmds for this level */
};

/*
 * This is the initialized structure that defines an xgsh configuration.
 * It consists of flag bits, colors for various panels and an array of
 * LevelConf structures, one for each top level.
 */
struct _GshConf {
	int		gc_flags;	/* Flag bits, see G_xx defs */
	char		**gc_envir;	/* Environment list for login sh */
	char		*gc_title;	/* Title string for toplevel titlebar */
	int		gc_umask;	/* Umask value to be set */
	int		gc_firstop;	/* Toplevel to start with */
	char		*gc_logincmd;	/* Login cmd string */
	char		*gc_helplib;	/* Path name for help lib. */
	char		*gc_logfile;	/* Log file pathname */
	char		*gc_fgr;	/* Foreground color def */
	char		*gc_bgr;	/* Background ditto */
	char		*gc_cursorfgr;	/* Fgr color of cursors */
	char		*gc_cursorbgr;	/* Bgr ditto */
	char		*gc_helpfgr;	/* Fgr of Help windows */
	char		*gc_helpbgr;	/* Bgr ditto */
	char		*gc_errfgr;	/* Fgr of error popups */
	char		*gc_errbgr;	/* Bgr ditto */
	char		*gc_toplfgr;	/* Fgr of top level panel */
	char		*gc_toplbgr;	/* Bgr ditto */
	char		*gc_titlefgr;	/* Fgr of title bar */
	char		*gc_titlebgr;	/* Bgr ditto */
	char		*gc_curdirfgr;	/* Fgr of cur dir label */
	char		*gc_curdirbgr;	/* Bgr ditto */
	char		*gc_toplbbfgr;	/* Fgr for top level bbox */
	char		*gc_toplbbbgr;	/* Bgr ditto */
	char		*gc_ctrlfgr;	/* Fgr of ctrl bbox */
	char		*gc_ctrlbgr;	/* Bgr ditto */
	char		*gc_ctrlbutfgr;	/* Fgr of ctrl buttons */
	char		*gc_ctrlbutbgr;	/* Bgr ditto */
	char		*gc_infofgr;	/* Fgr of info widget panel */
	char		*gc_infobgr;	/* Bgr ditto */
	char		*gc_dirbfgr;	/* Fgr for dir. browser */
	char		*gc_dirbbgr;	/* Bgr ditto */
	char		*gc_clockfgr;	/* Fgr of clock */
	char		*gc_clockbgr;	/* Bgr ditto */
	char		*gc_mailfgr;	/* Fgr of mailbox */
	char		*gc_mailbgr;	/* Bgr ditto */
	char		*gc_loadfgr;	/* Fgr of load widget */
	char		*gc_loadbgr;	/* Bgr ditto */
	char		*gc_cmdstrfgr;	/* Fgr of cmd string */
	char		*gc_cmdstrbgr;	/* Bgr ditto */
	char		*gc_iconfgr;	/* Fgr of icon window */
	char		*gc_iconbgr;	/* Bgr ditto */
	char		*gc_namefgr;	/* Fgr of name sel panel */
	char		*gc_namebgr;	/* Bgr ditto */
	char		*gc_viewfgr;	/* Fgr of name viewport */
	char		*gc_viewbgr;	/* Bgr ditto */
	char		*gc_viewboxfgr;	/* Fgr of name view bbox */
	char		*gc_viewboxbgr;	/* Bgr ditto */
	char		*gc_namebutfgr;	/* Fgr of name sel buttons */
	char		*gc_namebutbgr;	/* Bgr ditto */
	char		*gc_newnamefgr;	/* Fgr of new name panel */
	char		*gc_newnamebgr;	/* Bgr ditto */
	char		*gc_newnametextfgr; /* Fgr of new name text */
	char		*gc_newnametextbgr; /* Bgr ditto */
	char		*gc_procmenufgr;/* Fgr of proc ctrl menu */
	char		*gc_procmenubgr;/* Bgr ditto */
	LevelConf	gc_level[NTOPLEVEL];	/* Array of LevelConf's for toplevels */
};

/*
 * and bit defs for the flags
 */
#define	G_NOMULTI	0x00000001	/* Don't allow multiple commands */
#define	G_ICONCTRL	0x00000002	/* Use icons for ctrl buttons */
#define	G_DIRBROWSER	0x00000004	/* Allow use of the dir browser */
#define	G_TTYMOUSEPOS	0x00000008	/* User positions tty with mouse */
#define G_CHDIR		0x00000010	/* user changes directories   */
#define	G_TEXTERR	0x00000020	/* print text window on errs */
#define	G_ICONERR	0x00000040	/* put up icon on errs */
#define	G_STDERR	0x00000080	/* print errs on stderr (testing) */
#define	G_COMMANDSTR	0x00000100	/* Show csh command being built */
#define	G_LOGINCMD	0x00000200	/* Run gc_logincmd in tty win */
#define G_HISTSTATS	0x00000400	/* Print out level/cmd stats hist */
#define	G_CLOCK		0x00001000	/* Show a clock widget */
#define	G_MAILBOX	0x00002000	/* Show a mailbox widget */
#define	G_LOAD		0x00004000	/* Show a load monitor widget */
#define	G_WARPPOINTER	0x00008000	/* Warp the pointer to panels */
#define	G_FULLDIRPATH	0x00010000	/* Show full directory path */
#define	G_DIRBRMDIR	0x00020000	/* Allow dirb to remove dirs */
#define	G_DIRBCHDIR	0x00040000	/* Allow dirb to chdir */
#define	G_DIRBMKDIR	0x00080000	/* Allow dirb to mkdir */
#define	G_DIRBRMFILE	0x00100000	/* Allow dirb to rm files in a dir */

/*
 * Flag bit defs for l_flags
 */
#define	L_VALID		0x00000001	/* entry is valid */
#define	L_ICON		0x00000002	/* Use icon for level */

/*
 * Here are the bit defs for the c_flags field. The ones marked XX are status
 * bits that should never be set in the initialized CmdConf structure.
 */
#define	C_VALID		0x00000001	/* This entry is valid */
#define	C_ICON		0x00000002	/* This cmd. a raster (icon) */
#define	C_NOFILES	0x00000010	/* No names required/allowed */
#define	C_TTY		0x00000020	/* Run with an associated tty window */
#define	C_ICONW		0x00000040	/* Run with an associated icon window */
#define	C_AUTOGO	0x00000080	/* Do Go as soon as selected */
#define	C_NAME1		0x00000100	/* Allows a first name arg list */
#define	C_NAME2		0x00000200	/* Allows a 2nd name arg list */
#define	C_TTYJUMPSCROLL	0x00000400	/* Use page scroll mode on tty window */
#define	C_WINLINGER	0x00000800	/* window lingers after cmd done(non-interactive) */
#define	C_DEFUNCT	0x00001000	/* XX Job is done but window lingers */
#define	C_KILLED	0x00002000	/* XX Job has been killed ->SIGINT */
#define	C_WARPMOUSE	0x00004000	/* Warp mouse into tty window on startup */
#define	C_STOPPED	0x00010000	/* XX Job is stopped */
#define	C_DEFUNCTMSG	0x00040000	/* Print msg in tty win when defunct */
#define	C_LOGIN		0x00100000	/* This is the login cmd. */
#define	C_TTYVIFCONF	0x00200000	/*There is a vif config file defined */

/* NameConf flags */
#define	N_NAMEFILTER	0x00000001	/* Name filter program to run */
#define	N_NAMEVALS	0x00000002	/* Explicit name list */
#define	N_FILES		0x00000004	/* Names from file name space */
#define	N_SUMP		0x00000008	/* Names from sump connection */
#define	N_ONENAME	0x00000010	/* One name only */
#define	N_MORETHAN1	0x00000020	/* More than one name only */
#define	N_0OR1		0x00000040	/* Zero or one name */
#define	N_1ORMORE	0x00000080	/* One or more names */
#define	N_0ORMORE	0x00000100	/* Zero or more names */
#define	N_SUBTREE	0x00000200	/* Recurse down dir subtree */
#define	N_PREFIX	0x00000400	/* Use prefix labels (like subdirs) */
#define	N_NEWNAME	0x00000800	/* New Names entered via. kbd allowed */

