/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*
 * This module handles name selection panels.
 */
#include <X11/Xos.h>
#include <stdio.h>
#include <sys/dir.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/Atoms.h>
#include <X11/Core.h>
#include <X11/CoreP.h>
#include <X11/Shell.h>
#include <X11/AsciiText.h>
#include <X11/Label.h>
#include <X11/LabelP.h>
#include <X11/Viewport.h>
#include <X11/ViewportP.h>
#include <X11/Box.h>
#include <X11/Command.h>
#include <X11/Icon.h>
#include <X11/ICommand.h>
#include "../include/tar.h"
#include "../include/help.h"
#include "../include/Xtty.h"
#include "../include/xgshconf.h"
#include "../include/xgshstate.h"
#include "../include/xgsherr.h"

/*
 * Global vars.
 */
extern Widget toplevel;
extern GshState	gshstate;	/* state struct for gsh		*/
extern GshConf *gconfptr;
extern void help_call();
extern NameList *creat_namelist();
extern Widget creatpopup_text();
extern void popup_text();

/* Global vars */
Widget name_w;
static Widget name_dialogw;
Widget noname_labelw;
static Widget name_dialboxw;
static Widget name_dialtextw;
static Widget name_diallabelw;
static Widget *name_childw;
static int name_flags = 0;
Widget name_vieww;
Widget viewbox_w;
Widget newicon_w;
NameConf *curnamep;
static NameList *chainlp;
static int name_numchild;
static char name_dialogresp[MAXLABEL+1];
static NameList *name_curlp;
static int name_cnt;
void name_input();
static void newname_input();
static void fullname_input();
void namectrl_input();

#define	NAME_UP		0x00000001
#define	NEWNAME_UP	0x00000002

/* Flags for NameList */
#define NL_MAPPED	0x00000001
#define NL_PREMAPPED	0x00000002

/*
 * This function pops down the full name panel.
 */
static void fullname_input(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	Widget tw;

	if (p2 == NULL || *p2 != 'D')
		return;
	tw = (Widget) p1;
	XtPopdown(tw);
	XtDestroyWidget(tw);
}

/*
 * This function deals with input to a name selection panel.
 */
void name_input(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	register GshState *gs = &gshstate;
	register NameList *lp;
	register CmdConf *cmdp;
	GshConf *gc = gconfptr;
	Widget pw, tw;

	lp = (NameList *)p1;
	if (p2 != NULL) {
		if (*p2 == 'H') {
			popup_help(&(gs->gs_helphead), &(gs->gs_popuphead), w);
		}
		if (*p2 == 'P') {
			/* Popup the full name */
#ifndef SAFE
			pw = creatpopup_text(gs->gs_toplw, lp->l_name, gc->gc_namefgr, gc->gc_namebgr,
				&tw);
			XtOverrideTranslations(tw, XtParseTranslationTable(
				"<Btn3Down>: enablenotify() \n\
				<Btn3Up>: notify(Down) disablenotify()"));
			XtAddCallback(tw, XtNcallback, fullname_input,
				(caddr_t) pw);
			popup_text(pw, -1, -1, 0);
#endif
		}
		return;
	}
	if (gs->gs_nonameinput) {
		return;
	}
	/* Check to see iff we can take another name ?? */
	if (name_cnt >= 1 && (curnamep->n_flags & (N_ONENAME|N_0OR1))) {
		err(ER_NOMORENAMES);
		return;
	}
	/* Selection of a name, desensitize it and append to selected list */
	XtSetSensitive(lp->l_w, False);
	lp->l_selnext = NULL;
	chainlp->l_selnext = lp;
	chainlp = lp;
	disp_cmd();
	name_cnt++;
	cmdp = &(gconfptr->gc_level[gs->gs_curtoplevel].l_cmd[gs->gs_curcmd]);
	if ((curnamep->n_flags & (N_ONENAME|N_0OR1)) &&
		(cmdp->c_flags & C_AUTOGO)) {
		reset_names();
		if (curnamep == &(cmdp->c_name1)) {
			if (cmdp->c_flags & C_NAME2) {
				get_name(&(cmdp->c_name2), &(gs->gs_name2));
				disp_cmd();
			} else
				go_cmd();
		} else if (curnamep == &(cmdp->c_name2))
			go_cmd();
	}
}

/*
 * This function is called by name ctrl buttons.
 */
void namectrl_input(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	register GshState *gs = &gshstate;
	register NameList *lp;
	register CmdConf *cmdp;
	register int i;
	int j;
	Window ww;
	static int xpos, ypos;
	static Arg setpos[] = {
		{XtNx,	(XtArgVal) NULL},
		{XtNy,	(XtArgVal) NULL},
	};

	if (p2 != NULL) {
		if (*p2 == 'H') {
			popup_help(&(gs->gs_helphead), &(gs->gs_popuphead), w);
		}
		return;
	}
	if (gs->gs_nonameinput) {
		return;
	}
	j = (int) p1;
	switch (j) {
	case 0:
		reset_names();
		reset_cmd(True);
		break;
	case 1:
		/* Just reinitialize list and cnt */
		lp = name_curlp->l_selnext;
		/* Resensitize names */
		for (i = 0; i < name_cnt; i++) {
			XtSetSensitive(lp->l_w, True);
			lp = lp->l_selnext;
		}
		name_curlp->l_selnext = NULL;
		chainlp = name_curlp;
		name_cnt = 0;
		disp_cmd();
		break;
	case 2:
		/* Check to see if an appropriate num of names has been selected */
		if ((name_cnt == 0 && (curnamep->n_flags & (N_ONENAME|N_MORETHAN1|N_1ORMORE)))
			|| (name_cnt == 1 && (curnamep->n_flags & N_MORETHAN1))) {
			err(ER_NOTENOUGHNAMES);
			return;
		}
		cmdp = &(gconfptr->gc_level[gs->gs_curtoplevel].l_cmd[gs->gs_curcmd]);
		reset_names();
		if (curnamep == &(cmdp->c_name1)) {
			if (cmdp->c_flags & C_NAME2) {
				get_name(&(cmdp->c_name2), &(gs->gs_name2));
				disp_cmd();
			} else if (cmdp->c_flags & C_AUTOGO)
				go_cmd();
		} else if (curnamep == &(cmdp->c_name2) && (cmdp->c_flags & C_AUTOGO))
			go_cmd();
		break;
	case 3:
		/* Check to see iff we can take another name ?? */
		if (name_cnt >= 1 && (curnamep->n_flags & (N_ONENAME|N_0OR1))) {
			err(ER_NOMORENAMES);
			return;
		}
		/* Pop up the new name panel */
		XTranslateCoordinates(gs->gs_disp, XtWindow(name_w),
			gs->gs_rootwin, 30, 100, &xpos, &ypos, &ww);
		setpos[0].value = (XtArgVal)(xpos);
		setpos[1].value = (XtArgVal)(ypos);
		XtSetValues(name_dialogw, setpos, 2);
		XtTextErase(name_dialtextw);
		name_flags |= NEWNAME_UP;
		XtPopup(name_dialogw, XtGrabNone);
		if (gconfptr->gc_flags & G_WARPPOINTER)
			warp_pointer(name_dialtextw);
		break;
	};
}

/*
 * Initialize the name and newname selection panels.
 */
init_names()
{
	register GshConf *gc = gconfptr;
	register GshState *gs = &gshstate;

	/* Create newname popup widget */
	dial_creat(gs->gs_toplw, "Newname", gc->gc_newnamefgr, gc->gc_newnamebgr,
		gc->gc_newnametextfgr, gc->gc_newnametextbgr,
		gs->gs_basefont, name_dialogresp, MAXLABEL,
		newname_input, &(gs->gs_helphead), (gc->gc_flags & G_ICONCTRL),
		&name_dialogw, &name_dialboxw, &name_diallabelw,
		&name_dialtextw);
}

/*
 * Callback from buttons on dialog box
 */
static void newname_input(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	register GshState *gs = &gshstate;
	register NameList *lp;
	register CmdConf *cmdp;
	int j;
	static char *labelptr;
	static Pixel fgr, bgr;
	static char errstr[1024];
	static Arg	getargl[] = {
		{XtNlabel,	(XtArgVal)&labelptr},
		{XtNforeground, (XtArgVal)&fgr},
		{XtNbackground, (XtArgVal)&bgr},
	};
	static Arg	setargl[] = {
		{XtNlabel,	(XtArgVal) NULL},
		{XtNforeground, (XtArgVal) NULL},
		{XtNbackground, (XtArgVal) NULL},
	};

	/* Handle non-select input */
	if (p2 != NULL) {
		if (*p2 == 'H') {
			popup_help(&(gs->gs_helphead), &(gs->gs_popuphead), w);
		}
		return;
	}
	j = (int) p1;
	switch (j) {
	case 0:
		/* pop it down */
		XtPopdown(name_dialogw);
		name_flags &= ~NEWNAME_UP;
		break;
	case 1:
		/* Just erase text */
		XtTextErase(name_dialtextw);
		break;
	case 2:
		/* See if it passes the regular expression */
		if (re_exec(name_dialogresp)) {
			/* Add the new name to the list and select it */
			if (gs->gs_endlp->l_next == NULL) {
				if ((lp = creat_namelist()) == NULL) {
					err(ER_NOMEM);
					return;
				}
			} else
				lp = gs->gs_endlp->l_next;
			gs->gs_endlp = lp;
			strncpy(lp->l_name, name_dialogresp, MYMAXPATHLEN);
			lp->l_name[MYMAXPATHLEN] = '\0';
			lp->l_selnext = NULL;
			chainlp->l_selnext = lp;
			chainlp = lp;
			disp_cmd();
			name_cnt++;
			XtPopdown(name_dialogw);
			name_flags &= ~NEWNAME_UP;
			cmdp = &(gconfptr->gc_level[gs->gs_curtoplevel].l_cmd[gs->gs_curcmd]);
			if ((curnamep->n_flags & (N_ONENAME|N_0OR1)) &&
				(cmdp->c_flags & C_AUTOGO)) {
				reset_names();
				if (curnamep == &(cmdp->c_name1)) {
					if (cmdp->c_flags & C_NAME2) {
						get_name(&(cmdp->c_name2), &(gs->gs_name2));
						disp_cmd();
					} else
						go_cmd();
				} else if (curnamep == &(cmdp->c_name2))
					go_cmd();
			}
		} else {
			/* Pop up match pattern in rev video and wait for new string */
			sprintf(errstr, "Bad Match %s", curnamep->n_namereg);
			XtGetValues(name_diallabelw, getargl, XtNumber(getargl));
			setargl[0].value = (XtArgVal) errstr;
			setargl[1].value = (XtArgVal) bgr;
			setargl[2].value = (XtArgVal) fgr;
			XtSetValues(name_diallabelw, setargl, XtNumber(setargl));
			/* Kludge, but how else do i get the string redrawn */
			(*(name_diallabelw->core.widget_class->core_class.expose))(name_diallabelw, (XEvent *) NULL, (Region) NULL);
			XFlush(XtDisplay(name_diallabelw));
			/* wait a bit */
			sleep(1);
			XtTextErase(name_dialtextw);
			setargl[0].value = (XtArgVal) labelptr;
			setargl[1].value = (XtArgVal) fgr;
			setargl[2].value = (XtArgVal) bgr;
			XtSetValues(name_diallabelw, setargl, XtNumber(setargl));
		}
		break;
	};
}

/*
 * pop up the name panel with the names from the list
 */
void setnameget(np, listp, j, nameret)
	NameConf *np;
	NameList *listp;
	int j;
	NameList *nameret;
{
	register int i;
	register NameList *lp;
	register Widget *wp;
	GshState *gs = &gshstate;
	ViewportWidget vw;
	static Arg setlab[] = {
		{XtNlabel,	(XtArgVal) NULL},
	};

	lp = listp->l_next;
	name_numchild = j;
	name_curlp = chainlp = nameret;
	curnamep = np;
	nameret->l_selnext = NULL;
	name_cnt = 0;
	/* Set sensitivity of new name icon */
	if (np->n_flags & N_NEWNAME) {
		if (!XtIsSensitive(newicon_w))
			XtSetSensitive(newicon_w, True);
	} else {
		if (XtIsSensitive(newicon_w))
			XtSetSensitive(newicon_w, False);
	}
	vw = (ViewportWidget) name_vieww;
	if (((np->n_flags & (N_PREFIX|N_SUBTREE)) && j > NAMEROWS) ||
	    (!(np->n_flags & (N_PREFIX|N_SUBTREE)) && j > (3*NAMEROWS))) {
		if (!XtIsSensitive(vw->viewport.vert_bar))
			XtSetSensitive(vw->viewport.vert_bar, True);
	} else {
		if (XtIsSensitive(vw->viewport.vert_bar))
			XtSetSensitive(vw->viewport.vert_bar, False);
	}
	/* Handle no names case */
	if (j == 0) {
		if (!(np->n_flags & N_NEWNAME) && (np->n_flags & (N_ONENAME|N_MORETHAN1|N_1ORMORE))) {
			err(ER_NOTENOUGHNAMES);
			reset_cmd(True);
			return;
		}
		name_numchild = 1;
		if ((name_childw = (Widget *)malloc(sizeof(Widget))) == NULL) {
			err(ER_NOMEM);
			reset_cmd(True);
			return;
		}
		*name_childw = noname_labelw;
	} else if (j == 1 && !(np->n_flags & N_NEWNAME) &&
		(np->n_flags & N_MORETHAN1)) {
		err(ER_NOTENOUGHNAMES);
		reset_cmd(True);
		return;
	} else {
		if (np->n_flags & (N_PREFIX|N_SUBTREE))
			name_numchild *= 2;
		wp = name_childw = (Widget *)malloc(name_numchild*sizeof(Widget));
		if (wp == NULL) {
			err(ER_NOMEM);
			reset_cmd(True);
			return;
		}
		/* Loop thru list setting widgets to be managed by viewbox */
		for (i = 0; i < j; i++) {
			/* Iff prefix, put it on */
			if (np->n_flags & (N_PREFIX|N_SUBTREE)) {
				setlab[0].value = (XtArgVal) lp->l_prelabel;
				XtSetValues(lp->l_prew, setlab, 1);
				*wp++ = lp->l_prew;
			}
			/* And the label */
			setlab[0].value = (XtArgVal) lp->l_label;
			XtSetValues(lp->l_w, setlab, 1);
			*wp++ = lp->l_w;
			if (!XtIsSensitive(lp->l_w))
				XtSetSensitive(lp->l_w, True);
			lp = lp->l_next;
		}
	}
	XtManageChildren(name_childw, name_numchild);
	name_flags |= NAME_UP;
	/* Set viewport to top and pop up */
	XtViewMovechild(name_vieww, 0, 0);
	XDefineCursor(gs->gs_disp, gs->gs_rootwin, gs->gs_defcursor);
	XtPopup(name_w, XtGrabNone);
	XtSetSensitive(name_w, True);
	if (gconfptr->gc_flags & G_WARPPOINTER)
		warp_pointer(viewbox_w);
}

/*
 * Reset name selection panels
 */
reset_names()
{

	if (name_flags & NEWNAME_UP) {
		name_flags &= ~NEWNAME_UP;
		XtPopdown(name_dialogw);
	}
	if (name_flags & NAME_UP) {
		name_flags &= ~NAME_UP;
		XtPopdown(name_w);
		XtUnmanageChildren(name_childw, name_numchild);
		free((caddr_t) name_childw);
	}
}

